/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.slf4j.Logger;

public class EntityZombieVillager
extends EntityZombie
implements VillagerDataHolder {
    private static final Logger b = LogUtils.getLogger();
    public static final DataWatcherObject<Boolean> c = DataWatcher.a(EntityZombieVillager.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<VillagerData> d = DataWatcher.a(EntityZombieVillager.class, DataWatcherRegistry.t);
    private static final int bW = 3600;
    private static final int bX = 6000;
    private static final int bY = 14;
    private static final int bZ = 4;
    public int ca;
    @Nullable
    public UUID cb;
    @Nullable
    private NBTBase cc;
    @Nullable
    private NBTTagCompound cd;
    private int ce;
    private int lastTick = MinecraftServer.currentTick;

    public EntityZombieVillager(EntityTypes<? extends EntityZombieVillager> type, World world) {
        super((EntityTypes<? extends EntityZombie>)type, world);
        BuiltInRegistries.z.a(this.af).ifPresent(holder_c -> this.a(this.gd().a((VillagerProfession)holder_c.a())));
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(c, false);
        this.am.a(d, new VillagerData(VillagerType.c, VillagerProfession.b, 1));
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        DataResult dataresult = VillagerData.c.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.gd());
        Logger logger = b;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("VillagerData", (NBTBase)nbtbase));
        if (this.cd != null) {
            nbt.a("Offers", this.cd);
        }
        if (this.cc != null) {
            nbt.a("Gossips", this.cc);
        }
        nbt.a("ConversionTime", this.gc() ? this.ca : -1);
        if (this.cb != null) {
            nbt.a("ConversionPlayer", this.cb);
        }
        nbt.a("Xp", this.ce);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.b("VillagerData", 10)) {
            DataResult dataresult = VillagerData.c.parse(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbt.c("VillagerData")));
            Logger logger = b;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(this::a);
        }
        if (nbt.b("Offers", 10)) {
            this.cd = nbt.p("Offers");
        }
        if (nbt.b("Gossips", 9)) {
            this.cc = nbt.c("Gossips", 10);
        }
        if (nbt.b("ConversionTime", 99) && nbt.h("ConversionTime") > -1) {
            this.a(nbt.b("ConversionPlayer") ? nbt.a("ConversionPlayer") : null, nbt.h("ConversionTime"));
        }
        if (nbt.b("Xp", 3)) {
            this.ce = nbt.h("Xp");
        }
    }

    @Override
    public void l() {
        if (!this.H.B && this.bq() && this.gc()) {
            int i2 = this.gf();
            int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
            this.ca -= (i2 *= elapsedTicks);
            if (this.ca <= 0) {
                this.c((WorldServer)this.H);
            }
        }
        super.l();
        this.lastTick = MinecraftServer.currentTick;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (itemstack.a(Items.pi)) {
            if (this.a(MobEffects.r)) {
                if (!player.fK().d) {
                    itemstack.h(1);
                }
                if (!this.H.B) {
                    this.a(player.cs(), this.af.a(2401) + 3600);
                }
                return EnumInteractionResult.a;
            }
            return EnumInteractionResult.b;
        }
        return super.b(player, hand);
    }

    @Override
    protected boolean fT() {
        return false;
    }

    @Override
    public boolean h(double distanceSquared) {
        return !this.gc() && this.ce == 0;
    }

    public boolean gc() {
        return this.aj().a(c);
    }

    public void a(@Nullable UUID uuid, int delay) {
        this.startConverting(uuid, delay, true);
    }

    public void startConverting(@Nullable UUID uuid, int delay, boolean broadcastEntityEvent) {
        this.cb = uuid;
        this.ca = delay;
        this.aj().b(c, true);
        this.removeEffect(MobEffects.r, EntityPotionEffectEvent.Cause.CONVERSION);
        this.addEffect(new MobEffect(MobEffects.e, delay, Math.min(this.H.ah().a() - 1, 0)), EntityPotionEffectEvent.Cause.CONVERSION);
        if (broadcastEntityEvent) {
            this.H.a((Entity)this, (byte)16);
        }
    }

    @Override
    public void b(byte status) {
        if (status == 16) {
            if (!this.aO()) {
                this.H.a(this.dl(), this.dp(), this.dr(), SoundEffects.AO, this.cX(), 1.0f + this.af.i(), this.af.i() * 0.7f + 0.3f, false);
            }
        } else {
            super.b(status);
        }
    }

    private void c(WorldServer world) {
        EntityHuman entityhuman;
        EntityVillager entityvillager = this.convertTo(EntityTypes.bf, false, EntityTransformEvent.TransformReason.CURED, CreatureSpawnEvent.SpawnReason.CURED);
        if (entityvillager == null) {
            ((ZombieVillager)this.getBukkitEntity()).setConversionTime(-1);
            return;
        }
        for (EnumItemSlot enumitemslot : EnumItemSlot.values()) {
            ItemStack itemstack = this.c(enumitemslot);
            if (itemstack.b()) continue;
            if (EnchantmentManager.d(itemstack)) {
                entityvillager.a_(enumitemslot.b() + 300).a(itemstack);
                continue;
            }
            double d0 = this.f(enumitemslot);
            if (!(d0 > 1.0)) continue;
            this.forceDrops = true;
            this.b(itemstack);
            this.forceDrops = false;
        }
        entityvillager.a(this.gd());
        if (this.cc != null) {
            entityvillager.a(this.cc);
        }
        if (this.cd != null) {
            entityvillager.b(new MerchantRecipeList(this.cd));
        }
        entityvillager.t(this.ce);
        entityvillager.a(world, world.d_(entityvillager.dg()), EnumMobSpawn.i, (GroupDataEntity)null, null);
        entityvillager.c(world);
        if (this.cb != null && (entityhuman = world.getGlobalPlayerByUUID(this.cb)) instanceof EntityPlayer) {
            CriterionTriggers.r.a((EntityPlayer)entityhuman, this, entityvillager);
            world.a(ReputationEvent.a, (Entity)entityhuman, entityvillager);
        }
        entityvillager.addEffect(new MobEffect(MobEffects.i, 200, 0), EntityPotionEffectEvent.Cause.CONVERSION);
        if (!this.aO()) {
            world.a((EntityHuman)null, 1027, this.dg(), 0);
        }
    }

    private int gf() {
        int i2 = 1;
        if (this.af.i() < 0.01f) {
            int j2 = 0;
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            for (int k2 = (int)this.dl() - 4; k2 < (int)this.dl() + 4 && j2 < 14; ++k2) {
                for (int l2 = (int)this.dn() - 4; l2 < (int)this.dn() + 4 && j2 < 14; ++l2) {
                    for (int i1 = (int)this.dr() - 4; i1 < (int)this.dr() + 4 && j2 < 14; ++i1) {
                        IBlockData iblockdata = this.H.a_(blockposition_mutableblockposition.d(k2, l2, i1));
                        if (!iblockdata.a(Blocks.eW) && !(iblockdata.b() instanceof BlockBed)) continue;
                        if (this.af.i() < 0.3f) {
                            ++i2;
                        }
                        ++j2;
                    }
                }
            }
        }
        return i2;
    }

    @Override
    public float eO() {
        return this.y_() ? (this.af.i() - this.af.i()) * 0.2f + 2.0f : (this.af.i() - this.af.i()) * 0.2f + 1.0f;
    }

    @Override
    public SoundEffect s() {
        return SoundEffects.AM;
    }

    @Override
    public SoundEffect d(DamageSource source) {
        return SoundEffects.AQ;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.AP;
    }

    @Override
    public SoundEffect w() {
        return SoundEffects.AR;
    }

    @Override
    protected ItemStack fS() {
        return ItemStack.b;
    }

    public void c(NBTTagCompound offerData) {
        this.cd = offerData;
    }

    @Override
    public void a(NBTBase gossipData) {
        this.cc = gossipData;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        this.a(this.gd().a(VillagerType.a(world.v(this.dg()))));
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    public void a(VillagerData villagerData) {
        VillagerData villagerdata1 = this.gd();
        if (villagerdata1.b() != villagerData.b()) {
            this.cd = null;
        }
        this.am.b(d, villagerData);
    }

    @Override
    public VillagerData gd() {
        return this.am.a(d);
    }

    public int ge() {
        return this.ce;
    }

    @Override
    public void b(int xp) {
        this.ce = xp;
    }
}

