/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.piglin;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.ICrossbow;
import net.minecraft.world.entity.monster.piglin.EntityPiglinAbstract;
import net.minecraft.world.entity.monster.piglin.EntityPiglinArmPose;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;

public class EntityPiglin
extends EntityPiglinAbstract
implements ICrossbow,
InventoryCarrier {
    private static final DataWatcherObject<Boolean> bU = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> bV = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> bW = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.k);
    private static final UUID bX = UUID.fromString("766bfa64-11f3-11ea-8d71-362b9e155667");
    private static final AttributeModifier bY = new AttributeModifier(bX, "Baby speed boost", (double)0.2f, AttributeModifier.Operation.b);
    private static final int bZ = 16;
    private static final float ca = 0.35f;
    private static final int cb = 5;
    private static final float cc = 1.6f;
    private static final float cd = 0.1f;
    private static final int ce = 3;
    private static final float cf = 0.2f;
    private static final float cg = 0.82f;
    private static final double ch = 0.5;
    public final InventorySubcontainer ci = new InventorySubcontainer(8);
    public boolean cj;
    protected static final ImmutableList<SensorType<? extends Sensor<? super EntityPiglin>>> bS = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.f, SensorType.k);
    protected static final ImmutableList<MemoryModuleType<?>> bT = ImmutableList.of(MemoryModuleType.n, MemoryModuleType.v, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.an, MemoryModuleType.am, MemoryModuleType.K, MemoryModuleType.aO, MemoryModuleType.x, MemoryModuleType.y, (Object[])new MemoryModuleType[]{MemoryModuleType.m, MemoryModuleType.E, MemoryModuleType.o, MemoryModuleType.p, MemoryModuleType.q, MemoryModuleType.t, MemoryModuleType.aa, MemoryModuleType.ab, MemoryModuleType.z, MemoryModuleType.ac, MemoryModuleType.ad, MemoryModuleType.af, MemoryModuleType.ae, MemoryModuleType.ah, MemoryModuleType.ai, MemoryModuleType.ag, MemoryModuleType.ak, MemoryModuleType.L, MemoryModuleType.aq, MemoryModuleType.s, MemoryModuleType.ar, MemoryModuleType.as, MemoryModuleType.aj, MemoryModuleType.al, MemoryModuleType.at, MemoryModuleType.au, MemoryModuleType.av});
    public Set<Item> allowedBarterItems = new HashSet<Item>();
    public Set<Item> interestItems = new HashSet<Item>();

    public EntityPiglin(EntityTypes<? extends EntityPiglinAbstract> type, World world) {
        super(type, world);
        this.bI = 5;
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (this.y_()) {
            nbt.a("IsBaby", true);
        }
        if (this.cj) {
            nbt.a("CannotHunt", true);
        }
        this.a_(nbt);
        NBTTagList barterList = new NBTTagList();
        this.allowedBarterItems.stream().map(BuiltInRegistries.i::b).map(MinecraftKey::toString).map(NBTTagString::a).forEach(barterList::add);
        nbt.a("Bukkit.BarterList", barterList);
        NBTTagList interestList = new NBTTagList();
        this.interestItems.stream().map(BuiltInRegistries.i::b).map(MinecraftKey::toString).map(NBTTagString::a).forEach(interestList::add);
        nbt.a("Bukkit.InterestList", interestList);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a(nbt.q("IsBaby"));
        this.y(nbt.q("CannotHunt"));
        this.c(nbt);
        this.allowedBarterItems = nbt.c("Bukkit.BarterList", 8).stream().map(NBTBase::f_).map(MinecraftKey::a).map(BuiltInRegistries.i::a).collect(Collectors.toCollection(HashSet::new));
        this.interestItems = nbt.c("Bukkit.InterestList", 8).stream().map(NBTBase::f_).map(MinecraftKey::a).map(BuiltInRegistries.i::a).collect(Collectors.toCollection(HashSet::new));
    }

    @Override
    @VisibleForDebug
    public InventorySubcontainer w() {
        return this.ci;
    }

    @Override
    protected void a(DamageSource source, int lootingMultiplier, boolean allowDrops) {
        EntityCreeper entitycreeper;
        Entity entity;
        super.a(source, lootingMultiplier, allowDrops);
        if (this.Y().G().b(FeatureFlags.c) && (entity = source.d()) instanceof EntityCreeper && (entitycreeper = (EntityCreeper)entity).fT()) {
            ItemStack itemstack = new ItemStack(Items.tt);
            entitycreeper.fU();
            this.b(itemstack);
        }
        this.ci.f().forEach(this::b);
    }

    protected ItemStack l(ItemStack stack) {
        return this.ci.a(stack);
    }

    protected boolean m(ItemStack stack) {
        return this.ci.b(stack);
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(bU, false);
        this.am.a(bV, false);
        this.am.a(bW, false);
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        super.a(data);
        if (bU.equals(data)) {
            this.c_();
        }
    }

    public static AttributeProvider.Builder fZ() {
        return EntityMonster.fY().a(GenericAttributes.a, 16.0).a(GenericAttributes.d, 0.35f).a(GenericAttributes.f, 5.0);
    }

    public static boolean b(EntityTypes<EntityPiglin> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        return !world.a_(pos.d()).a(Blocks.kH);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        RandomSource randomsource = world.r_();
        if (spawnReason != EnumMobSpawn.d) {
            if (randomsource.i() < 0.2f) {
                this.a(true);
            } else if (this.fT()) {
                this.a(EnumItemSlot.a, this.gb());
            }
        }
        PiglinAI.a(this, world.r_());
        this.a(randomsource, difficulty);
        this.b(randomsource, difficulty);
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    protected boolean R() {
        return false;
    }

    @Override
    public boolean h(double distanceSquared) {
        return !this.fB();
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler localDifficulty) {
        if (this.fT()) {
            this.a(EnumItemSlot.f, new ItemStack(Items.oW), random);
            this.a(EnumItemSlot.e, new ItemStack(Items.oX), random);
            this.a(EnumItemSlot.d, new ItemStack(Items.oY), random);
            this.a(EnumItemSlot.c, new ItemStack(Items.oZ), random);
        }
    }

    private void a(EnumItemSlot slot, ItemStack stack, RandomSource random) {
        if (random.i() < 0.1f) {
            this.a(slot, stack);
        }
    }

    protected BehaviorController.b<EntityPiglin> dI() {
        return BehaviorController.a(bT, bS);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return PiglinAI.a(this, this.dI().a(dynamic));
    }

    public BehaviorController<EntityPiglin> dH() {
        return super.dH();
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        EnumInteractionResult enuminteractionresult = super.b(player, hand);
        if (enuminteractionresult.a()) {
            return enuminteractionresult;
        }
        if (!this.H.B) {
            return PiglinAI.a(this, player, hand);
        }
        boolean flag = PiglinAI.b(this, player.b(hand)) && this.fU() != EntityPiglinArmPose.d;
        return flag ? EnumInteractionResult.a : EnumInteractionResult.d;
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        float f2 = super.b(pose, dimensions);
        return this.y_() ? f2 - 0.82f : f2;
    }

    @Override
    public double bv() {
        return (double)this.dd() * 0.92;
    }

    @Override
    public void a(boolean baby) {
        this.aj().b(bU, baby);
        if (!this.H.B) {
            AttributeModifiable attributemodifiable = this.a(GenericAttributes.d);
            attributemodifiable.d(bY);
            if (baby) {
                attributemodifiable.b(bY);
            }
        }
    }

    @Override
    public boolean y_() {
        return this.aj().a(bU);
    }

    private void y(boolean cannotHunt) {
        this.cj = cannotHunt;
    }

    @Override
    protected boolean q() {
        return !this.cj;
    }

    @Override
    protected void U() {
        this.H.ac().a("piglinBrain");
        this.dH().a((WorldServer)this.H, this);
        this.H.ac().c();
        PiglinAI.a(this);
        super.U();
    }

    @Override
    public int dX() {
        return this.bI;
    }

    @Override
    protected void c(WorldServer world) {
        PiglinAI.b(this);
        this.forceDrops = true;
        this.ci.f().forEach(this::b);
        this.forceDrops = false;
        super.c(world);
    }

    private ItemStack gb() {
        return (double)this.af.i() < 0.5 ? new ItemStack(Items.uT) : new ItemStack(Items.od);
    }

    public boolean gc() {
        return this.am.a(bV);
    }

    @Override
    public void b(boolean charging) {
        this.am.b(bV, charging);
    }

    @Override
    public void a() {
        this.ba = 0;
    }

    @Override
    public EntityPiglinArmPose fU() {
        return this.ga() ? EntityPiglinArmPose.e : (PiglinAI.a(this.eL()) ? EntityPiglinArmPose.d : (this.fM() && this.fV() ? EntityPiglinArmPose.a : (this.gc() ? EntityPiglinArmPose.c : (this.fM() && this.b(Items.uT) ? EntityPiglinArmPose.b : EntityPiglinArmPose.f))));
    }

    public boolean ga() {
        return this.am.a(bW);
    }

    public void x(boolean dancing) {
        this.am.b(bW, dancing);
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        boolean flag = super.a(source, amount);
        if (this.H.B) {
            return false;
        }
        if (flag && source.d() instanceof EntityLiving) {
            PiglinAI.a(this, (EntityLiving)source.d());
        }
        return flag;
    }

    @Override
    public void a(EntityLiving target, float pullProgress) {
        this.b((EntityLiving)this, 1.6f);
    }

    @Override
    public void a(EntityLiving target, ItemStack crossbow, IProjectile projectile, float multiShotSpray) {
        this.a(this, target, projectile, multiShotSpray, 1.6f);
    }

    @Override
    public boolean a(ItemProjectileWeapon weapon) {
        return weapon == Items.uT;
    }

    protected void n(ItemStack stack) {
        this.b(EnumItemSlot.a, stack);
    }

    protected void o(ItemStack stack) {
        if (stack.a(PiglinAI.c) || this.allowedBarterItems.contains(stack.c())) {
            this.a(EnumItemSlot.b, stack);
            this.e(EnumItemSlot.b);
        } else {
            this.b(EnumItemSlot.b, stack);
        }
    }

    @Override
    public boolean k(ItemStack stack) {
        return this.H.W().b(GameRules.c) && this.fA() && PiglinAI.a(this, stack);
    }

    protected boolean p(ItemStack stack) {
        EnumItemSlot enumitemslot = EntityInsentient.h(stack);
        ItemStack itemstack1 = this.c(enumitemslot);
        return this.b(stack, itemstack1);
    }

    @Override
    protected boolean b(ItemStack newStack, ItemStack oldStack) {
        boolean flag1;
        if (EnchantmentManager.d(oldStack)) {
            return false;
        }
        boolean flag = PiglinAI.isLovedItem(newStack, this) || newStack.a(Items.uT);
        boolean bl = flag1 = PiglinAI.isLovedItem(oldStack, this) || oldStack.a(Items.uT);
        return flag && !flag1 ? true : (!flag && flag1 ? false : (this.fT() && !newStack.a(Items.uT) && oldStack.a(Items.uT) ? false : super.b(newStack, oldStack)));
    }

    @Override
    protected void b(EntityItem item) {
        PiglinAI.a(this, item);
    }

    @Override
    public boolean a(Entity entity, boolean force) {
        if (this.y_() && entity.ae() == EntityTypes.W) {
            entity = this.b(entity, 3);
        }
        return super.a(entity, force);
    }

    private Entity b(Entity entity, int maxLevel) {
        List<Entity> list = entity.cM();
        return maxLevel != 1 && !list.isEmpty() ? this.b(list.get(0), maxLevel - 1) : entity;
    }

    @Override
    protected SoundEffect s() {
        return this.H.B ? null : (SoundEffect)PiglinAI.c(this).orElse(null);
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.rJ;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.rH;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.rL, 0.15f, 1.0f);
    }

    protected void b(SoundEffect sound) {
        this.a(sound, this.eN(), this.eO());
    }

    @Override
    protected void fW() {
        this.b(SoundEffects.rM);
    }
}

