/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.Behaviors;
import net.minecraft.world.entity.ai.gossip.Reputation;
import net.minecraft.world.entity.ai.gossip.ReputationType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorGolemLastSeen;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityWitch;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.VillagerReplenishTradeEvent;
import org.bukkit.inventory.MerchantRecipe;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;
import top.leavesmc.leaves.LeavesConfig;

public class EntityVillager
extends EntityVillagerAbstract
implements ReputationHandler,
VillagerDataHolder {
    private static final Logger bY = LogUtils.getLogger();
    private static final DataWatcherObject<VillagerData> bZ = DataWatcher.a(EntityVillager.class, DataWatcherRegistry.t);
    public static final int bU = 12;
    public static final Map<Item, Integer> bV = ImmutableMap.of((Object)Items.oF, (Object)4, (Object)Items.ti, (Object)1, (Object)Items.th, (Object)1, (Object)Items.ul, (Object)1);
    private static final int ca = 2;
    private static final Set<Item> cb = ImmutableSet.of((Object)Items.oF, (Object)Items.ti, (Object)Items.th, (Object)Items.oE, (Object)Items.oD, (Object)Items.ul, (Object[])new Item[]{Items.um});
    private static final int cc = 10;
    private static final int cd = 1200;
    private static final int ce = 24000;
    private static final int cf = 25;
    private static final int cg = 10;
    private static final int ch = 5;
    private static final long ci = 24000L;
    @VisibleForTesting
    public static final float bW = 0.5f;
    private int cj;
    private boolean ck;
    @Nullable
    private EntityHuman cl;
    private boolean cm;
    private int cn;
    private final Reputation co = new Reputation();
    private long cp;
    private long cq;
    private int cr;
    private long cs;
    public int ct;
    private long cu;
    private boolean cv;
    private static final ImmutableList<MemoryModuleType<?>> cw = ImmutableList.of(MemoryModuleType.b, MemoryModuleType.c, MemoryModuleType.d, MemoryModuleType.e, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.i, MemoryModuleType.j, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.K, MemoryModuleType.aO, (Object[])new MemoryModuleType[]{MemoryModuleType.m, MemoryModuleType.n, MemoryModuleType.q, MemoryModuleType.r, MemoryModuleType.t, MemoryModuleType.v, MemoryModuleType.w, MemoryModuleType.x, MemoryModuleType.y, MemoryModuleType.A, MemoryModuleType.f, MemoryModuleType.C, MemoryModuleType.D, MemoryModuleType.E, MemoryModuleType.G, MemoryModuleType.H, MemoryModuleType.I, MemoryModuleType.F});
    private static final ImmutableList<SensorType<? extends Sensor<? super EntityVillager>>> cx = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.e, SensorType.f, SensorType.g, SensorType.h, SensorType.i, SensorType.j);
    public static final Map<MemoryModuleType<GlobalPos>, BiPredicate<EntityVillager, Holder<VillagePlaceType>>> bX = ImmutableMap.of(MemoryModuleType.b, (entityvillager, holder) -> holder.a(PoiTypes.n), MemoryModuleType.c, (entityvillager, holder) -> entityvillager.gd().b().b().test((Holder<VillagePlaceType>)holder), MemoryModuleType.d, (entityvillager, holder) -> VillagerProfession.a.test((Holder<VillagePlaceType>)holder), MemoryModuleType.e, (entityvillager, holder) -> holder.a(PoiTypes.o));

    public EntityVillager(EntityTypes<? extends EntityVillager> entityType, World world) {
        this(entityType, world, VillagerType.c);
    }

    public EntityVillager(EntityTypes<? extends EntityVillager> entityType, World world, VillagerType type) {
        super((EntityTypes<? extends EntityVillagerAbstract>)entityType, world);
        ((Navigation)this.G()).b(true);
        this.G().a(true);
        this.s(true);
        this.a(this.gd().a(type).a(VillagerProfession.b));
    }

    public BehaviorController<EntityVillager> dH() {
        return super.dH();
    }

    protected BehaviorController.b<EntityVillager> dI() {
        return BehaviorController.a(cw, cx);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        BehaviorController<EntityVillager> behaviorcontroller = this.dI().a(dynamic);
        this.a(behaviorcontroller);
        return behaviorcontroller;
    }

    public void c(WorldServer world) {
        BehaviorController<EntityVillager> behaviorcontroller = this.dH();
        behaviorcontroller.b(world, this);
        this.by = behaviorcontroller.i();
        this.a(this.dH());
    }

    @Override
    private void a(BehaviorController<EntityVillager> brain) {
        VillagerProfession villagerprofession = this.gd().b();
        if (this.y_()) {
            brain.a(Schedule.e);
            brain.a(Activity.d, Behaviors.a(0.5f));
        } else {
            brain.a(Schedule.f);
            brain.a(Activity.c, (ImmutableList<Pair<Integer, BehaviorControl<EntityVillager>>>)Behaviors.b(villagerprofession, 0.5f), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.c, (Object)((Object)MemoryStatus.a))));
        }
        brain.a(Activity.a, Behaviors.a(villagerprofession, 0.5f));
        brain.a(Activity.f, (ImmutableList<Pair<Integer, BehaviorControl<EntityVillager>>>)Behaviors.d(villagerprofession, 0.5f), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.e, (Object)((Object)MemoryStatus.a))));
        brain.a(Activity.e, Behaviors.c(villagerprofession, 0.5f));
        brain.a(Activity.b, Behaviors.e(villagerprofession, 0.5f));
        brain.a(Activity.g, Behaviors.f(villagerprofession, 0.5f));
        brain.a(Activity.i, Behaviors.g(villagerprofession, 0.5f));
        brain.a(Activity.h, Behaviors.h(villagerprofession, 0.5f));
        brain.a(Activity.j, Behaviors.i(villagerprofession, 0.5f));
        brain.a((Set<Activity>)ImmutableSet.of((Object)Activity.a));
        brain.b(Activity.b);
        brain.a(Activity.b);
        brain.a(this.H.V(), this.H.U());
    }

    @Override
    protected void m() {
        super.m();
        if (this.H instanceof WorldServer) {
            this.c((WorldServer)this.H);
        }
    }

    public static AttributeProvider.Builder gb() {
        return EntityInsentient.y().a(GenericAttributes.d, 0.5).a(GenericAttributes.b, 48.0);
    }

    public boolean gc() {
        return this.cv;
    }

    @Override
    public void inactiveTick() {
        if (this.q() > 0) {
            this.r(this.q() - 1);
        }
        if (this.cU()) {
            if (this.H.spigotConfig.tickInactiveVillagers) {
                this.U();
            } else {
                this.mobTick(true);
            }
        }
        this.gB();
        super.inactiveTick();
    }

    @Override
    protected void U() {
        this.mobTick(false);
    }

    protected void mobTick(boolean inactive) {
        Raid raid;
        this.H.ac().a("villagerBrain");
        if (!inactive) {
            this.dH().a((WorldServer)this.H, this);
        }
        this.H.ac().c();
        if (this.cv) {
            this.cv = false;
        }
        if (!this.fT() && this.cj > 0) {
            --this.cj;
            if (this.cj <= 0) {
                if (this.ck) {
                    this.gz();
                    this.ck = false;
                }
                this.addEffect(new MobEffect(MobEffects.j, 200, 0), EntityPotionEffectEvent.Cause.VILLAGER_TRADE);
            }
        }
        if (this.cl != null && this.H instanceof WorldServer) {
            ((WorldServer)this.H).a(ReputationEvent.e, (Entity)this.cl, this);
            this.H.a((Entity)this, (byte)14);
            this.cl = null;
        }
        if (!inactive && !this.fK() && this.af.a(100) == 0 && (raid = ((WorldServer)this.H).c(this.dg())) != null && raid.v() && !raid.a()) {
            this.H.a((Entity)this, (byte)42);
        }
        if (this.gd().b() == VillagerProfession.b && this.fT()) {
            this.fY();
        }
        if (inactive) {
            return;
        }
        super.U();
    }

    @Override
    public void l() {
        super.l();
        if (this.q() > 0) {
            this.r(this.q() - 1);
        }
        this.gB();
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (!itemstack.a(Items.sN) && this.bq() && !this.fT() && !this.fu()) {
            if (this.y_()) {
                this.go();
                return EnumInteractionResult.a(this.H.B);
            }
            boolean flag = this.fU().isEmpty();
            if (hand == EnumHand.a) {
                if (flag && !this.H.B) {
                    this.go();
                }
                player.a(StatisticList.S);
            }
            if (flag) {
                return EnumInteractionResult.a(this.H.B);
            }
            if (!this.H.B && !this.bT.isEmpty()) {
                this.g(player);
            }
            return EnumInteractionResult.a(this.H.B);
        }
        return super.b(player, hand);
    }

    public void go() {
        this.r(40);
        if (!this.H.k_()) {
            this.a(SoundEffects.ym, this.eN(), this.eO());
        }
    }

    private void g(EntityHuman customer) {
        this.h(customer);
        this.e(customer);
        this.a(customer, this.G_(), this.gd().c());
    }

    @Override
    public void e(@Nullable EntityHuman customer) {
        boolean flag = this.fS() != null && customer == null;
        super.e(customer);
        if (flag) {
            this.fY();
        }
    }

    @Override
    protected void fY() {
        super.fY();
        this.gp();
    }

    private void gp() {
        for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.fU()) {
            merchantrecipe.l();
        }
    }

    @Override
    public boolean ge() {
        return true;
    }

    @Override
    public boolean ga() {
        return this.Y().B;
    }

    public void gf() {
        this.gu();
        for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.fU()) {
            VillagerReplenishTradeEvent event = new VillagerReplenishTradeEvent((AbstractVillager)((Villager)this.getBukkitEntity()), (MerchantRecipe)merchantrecipe.asBukkit());
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            merchantrecipe.h();
        }
        this.gq();
        this.cs = this.H.U();
        ++this.ct;
    }

    private void gq() {
        MerchantRecipeList merchantrecipelist = this.fU();
        EntityHuman entityhuman = this.fS();
        if (entityhuman != null && !merchantrecipelist.isEmpty()) {
            entityhuman.a(entityhuman.bP.j, merchantrecipelist, this.gd().c(), this.r(), this.fV(), this.ge());
        }
    }

    private boolean gr() {
        net.minecraft.world.item.trading.MerchantRecipe merchantrecipe;
        Iterator iterator = this.fU().iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!(merchantrecipe = (net.minecraft.world.item.trading.MerchantRecipe)iterator.next()).r());
        return true;
    }

    private boolean gs() {
        return this.ct == 0 || this.ct < 2 && this.H.U() > this.cs + 2400L;
    }

    public boolean gg() {
        long i2 = this.cs + 12000L;
        long j2 = this.H.U();
        boolean flag = j2 > i2;
        long k2 = this.H.V();
        if (this.cu > 0L) {
            long i1 = k2 / 24000L;
            long l2 = this.cu / 24000L;
            flag |= i1 > l2;
        }
        this.cu = k2;
        if (flag) {
            this.cs = j2;
            this.gC();
        }
        return this.gs() && this.gr();
    }

    private void gt() {
        int i2 = 2 - this.ct;
        if (i2 > 0) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.fU()) {
                VillagerReplenishTradeEvent event = new VillagerReplenishTradeEvent((AbstractVillager)((Villager)this.getBukkitEntity()), (MerchantRecipe)merchantrecipe.asBukkit());
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                merchantrecipe.h();
            }
        }
        for (int j2 = 0; j2 < i2; ++j2) {
            this.gu();
        }
        this.gq();
    }

    private void gu() {
        for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.fU()) {
            merchantrecipe.e();
        }
    }

    private void h(EntityHuman player) {
        int i2 = this.f(player);
        if (i2 != 0) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.fU()) {
                if (merchantrecipe.ignoreDiscounts) continue;
                merchantrecipe.a(-MathHelper.d((float)i2 * merchantrecipe.n()));
            }
        }
        if (player.a(MobEffects.F)) {
            MobEffect mobeffect = player.b(MobEffects.F);
            int j2 = mobeffect.e();
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe1 : this.fU()) {
                if (merchantrecipe1.ignoreDiscounts) continue;
                double d0 = 0.3 + 0.0625 * (double)j2;
                int k2 = (int)Math.floor(d0 * (double)merchantrecipe1.a().K());
                merchantrecipe1.a(-Math.max(k2, 1));
            }
        }
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(bZ, new VillagerData(VillagerType.c, VillagerProfession.b, 1));
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        DataResult dataresult = VillagerData.c.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.gd());
        Logger logger = bY;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("VillagerData", (NBTBase)nbtbase));
        nbt.a("FoodLevel", (byte)this.cn);
        nbt.a("Gossips", this.co.a(DynamicOpsNBT.a));
        nbt.a("Xp", this.cr);
        nbt.a("LastRestock", this.cs);
        nbt.a("LastGossipDecay", this.cq);
        nbt.a("RestocksToday", this.ct);
        if (this.cv) {
            nbt.a("AssignProfessionWhenSpawned", true);
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.b("VillagerData", 10)) {
            DataResult dataresult = VillagerData.c.parse(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbt.c("VillagerData")));
            Logger logger = bY;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(this::a);
        }
        if (nbt.b("Offers", 10)) {
            this.bT = new MerchantRecipeList(nbt.p("Offers"));
        }
        if (nbt.b("FoodLevel", 1)) {
            this.cn = nbt.f("FoodLevel");
        }
        NBTTagList nbttaglist = nbt.c("Gossips", 10);
        this.co.a(new Dynamic<NBTTagList>(DynamicOpsNBT.a, nbttaglist));
        if (nbt.b("Xp", 3)) {
            this.cr = nbt.h("Xp");
        }
        this.cs = nbt.i("LastRestock");
        this.cq = nbt.i("LastGossipDecay");
        this.s(true);
        if (this.H instanceof WorldServer) {
            this.c((WorldServer)this.H);
        }
        this.ct = nbt.h("RestocksToday");
        if (nbt.e("AssignProfessionWhenSpawned")) {
            this.cv = nbt.q("AssignProfessionWhenSpawned");
        }
    }

    @Override
    public boolean h(double distanceSquared) {
        return false;
    }

    @Override
    @Nullable
    protected SoundEffect s() {
        return this.fu() ? null : (this.fT() ? SoundEffects.yn : SoundEffects.yi);
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.yl;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.yk;
    }

    public void gh() {
        SoundEffect soundeffect = this.gd().b().f();
        if (soundeffect != null) {
            this.a(soundeffect, this.eN(), this.eO());
        }
    }

    @Override
    public void a(VillagerData villagerData) {
        VillagerData villagerdata1 = this.gd();
        if (villagerdata1.b() != villagerData.b()) {
            this.bT = null;
        }
        this.am.b(bZ, villagerData);
    }

    @Override
    public VillagerData gd() {
        return this.am.a(bZ);
    }

    @Override
    protected void b(net.minecraft.world.item.trading.MerchantRecipe offer) {
        int i2 = 3 + this.af.a(4);
        this.cr += offer.o();
        this.cl = this.fS();
        if (this.gy()) {
            this.cj = 40;
            this.ck = true;
            i2 += 5;
        }
        if (offer.s()) {
            this.H.b(new EntityExperienceOrb(this.H, this.dl(), this.dn() + 0.5, this.dr(), i2, ExperienceOrb.SpawnReason.VILLAGER_TRADE, this.fS(), this));
        }
    }

    public void x(boolean flag) {
        this.cm = flag;
    }

    public boolean gi() {
        return this.cm;
    }

    @Override
    public void a(@Nullable EntityLiving attacker) {
        if (attacker != null && this.H instanceof WorldServer) {
            ((WorldServer)this.H).a(ReputationEvent.c, (Entity)attacker, this);
            if (this.bq() && attacker instanceof EntityHuman) {
                this.H.a((Entity)this, (byte)13);
            }
        }
        super.a(attacker);
    }

    @Override
    public void a(DamageSource damageSource) {
        Entity entity;
        if (SpigotConfig.logVillagerDeaths) {
            bY.info("Villager {} died, message: '{}'", (Object)this, (Object)damageSource.a(this).getString());
        }
        if ((entity = damageSource.d()) != null) {
            this.a(entity);
        }
        this.gv();
        super.a(damageSource);
    }

    public void gv() {
        this.a(MemoryModuleType.b);
        this.a(MemoryModuleType.c);
        this.a(MemoryModuleType.d);
        this.a(MemoryModuleType.e);
    }

    @Override
    private void a(Entity killer) {
        World world = this.H;
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            Optional<NearestVisibleLivingEntities> optional = this.by.c(MemoryModuleType.h);
            if (!optional.isEmpty()) {
                NearestVisibleLivingEntities nearestvisiblelivingentities = optional.get();
                Objects.requireNonNull(ReputationHandler.class);
                nearestvisiblelivingentities.b(ReputationHandler.class::isInstance).forEach(entityliving -> worldserver.a(ReputationEvent.d, killer, (ReputationHandler)((Object)entityliving)));
            }
        }
    }

    @Override
    public void a(MemoryModuleType<GlobalPos> pos) {
        if (this.H instanceof WorldServer) {
            MinecraftServer minecraftserver = ((WorldServer)this.H).n();
            this.by.c(pos).ifPresent(globalpos -> {
                WorldServer worldserver = minecraftserver.a(globalpos.a());
                if (worldserver != null) {
                    VillagePlace villageplace = worldserver.w();
                    Optional<Holder<VillagePlaceType>> optional = villageplace.c(globalpos.b());
                    BiPredicate<EntityVillager, Holder<VillagePlaceType>> bipredicate = bX.get(pos);
                    if (optional.isPresent() && bipredicate.test(this, optional.get())) {
                        villageplace.b(globalpos.b());
                        PacketDebug.c(worldserver, globalpos.b());
                    }
                }
            });
        }
    }

    @Override
    public boolean O_() {
        return this.cn + this.gA() >= 12 && !this.fu() && this.h() == 0;
    }

    private boolean gw() {
        return this.cn < 12;
    }

    private void gx() {
        if (this.gw() && this.gA() != 0) {
            for (int i2 = 0; i2 < this.w().b(); ++i2) {
                int j2;
                Integer integer;
                ItemStack itemstack = this.w().a(i2);
                if (itemstack.b() || (integer = bV.get(itemstack.c())) == null) continue;
                for (int k2 = j2 = itemstack.K(); k2 > 0; --k2) {
                    this.cn += integer.intValue();
                    this.w().a(i2, 1);
                    if (this.gw()) continue;
                    return;
                }
            }
        }
    }

    public int f(EntityHuman player) {
        return this.co.a(player.cs(), (ReputationType reputationtype) -> true);
    }

    private void u(int amount) {
        this.cn -= amount;
    }

    public void gj() {
        this.gx();
        this.u(12);
    }

    public void b(MerchantRecipeList offers) {
        this.bT = offers;
    }

    private boolean gy() {
        int i2 = this.gd().c();
        return VillagerData.d(i2) && this.cr >= VillagerData.c(i2);
    }

    public void gz() {
        this.a(this.gd().a(this.gd().c() + 1));
        this.fZ();
    }

    @Override
    protected IChatBaseComponent cj() {
        String s2 = this.ae().g();
        return IChatBaseComponent.c(s2 + "." + BuiltInRegistries.z.b(this.gd().b()).a());
    }

    @Override
    public void b(byte status) {
        if (status == 12) {
            this.a(Particles.O);
        } else if (status == 13) {
            this.a(Particles.b);
        } else if (status == 14) {
            this.a(Particles.M);
        } else if (status == 42) {
            this.a(Particles.ai);
        } else {
            super.b(status);
        }
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        if (spawnReason == EnumMobSpawn.e) {
            this.a(this.gd().a(VillagerProfession.b));
        }
        if (spawnReason == EnumMobSpawn.n || spawnReason == EnumMobSpawn.m || spawnReason == EnumMobSpawn.c || spawnReason == EnumMobSpawn.o) {
            this.a(this.gd().a(VillagerType.a(world.v(this.dg()))));
        }
        if (spawnReason == EnumMobSpawn.d) {
            this.cv = true;
        }
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Nullable
    public EntityVillager b(WorldServer world, EntityAgeable entity) {
        double d0 = this.af.j();
        VillagerType villagertype = d0 < 0.5 ? VillagerType.a(world.v(this.dg())) : (d0 < 0.75 ? this.gd().a() : ((EntityVillager)entity).gd().a());
        EntityVillager entityvillager = new EntityVillager(EntityTypes.bf, world, villagertype);
        entityvillager.a(world, world.d_(entityvillager.dg()), EnumMobSpawn.e, (GroupDataEntity)null, null);
        return entityvillager;
    }

    @Override
    public void a(WorldServer world, EntityLightning lightning) {
        if (world.ah() != EnumDifficulty.a) {
            EntityWitch entitywitch = EntityTypes.bj.a(world);
            if (entitywitch != null) {
                if (CraftEventFactory.callEntityZapEvent(this, lightning, entitywitch).isCancelled()) {
                    return;
                }
                if (SpigotConfig.logVillagerDeaths) {
                    bY.info("Villager {} was struck by lightning {}.", (Object)this, (Object)lightning);
                }
                entitywitch.b(this.dl(), this.dn(), this.dr(), this.dw(), this.dy());
                entitywitch.a(world, world.d_(entitywitch.dg()), EnumMobSpawn.i, (GroupDataEntity)null, null);
                entitywitch.t(this.fK());
                if (this.aa()) {
                    entitywitch.b(this.ab());
                    entitywitch.n(this.cx());
                }
                entitywitch.fz();
                if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, entitywitch, EntityTransformEvent.TransformReason.LIGHTNING).isCancelled()) {
                    return;
                }
                world.addFreshEntityWithPassengers(entitywitch, CreatureSpawnEvent.SpawnReason.LIGHTNING);
                this.gv();
                this.ai();
            } else {
                super.a(world, lightning);
            }
        } else {
            super.a(world, lightning);
        }
    }

    @Override
    protected void b(EntityItem item) {
        InventoryCarrier.a(this, this, item);
    }

    @Override
    public boolean k(ItemStack stack) {
        Item item = stack.c();
        return (cb.contains(item) || this.gd().b().d().contains((Object)item)) && this.w().b(stack);
    }

    public boolean gk() {
        return this.gA() >= 24;
    }

    public boolean gl() {
        return this.gA() < 12;
    }

    private int gA() {
        InventorySubcontainer inventorysubcontainer = this.w();
        return bV.entrySet().stream().mapToInt(entry -> inventorysubcontainer.a_((Item)entry.getKey()) * (Integer)entry.getValue()).sum();
    }

    public boolean gm() {
        return this.w().a((Set<Item>)ImmutableSet.of((Object)Items.oD, (Object)Items.ti, (Object)Items.th, (Object)Items.um));
    }

    @Override
    protected void fZ() {
        this.updateTrades(2);
    }

    public boolean updateTrades(int amount) {
        VillagerTrades.IMerchantRecipeOption[] avillagertrades_imerchantrecipeoption;
        VillagerData villagerdata = this.gd();
        Int2ObjectMap<VillagerTrades.IMerchantRecipeOption[]> int2objectmap = VillagerTrades.a.get(villagerdata.b());
        if (int2objectmap != null && !int2objectmap.isEmpty() && (avillagertrades_imerchantrecipeoption = (VillagerTrades.IMerchantRecipeOption[])int2objectmap.get(villagerdata.c())) != null) {
            MerchantRecipeList merchantrecipelist = this.fU();
            this.a(merchantrecipelist, avillagertrades_imerchantrecipeoption, amount);
            return true;
        }
        return false;
    }

    public void a(WorldServer world, EntityVillager villager, long time) {
        if (!(time >= this.cp && time < this.cp + 1200L || time >= villager.cp && time < villager.cp + 1200L)) {
            this.co.a(villager.co, this.af, 10);
            this.cp = time;
            villager.cp = time;
            this.a(world, time, 5);
        }
    }

    private void gB() {
        long i2 = this.H.U();
        if (this.cq == 0L) {
            this.cq = i2;
        } else if (i2 >= this.cq + 24000L) {
            this.co.b();
            this.cq = i2;
        }
    }

    public void a(WorldServer world, long time, int requiredCount) {
        AxisAlignedBB axisalignedbb;
        List<EntityVillager> list;
        List list1;
        if (this.a(time) && (list1 = (list = world.a(EntityVillager.class, axisalignedbb = this.cD().c(10.0, 10.0, 10.0))).stream().filter(entityvillager -> entityvillager.a(time)).limit(5L).collect(Collectors.toList())).size() >= requiredCount && SpawnUtil.trySpawnMob(EntityTypes.ac, EnumMobSpawn.f, world, this.dg(), 10, 8, 6, SpawnUtil.a.a, CreatureSpawnEvent.SpawnReason.VILLAGE_DEFENSE, () -> SensorGolemLastSeen.b(this)).isPresent()) {
            list.forEach(SensorGolemLastSeen::b);
        }
    }

    public boolean a(long time) {
        return !this.b(this.H.U()) ? false : !this.by.a(MemoryModuleType.F);
    }

    @Override
    public void a(ReputationEvent interaction, Entity entity) {
        if (interaction == ReputationEvent.a) {
            Reputation.a playerReputation;
            if (!LeavesConfig.mcTechnicalMode && this.H.paperConfig().fixes.fixCuringZombieVillagerDiscountExploit && (playerReputation = this.gn().c.get(entity.cs())) != null) {
                playerReputation.b(ReputationType.d);
                playerReputation.b(ReputationType.c);
            }
            this.co.a(entity.cs(), ReputationType.d, 20);
            this.co.a(entity.cs(), ReputationType.c, 25);
        } else if (interaction == ReputationEvent.e) {
            this.co.a(entity.cs(), ReputationType.e, 2);
        } else if (interaction == ReputationEvent.c) {
            this.co.a(entity.cs(), ReputationType.b, 25);
        } else if (interaction == ReputationEvent.d) {
            this.co.a(entity.cs(), ReputationType.a, 25);
        }
    }

    @Override
    public int r() {
        return this.cr;
    }

    public void t(int experience) {
        this.cr = experience;
    }

    private void gC() {
        this.gt();
        this.ct = 0;
    }

    public Reputation gn() {
        return this.co;
    }

    @Override
    public void a(NBTBase nbt) {
        this.co.a(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbt));
    }

    @Override
    protected void T() {
        super.T();
        PacketDebug.a(this);
    }

    @Override
    public void b(BlockPosition pos) {
        super.b(pos);
        this.by.a(MemoryModuleType.G, Long.valueOf(this.H.U()));
        this.by.b(MemoryModuleType.m);
        this.by.b(MemoryModuleType.E);
    }

    @Override
    public void fv() {
        super.fv();
        this.by.a(MemoryModuleType.H, Long.valueOf(this.H.U()));
    }

    private boolean b(long worldTime) {
        Optional<Long> optional = this.by.c(MemoryModuleType.G);
        return optional.isPresent() ? worldTime - optional.get() < 24000L : false;
    }
}

