/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.IDyeable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmorColorable;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemEnchantedBook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemSuspiciousStew;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.WeightedRandomEnchant;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapIcon;
import net.minecraft.world.level.saveddata.maps.WorldMap;

public class VillagerTrades {
    private static final int d = 12;
    private static final int e = 16;
    private static final int f = 3;
    private static final int g = 1;
    private static final int h = 2;
    private static final int i = 5;
    private static final int j = 10;
    private static final int k = 10;
    private static final int l = 20;
    private static final int m = 15;
    private static final int n = 30;
    private static final int o = 30;
    private static final float p = 0.05f;
    private static final float q = 0.2f;
    public static final Map<VillagerProfession, Int2ObjectMap<IMerchantRecipeOption[]>> a = SystemUtils.a(Maps.newHashMap(), map -> {
        map.put(VillagerProfession.g, VillagerTrades.a((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.oE, 20, 16, 2), new b(Items.ti, 26, 16, 2), new b(Items.th, 22, 16, 2), new b(Items.ul, 15, 16, 2), new h(Items.oF, 1, 6, 16, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Blocks.dU, 6, 12, 10), new h(Items.tv, 1, 4, 5), new h(Items.nB, 1, 4, 16, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new h(Items.ra, 3, 18, 10), new b(Blocks.eZ, 4, 12, 20)}, (Object)4, (Object)new IMerchantRecipeOption[]{new h(Blocks.eg, 1, 1, 12, 15), new i(MobEffects.p, 100, 15), new i(MobEffects.h, 160, 15), new i(MobEffects.r, 140, 15), new i(MobEffects.o, 120, 15), new i(MobEffects.s, 280, 15), new i(MobEffects.w, 7, 15)}, (Object)5, (Object)new IMerchantRecipeOption[]{new h(Items.tm, 3, 3, 30), new h(Items.rA, 4, 3, 30)})));
        map.put(VillagerProfession.h, VillagerTrades.a((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.oA, 20, 16, 2), new b(Items.nE, 10, 16, 2), new g(Items.qh, 6, Items.ql, 6, 16, 1), new h(Items.pP, 3, 1, 16, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.qh, 15, 16, 10), new g(Items.qi, 6, Items.qm, 6, 16, 5), new h(Items.vr, 2, 1, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.qi, 13, 16, 20), new e(Items.qd, 3, 3, 10, 0.2f)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.qj, 6, 12, 30)}, (Object)5, (Object)new IMerchantRecipeOption[]{new b(Items.qk, 4, 12, 30), new c(1, 12, 30, (Map<VillagerType, Item>)ImmutableMap.builder().put((Object)VillagerType.c, (Object)Items.ne).put((Object)VillagerType.g, (Object)Items.ng).put((Object)VillagerType.e, (Object)Items.ng).put((Object)VillagerType.a, (Object)Items.nk).put((Object)VillagerType.b, (Object)Items.nk).put((Object)VillagerType.d, (Object)Items.nm).put((Object)VillagerType.f, (Object)Items.nq).build())})));
        map.put(VillagerProfession.n, VillagerTrades.a((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Blocks.bz, 18, 16, 2), new b(Blocks.bL, 18, 16, 2), new b(Blocks.bO, 18, 16, 2), new b(Blocks.bG, 18, 16, 2), new h(Items.rc, 2, 1, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.qq, 12, 16, 10), new b(Items.qx, 12, 16, 10), new b(Items.qF, 12, 16, 10), new b(Items.qt, 12, 16, 10), new b(Items.qv, 12, 16, 10), new h(Blocks.bz, 1, 1, 16, 5), new h(Blocks.bA, 1, 1, 16, 5), new h(Blocks.bB, 1, 1, 16, 5), new h(Blocks.bC, 1, 1, 16, 5), new h(Blocks.bD, 1, 1, 16, 5), new h(Blocks.bE, 1, 1, 16, 5), new h(Blocks.bF, 1, 1, 16, 5), new h(Blocks.bG, 1, 1, 16, 5), new h(Blocks.bH, 1, 1, 16, 5), new h(Blocks.bI, 1, 1, 16, 5), new h(Blocks.bJ, 1, 1, 16, 5), new h(Blocks.bK, 1, 1, 16, 5), new h(Blocks.bL, 1, 1, 16, 5), new h(Blocks.bM, 1, 1, 16, 5), new h(Blocks.bN, 1, 1, 16, 5), new h(Blocks.bO, 1, 1, 16, 5), new h(Blocks.ij, 1, 4, 16, 5), new h(Blocks.ik, 1, 4, 16, 5), new h(Blocks.il, 1, 4, 16, 5), new h(Blocks.im, 1, 4, 16, 5), new h(Blocks.in, 1, 4, 16, 5), new h(Blocks.io, 1, 4, 16, 5), new h(Blocks.ip, 1, 4, 16, 5), new h(Blocks.iq, 1, 4, 16, 5), new h(Blocks.ir, 1, 4, 16, 5), new h(Blocks.is, 1, 4, 16, 5), new h(Blocks.it, 1, 4, 16, 5), new h(Blocks.iu, 1, 4, 16, 5), new h(Blocks.iv, 1, 4, 16, 5), new h(Blocks.iw, 1, 4, 16, 5), new h(Blocks.ix, 1, 4, 16, 5), new h(Blocks.iy, 1, 4, 16, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.qu, 12, 16, 20), new b(Items.qy, 12, 16, 20), new b(Items.qr, 12, 16, 20), new b(Items.qE, 12, 16, 20), new b(Items.qw, 12, 16, 20), new h(Blocks.aY, 3, 1, 12, 10), new h(Blocks.bc, 3, 1, 12, 10), new h(Blocks.bm, 3, 1, 12, 10), new h(Blocks.bn, 3, 1, 12, 10), new h(Blocks.bj, 3, 1, 12, 10), new h(Blocks.bk, 3, 1, 12, 10), new h(Blocks.bh, 3, 1, 12, 10), new h(Blocks.bf, 3, 1, 12, 10), new h(Blocks.bl, 3, 1, 12, 10), new h(Blocks.bb, 3, 1, 12, 10), new h(Blocks.bg, 3, 1, 12, 10), new h(Blocks.bd, 3, 1, 12, 10), new h(Blocks.ba, 3, 1, 12, 10), new h(Blocks.aZ, 3, 1, 12, 10), new h(Blocks.be, 3, 1, 12, 10), new h(Blocks.bi, 3, 1, 12, 10)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.qC, 12, 16, 30), new b(Items.qA, 12, 16, 30), new b(Items.qB, 12, 16, 30), new b(Items.qD, 12, 16, 30), new b(Items.qs, 12, 16, 30), new b(Items.qz, 12, 16, 30), new h(Items.tR, 3, 1, 12, 15), new h(Items.uc, 3, 1, 12, 15), new h(Items.tU, 3, 1, 12, 15), new h(Items.uf, 3, 1, 12, 15), new h(Items.tX, 3, 1, 12, 15), new h(Items.ue, 3, 1, 12, 15), new h(Items.tW, 3, 1, 12, 15), new h(Items.tY, 3, 1, 12, 15), new h(Items.ug, 3, 1, 12, 15), new h(Items.ub, 3, 1, 12, 15), new h(Items.tT, 3, 1, 12, 15), new h(Items.ua, 3, 1, 12, 15), new h(Items.ud, 3, 1, 12, 15), new h(Items.tV, 3, 1, 12, 15), new h(Items.tS, 3, 1, 12, 15), new h(Items.tZ, 3, 1, 12, 15)}, (Object)5, (Object)new IMerchantRecipeOption[]{new h(Items.ph, 2, 3, 30)})));
        map.put(VillagerProfession.i, VillagerTrades.a((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.ox, 32, 16, 2), new h(Items.nD, 1, 16, 1), new g(Blocks.L, 10, Items.pe, 10, 12, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.pe, 26, 12, 10), new h(Items.nC, 2, 1, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.oA, 14, 16, 20), new h(Items.uT, 3, 1, 10)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.oB, 24, 16, 30), new e(Items.nC, 2, 3, 15)}, (Object)5, (Object)new IMerchantRecipeOption[]{new b(Items.lB, 8, 12, 30), new e(Items.uT, 3, 3, 15), new j(Items.nD, 5, Items.ur, 5, 2, 12, 30)})));
        map.put(VillagerProfession.k, VillagerTrades.a((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.builder().put((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.pW, 24, 16, 2), new d(1), new h(Blocks.ck, 9, 1, 12, 1)}).put((Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.pX, 4, 12, 10), new d(5), new h(Items.vn, 1, 1, 5)}).put((Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.qn, 5, 12, 20), new d(10), new h(Items.cj, 1, 4, 10)}).put((Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.tc, 2, 12, 30), new d(15), new h(Items.qe, 5, 1, 15), new h(Items.qa, 4, 1, 15)}).put((Object)5, (Object)new IMerchantRecipeOption[]{new h(Items.tN, 20, 1, 30)}).build()));
        map.put(VillagerProfession.e, VillagerTrades.a((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.pW, 24, 16, 2), new h(Items.tl, 7, 1, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.fv, 11, 16, 10), new k(13, StructureTags.d, "filled_map.monument", MapIcon.Type.j, 12, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.qa, 1, 12, 20), new k(14, StructureTags.c, "filled_map.mansion", MapIcon.Type.i, 12, 10)}, (Object)4, (Object)new IMerchantRecipeOption[]{new h(Items.te, 7, 1, 15), new h(Items.tR, 3, 1, 15), new h(Items.uc, 3, 1, 15), new h(Items.tU, 3, 1, 15), new h(Items.uf, 3, 1, 15), new h(Items.tX, 3, 1, 15), new h(Items.ue, 3, 1, 15), new h(Items.tW, 3, 1, 15), new h(Items.tY, 3, 1, 15), new h(Items.ug, 3, 1, 15), new h(Items.ub, 3, 1, 15), new h(Items.tT, 3, 1, 15), new h(Items.ua, 3, 1, 15), new h(Items.ud, 3, 1, 15), new h(Items.tV, 3, 1, 15), new h(Items.tS, 3, 1, 15), new h(Items.tZ, 3, 1, 15)}, (Object)5, (Object)new IMerchantRecipeOption[]{new h(Items.va, 8, 1, 30)})));
        map.put(VillagerProfession.f, VillagerTrades.a((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.rl, 32, 16, 2), new h(Items.li, 1, 2, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.nQ, 3, 12, 10), new h(Items.nI, 1, 1, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.tF, 2, 12, 20), new h(Blocks.ec, 4, 1, 12, 10)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.nz, 4, 12, 30), new b(Items.rs, 9, 12, 30), new h(Items.rm, 5, 1, 15)}, (Object)5, (Object)new IMerchantRecipeOption[]{new b(Items.rq, 22, 12, 30), new h(Items.ta, 3, 1, 30)})));
        map.put(VillagerProfession.c, VillagerTrades.a((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.nE, 15, 16, 2), new h(new ItemStack(Items.oQ), 7, 1, 12, 1, 0.2f), new h(new ItemStack(Items.oR), 4, 1, 12, 1, 0.2f), new h(new ItemStack(Items.oO), 5, 1, 12, 1, 0.2f), new h(new ItemStack(Items.oP), 9, 1, 12, 1, 0.2f)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.nM, 4, 12, 10), new h(new ItemStack(Items.vm), 36, 1, 12, 5, 0.2f), new h(new ItemStack(Items.oN), 1, 1, 12, 5, 0.2f), new h(new ItemStack(Items.oM), 3, 1, 12, 5, 0.2f)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.pI, 1, 12, 20), new b(Items.nG, 1, 12, 20), new h(new ItemStack(Items.oK), 1, 1, 12, 10, 0.2f), new h(new ItemStack(Items.oL), 4, 1, 12, 10, 0.2f), new h(new ItemStack(Items.ut), 5, 1, 12, 10, 0.2f)}, (Object)4, (Object)new IMerchantRecipeOption[]{new e(Items.oU, 14, 3, 15, 0.2f), new e(Items.oV, 8, 3, 15, 0.2f)}, (Object)5, (Object)new IMerchantRecipeOption[]{new e(Items.oS, 8, 3, 30, 0.2f), new e(Items.oT, 16, 3, 30, 0.2f)})));
        map.put(VillagerProfession.p, VillagerTrades.a((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.nE, 15, 16, 2), new h(new ItemStack(Items.ol), 3, 1, 12, 1, 0.2f), new e(Items.oi, 2, 3, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.nM, 4, 12, 10), new h(new ItemStack(Items.vm), 36, 1, 12, 5, 0.2f)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.pe, 24, 12, 20)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.nG, 1, 12, 30), new e(Items.oq, 12, 3, 15, 0.2f)}, (Object)5, (Object)new IMerchantRecipeOption[]{new e(Items.on, 8, 3, 30, 0.2f)})));
        map.put(VillagerProfession.o, VillagerTrades.a((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.nE, 15, 16, 2), new h(new ItemStack(Items.ob), 1, 1, 12, 1, 0.2f), new h(new ItemStack(Items.nZ), 1, 1, 12, 1, 0.2f), new h(new ItemStack(Items.oa), 1, 1, 12, 1, 0.2f), new h(new ItemStack(Items.oc), 1, 1, 12, 1, 0.2f)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.nM, 4, 12, 10), new h(new ItemStack(Items.vm), 36, 1, 12, 5, 0.2f)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.pe, 30, 12, 20), new e(Items.ol, 1, 3, 10, 0.2f), new e(Items.oj, 2, 3, 10, 0.2f), new e(Items.ok, 3, 3, 10, 0.2f), new h(new ItemStack(Items.or), 4, 1, 3, 10, 0.2f)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.nG, 1, 12, 30), new e(Items.oq, 12, 3, 15, 0.2f), new e(Items.oo, 5, 3, 15, 0.2f)}, (Object)5, (Object)new IMerchantRecipeOption[]{new e(Items.op, 13, 3, 30, 0.2f)})));
        map.put(VillagerProfession.d, VillagerTrades.a((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.rj, 14, 16, 2), new b(Items.pf, 7, 16, 2), new b(Items.tC, 4, 16, 2), new h(Items.tE, 1, 1, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.nE, 15, 16, 2), new h(Items.pg, 1, 5, 16, 5), new h(Items.rk, 1, 8, 16, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.tP, 7, 16, 20), new b(Items.rh, 10, 16, 20)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.pV, 10, 12, 30)}, (Object)5, (Object)new IMerchantRecipeOption[]{new b(Items.vp, 10, 12, 30)})));
        map.put(VillagerProfession.j, VillagerTrades.a((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.pL, 6, 16, 2), new a(Items.oI, 3), new a(Items.oH, 7)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.pe, 26, 12, 10), new a(Items.oG, 5, 12, 5), new a(Items.oJ, 4, 12, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.tG, 9, 12, 20), new a(Items.oH, 7)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.nz, 4, 12, 30), new a(Items.tL, 6, 12, 15)}, (Object)5, (Object)new IMerchantRecipeOption[]{new h(new ItemStack(Items.mV), 6, 1, 12, 30, 0.2f), new a(Items.oG, 5, 12, 30)})));
        map.put(VillagerProfession.l, VillagerTrades.a((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.pU, 10, 16, 2), new h(Items.pT, 1, 10, 16, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Blocks.b, 20, 16, 10), new h(Blocks.eK, 1, 4, 16, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Blocks.c, 16, 16, 20), new b(Blocks.g, 16, 16, 20), new b(Blocks.e, 16, 16, 20), new h(Blocks.ro, 1, 4, 16, 10), new h(Blocks.h, 1, 4, 16, 10), new h(Blocks.f, 1, 4, 16, 10), new h(Blocks.d, 1, 4, 16, 10)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.nJ, 12, 12, 30), new h(Blocks.hj, 1, 1, 12, 15), new h(Blocks.hi, 1, 1, 12, 15), new h(Blocks.ht, 1, 1, 12, 15), new h(Blocks.hl, 1, 1, 12, 15), new h(Blocks.hp, 1, 1, 12, 15), new h(Blocks.hq, 1, 1, 12, 15), new h(Blocks.hx, 1, 1, 12, 15), new h(Blocks.hw, 1, 1, 12, 15), new h(Blocks.ho, 1, 1, 12, 15), new h(Blocks.hk, 1, 1, 12, 15), new h(Blocks.hn, 1, 1, 12, 15), new h(Blocks.hv, 1, 1, 12, 15), new h(Blocks.hr, 1, 1, 12, 15), new h(Blocks.hs, 1, 1, 12, 15), new h(Blocks.hm, 1, 1, 12, 15), new h(Blocks.hu, 1, 1, 12, 15), new h(Blocks.le, 1, 1, 12, 15), new h(Blocks.ld, 1, 1, 12, 15), new h(Blocks.lo, 1, 1, 12, 15), new h(Blocks.lg, 1, 1, 12, 15), new h(Blocks.lk, 1, 1, 12, 15), new h(Blocks.ll, 1, 1, 12, 15), new h(Blocks.ls, 1, 1, 12, 15), new h(Blocks.lr, 1, 1, 12, 15), new h(Blocks.lj, 1, 1, 12, 15), new h(Blocks.lf, 1, 1, 12, 15), new h(Blocks.li, 1, 1, 12, 15), new h(Blocks.lq, 1, 1, 12, 15), new h(Blocks.lm, 1, 1, 12, 15), new h(Blocks.ln, 1, 1, 12, 15), new h(Blocks.lh, 1, 1, 12, 15), new h(Blocks.lp, 1, 1, 12, 15)}, (Object)5, (Object)new IMerchantRecipeOption[]{new h(Blocks.he, 1, 1, 12, 30), new h(Blocks.hc, 1, 1, 12, 30)})));
    });
    public static final Int2ObjectMap<IMerchantRecipeOption[]> b = VillagerTrades.a((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new h(Items.cw, 2, 1, 5, 1), new h(Items.pY, 4, 1, 5, 1), new h(Items.eW, 2, 1, 5, 1), new h(Items.uR, 5, 1, 5, 1), new h(Items.cr, 1, 1, 12, 1), new h(Items.dl, 1, 1, 8, 1), new h(Items.eM, 1, 1, 4, 1), new h(Items.dm, 3, 1, 12, 1), new h(Items.ey, 3, 1, 8, 1), new h(Items.cN, 1, 1, 12, 1), new h(Items.cO, 1, 1, 12, 1), new h(Items.cP, 1, 1, 8, 1), new h(Items.cQ, 1, 1, 12, 1), new h(Items.cR, 1, 1, 12, 1), new h(Items.cS, 1, 1, 12, 1), new h(Items.cT, 1, 1, 12, 1), new h(Items.cU, 1, 1, 12, 1), new h(Items.cV, 1, 1, 12, 1), new h(Items.cW, 1, 1, 12, 1), new h(Items.cX, 1, 1, 12, 1), new h(Items.cY, 1, 1, 7, 1), new h(Items.oD, 1, 1, 12, 1), new h(Items.um, 1, 1, 12, 1), new h(Items.rf, 1, 1, 12, 1), new h(Items.rg, 1, 1, 12, 1), new h(Items.N, 5, 1, 8, 1), new h(Items.L, 5, 1, 8, 1), new h(Items.P, 5, 1, 8, 1), new h(Items.M, 5, 1, 8, 1), new h(Items.J, 5, 1, 8, 1), new h(Items.K, 5, 1, 8, 1), new h(Items.Q, 5, 1, 8, 1), new h(Items.qE, 1, 3, 12, 1), new h(Items.qq, 1, 3, 12, 1), new h(Items.qB, 1, 3, 12, 1), new h(Items.qw, 1, 3, 12, 1), new h(Items.qF, 1, 3, 12, 1), new h(Items.qD, 1, 3, 12, 1), new h(Items.qy, 1, 3, 12, 1), new h(Items.qs, 1, 3, 12, 1), new h(Items.qu, 1, 3, 12, 1), new h(Items.qx, 1, 3, 12, 1), new h(Items.qA, 1, 3, 12, 1), new h(Items.qt, 1, 3, 12, 1), new h(Items.qv, 1, 3, 12, 1), new h(Items.qr, 1, 3, 12, 1), new h(Items.qC, 1, 3, 12, 1), new h(Items.qz, 1, 3, 12, 1), new h(Items.jY, 3, 1, 8, 1), new h(Items.jZ, 3, 1, 8, 1), new h(Items.ka, 3, 1, 8, 1), new h(Items.kb, 3, 1, 8, 1), new h(Items.jX, 3, 1, 8, 1), new h(Items.fx, 1, 1, 12, 1), new h(Items.dc, 1, 1, 12, 1), new h(Items.dd, 1, 1, 12, 1), new h(Items.fD, 1, 2, 5, 1), new h(Items.ds, 1, 2, 5, 1), new h(Items.S, 1, 8, 8, 1), new h(Items.U, 1, 4, 6, 1), new h(Items.wj, 1, 2, 5, 1), new h(Items.s, 1, 2, 5, 1), new h(Items.dp, 1, 2, 5, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new h(Items.pQ, 5, 1, 4, 1), new h(Items.pN, 5, 1, 4, 1), new h(Items.hx, 3, 1, 6, 1), new h(Items.kw, 6, 1, 6, 1), new h(Items.oC, 1, 1, 8, 1), new h(Items.r, 3, 3, 6, 1)}));
    public static final Int2ObjectMap<IMerchantRecipeOption[]> c = VillagerTrades.a((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new h(Items.O, 5, 1, 8, 1)}));

    private static Int2ObjectMap<IMerchantRecipeOption[]> a(ImmutableMap<Integer, IMerchantRecipeOption[]> map) {
        return new Int2ObjectOpenHashMap(map);
    }

    public static interface IMerchantRecipeOption {
        @Nullable
        public MerchantRecipe a(Entity var1, RandomSource var2);
    }

    static class b
    implements IMerchantRecipeOption {
        private final Item a;
        private final int b;
        private final int c;
        private final int d;
        private final float e;

        public b(IMaterial item, int price, int maxUses, int experience) {
            this.a = item.k();
            this.b = price;
            this.c = maxUses;
            this.d = experience;
            this.e = 0.05f;
        }

        @Override
        public MerchantRecipe a(Entity entity, RandomSource random) {
            ItemStack itemStack = new ItemStack(this.a, this.b);
            return new MerchantRecipe(itemStack, new ItemStack(Items.nH), this.c, this.d, this.e);
        }
    }

    static class h
    implements IMerchantRecipeOption {
        private final ItemStack a;
        private final int b;
        private final int c;
        private final int d;
        private final int e;
        private final float f;

        public h(Block block, int price, int count, int maxUses, int experience) {
            this(new ItemStack(block), price, count, maxUses, experience);
        }

        public h(Item item, int price, int count, int experience) {
            this(new ItemStack(item), price, count, 12, experience);
        }

        public h(Item item, int price, int count, int maxUses, int experience) {
            this(new ItemStack(item), price, count, maxUses, experience);
        }

        public h(ItemStack stack, int price, int count, int maxUses, int experience) {
            this(stack, price, count, maxUses, experience, 0.05f);
        }

        public h(ItemStack stack, int price, int count, int maxUses, int experience, float multiplier) {
            this.a = stack;
            this.b = price;
            this.c = count;
            this.d = maxUses;
            this.e = experience;
            this.f = multiplier;
        }

        @Override
        public MerchantRecipe a(Entity entity, RandomSource random) {
            return new MerchantRecipe(new ItemStack(Items.nH, this.b), new ItemStack(this.a.c(), this.c), this.d, this.e, this.f);
        }
    }

    static class i
    implements IMerchantRecipeOption {
        final MobEffectList a;
        final int b;
        final int c;
        private final float d;

        public i(MobEffectList effect, int duration, int experience) {
            this.a = effect;
            this.b = duration;
            this.c = experience;
            this.d = 0.05f;
        }

        @Override
        @Nullable
        public MerchantRecipe a(Entity entity, RandomSource random) {
            ItemStack itemStack = new ItemStack(Items.uU, 1);
            ItemSuspiciousStew.a(itemStack, this.a, this.b);
            return new MerchantRecipe(new ItemStack(Items.nH, 1), itemStack, 12, this.c, this.d);
        }
    }

    static class g
    implements IMerchantRecipeOption {
        private final ItemStack a;
        private final int b;
        private final int c;
        private final ItemStack d;
        private final int e;
        private final int f;
        private final int g;
        private final float h;

        public g(IMaterial item, int secondCount, Item sellItem, int sellCount, int maxUses, int experience) {
            this(item, secondCount, 1, sellItem, sellCount, maxUses, experience);
        }

        public g(IMaterial item, int secondCount, int price, Item sellItem, int sellCount, int maxUses, int experience) {
            this.a = new ItemStack(item);
            this.b = secondCount;
            this.c = price;
            this.d = new ItemStack(sellItem);
            this.e = sellCount;
            this.f = maxUses;
            this.g = experience;
            this.h = 0.05f;
        }

        @Override
        @Nullable
        public MerchantRecipe a(Entity entity, RandomSource random) {
            return new MerchantRecipe(new ItemStack(Items.nH, this.c), new ItemStack(this.a.c(), this.b), new ItemStack(this.d.c(), this.e), this.f, this.g, this.h);
        }
    }

    static class e
    implements IMerchantRecipeOption {
        private final ItemStack a;
        private final int b;
        private final int c;
        private final int d;
        private final float e;

        public e(Item item, int basePrice, int maxUses, int experience) {
            this(item, basePrice, maxUses, experience, 0.05f);
        }

        public e(Item item, int basePrice, int maxUses, int experience, float multiplier) {
            this.a = new ItemStack(item);
            this.b = basePrice;
            this.c = maxUses;
            this.d = experience;
            this.e = multiplier;
        }

        @Override
        public MerchantRecipe a(Entity entity, RandomSource random) {
            int i2 = 5 + random.a(15);
            ItemStack itemStack = EnchantmentManager.a(random, new ItemStack(this.a.c()), i2, false);
            int j2 = Math.min(this.b + i2, 64);
            ItemStack itemStack2 = new ItemStack(Items.nH, j2);
            return new MerchantRecipe(itemStack2, itemStack, this.c, this.d, this.e);
        }
    }

    static class c
    implements IMerchantRecipeOption {
        private final Map<VillagerType, Item> a;
        private final int b;
        private final int c;
        private final int d;

        public c(int count, int maxUses, int experience, Map<VillagerType, Item> map) {
            BuiltInRegistries.y.s().filter(villagerType -> !map.containsKey(villagerType)).findAny().ifPresent(villagerType -> {
                throw new IllegalStateException("Missing trade for villager type: " + BuiltInRegistries.y.b((VillagerType)villagerType));
            });
            this.a = map;
            this.b = count;
            this.c = maxUses;
            this.d = experience;
        }

        @Override
        @Nullable
        public MerchantRecipe a(Entity entity, RandomSource random) {
            if (entity instanceof VillagerDataHolder) {
                ItemStack itemStack = new ItemStack(this.a.get(((VillagerDataHolder)((Object)entity)).gd().a()), this.b);
                return new MerchantRecipe(itemStack, new ItemStack(Items.nH), this.c, this.d, 0.05f);
            }
            return null;
        }
    }

    static class j
    implements IMerchantRecipeOption {
        private final ItemStack a;
        private final int b;
        private final int c;
        private final int d;
        private final int e;
        private final Item f;
        private final int g;
        private final float h;

        public j(Item arrow, int secondCount, Item tippedArrow, int sellCount, int price, int maxUses, int experience) {
            this.a = new ItemStack(tippedArrow);
            this.c = price;
            this.d = maxUses;
            this.e = experience;
            this.f = arrow;
            this.g = secondCount;
            this.b = sellCount;
            this.h = 0.05f;
        }

        @Override
        public MerchantRecipe a(Entity entity, RandomSource random) {
            ItemStack itemStack = new ItemStack(Items.nH, this.c);
            List list = BuiltInRegistries.j.s().filter(potionx -> !potionx.a().isEmpty() && PotionBrewer.a(potionx)).collect(Collectors.toList());
            PotionRegistry potion = (PotionRegistry)list.get(random.a(list.size()));
            ItemStack itemStack2 = PotionUtil.a(new ItemStack(this.a.c(), this.b), potion);
            return new MerchantRecipe(itemStack, new ItemStack(this.f, this.g), itemStack2, this.d, this.e, this.h);
        }
    }

    static class d
    implements IMerchantRecipeOption {
        private final int a;

        public d(int experience) {
            this.a = experience;
        }

        @Override
        public MerchantRecipe a(Entity entity, RandomSource random) {
            List list = BuiltInRegistries.g.s().filter(Enchantment::h).collect(Collectors.toList());
            Enchantment enchantment = (Enchantment)list.get(random.a(list.size()));
            int i2 = MathHelper.a(random, enchantment.e(), enchantment.a());
            ItemStack itemStack = ItemEnchantedBook.a(new WeightedRandomEnchant(enchantment, i2));
            int j2 = 2 + random.a(5 + i2 * 10) + 3 * i2;
            if (enchantment.b()) {
                j2 *= 2;
            }
            if (j2 > 64) {
                j2 = 64;
            }
            return new MerchantRecipe(new ItemStack(Items.nH, j2), new ItemStack(Items.pX), itemStack, 12, this.a, 0.2f);
        }
    }

    static class k
    implements IMerchantRecipeOption {
        private final int a;
        private final TagKey<Structure> b;
        private final String c;
        private final MapIcon.Type d;
        private final int e;
        private final int f;

        public k(int price, TagKey<Structure> structure, String nameKey, MapIcon.Type iconType, int maxUses, int experience) {
            this.a = price;
            this.b = structure;
            this.c = nameKey;
            this.d = iconType;
            this.e = maxUses;
            this.f = experience;
        }

        @Override
        @Nullable
        public MerchantRecipe a(Entity entity, RandomSource random) {
            if (!(entity.H instanceof WorldServer)) {
                return null;
            }
            WorldServer serverLevel = (WorldServer)entity.H;
            if (!serverLevel.paperConfig().environment.treasureMaps.enabled) {
                return null;
            }
            BlockPosition blockPos = serverLevel.a(this.b, entity.dg(), 100, !serverLevel.paperConfig().environment.treasureMaps.findAlreadyDiscoveredVillager);
            if (blockPos != null) {
                ItemStack itemStack = ItemWorldMap.a(serverLevel, blockPos.u(), blockPos.w(), (byte)2, true, true);
                ItemWorldMap.a(serverLevel, itemStack);
                WorldMap.a(itemStack, blockPos, "+", this.d);
                itemStack.a(IChatBaseComponent.c(this.c));
                return new MerchantRecipe(new ItemStack(Items.nH, this.a), new ItemStack(Items.qa), itemStack, this.e, this.f, 0.2f);
            }
            return null;
        }
    }

    static class a
    implements IMerchantRecipeOption {
        private final Item a;
        private final int b;
        private final int c;
        private final int d;

        public a(Item item, int price) {
            this(item, price, 12, 1);
        }

        public a(Item item, int price, int maxUses, int experience) {
            this.a = item;
            this.b = price;
            this.c = maxUses;
            this.d = experience;
        }

        @Override
        public MerchantRecipe a(Entity entity, RandomSource random) {
            ItemStack itemStack = new ItemStack(Items.nH, this.b);
            ItemStack itemStack2 = new ItemStack(this.a);
            if (this.a instanceof ItemArmorColorable) {
                ArrayList list = Lists.newArrayList();
                list.add(net.minecraft.world.entity.npc.VillagerTrades$a.a(random));
                if (random.i() > 0.7f) {
                    list.add(net.minecraft.world.entity.npc.VillagerTrades$a.a(random));
                }
                if (random.i() > 0.8f) {
                    list.add(net.minecraft.world.entity.npc.VillagerTrades$a.a(random));
                }
                itemStack2 = IDyeable.a(itemStack2, list);
            }
            return new MerchantRecipe(itemStack, itemStack2, this.c, this.d, 0.2f);
        }

        private static ItemDye a(RandomSource random) {
            return ItemDye.a(EnumColor.a(random.a(16)));
        }
    }
}

