/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.destroystokyo.paper.event.player.PlayerReadyArrowEvent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.event.player.PlayerDeepSleepEvent;
import io.papermc.paper.event.player.PrePlayerAttackEntityEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.EntityPig;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.PlayerAbilities;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerPlayer;
import net.minecraft.world.inventory.InventoryEnderChest;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemElytra;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemSword;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockRespawnAnchor;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftVector;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;
import org.slf4j.Logger;

public abstract class EntityHuman
extends EntityLiving {
    private static final Logger b = LogUtils.getLogger();
    public static final int bz = 16;
    public static final int bA = 20;
    public static final int bB = 100;
    public static final int bC = 10;
    public static final int bD = 200;
    public static final float bE = 1.5f;
    public static final float bF = 0.6f;
    public static final float bG = 0.6f;
    public static final float bH = 1.62f;
    public static final EntitySize bI = EntitySize.b(0.6f, 1.8f);
    private static final Map<EntityPose, EntitySize> c = ImmutableMap.builder().put((Object)EntityPose.a, (Object)bI).put((Object)EntityPose.c, (Object)EntityLiving.aC).put((Object)EntityPose.b, (Object)EntitySize.b(0.6f, 0.6f)).put((Object)EntityPose.d, (Object)EntitySize.b(0.6f, 0.6f)).put((Object)EntityPose.e, (Object)EntitySize.b(0.6f, 0.6f)).put((Object)EntityPose.f, (Object)EntitySize.b(0.6f, 1.5f)).put((Object)EntityPose.h, (Object)EntitySize.c(0.2f, 0.2f)).build();
    private static final int d = 25;
    private static final DataWatcherObject<Float> e = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Integer> f = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.b);
    public static final DataWatcherObject<Byte> bJ = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.a);
    protected static final DataWatcherObject<Byte> bK = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.a);
    protected static final DataWatcherObject<NBTTagCompound> bL = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.s);
    protected static final DataWatcherObject<NBTTagCompound> bM = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.s);
    private long cj;
    private final PlayerInventory ck = new PlayerInventory(this);
    protected InventoryEnderChest bN = new InventoryEnderChest(this);
    public final ContainerPlayer bO;
    public Container bP;
    protected FoodMetaData bQ = new FoodMetaData(this);
    protected int bR;
    public float bS;
    public float bT;
    public int bU;
    public double bV;
    public double bW;
    public double bX;
    public double bY;
    public double bZ;
    public double ca;
    public int cl;
    protected boolean cb;
    private final PlayerAbilities cm = new PlayerAbilities();
    public int cc;
    public int cd;
    public float ce;
    public int cf;
    protected final float cg = 0.02f;
    private int cn;
    public GameProfile co;
    private boolean cp;
    private net.minecraft.world.item.ItemStack cq;
    private final ItemCooldown cr;
    private Optional<GlobalPos> cs;
    @Nullable
    public EntityFishingHook ch;
    public float ci;
    public boolean affectsSpawning = true;
    public TriState flyingFallDamage = TriState.NOT_SET;
    public boolean fauxSleeping;
    public int oldLevel = -1;

    @Override
    public CraftHumanEntity getBukkitEntity() {
        return (CraftHumanEntity)super.getBukkitEntity();
    }

    public EntityHuman(World world, BlockPosition pos, float yaw, GameProfile gameProfile) {
        super((EntityTypes<? extends EntityLiving>)EntityTypes.bt, world);
        this.cq = net.minecraft.world.item.ItemStack.b;
        this.cr = this.k();
        this.cs = Optional.empty();
        this.a_(UUIDUtil.a(gameProfile));
        this.co = gameProfile;
        this.bO = new ContainerPlayer(this.ck, !world.B, this);
        this.bP = this.bO;
        this.b((double)pos.u() + 0.5, pos.v() + 1, (double)pos.w() + 0.5, yaw, 0.0f);
        this.bf = 180.0f;
    }

    public boolean a(World world, BlockPosition pos, EnumGamemode gameMode) {
        if (!gameMode.f()) {
            return false;
        }
        if (gameMode == EnumGamemode.d) {
            return true;
        }
        if (this.fV()) {
            return false;
        }
        net.minecraft.world.item.ItemStack itemstack = this.eK();
        return itemstack.b() || !itemstack.b(world.u_().d(Registries.e), new ShapeDetectorBlock(world, pos, false));
    }

    public static AttributeProvider.Builder fy() {
        return EntityLiving.dJ().a(GenericAttributes.f, 1.0).a(GenericAttributes.d, 0.1f).a(GenericAttributes.h).a(GenericAttributes.k);
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(e, Float.valueOf(0.0f));
        this.am.a(f, 0);
        this.am.a(bJ, (byte)0);
        this.am.a(bK, (byte)1);
        this.am.a(bL, new NBTTagCompound());
        this.am.a(bM, new NBTTagCompound());
    }

    @Override
    public void l() {
        this.ae = this.F_();
        if (this.F_()) {
            this.N = false;
        }
        if (this.bU > 0) {
            --this.bU;
        }
        if (this.fu()) {
            ++this.cl;
            if (this.cl == 100 && !new PlayerDeepSleepEvent((Player)this.getBukkitEntity()).callEvent()) {
                this.cl = Integer.MIN_VALUE;
            }
            if (this.cl > 100) {
                this.cl = 100;
            }
            if (!this.H.B && this.H.M()) {
                this.a(false, true);
            }
        } else if (this.cl > 0) {
            ++this.cl;
            if (this.cl >= 110) {
                this.cl = 0;
            }
        }
        this.fC();
        super.l();
        if (!this.H.B && this.bP != null && !this.bP.a(this)) {
            this.closeContainer(InventoryCloseEvent.Reason.CANT_USE);
            this.bP = this.bO;
        }
        this.x();
        if (!this.H.B) {
            this.bQ.a(this);
            this.a(StatisticList.k);
            this.a(StatisticList.l);
            if (this.bq()) {
                this.a(StatisticList.m);
            }
            if (this.bR()) {
                this.a(StatisticList.o);
            }
            if (!this.fu()) {
                this.a(StatisticList.n);
            }
        }
        int i2 = 29999999;
        double d0 = MathHelper.a(this.dl(), -2.9999999E7, 2.9999999E7);
        double d1 = MathHelper.a(this.dr(), -2.9999999E7, 2.9999999E7);
        if (d0 != this.dl() || d1 != this.dr()) {
            this.e(d0, this.dn(), d1);
        }
        ++this.aO;
        net.minecraft.world.item.ItemStack itemstack = this.eK();
        if (!net.minecraft.world.item.ItemStack.b(this.cq, itemstack)) {
            if (!net.minecraft.world.item.ItemStack.c(this.cq, itemstack)) {
                this.gd();
            }
            this.cq = itemstack.o();
        }
        this.s();
        this.cr.a();
        this.fD();
    }

    public boolean fz() {
        return this.bO();
    }

    protected boolean fA() {
        return this.bO();
    }

    protected boolean fB() {
        return this.bO();
    }

    protected boolean fC() {
        this.cb = ((Entity)this).a(TagsFluid.a);
        return this.cb;
    }

    private void s() {
        net.minecraft.world.item.ItemStack itemstack = this.c(EnumItemSlot.f);
        if (itemstack.a(Items.ny) && !((Entity)this).a(TagsFluid.a)) {
            this.addEffect(new MobEffect(MobEffects.m, 200, 0, false, false, true), EntityPotionEffectEvent.Cause.TURTLE_HELMET);
        }
    }

    protected ItemCooldown k() {
        return new ItemCooldown();
    }

    private void x() {
        this.bV = this.bY;
        this.bW = this.bZ;
        this.bX = this.ca;
        double d0 = this.dl() - this.bY;
        double d1 = this.dn() - this.bZ;
        double d2 = this.dr() - this.ca;
        double d3 = 10.0;
        if (d0 > 10.0) {
            this.bV = this.bY = this.dl();
        }
        if (d2 > 10.0) {
            this.bX = this.ca = this.dr();
        }
        if (d1 > 10.0) {
            this.bW = this.bZ = this.dn();
        }
        if (d0 < -10.0) {
            this.bV = this.bY = this.dl();
        }
        if (d2 < -10.0) {
            this.bX = this.ca = this.dr();
        }
        if (d1 < -10.0) {
            this.bW = this.bZ = this.dn();
        }
        this.bY += d0 * 0.25;
        this.ca += d2 * 0.25;
        this.bZ += d1 * 0.25;
    }

    protected void fD() {
        if (this.d(EntityPose.d)) {
            EntityPose entitypose = this.fn() ? EntityPose.b : (this.fu() ? EntityPose.c : (this.bV() ? EntityPose.d : (this.fa() ? EntityPose.e : (this.bO() && !this.cm.b ? EntityPose.f : EntityPose.a))));
            EntityPose entitypose1 = !(this.F_() || this.bL() || this.d(entitypose)) ? (this.d(EntityPose.f) ? EntityPose.f : EntityPose.d) : entitypose;
            this.b(entitypose1);
        }
    }

    @Override
    public int as() {
        return this.cm.a ? 1 : 80;
    }

    @Override
    protected SoundEffect aI() {
        return SoundEffects.ss;
    }

    @Override
    protected SoundEffect aJ() {
        return SoundEffects.sq;
    }

    @Override
    protected SoundEffect aK() {
        return SoundEffects.sr;
    }

    @Override
    public int bG() {
        return 10;
    }

    @Override
    public void a(SoundEffect sound, float volume, float pitch) {
        this.H.a(this, this.dl(), this.dn(), this.dr(), sound, this.cX(), volume, pitch);
    }

    public void a(SoundEffect event, SoundCategory category, float volume, float pitch) {
    }

    @Override
    public SoundCategory cX() {
        return SoundCategory.h;
    }

    @Override
    public int cY() {
        return 20;
    }

    @Override
    public void b(byte status) {
        if (status == 9) {
            this.Y_();
        } else if (status == 23) {
            this.cp = false;
        } else if (status == 22) {
            this.cp = true;
        } else if (status == 43) {
            this.a(Particles.f);
        } else {
            super.b(status);
        }
    }

    private void a(ParticleParam parameters) {
        for (int i2 = 0; i2 < 5; ++i2) {
            double d0 = this.af.k() * 0.02;
            double d1 = this.af.k() * 0.02;
            double d2 = this.af.k() * 0.02;
            this.H.a(parameters, this.d(1.0), this.do() + 1.0, this.g(1.0), d0, d1, d2);
        }
    }

    public void closeContainer(InventoryCloseEvent.Reason reason) {
        this.q();
        this.bP = this.bO;
    }

    public void closeUnloadedInventory(InventoryCloseEvent.Reason reason) {
        this.bP = this.bO;
    }

    public void q() {
        this.bP = this.bO;
    }

    protected void r() {
    }

    @Override
    public void bt() {
        if (!this.H.B && this.fA() && this.bL()) {
            this.bz();
            if (!this.bL()) {
                this.f(false);
                return;
            }
        }
        double d0 = this.dl();
        double d1 = this.dn();
        double d2 = this.dr();
        super.bt();
        this.bS = this.bT;
        this.bT = 0.0f;
        this.s(this.dl() - d0, this.dn() - d1, this.dr() - d2);
    }

    @Override
    protected void eY() {
        super.eY();
        this.eH();
        this.aV = this.dw();
    }

    @Override
    public void b_() {
        if (this.bR > 0) {
            --this.bR;
        }
        if (this.H.ah() == EnumDifficulty.a && this.H.W().b(GameRules.j)) {
            if (this.eo() < this.eE() && this.ag % 20 == 0) {
                this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
            }
            if (this.bQ.c() && this.ag % 10 == 0) {
                this.bQ.a(this.bQ.a() + 1);
            }
        }
        this.ck.j();
        this.bS = this.bT;
        super.b_();
        this.h((float)this.b(GenericAttributes.d));
        float f2 = this.N && !this.ep() && !this.bV() ? Math.min(0.1f, (float)this.dj().h()) : 0.0f;
        this.bT += (f2 - this.bT) * 0.4f;
        if (this.eo() > 0.0f && !this.F_()) {
            AxisAlignedBB axisalignedbb = this.bL() && !this.cV().dB() ? this.cD().b(this.cV().cD()).c(1.0, 0.0, 1.0) : this.cD().c(1.0, 0.5, 1.0);
            List<Entity> list = this.H.a_(this, axisalignedbb);
            ArrayList list1 = Lists.newArrayList();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Entity entity = list.get(i2);
                if (entity.ae() == EntityTypes.J) {
                    list1.add(entity);
                    continue;
                }
                if (entity.dB()) continue;
                this.c(entity);
            }
            if (!list1.isEmpty()) {
                this.c((Entity)SystemUtils.a(list1, this.af));
            }
        }
        this.c(this.ga());
        this.c(this.gb());
        if ((!this.H.B && (this.aa > 0.5f || this.aT()) || this.cm.b || this.fu() || this.az) && !this.H.paperConfig().entities.behavior.parrotsAreUnaffectedByPlayerMovement) {
            this.fX();
        }
    }

    private void c(@Nullable NBTTagCompound entityNbt) {
        if (!(entityNbt == null || entityNbt.e("Silent") && entityNbt.q("Silent") || this.H.z.a(200) != 0)) {
            String s2 = entityNbt.l("id");
            EntityTypes.a(s2).filter(entitytypes -> entitytypes == EntityTypes.at).ifPresent(entitytypes -> {
                if (!EntityParrot.a(this.H, this)) {
                    this.H.a((EntityHuman)null, this.dl(), this.dn(), this.dr(), EntityParrot.a(this.H, this.H.z), this.cX(), 1.0f, EntityParrot.a(this.H.z));
                }
            });
        }
    }

    private void c(Entity entity) {
        entity.b_(this);
    }

    public int fE() {
        return this.am.a(f);
    }

    public void q(int score) {
        this.am.b(f, score);
    }

    public void r(int score) {
        int j2 = this.fE();
        this.am.b(f, j2 + score);
    }

    public void s(int riptideTicks) {
        this.bx = riptideTicks;
        if (!this.H.B) {
            this.fX();
            this.c(4, true);
        }
    }

    @Override
    public void a(DamageSource damageSource) {
        super.a(damageSource);
        this.an();
        if (!this.F_()) {
            this.dropAllDeathLoot(damageSource);
        }
        if (damageSource != null) {
            this.o(-MathHelper.b((this.ex() + this.dw()) * ((float)Math.PI / 180)) * 0.1f, 0.1f, -MathHelper.a((this.ex() + this.dw()) * ((float)Math.PI / 180)) * 0.1f);
        } else {
            this.o(0.0, 0.1, 0.0);
        }
        this.a(StatisticList.N);
        this.a(StatisticList.i.b(StatisticList.m));
        this.a(StatisticList.i.b(StatisticList.n));
        this.av();
        this.a_(false);
        this.a(Optional.of(GlobalPos.a(this.H.ab(), this.dg())));
    }

    @Override
    protected void er() {
        super.er();
        if (!this.H.W().b(GameRules.d)) {
            this.fF();
            this.ck.k();
        }
    }

    protected void fF() {
        for (int i2 = 0; i2 < this.ck.b(); ++i2) {
            net.minecraft.world.item.ItemStack itemstack = this.ck.a(i2);
            if (itemstack.b() || !EnchantmentManager.e(itemstack)) continue;
            this.ck.b(i2);
        }
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return source.j().d().a();
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.si;
    }

    @Nullable
    public EntityItem a(net.minecraft.world.item.ItemStack stack, boolean retainOwnership) {
        return this.a(stack, false, retainOwnership);
    }

    @Nullable
    public EntityItem a(net.minecraft.world.item.ItemStack stack, boolean throwRandomly, boolean retainOwnership) {
        return this.drop(stack, throwRandomly, retainOwnership, true);
    }

    @Nullable
    public EntityItem drop(net.minecraft.world.item.ItemStack itemstack, boolean flag, boolean flag1, boolean callEvent) {
        WorldMap worldmap;
        if (itemstack.b()) {
            return null;
        }
        if (this.H.B) {
            this.a(EnumHand.a);
        }
        double d0 = this.dp() - (double)0.3f;
        net.minecraft.world.item.ItemStack tmp = itemstack.o();
        itemstack.f(0);
        itemstack = tmp;
        EntityItem entityitem = new EntityItem(this.H, this.dl(), d0, this.dr(), itemstack);
        entityitem.b(40);
        if (flag1) {
            entityitem.c(this.cs());
        }
        if (flag) {
            float f2 = this.af.i() * 0.5f;
            float f1 = this.af.i() * ((float)Math.PI * 2);
            entityitem.o(-MathHelper.a(f1) * f2, 0.2f, MathHelper.b(f1) * f2);
        } else {
            float f3 = 0.3f;
            float f1 = MathHelper.a(this.dy() * ((float)Math.PI / 180));
            float f2 = MathHelper.b(this.dy() * ((float)Math.PI / 180));
            float f32 = MathHelper.a(this.dw() * ((float)Math.PI / 180));
            float f4 = MathHelper.b(this.dw() * ((float)Math.PI / 180));
            float f5 = this.af.i() * ((float)Math.PI * 2);
            float f6 = 0.02f * this.af.i();
            entityitem.o((double)(-f32 * f2 * 0.3f) + Math.cos(f5) * (double)f6, -f1 * 0.3f + 0.1f + (this.af.i() - this.af.i()) * 0.1f, (double)(f4 * f2 * 0.3f) + Math.sin(f5) * (double)f6);
        }
        if (!callEvent) {
            return entityitem;
        }
        Player player = (Player)this.getBukkitEntity();
        Item drop = (Item)entityitem.getBukkitEntity();
        PlayerDropItemEvent event = new PlayerDropItemEvent(player, drop);
        this.H.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            ItemStack cur = player.getInventory().getItemInHand();
            if (flag1 && (cur == null || cur.getAmount() == 0)) {
                player.getInventory().setItemInHand(drop.getItemStack());
            } else if (flag1 && cur.isSimilar(drop.getItemStack()) && cur.getAmount() < cur.getMaxStackSize() && drop.getItemStack().getAmount() == 1) {
                cur.setAmount(cur.getAmount() + 1);
                player.getInventory().setItemInHand(cur);
            } else {
                player.getInventory().addItem(new ItemStack[]{drop.getItemStack()});
            }
            return null;
        }
        if (itemstack.c() == Items.rb && (worldmap = ItemWorldMap.a(itemstack, this.H)) != null) {
            worldmap.a(this, itemstack);
        }
        return entityitem;
    }

    public float c(IBlockData block) {
        float f2 = this.ck.a(block);
        if (f2 > 1.0f) {
            int i2 = EnchantmentManager.g(this);
            net.minecraft.world.item.ItemStack itemstack = this.eK();
            if (i2 > 0 && !itemstack.b()) {
                f2 += (float)(i2 * i2 + 1);
            }
        }
        if (MobEffectUtil.a(this)) {
            f2 *= 1.0f + (float)(MobEffectUtil.b(this) + 1) * 0.2f;
        }
        if (this.a(MobEffects.d)) {
            f2 *= (switch (this.b(MobEffects.d).e()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            });
        }
        if (((Entity)this).a(TagsFluid.a) && !EnchantmentManager.i(this)) {
            f2 /= 5.0f;
        }
        if (!this.N) {
            f2 /= 5.0f;
        }
        return f2;
    }

    public boolean d(IBlockData state) {
        return !state.v() || this.ck.f().b(state);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a_(UUIDUtil.a(this.co));
        NBTTagList nbttaglist = nbt.c("Inventory", 10);
        this.ck.b(nbttaglist);
        this.ck.l = nbt.h("SelectedItemSlot");
        this.cl = nbt.g("SleepTimer");
        this.ce = nbt.j("XpP");
        this.cc = nbt.h("XpLevel");
        this.cd = nbt.h("XpTotal");
        this.cf = nbt.h("XpSeed");
        if (this.cf == 0) {
            this.cf = this.af.f();
        }
        this.q(nbt.h("Score"));
        this.bQ.a(nbt);
        this.cm.b(nbt);
        this.a(GenericAttributes.d).a(this.cm.b());
        if (nbt.b("EnderItems", 9)) {
            this.bN.a(nbt.c("EnderItems", 10));
        }
        if (nbt.b("ShoulderEntityLeft", 10)) {
            this.i(nbt.p("ShoulderEntityLeft"));
        }
        if (nbt.b("ShoulderEntityRight", 10)) {
            this.j(nbt.p("ShoulderEntityRight"));
        }
        if (nbt.b("LastDeathLocation", 10)) {
            DataResult dataresult = GlobalPos.a.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c("LastDeathLocation"));
            Logger logger = b;
            Objects.requireNonNull(logger);
            this.a(dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)));
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        GameProfileSerializer.g(nbt);
        nbt.a("Inventory", this.ck.a(new NBTTagList()));
        nbt.a("SelectedItemSlot", this.ck.l);
        nbt.a("SleepTimer", (short)this.cl);
        nbt.a("XpP", this.ce);
        nbt.a("XpLevel", this.cc);
        nbt.a("XpTotal", this.cd);
        nbt.a("XpSeed", this.cf);
        nbt.a("Score", this.fE());
        this.bQ.b(nbt);
        this.cm.a(nbt);
        nbt.a("EnderItems", this.bN.g());
        if (!this.ga().g()) {
            nbt.a("ShoulderEntityLeft", this.ga());
        }
        if (!this.gb().g()) {
            nbt.a("ShoulderEntityRight", this.gb());
        }
        this.gi().flatMap(globalpos -> {
            DataResult dataresult = GlobalPos.a.encodeStart((DynamicOps)DynamicOpsNBT.a, globalpos);
            Logger logger = b;
            Objects.requireNonNull(logger);
            return dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0));
        }).ifPresent(nbtbase -> nbt.a("LastDeathLocation", (NBTBase)nbtbase));
    }

    @Override
    public boolean b(DamageSource damageSource) {
        return super.b(damageSource) ? true : (damageSource.a(DamageTypeTags.n) ? !this.H.W().b(GameRules.C) : (damageSource.a(DamageTypeTags.m) ? !this.H.W().b(GameRules.D) : (damageSource.a(DamageTypeTags.i) ? !this.H.W().b(GameRules.E) : (damageSource.a(DamageTypeTags.o) ? !this.H.W().b(GameRules.F) : false))));
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        boolean damaged;
        if (this.b(source)) {
            return false;
        }
        if (this.cm.a && !source.a(DamageTypeTags.d)) {
            return false;
        }
        this.ba = 0;
        if (this.ep()) {
            return false;
        }
        if (!this.H.B) {
            // empty if block
        }
        if (source.f()) {
            if (this.H.ah() == EnumDifficulty.a) {
                return false;
            }
            if (this.H.ah() == EnumDifficulty.b) {
                amount = Math.min(amount / 2.0f + 1.0f, amount);
            }
            if (this.H.ah() == EnumDifficulty.d) {
                amount = amount * 3.0f / 2.0f;
            }
        }
        if (damaged = super.a(source, amount)) {
            this.fX();
        }
        return damaged;
    }

    @Override
    protected void d(EntityLiving attacker) {
        super.d(attacker);
        if (attacker.fx()) {
            this.s(true);
        }
    }

    @Override
    public boolean eh() {
        return !this.fK().a && super.eh();
    }

    public boolean a(EntityHuman player) {
        Team team;
        if (player instanceof EntityPlayer) {
            EntityPlayer thatPlayer = (EntityPlayer)player;
            team = thatPlayer.getBukkitEntity().getScoreboard().getPlayerTeam((OfflinePlayer)thatPlayer.getBukkitEntity());
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        } else {
            OfflinePlayer thisPlayer = player.H.getCraftServer().getOfflinePlayer(player.cu());
            team = player.H.getCraftServer().getScoreboardManager().getMainScoreboard().getPlayerTeam(thisPlayer);
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        }
        if (this instanceof EntityPlayer) {
            return !team.hasPlayer((OfflinePlayer)((EntityPlayer)this).getBukkitEntity());
        }
        return !team.hasPlayer(this.H.getCraftServer().getOfflinePlayer(this.cu()));
    }

    @Override
    protected void b(DamageSource source, float amount) {
        this.ck.a(source, amount, PlayerInventory.g);
    }

    @Override
    protected void c(DamageSource source, float amount) {
        this.ck.a(source, amount, PlayerInventory.h);
    }

    @Override
    protected void d(float amount) {
        if (this.bu.a(Items.ut)) {
            if (!this.H.B) {
                this.b(StatisticList.c.b(this.bu.c()));
            }
            if (amount >= 3.0f) {
                int i2 = 1 + MathHelper.d(amount);
                EnumHand enumhand = this.ff();
                this.bu.a(i2, this, (T entityhuman) -> entityhuman.d(enumhand));
                if (this.bu.b()) {
                    if (enumhand == EnumHand.a) {
                        this.a(EnumItemSlot.a, net.minecraft.world.item.ItemStack.b);
                    } else {
                        this.a(EnumItemSlot.b, net.minecraft.world.item.ItemStack.b);
                    }
                    this.bu = net.minecraft.world.item.ItemStack.b;
                    this.a(SoundEffects.uB, 0.8f, 0.8f + this.H.z.i() * 0.4f);
                }
            }
        }
    }

    @Override
    protected boolean damageEntity0(DamageSource damagesource, float f2) {
        return super.damageEntity0(damagesource, f2);
    }

    @Override
    protected boolean dN() {
        return !this.cm.b && super.dN();
    }

    public boolean U() {
        return false;
    }

    public void a(TileEntitySign sign) {
    }

    public void a(CommandBlockListenerAbstract commandBlockExecutor) {
    }

    public void a(TileEntityCommand commandBlock) {
    }

    public void a(TileEntityStructure structureBlock) {
    }

    public void a(TileEntityJigsaw jigsaw) {
    }

    public void a(EntityHorseAbstract horse, IInventory inventory) {
    }

    public OptionalInt a(@Nullable ITileInventory factory) {
        return OptionalInt.empty();
    }

    public void a(int syncId, MerchantRecipeList offers, int levelProgress, int experience, boolean leveled, boolean refreshable) {
    }

    public void a(net.minecraft.world.item.ItemStack book, EnumHand hand) {
    }

    public EnumInteractionResult a(Entity entity, EnumHand hand) {
        if (this.F_()) {
            if (entity instanceof ITileInventory) {
                this.a((ITileInventory)((Object)entity));
            }
            return EnumInteractionResult.d;
        }
        net.minecraft.world.item.ItemStack itemstack = this.b(hand);
        net.minecraft.world.item.ItemStack itemstack1 = itemstack.o();
        EnumInteractionResult enuminteractionresult = entity.a(this, hand);
        if (enuminteractionresult.a()) {
            if (this.cm.d && itemstack == this.b(hand) && itemstack.K() < itemstack1.K()) {
                itemstack.f(itemstack1.K());
            }
            return enuminteractionresult;
        }
        if (!itemstack.b() && entity instanceof EntityLiving) {
            EnumInteractionResult enuminteractionresult1;
            if (this.cm.d) {
                itemstack = itemstack1;
            }
            if ((enuminteractionresult1 = itemstack.a(this, (EntityLiving)entity, hand)).a()) {
                this.H.a(GameEvent.s, entity.de(), GameEvent.a.a(this));
                if (itemstack.b() && !this.cm.d) {
                    this.a(hand, net.minecraft.world.item.ItemStack.b);
                }
                return enuminteractionresult1;
            }
        }
        return EnumInteractionResult.d;
    }

    @Override
    public double bu() {
        return -0.35;
    }

    @Override
    public void by() {
        this.stopRiding(false);
    }

    @Override
    public void stopRiding(boolean suppressCancellation) {
        super.stopRiding(suppressCancellation);
        this.G = 0;
    }

    @Override
    protected boolean eP() {
        return super.eP() || this.fu() || this.dB() || !this.valid;
    }

    @Override
    public boolean dT() {
        return !this.cm.b;
    }

    @Override
    protected Vec3D a(Vec3D movement, EnumMoveType type) {
        if (!this.cm.b && movement.d <= 0.0 && (type == EnumMoveType.a || type == EnumMoveType.b) && this.fB() && this.y()) {
            double d0 = movement.c;
            double d1 = movement.e;
            double d2 = 0.05;
            while (d0 != 0.0 && this.H.a((Entity)this, this.cD().d(d0, -this.dA(), 0.0))) {
                if (d0 < 0.05 && d0 >= -0.05) {
                    d0 = 0.0;
                    continue;
                }
                if (d0 > 0.0) {
                    d0 -= 0.05;
                    continue;
                }
                d0 += 0.05;
            }
            while (d1 != 0.0 && this.H.a((Entity)this, this.cD().d(0.0, -this.dA(), d1))) {
                if (d1 < 0.05 && d1 >= -0.05) {
                    d1 = 0.0;
                    continue;
                }
                if (d1 > 0.0) {
                    d1 -= 0.05;
                    continue;
                }
                d1 += 0.05;
            }
            while (d0 != 0.0 && d1 != 0.0 && this.H.a((Entity)this, this.cD().d(d0, -this.dA(), d1))) {
                d0 = d0 < 0.05 && d0 >= -0.05 ? 0.0 : (d0 > 0.0 ? (d0 -= 0.05) : (d0 += 0.05));
                if (d1 < 0.05 && d1 >= -0.05) {
                    d1 = 0.0;
                    continue;
                }
                if (d1 > 0.0) {
                    d1 -= 0.05;
                    continue;
                }
                d1 += 0.05;
            }
            movement = new Vec3D(d0, movement.d, d1);
        }
        return movement;
    }

    private boolean y() {
        return this.N || this.aa < this.dA() && !this.H.a((Entity)this, this.cD().d(0.0, this.aa - this.dA(), 0.0));
    }

    public void d(Entity target) {
        boolean willAttack = target.cl() && !target.r(this);
        PrePlayerAttackEntityEvent playerAttackEntityEvent = new PrePlayerAttackEntityEvent((Player)this.getBukkitEntity(), (org.bukkit.entity.Entity)target.getBukkitEntity(), willAttack);
        if (playerAttackEntityEvent.callEvent() && willAttack) {
            float f2 = (float)this.b(GenericAttributes.f);
            float f1 = target instanceof EntityLiving ? EnchantmentManager.a(this.eK(), ((EntityLiving)target).eJ()) : EnchantmentManager.a(this.eK(), EnumMonsterType.a);
            float f22 = this.z(0.5f);
            f1 *= f22;
            if ((f2 *= 0.2f + f22 * f22 * 0.8f) > 0.0f || f1 > 0.0f) {
                net.minecraft.world.item.ItemStack itemstack;
                boolean flag = f22 > 0.9f;
                boolean flag1 = false;
                int b0 = 0;
                int i2 = b0 + EnchantmentManager.c(this);
                if (this.bU() && flag) {
                    EntityHuman.sendSoundEffect(this, this.dl(), this.dn(), this.dr(), SoundEffects.sa, this.cX(), 1.0f, 1.0f);
                    ++i2;
                    flag1 = true;
                }
                boolean flag2 = flag && this.aa > 0.0f && !this.N && !this.z_() && !this.aT() && !this.a(MobEffects.o) && !this.bL() && target instanceof EntityLiving;
                flag2 = flag2 && !this.H.paperConfig().entities.behavior.disablePlayerCrits;
                boolean bl = flag2 = flag2 && !this.bU();
                if (flag2) {
                    f2 *= 1.5f;
                }
                f2 += f1;
                boolean flag3 = false;
                double d0 = this.X - this.W;
                if (flag && !flag2 && !flag1 && this.ax() && d0 < (double)this.eW() && (itemstack = this.b(EnumHand.a)).c() instanceof ItemSword) {
                    flag3 = true;
                }
                float f3 = 0.0f;
                boolean flag4 = false;
                int j2 = EnchantmentManager.d(this);
                if (target instanceof EntityLiving) {
                    f3 = ((EntityLiving)target).eo();
                    if (j2 > 0 && !target.bK()) {
                        EntityCombustByEntityEvent combustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)target.getBukkitEntity(), 1);
                        Bukkit.getPluginManager().callEvent((Event)combustEvent);
                        if (!combustEvent.isCancelled()) {
                            flag4 = true;
                            target.setSecondsOnFire(combustEvent.getDuration(), false);
                        }
                    }
                }
                Vec3D vec3d = target.dj();
                boolean flag5 = target.a(this.dG().a(this).critical(flag2), f2);
                if (flag5) {
                    if (i2 > 0) {
                        if (target instanceof EntityLiving) {
                            ((EntityLiving)target).knockback((float)i2 * 0.5f, MathHelper.a(this.dw() * ((float)Math.PI / 180)), -MathHelper.b(this.dw() * ((float)Math.PI / 180)), this);
                        } else {
                            target.push(-MathHelper.a(this.dw() * ((float)Math.PI / 180)) * (float)i2 * 0.5f, 0.1, MathHelper.b(this.dw() * ((float)Math.PI / 180)) * (float)i2 * 0.5f, this);
                        }
                        this.f(this.dj().d(0.6, 1.0, 0.6));
                        if (!this.H.paperConfig().misc.disableSprintInterruptionOnAttack) {
                            this.g(false);
                        }
                    }
                    if (flag3) {
                        float f4 = 1.0f + EnchantmentManager.a(this) * f2;
                        List<EntityLiving> list = this.H.a(EntityLiving.class, target.cD().c(1.0, 0.25, 1.0));
                        for (EntityLiving entityliving : list) {
                            if (entityliving == this || entityliving == target || this.p(entityliving) || entityliving instanceof EntityArmorStand && ((EntityArmorStand)entityliving).w() || !(this.f((Entity)entityliving) < 9.0) || !entityliving.a(this.dG().a(this).sweep().critical(flag2), f4)) continue;
                            entityliving.knockback(0.4f, MathHelper.a(this.dw() * ((float)Math.PI / 180)), -MathHelper.b(this.dw() * ((float)Math.PI / 180)), this);
                        }
                        EntityHuman.sendSoundEffect(this, this.dl(), this.dn(), this.dr(), SoundEffects.sd, this.cX(), 1.0f, 1.0f);
                        this.fG();
                    }
                    if (target instanceof EntityPlayer && target.S) {
                        boolean cancelled = false;
                        Player player = (Player)target.getBukkitEntity();
                        Vector velocity = CraftVector.toBukkit(vec3d);
                        PlayerVelocityEvent event = new PlayerVelocityEvent(player, velocity.clone());
                        this.H.getCraftServer().getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            cancelled = true;
                        } else if (!velocity.equals((Object)event.getVelocity())) {
                            player.setVelocity(event.getVelocity());
                        }
                        if (!cancelled) {
                            ((EntityPlayer)target).b.a(new PacketPlayOutEntityVelocity(target));
                            target.S = false;
                            target.f(vec3d);
                        }
                    }
                    if (flag2) {
                        EntityHuman.sendSoundEffect(this, this.dl(), this.dn(), this.dr(), SoundEffects.rZ, this.cX(), 1.0f, 1.0f);
                        this.a(target);
                    }
                    if (!flag2 && !flag3) {
                        if (flag) {
                            EntityHuman.sendSoundEffect(this, this.dl(), this.dn(), this.dr(), SoundEffects.sc, this.cX(), 1.0f, 1.0f);
                        } else {
                            EntityHuman.sendSoundEffect(this, this.dl(), this.dn(), this.dr(), SoundEffects.se, this.cX(), 1.0f, 1.0f);
                        }
                    }
                    if (f1 > 0.0f) {
                        this.b(target);
                    }
                    this.x(target);
                    if (target instanceof EntityLiving) {
                        EnchantmentManager.a((EntityLiving)target, (Entity)this);
                    }
                    EnchantmentManager.b(this, target);
                    net.minecraft.world.item.ItemStack itemstack1 = this.eK();
                    Entity object = target;
                    if (target instanceof EntityComplexPart) {
                        object = ((EntityComplexPart)target).b;
                    }
                    if (!this.H.B && !itemstack1.b() && object instanceof EntityLiving) {
                        itemstack1.a((EntityLiving)object, this);
                        if (itemstack1.b()) {
                            this.a(EnumHand.a, net.minecraft.world.item.ItemStack.b);
                        }
                    }
                    if (target instanceof EntityLiving) {
                        float f5 = f3 - ((EntityLiving)target).eo();
                        this.a(StatisticList.G, Math.round(f5 * 10.0f));
                        if (j2 > 0) {
                            EntityCombustByEntityEvent combustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)target.getBukkitEntity(), j2 * 4);
                            Bukkit.getPluginManager().callEvent((Event)combustEvent);
                            if (!combustEvent.isCancelled()) {
                                target.setSecondsOnFire(combustEvent.getDuration(), false);
                            }
                        }
                        if (this.H instanceof WorldServer && f5 > 2.0f) {
                            int k2 = (int)((double)f5 * 0.5);
                            ((WorldServer)this.H).a(Particles.h, target.dl(), target.e(0.5), target.dr(), k2, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    this.causeFoodExhaustion(this.H.spigotConfig.combatExhaustion, EntityExhaustionEvent.ExhaustionReason.ATTACK);
                } else {
                    EntityHuman.sendSoundEffect(this, this.dl(), this.dn(), this.dr(), SoundEffects.sb, this.cX(), 1.0f, 1.0f);
                    if (flag4) {
                        target.av();
                    }
                    if (this instanceof EntityPlayer) {
                        ((EntityPlayer)this).getBukkitEntity().updateInventory();
                    }
                }
            }
        }
    }

    @Override
    protected void h(EntityLiving target) {
        this.d((Entity)target);
    }

    public void s(boolean sprinting) {
        float f2 = 0.25f + (float)EnchantmentManager.g(this) * 0.05f;
        if (sprinting) {
            f2 += 0.75f;
        }
        if (this.af.i() < f2) {
            this.ge().a(Items.ut, 100);
            this.fk();
            this.H.a((Entity)this, (byte)30);
        }
    }

    public void a(Entity target) {
    }

    public void b(Entity target) {
    }

    public void fG() {
        double d0 = -MathHelper.a(this.dw() * ((float)Math.PI / 180));
        double d1 = MathHelper.b(this.dw() * ((float)Math.PI / 180));
        if (this.H instanceof WorldServer) {
            ((WorldServer)this.H).a(Particles.af, this.dl() + d0, this.e(0.5), this.dr() + d1, 0, d0, 0.0, d1, 0.0);
        }
    }

    public void fH() {
    }

    @Override
    public void a(Entity.RemovalReason reason) {
        super.a(reason);
        this.bO.b(this);
        if (this.bP != null && this.fL()) {
            this.r();
        }
    }

    public boolean g() {
        return false;
    }

    public GameProfile fI() {
        return this.co;
    }

    public PlayerInventory fJ() {
        return this.ck;
    }

    public PlayerAbilities fK() {
        return this.cm;
    }

    public void a(net.minecraft.world.item.ItemStack cursorStack, net.minecraft.world.item.ItemStack slotStack, ClickAction clickType) {
    }

    public boolean fL() {
        return this.bP != this.bO;
    }

    public Either<EnumBedResult, Unit> a(BlockPosition pos) {
        return this.startSleepInBed(pos, false);
    }

    public Either<EnumBedResult, Unit> startSleepInBed(BlockPosition blockposition, boolean force) {
        this.b(blockposition);
        this.cl = 0;
        return Either.right(Unit.a);
    }

    public void a(boolean skipSleepTimer, boolean updateSleepingPlayers) {
        super.fv();
        if (this.H instanceof WorldServer && updateSleepingPlayers) {
            ((WorldServer)this.H).e();
        }
        this.cl = skipSleepTimer ? 0 : 100;
    }

    @Override
    public void fv() {
        this.a(true, true);
    }

    public static Optional<Vec3D> a(WorldServer world, BlockPosition pos, float angle, boolean forced, boolean alive) {
        IBlockData iblockdata = world.a_(pos);
        Block block = iblockdata.b();
        if (block instanceof BlockRespawnAnchor && (forced || iblockdata.c(BlockRespawnAnchor.c) > 0) && BlockRespawnAnchor.a(world)) {
            Optional<Vec3D> optional = BlockRespawnAnchor.a(EntityTypes.bt, world, pos);
            if (!forced && !alive && optional.isPresent()) {
                world.a(pos, (IBlockData)iblockdata.a(BlockRespawnAnchor.c, iblockdata.c(BlockRespawnAnchor.c) - 1), 3);
            }
            return optional;
        }
        if (block instanceof BlockBed && BlockBed.a(world)) {
            return BlockBed.a(EntityTypes.bt, (ICollisionAccess)world, pos, iblockdata.c(BlockFacingHorizontal.aD), angle);
        }
        if (!forced) {
            return Optional.empty();
        }
        boolean flag2 = block.ao_();
        boolean flag3 = world.a_(pos.c()).b().ao_();
        return flag2 && flag3 ? Optional.of(new Vec3D((double)pos.u() + 0.5, (double)pos.v() + 0.1, (double)pos.w() + 0.5)) : Optional.empty();
    }

    public boolean fM() {
        return this.fu() && this.cl >= 100;
    }

    public int fN() {
        return this.cl;
    }

    public void a(IChatBaseComponent message, boolean overlay) {
    }

    public void a(MinecraftKey stat) {
        this.b(StatisticList.i.b(stat));
    }

    public void a(MinecraftKey stat, int amount) {
        this.a(StatisticList.i.b(stat), amount);
    }

    public void b(Statistic<?> stat) {
        this.a(stat, 1);
    }

    public void a(Statistic<?> stat, int amount) {
    }

    public void a(Statistic<?> stat) {
    }

    public int a(Collection<IRecipe<?>> recipes) {
        return 0;
    }

    public void a(MinecraftKey[] ids) {
    }

    public int b(Collection<IRecipe<?>> recipes) {
        return 0;
    }

    @Override
    public void eS() {
        super.eS();
        this.a(StatisticList.E);
        if (this.bU()) {
            this.causeFoodExhaustion(this.H.spigotConfig.jumpSprintExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP_SPRINT);
        } else {
            this.causeFoodExhaustion(this.H.spigotConfig.jumpWalkExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP);
        }
    }

    @Override
    public void h(Vec3D movementInput) {
        double d3;
        double d0 = this.dl();
        double d1 = this.dn();
        double d2 = this.dr();
        if (this.bV() && !this.bL()) {
            double d4;
            d3 = this.bC().d;
            double d5 = d4 = d3 < -0.2 ? 0.085 : 0.06;
            if (d3 <= 0.0 || this.bi || !this.H.a_(BlockPosition.a(this.dl(), this.dn() + 1.0 - 0.1, this.dr())).r().c()) {
                Vec3D vec3d1 = this.dj();
                this.f(vec3d1.b(0.0, (d3 - vec3d1.d) * d4, 0.0));
            }
        }
        if (this.cm.b && !this.bL()) {
            d3 = this.dj().d;
            super.h(movementInput);
            Vec3D vec3d2 = this.dj();
            this.o(vec3d2.c, d3 * 0.6, vec3d2.e);
            this.n();
            if (this.h(7) && !CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
                this.b(7, false);
            }
        } else {
            super.h(movementInput);
        }
        this.r(this.dl() - d0, this.dn() - d1, this.dr() - d2);
    }

    @Override
    public void aY() {
        if (this.cm.b) {
            this.h(false);
        } else {
            super.aY();
        }
    }

    protected boolean f(BlockPosition pos) {
        return !this.H.a_(pos).o(this.H, pos);
    }

    @Override
    public float eW() {
        return (float)this.b(GenericAttributes.d);
    }

    public void r(double dx, double dy, double dz) {
        if (!this.bL()) {
            if (this.bV()) {
                int i2 = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f);
                if (i2 > 0) {
                    this.a(StatisticList.C, i2);
                    this.causeFoodExhaustion(this.H.spigotConfig.swimMultiplier * (float)i2 * 0.01f, EntityExhaustionEvent.ExhaustionReason.SWIM);
                }
            } else if (((Entity)this).a(TagsFluid.a)) {
                int i3 = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f);
                if (i3 > 0) {
                    this.a(StatisticList.w, i3);
                    this.causeFoodExhaustion(this.H.spigotConfig.swimMultiplier * (float)i3 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_UNDERWATER);
                }
            } else if (this.aT()) {
                int i4 = Math.round((float)Math.sqrt(dx * dx + dz * dz) * 100.0f);
                if (i4 > 0) {
                    this.a(StatisticList.s, i4);
                    this.causeFoodExhaustion(this.H.spigotConfig.swimMultiplier * (float)i4 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_ON_WATER);
                }
            } else if (this.z_()) {
                if (dy > 0.0) {
                    this.a(StatisticList.u, (int)Math.round(dy * 100.0));
                }
            } else if (this.N) {
                int i5 = Math.round((float)Math.sqrt(dx * dx + dz * dz) * 100.0f);
                if (i5 > 0) {
                    if (this.bU()) {
                        this.a(StatisticList.r, i5);
                        this.causeFoodExhaustion(this.H.spigotConfig.sprintMultiplier * (float)i5 * 0.01f, EntityExhaustionEvent.ExhaustionReason.SPRINT);
                    } else if (this.bT()) {
                        this.a(StatisticList.q, i5);
                        this.causeFoodExhaustion(this.H.spigotConfig.otherMultiplier * (float)i5 * 0.01f, EntityExhaustionEvent.ExhaustionReason.CROUCH);
                    } else {
                        this.a(StatisticList.p, i5);
                        this.causeFoodExhaustion(this.H.spigotConfig.otherMultiplier * (float)i5 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK);
                    }
                }
            } else if (this.fn()) {
                int i6 = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f);
                this.a(StatisticList.B, i6);
            } else {
                int i7 = Math.round((float)Math.sqrt(dx * dx + dz * dz) * 100.0f);
                if (i7 > 25) {
                    this.a(StatisticList.v, i7);
                }
            }
        }
    }

    private void s(double dx, double dy, double dz) {
        int i2;
        if (this.bL() && (i2 = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f)) > 0) {
            Entity entity = this.cV();
            if (entity instanceof EntityMinecartAbstract) {
                this.a(StatisticList.x, i2);
            } else if (entity instanceof EntityBoat) {
                this.a(StatisticList.y, i2);
            } else if (entity instanceof EntityPig) {
                this.a(StatisticList.z, i2);
            } else if (entity instanceof EntityHorseAbstract) {
                this.a(StatisticList.A, i2);
            } else if (entity instanceof EntityStrider) {
                this.a(StatisticList.D, i2);
            }
        }
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        if (this.cm.c && !this.flyingFallDamage.toBooleanOrElse(false)) {
            return false;
        }
        if (fallDistance >= 2.0f) {
            this.a(StatisticList.t, (int)Math.round((double)fallDistance * 100.0));
        }
        return super.a(fallDistance, damageMultiplier, damageSource);
    }

    public boolean fO() {
        net.minecraft.world.item.ItemStack itemstack;
        if (!this.N && !this.fn() && !this.aT() && !this.a(MobEffects.y) && (itemstack = this.c(EnumItemSlot.e)).a(Items.nd) && ItemElytra.d(itemstack)) {
            this.fP();
            return true;
        }
        return false;
    }

    public void fP() {
        if (!CraftEventFactory.callToggleGlideEvent(this, true).isCancelled()) {
            this.b(7, true);
        } else {
            this.b(7, true);
            this.b(7, false);
        }
    }

    public void fQ() {
        if (!CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
            this.b(7, true);
            this.b(7, false);
        }
    }

    @Override
    protected void bb() {
        if (!this.F_()) {
            super.bb();
        }
    }

    @Override
    public EntityLiving.a ey() {
        return new EntityLiving.a(SoundEffects.sp, SoundEffects.sf);
    }

    @Override
    public boolean a(WorldServer world, EntityLiving other) {
        this.b(StatisticList.g.b(other.ae()));
        return true;
    }

    @Override
    public void a(IBlockData state, Vec3D multiplier) {
        if (!this.cm.b) {
            super.a(state, multiplier);
        }
    }

    public void d(int experience) {
        this.r(experience);
        this.ce += (float)experience / (float)this.fS();
        this.cd = MathHelper.a(this.cd + experience, 0, Integer.MAX_VALUE);
        while (this.ce < 0.0f) {
            float f2 = this.ce * (float)this.fS();
            if (this.cc > 0) {
                this.c(-1);
                this.ce = 1.0f + f2 / (float)this.fS();
                continue;
            }
            this.c(-1);
            this.ce = 0.0f;
        }
        while (this.ce >= 1.0f) {
            this.ce = (this.ce - 1.0f) * (float)this.fS();
            this.c(1);
            this.ce /= (float)this.fS();
        }
    }

    public int fR() {
        return this.cf;
    }

    public void a(net.minecraft.world.item.ItemStack enchantedItem, int experienceLevels) {
        this.cc -= experienceLevels;
        if (this.cc < 0) {
            this.cc = 0;
            this.ce = 0.0f;
            this.cd = 0;
        }
        this.cf = this.af.f();
    }

    public void c(int levels) {
        this.cc += levels;
        if (this.cc < 0) {
            this.cc = 0;
            this.ce = 0.0f;
            this.cd = 0;
        }
        if (levels > 0 && this.cc % 5 == 0 && (float)this.cn < (float)this.ag - 100.0f) {
            float f2 = this.cc > 30 ? 1.0f : (float)this.cc / 30.0f;
            this.H.a((EntityHuman)null, this.dl(), this.dn(), this.dr(), SoundEffects.so, this.cX(), f2 * 0.75f, 1.0f);
            this.cn = this.ag;
        }
    }

    public int fS() {
        return this.cc >= 30 ? 112 + (this.cc - 30) * 9 : (this.cc >= 15 ? 37 + (this.cc - 15) * 5 : 7 + this.cc * 2);
    }

    private static void sendSoundEffect(EntityHuman fromEntity, double x2, double y2, double z2, SoundEffect soundEffect, SoundCategory soundCategory, float volume, float pitch) {
        fromEntity.H.a(fromEntity, x2, y2, z2, soundEffect, soundCategory, volume, pitch);
        if (fromEntity instanceof EntityPlayer) {
            ((EntityPlayer)fromEntity).b.a(new PacketPlayOutNamedSoundEffect(BuiltInRegistries.c.d(soundEffect), soundCategory, x2, y2, z2, volume, pitch, fromEntity.af.g()));
        }
    }

    public void y(float exhaustion) {
        this.causeFoodExhaustion(exhaustion, EntityExhaustionEvent.ExhaustionReason.UNKNOWN);
    }

    public void causeFoodExhaustion(float f2, EntityExhaustionEvent.ExhaustionReason reason) {
        EntityExhaustionEvent event;
        if (!(this.cm.a || this.H.B || (event = CraftEventFactory.callPlayerExhaustionEvent(this, reason, f2)).isCancelled())) {
            this.bQ.a(event.getExhaustion());
        }
    }

    public Optional<WardenSpawnTracker> W() {
        return Optional.empty();
    }

    public FoodMetaData fT() {
        return this.bQ;
    }

    public boolean t(boolean ignoreHunger) {
        return this.cm.a || ignoreHunger || this.bQ.c();
    }

    public boolean fU() {
        return this.eo() > 0.0f && this.eo() < this.eE();
    }

    public boolean fV() {
        return this.cm.e;
    }

    public boolean a(BlockPosition pos, EnumDirection facing, net.minecraft.world.item.ItemStack stack) {
        if (this.cm.e) {
            return true;
        }
        BlockPosition blockposition1 = pos.a(facing.g());
        ShapeDetectorBlock shapedetectorblock = new ShapeDetectorBlock(this.H, blockposition1, false);
        return stack.a(this.H.u_().d(Registries.e), shapedetectorblock);
    }

    @Override
    public int dX() {
        if (!this.H.W().b(GameRules.d) && !this.F_()) {
            int i2 = this.cc * 7;
            return i2 > 100 ? 100 : i2;
        }
        return 0;
    }

    @Override
    protected boolean dY() {
        return true;
    }

    @Override
    public boolean cy() {
        return true;
    }

    @Override
    protected Entity.MovementEmission aQ() {
        return !this.cm.b && (!this.N || !this.bR()) ? Entity.MovementEmission.d : Entity.MovementEmission.a;
    }

    public void w() {
    }

    @Override
    public IChatBaseComponent Z() {
        return IChatBaseComponent.b(this.co.getName());
    }

    public InventoryEnderChest fW() {
        return this.bN;
    }

    @Override
    public net.minecraft.world.item.ItemStack c(EnumItemSlot slot) {
        return slot == EnumItemSlot.a ? this.ck.f() : (slot == EnumItemSlot.b ? this.ck.k.get(0) : (slot.a() == EnumItemSlot.Function.b ? this.ck.j.get(slot.b()) : net.minecraft.world.item.ItemStack.b));
    }

    @Override
    protected boolean a(EnumItemSlot slot) {
        return slot.a() == EnumItemSlot.Function.b;
    }

    @Override
    public void a(EnumItemSlot slot, net.minecraft.world.item.ItemStack stack) {
        this.setItemSlot(slot, stack, false);
    }

    @Override
    public void setItemSlot(EnumItemSlot enumitemslot, net.minecraft.world.item.ItemStack itemstack, boolean silent) {
        this.e(itemstack);
        if (enumitemslot == EnumItemSlot.a) {
            this.onEquipItem(enumitemslot, this.ck.i.set(this.ck.l, itemstack), itemstack, silent);
        } else if (enumitemslot == EnumItemSlot.b) {
            this.onEquipItem(enumitemslot, this.ck.k.set(0, itemstack), itemstack, silent);
        } else if (enumitemslot.a() == EnumItemSlot.Function.b) {
            this.onEquipItem(enumitemslot, this.ck.j.set(enumitemslot.b(), itemstack), itemstack, silent);
        }
    }

    public boolean i(net.minecraft.world.item.ItemStack stack) {
        return this.ck.e(stack);
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> bH() {
        return Lists.newArrayList((Object[])new net.minecraft.world.item.ItemStack[]{this.eK(), this.eL()});
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> bI() {
        return this.ck.j;
    }

    public boolean h(NBTTagCompound entityNbt) {
        if (!this.bL() && this.N && !this.aT() && !this.az) {
            if (this.ga().g()) {
                this.i(entityNbt);
                this.cj = this.H.U();
                return true;
            }
            if (this.gb().g()) {
                this.j(entityNbt);
                this.cj = this.H.U();
                return true;
            }
            return false;
        }
        return false;
    }

    public void fX() {
        if (this.cj + 20L < this.H.U()) {
            if (this.spawnEntityFromShoulder(this.ga())) {
                this.i(new NBTTagCompound());
            }
            if (this.spawnEntityFromShoulder(this.gb())) {
                this.j(new NBTTagCompound());
            }
        }
    }

    public Entity releaseLeftShoulderEntity() {
        Entity entity = this.spawnEntityFromShoulder0(this.ga());
        if (entity != null) {
            this.i(new NBTTagCompound());
        }
        return entity;
    }

    public Entity releaseRightShoulderEntity() {
        Entity entity = this.spawnEntityFromShoulder0(this.gb());
        if (entity != null) {
            this.j(new NBTTagCompound());
        }
        return entity;
    }

    private boolean spawnEntityFromShoulder(NBTTagCompound nbttagcompound) {
        return this.spawnEntityFromShoulder0(nbttagcompound) != null;
    }

    private Entity spawnEntityFromShoulder0(@Nullable NBTTagCompound nbttagcompound) {
        if (!this.H.B && nbttagcompound != null && !nbttagcompound.g()) {
            return EntityTypes.a(nbttagcompound, this.H).map(entity -> {
                if (entity instanceof EntityTameableAnimal) {
                    ((EntityTameableAnimal)entity).b(this.ax);
                }
                entity.e(this.dl(), this.dn() + (double)0.7f, this.dr());
                boolean addedToWorld = ((WorldServer)this.H).addWithUUID((Entity)entity, CreatureSpawnEvent.SpawnReason.SHOULDER_ENTITY);
                return addedToWorld ? entity : null;
            }).orElse(null);
        }
        return null;
    }

    @Override
    public abstract boolean F_();

    @Override
    public boolean bl() {
        return !this.F_() && super.bl();
    }

    @Override
    public boolean bV() {
        return !this.cm.b && !this.F_() && super.bV();
    }

    public abstract boolean f();

    @Override
    public boolean cv() {
        return !this.cm.b;
    }

    public Scoreboard fY() {
        return this.H.H();
    }

    @Override
    public IChatBaseComponent G_() {
        IChatMutableComponent ichatmutablecomponent = ScoreboardTeam.a(this.cb(), this.Z());
        return this.a(ichatmutablecomponent);
    }

    private IChatMutableComponent a(IChatMutableComponent component) {
        String s2 = this.fI().getName();
        return component.a(chatmodifier -> chatmodifier.a(new ChatClickable(ChatClickable.EnumClickAction.d, "/tell " + s2 + " ")).a(this.cC()).a(s2));
    }

    @Override
    public String cu() {
        return this.fI().getName();
    }

    @Override
    public float b(EntityPose pose, EntitySize dimensions) {
        switch (pose) {
            case d: 
            case b: 
            case e: {
                return 0.4f;
            }
            case f: {
                return 1.27f;
            }
        }
        return 1.62f;
    }

    @Override
    public void x(float amount) {
        if (amount < 0.0f) {
            amount = 0.0f;
        }
        this.aj().b(e, Float.valueOf(amount));
    }

    @Override
    public float fb() {
        return this.aj().a(e).floatValue();
    }

    public boolean a(PlayerModelPart modelPart) {
        return (this.aj().a(bJ) & modelPart.a()) == modelPart.a();
    }

    @Override
    public SlotAccess a_(int mappedIndex) {
        if (mappedIndex >= 0 && mappedIndex < this.ck.i.size()) {
            return SlotAccess.a(this.ck, mappedIndex);
        }
        int j2 = mappedIndex - 200;
        return j2 >= 0 && j2 < this.bN.b() ? SlotAccess.a(this.bN, j2) : super.a_(mappedIndex);
    }

    public boolean fZ() {
        return this.cp;
    }

    public void u(boolean reducedDebugInfo) {
        this.cp = reducedDebugInfo;
    }

    @Override
    public void g(int fireTicks) {
        super.g(this.cm.a ? Math.min(fireTicks, 1) : fireTicks);
    }

    @Override
    public EnumMainHand fd() {
        return this.am.a(bK) == 0 ? EnumMainHand.a : EnumMainHand.b;
    }

    public void a(EnumMainHand arm) {
        this.am.b(bK, (byte)(arm != EnumMainHand.a ? 1 : 0));
    }

    public NBTTagCompound ga() {
        return this.am.a(bL);
    }

    public void i(NBTTagCompound entityNbt) {
        this.am.b(bL, entityNbt);
    }

    public NBTTagCompound gb() {
        return this.am.a(bM);
    }

    public void j(NBTTagCompound entityNbt) {
        this.am.b(bM, entityNbt);
    }

    public float gc() {
        return (float)(1.0 / this.b(GenericAttributes.h) * 20.0);
    }

    public float z(float baseTime) {
        return MathHelper.a(((float)this.aO + baseTime) / this.gc(), 0.0f, 1.0f);
    }

    public void gd() {
        this.aO = 0;
    }

    public ItemCooldown ge() {
        return this.cr;
    }

    @Override
    protected float aF() {
        return !this.cm.b && !this.fn() ? super.aF() : 1.0f;
    }

    public float gf() {
        return (float)this.b(GenericAttributes.k);
    }

    public boolean gg() {
        return this.cm.d && this.B() >= 2;
    }

    @Override
    public boolean f(net.minecraft.world.item.ItemStack stack) {
        EnumItemSlot enumitemslot = EntityInsentient.h(stack);
        return this.c(enumitemslot).b();
    }

    @Override
    public EntitySize a(EntityPose pose) {
        return c.getOrDefault((Object)pose, bI);
    }

    @Override
    public ImmutableList<EntityPose> fr() {
        return ImmutableList.of((Object)((Object)EntityPose.a), (Object)((Object)EntityPose.f), (Object)((Object)EntityPose.d));
    }

    protected boolean tryReadyArrow(net.minecraft.world.item.ItemStack bow, net.minecraft.world.item.ItemStack itemstack) {
        return !(this instanceof EntityPlayer) || new PlayerReadyArrowEvent((Player)((EntityPlayer)this).getBukkitEntity(), (ItemStack)CraftItemStack.asCraftMirror(bow), (ItemStack)CraftItemStack.asCraftMirror(itemstack)).callEvent();
    }

    @Override
    public net.minecraft.world.item.ItemStack g(net.minecraft.world.item.ItemStack stack) {
        if (!(stack.c() instanceof ItemProjectileWeapon)) {
            return net.minecraft.world.item.ItemStack.b;
        }
        Predicate<net.minecraft.world.item.ItemStack> predicate = ((ItemProjectileWeapon)stack.c()).e().and(item -> this.tryReadyArrow(stack, (net.minecraft.world.item.ItemStack)item));
        net.minecraft.world.item.ItemStack itemstack1 = ItemProjectileWeapon.a(this, predicate);
        if (!itemstack1.b()) {
            return itemstack1;
        }
        predicate = ((ItemProjectileWeapon)stack.c()).b().and(item -> this.tryReadyArrow(stack, (net.minecraft.world.item.ItemStack)item));
        for (int i2 = 0; i2 < this.ck.b(); ++i2) {
            net.minecraft.world.item.ItemStack itemstack2 = this.ck.a(i2);
            if (!predicate.test(itemstack2)) continue;
            return itemstack2;
        }
        return this.cm.d ? new net.minecraft.world.item.ItemStack(Items.nD) : net.minecraft.world.item.ItemStack.b;
    }

    @Override
    public net.minecraft.world.item.ItemStack a(World world, net.minecraft.world.item.ItemStack stack) {
        this.fT().a(stack.c(), stack);
        this.b(StatisticList.c.b(stack.c()));
        world.a((EntityHuman)null, this.dl(), this.dn(), this.dr(), SoundEffects.sh, SoundCategory.h, 0.5f, world.z.i() * 0.1f + 0.9f);
        if (this instanceof EntityPlayer) {
            CriterionTriggers.z.a((EntityPlayer)this, stack);
        }
        return super.a(world, stack);
    }

    @Override
    protected boolean b(IBlockData landingState) {
        return this.cm.b || super.b(landingState);
    }

    @Override
    public Vec3D u(float delta) {
        float f3;
        double d0 = 0.22 * (this.fd() == EnumMainHand.b ? -1.0 : 1.0);
        float f1 = MathHelper.i(delta * 0.5f, this.dy(), this.M) * ((float)Math.PI / 180);
        float f2 = MathHelper.i(delta, this.aU, this.aT) * ((float)Math.PI / 180);
        if (!this.fn() && !this.fa()) {
            if (this.bW()) {
                return this.p(delta).e(new Vec3D(d0, 0.2, -0.15).a(-f1).b(-f2));
            }
            double d2 = this.cD().c() - 1.0;
            double d1 = this.bT() ? -0.2 : 0.07;
            return this.p(delta).e(new Vec3D(d0, d2, d1).b(-f2));
        }
        Vec3D vec3d = this.j(delta);
        Vec3D vec3d1 = this.dj();
        double d1 = vec3d1.i();
        double d3 = vec3d.i();
        if (d1 > 0.0 && d3 > 0.0) {
            double d4 = (vec3d1.c * vec3d.c + vec3d1.e * vec3d.e) / Math.sqrt(d1 * d3);
            double d5 = vec3d1.c * vec3d.e - vec3d1.e * vec3d.c;
            f3 = (float)(Math.signum(d5) * Math.acos(d4));
        } else {
            f3 = 0.0f;
        }
        return this.p(delta).e(new Vec3D(d0, -0.11, 0.85).c(-f3).a(-f1).b(-f2));
    }

    @Override
    public boolean dF() {
        return true;
    }

    public boolean gh() {
        return this.fe() && this.fg().a(Items.qf);
    }

    @Override
    public boolean dE() {
        return false;
    }

    public Optional<GlobalPos> gi() {
        return this.cs;
    }

    public void a(Optional<GlobalPos> lastDeathPos) {
        this.cs = lastDeathPos;
    }

    @Override
    public float ex() {
        return this.ci;
    }

    @Override
    public void q(float yaw) {
        super.q(yaw);
        this.ci = yaw;
    }

    @Override
    public boolean dz() {
        return true;
    }

    @Override
    protected float eV() {
        return this.cm.b && !this.bL() ? (this.bU() ? this.cm.a() * 2.0f : this.cm.a()) : (this.bU() ? 0.025999999f : 0.02f);
    }

    public static enum EnumBedResult {
        a,
        b(IChatBaseComponent.c("block.minecraft.bed.no_sleep")),
        c(IChatBaseComponent.c("block.minecraft.bed.too_far_away")),
        d(IChatBaseComponent.c("block.minecraft.bed.obstructed")),
        e,
        f(IChatBaseComponent.c("block.minecraft.bed.not_safe"));

        @Nullable
        private final IChatBaseComponent g;

        private EnumBedResult() {
            this.g = null;
        }

        private EnumBedResult(IChatBaseComponent ichatbasecomponent) {
            this.g = ichatbasecomponent;
        }

        @Nullable
        public IChatBaseComponent a() {
            return this.g;
        }
    }
}

