/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.annotation.DoNotUse;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.PublicKey;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.ThrowingComponent;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MinecraftEncryption;
import net.minecraft.util.SignatureValidator;
import org.bukkit.event.player.PlayerKickEvent;

public final class ProfilePublicKey
extends Record {
    private final a d;
    public static final IChatBaseComponent a = IChatBaseComponent.c("multiplayer.disconnect.expired_public_key");
    private static final IChatBaseComponent e = IChatBaseComponent.c("multiplayer.disconnect.invalid_public_key_signature");
    public static final Duration b = Duration.ofHours(8L);
    public static final Codec<ProfilePublicKey> c = net.minecraft.world.entity.player.ProfilePublicKey$a.a.xmap(ProfilePublicKey::new, ProfilePublicKey::b);

    public ProfilePublicKey(a data) {
        this.d = data;
    }

    public static ProfilePublicKey a(SignatureValidator servicesSignatureVerifier, UUID playerUuid, a publicKeyData, Duration gracePeriod) throws b {
        if (publicKeyData.a(gracePeriod)) {
            throw new b(a, PlayerKickEvent.Cause.EXPIRED_PROFILE_PUBLIC_KEY);
        }
        if (!publicKeyData.a(servicesSignatureVerifier, playerUuid)) {
            throw new b(e, PlayerKickEvent.Cause.INVALID_PUBLIC_KEY_SIGNATURE);
        }
        return new ProfilePublicKey(publicKeyData);
    }

    public SignatureValidator a() {
        return SignatureValidator.a(this.d.c, "SHA256withRSA");
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ProfilePublicKey.class, "data", "d"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ProfilePublicKey.class, "data", "d"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ProfilePublicKey.class, "data", "d"}, this, o2);
    }

    public a b() {
        return this.d;
    }

    public record a(Instant b, PublicKey c, byte[] d) {
        private static final int e = 4096;
        public static final Codec<a> a = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.l.fieldOf("expires_at").forGetter(a::b), (App)MinecraftEncryption.f.fieldOf("key").forGetter(a::c), (App)ExtraCodecs.m.fieldOf("signature_v2").forGetter(a::d)).apply((Applicative)instance, a::new));

        public a(PacketDataSerializer buf) {
            this(buf.v(), buf.w(), buf.b(4096));
        }

        public void a(PacketDataSerializer buf) {
            buf.a(this.b);
            buf.a(this.c);
            buf.a(this.d);
        }

        boolean a(SignatureValidator servicesSignatureVerifier, UUID playerUuid) {
            return servicesSignatureVerifier.a(this.a(playerUuid), this.d);
        }

        private byte[] a(UUID playerUuid) {
            byte[] bs = this.c.getEncoded();
            byte[] cs = new byte[24 + bs.length];
            ByteBuffer byteBuffer = ByteBuffer.wrap(cs).order(ByteOrder.BIG_ENDIAN);
            byteBuffer.putLong(playerUuid.getMostSignificantBits()).putLong(playerUuid.getLeastSignificantBits()).putLong(this.b.toEpochMilli()).put(bs);
            return cs;
        }

        public boolean a() {
            return this.b.isBefore(Instant.now());
        }

        public boolean a(Duration gracePeriod) {
            return this.b.plus(gracePeriod).isBefore(Instant.now());
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof a)) {
                return false;
            }
            a data = (a)object;
            return this.b.equals(data.b) && this.c.equals(data.c) && Arrays.equals(this.d, data.d);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "expiresAt;key;keySignature", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "expiresAt;key;keySignature", "b", "c", "d"}, this);
        }
    }

    public static class b
    extends ThrowingComponent {
        public final PlayerKickEvent.Cause kickCause;

        @DoNotUse
        @Deprecated
        public b(IChatBaseComponent messageText) {
            this(messageText, PlayerKickEvent.Cause.UNKNOWN);
        }

        public b(IChatBaseComponent messageText, PlayerKickEvent.Cause kickCause) {
            super(messageText);
            this.kickCause = kickCause;
        }
    }
}

