/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftItem;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.player.PlayerPickupArrowEvent;

public abstract class EntityArrow
extends IProjectile {
    private static final double f = 2.0;
    private static final DataWatcherObject<Byte> g = DataWatcher.a(EntityArrow.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Byte> h = DataWatcher.a(EntityArrow.class, DataWatcherRegistry.a);
    private static final int i = 1;
    private static final int j = 2;
    private static final int k = 4;
    @Nullable
    private IBlockData l;
    public boolean b;
    protected int c;
    public PickupStatus d = PickupStatus.a;
    public int e;
    public int m;
    private double n = 2.0;
    public int o;
    public SoundEffect p = this.j();
    @Nullable
    private IntOpenHashSet q;
    @Nullable
    private List<Entity> r;

    @Override
    public void inactiveTick() {
        if (this.b) {
            ++this.m;
        }
        super.inactiveTick();
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> type, World world) {
        super((EntityTypes<? extends IProjectile>)type, world);
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> type, double x2, double y2, double z2, World world) {
        this(type, world);
        this.e(x2, y2, z2);
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> type, EntityLiving owner, World world) {
        this(type, owner.dl(), owner.dp() - (double)0.1f, owner.dr(), world);
        this.b((Entity)owner);
        if (owner instanceof EntityHuman) {
            this.d = PickupStatus.b;
        }
    }

    public void b(SoundEffect sound) {
        this.p = sound;
    }

    @Override
    public boolean a(double distance) {
        double d1 = this.cD().a() * 10.0;
        if (Double.isNaN(d1)) {
            d1 = 1.0;
        }
        return distance < (d1 *= 64.0 * EntityArrow.cw()) * d1;
    }

    @Override
    protected void a_() {
        this.am.a(g, (byte)0);
        this.am.a(h, (byte)0);
    }

    @Override
    public void c(double x2, double y2, double z2, float speed, float divergence) {
        super.c(x2, y2, z2, speed, divergence);
        this.m = 0;
    }

    @Override
    public void a(double x2, double y2, double z2, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.e(x2, y2, z2);
        this.a(yaw, pitch);
    }

    @Override
    public void l(double x2, double y2, double z2) {
        super.l(x2, y2, z2);
        this.m = 0;
    }

    @Override
    public void l() {
        Vec3D vec3d1;
        VoxelShape voxelshape;
        BlockPosition blockposition;
        IBlockData iblockdata;
        super.l();
        boolean flag = this.x();
        Vec3D vec3d = this.dj();
        if (this.M == 0.0f && this.L == 0.0f) {
            double d0 = vec3d.h();
            this.f((float)(MathHelper.d(vec3d.c, vec3d.e) * 57.2957763671875));
            this.e((float)(MathHelper.d(vec3d.d, d0) * 57.2957763671875));
            this.L = this.dw();
            this.M = this.dy();
        }
        if (!((iblockdata = this.H.a_(blockposition = this.dg())).h() || flag || (voxelshape = iblockdata.k(this.H, blockposition)).b())) {
            vec3d1 = this.de();
            for (AxisAlignedBB axisalignedbb : voxelshape.d()) {
                if (!axisalignedbb.a(blockposition).d(vec3d1)) continue;
                this.b = true;
                break;
            }
        }
        if (this.e > 0) {
            --this.e;
        }
        if (this.aU() || iblockdata.a(Blocks.qy)) {
            this.av();
        }
        if (this.b && !flag) {
            if (this.l != iblockdata && this.y()) {
                this.C();
            } else if (!this.H.B) {
                this.i();
            }
            ++this.c;
        } else {
            if (this.ag > 200) {
                this.i();
            }
            this.c = 0;
            Vec3D vec3d2 = this.de();
            MovingObjectPosition object = this.H.a(new RayTrace(vec3d2, vec3d1 = vec3d2.e(vec3d), RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, this));
            if (((MovingObjectPosition)object).c() != MovingObjectPosition.EnumMovingObjectType.a) {
                vec3d1 = ((MovingObjectPosition)object).e();
            }
            while (!this.dB()) {
                MovingObjectPositionEntity movingobjectpositionentity = this.a(vec3d2, vec3d1);
                if (movingobjectpositionentity != null) {
                    object = movingobjectpositionentity;
                }
                if (object != null && ((MovingObjectPosition)object).c() == MovingObjectPosition.EnumMovingObjectType.c) {
                    Entity entity = ((MovingObjectPositionEntity)object).a();
                    Entity entity1 = this.v();
                    if (entity instanceof EntityHuman && entity1 instanceof EntityHuman && !((EntityHuman)entity1).a((EntityHuman)entity)) {
                        object = null;
                        movingobjectpositionentity = null;
                    }
                }
                if (object != null && !flag) {
                    this.preOnHit(object);
                    this.at = true;
                }
                if (movingobjectpositionentity == null || this.t() <= 0) break;
                object = null;
            }
            vec3d = this.dj();
            double d1 = vec3d.c;
            double d2 = vec3d.d;
            double d3 = vec3d.e;
            if (this.r()) {
                for (int i2 = 0; i2 < 4; ++i2) {
                    this.H.a(Particles.g, this.dl() + d1 * (double)i2 / 4.0, this.dn() + d2 * (double)i2 / 4.0, this.dr() + d3 * (double)i2 / 4.0, -d1, -d2 + 0.2, -d3);
                }
            }
            double d4 = this.dl() + d1;
            double d5 = this.dn() + d2;
            double d6 = this.dr() + d3;
            double d7 = vec3d.h();
            if (flag) {
                this.f((float)(MathHelper.d(-d1, -d3) * 57.2957763671875));
            } else {
                this.f((float)(MathHelper.d(d1, d3) * 57.2957763671875));
            }
            this.e((float)(MathHelper.d(d2, d7) * 57.2957763671875));
            this.e(EntityArrow.d(this.M, this.dy()));
            this.f(EntityArrow.d(this.L, this.dw()));
            float f2 = 0.99f;
            float f1 = 0.05f;
            if (this.aT()) {
                for (int j2 = 0; j2 < 4; ++j2) {
                    float f22 = 0.25f;
                    this.H.a(Particles.e, d4 - d1 * 0.25, d5 - d2 * 0.25, d6 - d3 * 0.25, d1, d2, d3);
                }
                f2 = this.w();
            }
            this.f(vec3d.a((double)f2));
            if (!this.aP() && !flag) {
                Vec3D vec3d3 = this.dj();
                this.o(vec3d3.c, vec3d3.d - (double)0.05f, vec3d3.e);
            }
            this.e(d4, d5, d6);
            this.aL();
        }
    }

    @Override
    public void preOnHit(MovingObjectPosition hitResult) {
        super.preOnHit(hitResult);
        if (hitResult instanceof MovingObjectPositionEntity) {
            MovingObjectPositionEntity entityHitResult = (MovingObjectPositionEntity)hitResult;
            if (this.hitCancelled && this.t() > 0) {
                if (this.q == null) {
                    this.q = new IntOpenHashSet(5);
                }
                this.q.add(entityHitResult.a().af());
            }
        }
    }

    private boolean y() {
        return this.b && this.H.b(new AxisAlignedBB(this.de(), this.de()).g(0.06));
    }

    private void C() {
        this.b = false;
        Vec3D vec3d = this.dj();
        this.f(vec3d.d(this.af.i() * 0.2f, this.af.i() * 0.2f, this.af.i() * 0.2f));
        this.m = 0;
    }

    @Override
    public void a(EnumMoveType movementType, Vec3D movement) {
        super.a(movementType, movement);
        if (movementType != EnumMoveType.a && this.y()) {
            this.C();
        }
    }

    protected void i() {
        ++this.m;
        if (this.m >= (this.d == PickupStatus.c ? this.H.paperConfig().entities.spawning.creativeArrowDespawnRate.value() : (this.d == PickupStatus.a ? this.H.paperConfig().entities.spawning.nonPlayerArrowDespawnRate.value() : (this instanceof EntityThrownTrident ? this.H.spigotConfig.tridentDespawnRate : this.H.spigotConfig.arrowDespawnRate)))) {
            this.ai();
        }
    }

    private void D() {
        if (this.r != null) {
            this.r.clear();
        }
        if (this.q != null) {
            this.q.clear();
        }
    }

    @Override
    protected void a(MovingObjectPositionEntity entityHitResult) {
        DamageSource damagesource;
        Entity entity1;
        super.a(entityHitResult);
        Entity entity = entityHitResult.a();
        float f2 = (float)this.dj().f();
        int i2 = MathHelper.c(MathHelper.a((double)f2 * this.n, 0.0, 2.147483647E9));
        if (this.t() > 0) {
            if (this.q == null) {
                this.q = new IntOpenHashSet(5);
            }
            if (this.r == null) {
                this.r = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.q.size() >= this.t() + 1) {
                this.ai();
                return;
            }
            this.q.add(entity.af());
        }
        if (this.r()) {
            long j2 = this.af.a(i2 / 2 + 2);
            i2 = (int)Math.min(j2 + (long)i2, Integer.MAX_VALUE);
        }
        if ((entity1 = this.v()) == null) {
            damagesource = this.dG().a(this, (Entity)this);
        } else {
            damagesource = this.dG().a(this, entity1);
            if (entity1 instanceof EntityLiving) {
                ((EntityLiving)entity1).x(entity);
            }
        }
        if (this.r()) {
            damagesource = damagesource.critical();
        }
        boolean flag = entity.ae() == EntityTypes.E;
        int k2 = entity.au();
        if (this.bK() && !flag) {
            EntityCombustByEntityEvent combustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity(), 5);
            Bukkit.getPluginManager().callEvent((Event)combustEvent);
            if (!combustEvent.isCancelled()) {
                entity.setSecondsOnFire(combustEvent.getDuration(), false);
            }
        }
        if (entity.a(damagesource, (float)i2)) {
            if (flag) {
                return;
            }
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                if (!this.H.B && this.t() <= 0) {
                    entityliving.o(entityliving.eF() + 1);
                }
                if (this.o > 0) {
                    double d0 = Math.max(0.0, 1.0 - entityliving.b(GenericAttributes.c));
                    Vec3D vec3d = this.dj().d(1.0, 0.0, 1.0).d().a((double)this.o * 0.6 * d0);
                    if (vec3d.g() > 0.0) {
                        entityliving.push(vec3d.c, 0.1, vec3d.e, this);
                    }
                }
                if (!this.H.B && entity1 instanceof EntityLiving) {
                    EnchantmentManager.a(entityliving, entity1);
                    EnchantmentManager.b((EntityLiving)entity1, (Entity)entityliving);
                }
                this.a(entityliving);
                if (entity1 != null && entityliving != entity1 && entityliving instanceof EntityHuman && entity1 instanceof EntityPlayer && !this.aO()) {
                    ((EntityPlayer)entity1).b.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.g, 0.0f));
                }
                if (!entity.bq() && this.r != null) {
                    this.r.add(entityliving);
                }
                if (!this.H.B && entity1 instanceof EntityPlayer) {
                    EntityPlayer entityplayer = (EntityPlayer)entity1;
                    if (this.r != null && this.s()) {
                        CriterionTriggers.G.a(entityplayer, this.r);
                    } else if (!entity.bq() && this.s()) {
                        CriterionTriggers.G.a(entityplayer, Arrays.asList(entity));
                    }
                }
            }
            this.a(this.p, 1.0f, 1.2f / (this.af.i() * 0.2f + 0.9f));
            if (this.t() <= 0) {
                this.ai();
            }
        } else {
            entity.g(k2);
            this.f(this.dj().a(-0.1));
            this.f(this.dw() + 180.0f);
            this.L += 180.0f;
            if (!this.H.B && this.dj().g() < 1.0E-7) {
                if (this.d == PickupStatus.b) {
                    this.a(this.o(), 0.1f);
                }
                this.ai();
            }
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock blockHitResult) {
        this.l = this.H.a_(blockHitResult.a());
        super.a(blockHitResult);
        Vec3D vec3d = blockHitResult.e().a(this.dl(), this.dn(), this.dr());
        this.f(vec3d);
        Vec3D vec3d1 = vec3d.d().a((double)0.05f);
        this.p(this.dl() - vec3d1.c, this.dn() - vec3d1.d, this.dr() - vec3d1.e);
        this.a(this.k(), 1.0f, 1.2f / (this.af.i() * 0.2f + 0.9f));
        this.b = true;
        this.e = 7;
        this.a(false);
        this.a((byte)0);
        this.b(SoundEffects.ao);
        this.q(false);
        this.D();
    }

    protected SoundEffect j() {
        return SoundEffects.ao;
    }

    protected final SoundEffect k() {
        return this.p;
    }

    protected void a(EntityLiving target) {
    }

    @Nullable
    protected MovingObjectPositionEntity a(Vec3D currentPosition, Vec3D nextPosition) {
        return ProjectileHelper.a(this.H, this, currentPosition, nextPosition, this.cD().b(this.dj()).g(1.0), this::a);
    }

    @Override
    public boolean a(Entity entity) {
        return super.a(entity) && (this.q == null || !this.q.contains(entity.af()));
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("life", (short)this.m);
        if (this.l != null) {
            nbt.a("inBlockState", GameProfileSerializer.a(this.l));
        }
        nbt.a("shake", (byte)this.e);
        nbt.a("inGround", this.b);
        nbt.a("pickup", (byte)this.d.ordinal());
        nbt.a("damage", this.n);
        nbt.a("crit", this.r());
        nbt.a("PierceLevel", this.t());
        nbt.a("SoundEvent", BuiltInRegistries.c.b(this.p).toString());
        nbt.a("ShotFromCrossbow", this.s());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.m = nbt.g("life");
        if (nbt.b("inBlockState", 10)) {
            this.l = GameProfileSerializer.a(this.H.a(Registries.e), nbt.p("inBlockState"));
        }
        this.e = nbt.f("shake") & 0xFF;
        this.b = nbt.q("inGround");
        if (nbt.b("damage", 99)) {
            this.n = nbt.k("damage");
        }
        this.d = PickupStatus.a(nbt.f("pickup"));
        this.a(nbt.q("crit"));
        this.a(nbt.f("PierceLevel"));
        if (nbt.b("SoundEvent", 8)) {
            this.p = BuiltInRegistries.c.b(new MinecraftKey(nbt.l("SoundEvent"))).orElse(this.j());
        }
        this.q(nbt.q("ShotFromCrossbow"));
    }

    @Override
    public void b(@Nullable Entity entity) {
        super.b(entity);
        if (entity instanceof EntityHuman) {
            this.d = ((EntityHuman)entity).fK().d ? PickupStatus.c : PickupStatus.b;
        }
    }

    @Override
    public void b_(EntityHuman player) {
        if (!this.H.B && (this.b || this.x()) && this.e <= 0) {
            ItemStack itemstack = this.o();
            if (this.d == PickupStatus.b && !itemstack.b() && player.fJ().canHold(itemstack) > 0) {
                EntityItem item = new EntityItem(this.H, this.dl(), this.dn(), this.dr(), itemstack);
                PlayerPickupArrowEvent event = new PlayerPickupArrowEvent((Player)player.getBukkitEntity(), (Item)new CraftItem(this.H.getCraftServer(), this, item), (AbstractArrow)this.getBukkitEntity());
                this.H.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                itemstack = item.i();
            }
            if (this.d == PickupStatus.b && player.fJ().e(itemstack) || this.d == PickupStatus.c && player.fK().d) {
                player.a((Entity)this, 1);
                this.ai();
            }
        }
    }

    protected boolean a(EntityHuman player) {
        switch (this.d) {
            case b: {
                return player.fJ().e(this.o());
            }
            case c: {
                return player.fK().d;
            }
        }
        return false;
    }

    public abstract ItemStack o();

    @Override
    protected Entity.MovementEmission aQ() {
        return Entity.MovementEmission.a;
    }

    public void h(double damage) {
        this.n = damage;
    }

    public double p() {
        return this.n;
    }

    public void b(int punch) {
        this.o = punch;
    }

    public int q() {
        return this.o;
    }

    @Override
    public boolean cl() {
        return false;
    }

    @Override
    protected float a(EntityPose pose, EntitySize dimensions) {
        return 0.13f;
    }

    public void a(boolean critical) {
        this.a(1, critical);
    }

    public void a(byte level) {
        this.am.b(h, level);
    }

    private void a(int index, boolean flag) {
        byte b0 = this.am.a(g);
        if (flag) {
            this.am.b(g, (byte)(b0 | index));
        } else {
            this.am.b(g, (byte)(b0 & ~index));
        }
    }

    public boolean r() {
        byte b0 = this.am.a(g);
        return (b0 & 1) != 0;
    }

    public boolean s() {
        byte b0 = this.am.a(g);
        return (b0 & 4) != 0;
    }

    public byte t() {
        return this.am.a(h);
    }

    public void a(EntityLiving entity, float damageModifier) {
        int i2 = EnchantmentManager.a(Enchantments.y, entity);
        int j2 = EnchantmentManager.a(Enchantments.z, entity);
        this.h((double)(damageModifier * 2.0f) + this.af.a((double)this.H.ah().a() * 0.11, 0.57425));
        if (i2 > 0) {
            this.h(this.p() + (double)i2 * 0.5 + 0.5);
        }
        if (j2 > 0) {
            this.b(j2);
        }
        if (EnchantmentManager.a(Enchantments.A, entity) > 0) {
            this.f(100);
        }
    }

    protected float w() {
        return 0.6f;
    }

    public void p(boolean noClip) {
        this.ae = noClip;
        this.a(2, noClip);
    }

    public boolean x() {
        return !this.H.B ? this.ae : (this.am.a(g) & 2) != 0;
    }

    public void q(boolean shotFromCrossbow) {
        this.a(4, shotFromCrossbow);
    }

    public static enum PickupStatus {
        a,
        b,
        c;


        public static PickupStatus a(int ordinal) {
            if (ordinal < 0 || ordinal > PickupStatus.values().length) {
                ordinal = 0;
            }
            return PickupStatus.values()[ordinal];
        }
    }
}

