/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.destroystokyo.paper.loottable.PaperLootableInventoryData;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.IPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;

public interface ContainerEntity
extends IInventory,
ITileInventory {
    public Vec3D de();

    @Nullable
    public MinecraftKey z();

    public void a(@Nullable MinecraftKey var1);

    public long A();

    public void a(long var1);

    public NonNullList<ItemStack> C();

    public void D();

    public World Y();

    public boolean dB();

    @Override
    default public boolean aa_() {
        return this.g();
    }

    default public void c(NBTTagCompound nbt) {
        if (this.z() != null) {
            nbt.a("LootTable", this.z().toString());
            if (this.A() != 0L) {
                nbt.a("LootTableSeed", this.A());
            }
        } else {
            ContainerUtil.a(nbt, this.C());
        }
    }

    default public void b_(NBTTagCompound nbt) {
        this.D();
        if (nbt.b("LootTable", 8)) {
            this.a(new MinecraftKey(nbt.l("LootTable")));
            this.a(nbt.i("LootTableSeed"));
        } else {
            ContainerUtil.b(nbt, this.C());
        }
    }

    default public void a(DamageSource source, World world, Entity vehicle) {
        if (world.W().b(GameRules.h)) {
            Entity entity;
            InventoryUtils.a(world, vehicle, (IInventory)this);
            if (!world.B && (entity = source.c()) != null && entity.ae() == EntityTypes.bt) {
                PiglinAI.a((EntityHuman)entity, true);
            }
        }
    }

    default public EnumInteractionResult c_(EntityHuman player) {
        player.a(this);
        return !player.H.B ? EnumInteractionResult.b : EnumInteractionResult.a;
    }

    default public void f(@Nullable EntityHuman player) {
        MinecraftServer minecraftServer = this.Y().n();
        if (this.getLootableData().shouldReplenish(player) && minecraftServer != null) {
            LootTable lootTable = minecraftServer.aH().a(this.z());
            if (player != null) {
                CriterionTriggers.N.a((EntityPlayer)player, this.z());
            }
            this.getLootableData().processRefill(player);
            LootTableInfo.Builder builder = new LootTableInfo.Builder((WorldServer)this.Y()).a(LootContextParameters.f, this.de()).a(this.A());
            if (player != null) {
                builder.a(player.gf()).a(LootContextParameters.a, player);
            }
            lootTable.a((IInventory)this, builder.a(LootContextParameterSets.b));
        }
    }

    default public void f() {
        this.f(null);
        this.C().clear();
    }

    default public boolean g() {
        for (ItemStack itemStack : this.C()) {
            if (itemStack.b()) continue;
            return false;
        }
        return true;
    }

    default public ItemStack e_(int slot) {
        this.f(null);
        ItemStack itemStack = this.C().get(slot);
        if (itemStack.b()) {
            return ItemStack.b;
        }
        this.C().set(slot, ItemStack.b);
        return itemStack;
    }

    default public ItemStack f_(int slot) {
        this.f(null);
        return this.C().get(slot);
    }

    default public ItemStack b(int slot, int amount) {
        this.f(null);
        return ContainerUtil.a(this.C(), slot, amount);
    }

    default public void c(int slot, ItemStack stack) {
        this.f(null);
        this.C().set(slot, stack);
        if (!stack.b() && stack.K() > this.ab_()) {
            stack.f(this.ab_());
        }
    }

    default public SlotAccess g_(final int slot) {
        return slot >= 0 && slot < this.b() ? new SlotAccess(){

            @Override
            public ItemStack a() {
                return ContainerEntity.this.f_(slot);
            }

            @Override
            public boolean a(ItemStack stack) {
                ContainerEntity.this.c(slot, stack);
                return true;
            }
        } : SlotAccess.b;
    }

    default public boolean g(EntityHuman player) {
        return !this.dB() && this.de().a((IPosition)player.de(), 8.0);
    }

    default public Entity getEntity() {
        throw new UnsupportedOperationException();
    }

    default public PaperLootableInventoryData getLootableData() {
        throw new UnsupportedOperationException();
    }
}

