/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayInBoatMove;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockWaterLily;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftLocation;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.vehicle.VehicleUpdateEvent;

public class EntityBoat
extends Entity
implements VariantHolder<EnumBoatType> {
    private static final DataWatcherObject<Integer> f = DataWatcher.a(EntityBoat.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> g = DataWatcher.a(EntityBoat.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Float> h = DataWatcher.a(EntityBoat.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Integer> i = DataWatcher.a(EntityBoat.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> j = DataWatcher.a(EntityBoat.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> k = DataWatcher.a(EntityBoat.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> l = DataWatcher.a(EntityBoat.class, DataWatcherRegistry.b);
    public static final int b = 0;
    public static final int c = 1;
    private static final int m = 60;
    private static final float n = 0.3926991f;
    public static final double d = 0.7853981852531433;
    public static final int e = 60;
    private final float[] o = new float[2];
    private float p;
    private float q;
    private float r;
    private int s;
    private double t;
    private double u;
    private double aC;
    private double aD;
    private double aE;
    private boolean aF;
    private boolean aG;
    private boolean aH;
    private boolean aI;
    private double aJ;
    private float aK;
    public EnumStatus aL;
    private EnumStatus aM;
    private double aN;
    private boolean aO;
    private boolean aP;
    private float aQ;
    private float aR;
    private float aS;
    public double maxSpeed = 0.4;
    public double occupiedDeceleration = 0.2;
    public double unoccupiedDeceleration = -1.0;
    public boolean landBoats = false;
    private Location lastLocation;

    public EntityBoat(EntityTypes<? extends EntityBoat> type, World world) {
        super(type, world);
        this.F = true;
    }

    public EntityBoat(World world, double x2, double y2, double z2) {
        this((EntityTypes<? extends EntityBoat>)EntityTypes.k, world);
        this.e(x2, y2, z2);
        this.I = x2;
        this.J = y2;
        this.K = z2;
    }

    @Override
    protected float a(EntityPose pose, EntitySize dimensions) {
        return dimensions.b;
    }

    @Override
    protected Entity.MovementEmission aQ() {
        return Entity.MovementEmission.c;
    }

    @Override
    protected void a_() {
        this.am.a(f, 0);
        this.am.a(g, 1);
        this.am.a(h, Float.valueOf(0.0f));
        this.am.a(i, EnumBoatType.a.ordinal());
        this.am.a(j, false);
        this.am.a(k, false);
        this.am.a(l, 0);
    }

    @Override
    public boolean h(Entity other) {
        return EntityBoat.a(this, other);
    }

    public static boolean a(Entity entity, Entity other) {
        return (other.bs() || other.bn()) && !entity.v(other);
    }

    @Override
    public boolean bs() {
        return true;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return true;
    }

    @Override
    protected Vec3D a(EnumDirection.EnumAxis portalAxis, BlockUtil.Rectangle portalRect) {
        return EntityLiving.i(super.a(portalAxis, portalRect));
    }

    @Override
    public double bv() {
        return this.t() == EnumBoatType.i ? 0.3 : -0.1;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        if (!this.H.B && !this.dB()) {
            boolean flag;
            Vehicle vehicle = (Vehicle)this.getBukkitEntity();
            CraftEntity attacker = source.d() == null ? null : source.d().getBukkitEntity();
            VehicleDamageEvent event = new VehicleDamageEvent(vehicle, (org.bukkit.entity.Entity)attacker, (double)amount);
            this.H.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
            this.l(-this.s());
            this.d(10);
            this.a(this.q() + amount * 10.0f);
            this.bj();
            this.a(GameEvent.p, source.d());
            boolean bl = flag = source.d() instanceof EntityHuman && ((EntityHuman)source.d()).fK().d;
            if (flag || this.q() > 40.0f) {
                VehicleDestroyEvent destroyEvent = new VehicleDestroyEvent(vehicle, (org.bukkit.entity.Entity)attacker);
                this.H.getCraftServer().getPluginManager().callEvent((Event)destroyEvent);
                if (destroyEvent.isCancelled()) {
                    this.a(40.0f);
                    return true;
                }
                if (!flag && this.H.W().b(GameRules.h)) {
                    this.a(source);
                }
                this.ai();
            }
            return true;
        }
        return true;
    }

    @Override
    protected void a(DamageSource source) {
        this.a((IMaterial)this.i());
    }

    @Override
    public void k(boolean drag) {
        if (!this.H.B) {
            this.aO = true;
            this.aP = drag;
            if (this.E() == 0) {
                this.b(60);
            }
        }
        this.H.a(Particles.ai, this.dl() + (double)this.af.i(), this.dn() + 0.7, this.dr() + (double)this.af.i(), 0.0, 0.0, 0.0);
        if (this.af.a(20) == 0) {
            this.H.a(this.dl(), this.dn(), this.dr(), this.aJ(), this.cX(), 1.0f, 0.8f + 0.4f * this.af.i(), false);
            this.a(GameEvent.S, (Entity)this.cK());
        }
    }

    @Override
    public void g(Entity entity) {
        if (!this.H.paperConfig().collisions.allowVehicleCollisions && this.H.paperConfig().collisions.onlyPlayersCollide && !(entity instanceof EntityHuman)) {
            return;
        }
        if (entity instanceof EntityBoat) {
            if (entity.cD().b < this.cD().e) {
                if (!this.v(entity)) {
                    VehicleEntityCollisionEvent event = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
                    this.H.getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return;
                    }
                }
                super.g(entity);
            }
        } else if (entity.cD().b <= this.cD().b) {
            if (!this.v(entity)) {
                VehicleEntityCollisionEvent event = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
                this.H.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
            }
            super.g(entity);
        }
    }

    public Item i() {
        return switch (this.t()) {
            case EnumBoatType.b -> Items.ng;
            case EnumBoatType.c -> Items.ni;
            case EnumBoatType.d -> Items.nk;
            case EnumBoatType.e -> Items.nm;
            case EnumBoatType.f -> Items.no;
            case EnumBoatType.g -> Items.nq;
            case EnumBoatType.h -> Items.ns;
            case EnumBoatType.i -> Items.nu;
            default -> Items.ne;
        };
    }

    @Override
    public void q(float yaw) {
        this.l(-this.s());
        this.d(10);
        this.a(this.q() * 11.0f);
    }

    @Override
    public boolean bm() {
        return !this.dB();
    }

    @Override
    public void a(double x2, double y2, double z2, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.t = x2;
        this.u = y2;
        this.aC = z2;
        this.aD = yaw;
        this.aE = pitch;
        this.s = 10;
    }

    @Override
    public EnumDirection cB() {
        return this.cA().h();
    }

    @Override
    public void l() {
        this.aM = this.aL;
        this.aL = this.y();
        this.q = this.aL != EnumStatus.b && this.aL != EnumStatus.c ? 0.0f : (this.q += 1.0f);
        if (!this.H.B && this.q >= 60.0f) {
            this.bx();
        }
        if (this.r() > 0) {
            this.d(this.r() - 1);
        }
        if (this.q() > 0.0f) {
            this.a(this.q() - 1.0f);
        }
        super.l();
        this.x();
        if (this.cT()) {
            if (!(this.cN() instanceof EntityHuman)) {
                this.a(false, false);
            }
            this.C();
            if (this.H.B) {
                this.D();
                this.H.a(new PacketPlayInBoatMove(this.c(0), this.c(1)));
            }
            this.a(EnumMoveType.a, this.dj());
        } else {
            this.f(Vec3D.b);
        }
        CraftServer server = this.H.getCraftServer();
        CraftWorld bworld = this.H.getWorld();
        Location to = CraftLocation.toBukkit(this.de(), (org.bukkit.World)bworld, this.dw(), this.dy());
        Vehicle vehicle = (Vehicle)this.getBukkitEntity();
        server.getPluginManager().callEvent((Event)new VehicleUpdateEvent(vehicle));
        if (this.lastLocation != null && !this.lastLocation.equals((Object)to)) {
            VehicleMoveEvent event = new VehicleMoveEvent(vehicle, this.lastLocation, to);
            server.getPluginManager().callEvent((Event)event);
        }
        this.lastLocation = vehicle.getLocation();
        this.w();
        for (int i2 = 0; i2 <= 1; ++i2) {
            if (this.c(i2)) {
                SoundEffect soundeffect;
                if (!this.aO() && (double)(this.o[i2] % ((float)Math.PI * 2)) <= 0.7853981852531433 && (double)((this.o[i2] + 0.3926991f) % ((float)Math.PI * 2)) >= 0.7853981852531433 && (soundeffect = this.j()) != null) {
                    Vec3D vec3d = this.j(1.0f);
                    double d0 = i2 == 1 ? -vec3d.e : vec3d.e;
                    double d1 = i2 == 1 ? vec3d.c : -vec3d.c;
                    this.H.a((EntityHuman)null, this.dl() + d0, this.dn(), this.dr() + d1, soundeffect, this.cX(), 1.0f, 0.8f + 0.4f * this.af.i());
                }
                int n2 = i2;
                this.o[n2] = this.o[n2] + 0.3926991f;
                continue;
            }
            this.o[i2] = 0.0f;
        }
        this.aL();
        List<Entity> list = this.H.a((Entity)this, this.cD().c(0.2f, -0.01f, 0.2f), IEntitySelector.a(this));
        if (!list.isEmpty()) {
            boolean flag = !this.H.B && !(this.cK() instanceof EntityHuman);
            for (int j2 = 0; j2 < list.size(); ++j2) {
                Entity entity = list.get(j2);
                if (entity.u(this)) continue;
                if (flag && this.cM().size() < this.v() && !entity.bL() && this.a(entity) && entity instanceof EntityLiving && !(entity instanceof EntityWaterAnimal) && !(entity instanceof EntityHuman)) {
                    entity.k(this);
                    continue;
                }
                this.g(entity);
            }
        }
    }

    private void w() {
        if (this.H.B) {
            int i2 = this.E();
            this.aQ = i2 > 0 ? (this.aQ += 0.05f) : (this.aQ -= 0.1f);
            this.aQ = MathHelper.a(this.aQ, 0.0f, 1.0f);
            this.aS = this.aR;
            this.aR = 10.0f * (float)Math.sin(0.5f * (float)this.H.U()) * this.aQ;
        } else {
            int i3;
            if (!this.aO) {
                this.b(0);
            }
            if ((i3 = this.E()) > 0) {
                this.b(--i3);
                int j2 = 60 - i3 - 1;
                if (j2 > 0 && i3 == 0) {
                    this.b(0);
                    Vec3D vec3d = this.dj();
                    if (this.aP) {
                        this.f(vec3d.b(0.0, -0.7, 0.0));
                        this.bx();
                    } else {
                        this.o(vec3d.c, this.a((Entity entity) -> entity instanceof EntityHuman) ? 2.7 : 0.6, vec3d.e);
                    }
                }
                this.aO = false;
            }
        }
    }

    @Nullable
    protected SoundEffect j() {
        switch (this.y()) {
            case a: 
            case b: 
            case c: {
                return SoundEffects.bW;
            }
            case d: {
                return SoundEffects.bV;
            }
        }
        return null;
    }

    private void x() {
        if (this.cT()) {
            this.s = 0;
            this.f(this.dl(), this.dn(), this.dr());
        }
        if (this.s > 0) {
            double d0 = this.dl() + (this.t - this.dl()) / (double)this.s;
            double d1 = this.dn() + (this.u - this.dn()) / (double)this.s;
            double d2 = this.dr() + (this.aC - this.dr()) / (double)this.s;
            double d3 = MathHelper.d(this.aD - (double)this.dw());
            this.f(this.dw() + (float)d3 / (float)this.s);
            this.e(this.dy() + (float)(this.aE - (double)this.dy()) / (float)this.s);
            --this.s;
            this.e(d0, d1, d2);
            this.a(this.dw(), this.dy());
        }
    }

    public void a(boolean leftMoving, boolean rightMoving) {
        this.am.b(j, leftMoving);
        this.am.b(k, rightMoving);
    }

    public float a(int paddle, float tickDelta) {
        return this.c(paddle) ? MathHelper.b(this.o[paddle] - 0.3926991f, this.o[paddle], tickDelta) : 0.0f;
    }

    private EnumStatus y() {
        EnumStatus entityboat_enumstatus = this.A();
        if (entityboat_enumstatus != null) {
            this.aJ = this.cD().e;
            return entityboat_enumstatus;
        }
        if (this.z()) {
            return EnumStatus.a;
        }
        float f2 = this.o();
        if (f2 > 0.0f) {
            this.aK = f2;
            return EnumStatus.d;
        }
        return EnumStatus.e;
    }

    public float k() {
        AxisAlignedBB axisalignedbb = this.cD();
        int i2 = MathHelper.a(axisalignedbb.a);
        int j2 = MathHelper.c(axisalignedbb.d);
        int k2 = MathHelper.a(axisalignedbb.e);
        int l2 = MathHelper.c(axisalignedbb.e - this.aN);
        int i1 = MathHelper.a(axisalignedbb.c);
        int j1 = MathHelper.c(axisalignedbb.f);
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        block0: for (int k1 = k2; k1 < l2; ++k1) {
            float f2 = 0.0f;
            block1: for (int l1 = i2; l1 < j2; ++l1) {
                int i22 = i1;
                while (true) {
                    if (i22 >= j1) {
                        continue block1;
                    }
                    blockposition_mutableblockposition.d(l1, k1, i22);
                    Fluid fluid = this.H.b_(blockposition_mutableblockposition);
                    if (fluid.a(TagsFluid.a)) {
                        f2 = Math.max(f2, fluid.a((IBlockAccess)this.H, (BlockPosition)blockposition_mutableblockposition));
                    }
                    if (f2 >= 1.0f) continue block0;
                    ++i22;
                }
            }
            if (!(f2 < 1.0f)) continue;
            return (float)blockposition_mutableblockposition.v() + f2;
        }
        return l2 + 1;
    }

    public float o() {
        AxisAlignedBB axisalignedbb = this.cD();
        AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(axisalignedbb.a, axisalignedbb.b - 0.001, axisalignedbb.c, axisalignedbb.d, axisalignedbb.b, axisalignedbb.f);
        int i2 = MathHelper.a(axisalignedbb1.a) - 1;
        int j2 = MathHelper.c(axisalignedbb1.d) + 1;
        int k2 = MathHelper.a(axisalignedbb1.b) - 1;
        int l2 = MathHelper.c(axisalignedbb1.e) + 1;
        int i1 = MathHelper.a(axisalignedbb1.c) - 1;
        int j1 = MathHelper.c(axisalignedbb1.f) + 1;
        VoxelShape voxelshape = VoxelShapes.a(axisalignedbb1);
        float f2 = 0.0f;
        int k1 = 0;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int l1 = i2; l1 < j2; ++l1) {
            for (int i22 = i1; i22 < j1; ++i22) {
                int j22 = (l1 != i2 && l1 != j2 - 1 ? 0 : 1) + (i22 != i1 && i22 != j1 - 1 ? 0 : 1);
                if (j22 == 2) continue;
                for (int k22 = k2; k22 < l2; ++k22) {
                    if (j22 > 0 && (k22 == k2 || k22 == l2 - 1)) continue;
                    blockposition_mutableblockposition.d(l1, k22, i22);
                    IBlockData iblockdata = this.H.a_(blockposition_mutableblockposition);
                    if (iblockdata.b() instanceof BlockWaterLily || !VoxelShapes.c(iblockdata.k(this.H, blockposition_mutableblockposition).a((double)l1, (double)k22, (double)i22), voxelshape, OperatorBoolean.i)) continue;
                    f2 += iblockdata.b().i();
                    ++k1;
                }
            }
        }
        return f2 / (float)k1;
    }

    private boolean z() {
        AxisAlignedBB axisalignedbb = this.cD();
        int i2 = MathHelper.a(axisalignedbb.a);
        int j2 = MathHelper.c(axisalignedbb.d);
        int k2 = MathHelper.a(axisalignedbb.b);
        int l2 = MathHelper.c(axisalignedbb.b + 0.001);
        int i1 = MathHelper.a(axisalignedbb.c);
        int j1 = MathHelper.c(axisalignedbb.f);
        boolean flag = false;
        this.aJ = -1.7976931348623157E308;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int k1 = i2; k1 < j2; ++k1) {
            for (int l1 = k2; l1 < l2; ++l1) {
                for (int i22 = i1; i22 < j1; ++i22) {
                    blockposition_mutableblockposition.d(k1, l1, i22);
                    Fluid fluid = this.H.b_(blockposition_mutableblockposition);
                    if (!fluid.a(TagsFluid.a)) continue;
                    float f2 = (float)l1 + fluid.a((IBlockAccess)this.H, (BlockPosition)blockposition_mutableblockposition);
                    this.aJ = Math.max((double)f2, this.aJ);
                    flag |= axisalignedbb.b < (double)f2;
                }
            }
        }
        return flag;
    }

    @Nullable
    private EnumStatus A() {
        AxisAlignedBB axisalignedbb = this.cD();
        double d0 = axisalignedbb.e + 0.001;
        int i2 = MathHelper.a(axisalignedbb.a);
        int j2 = MathHelper.c(axisalignedbb.d);
        int k2 = MathHelper.a(axisalignedbb.e);
        int l2 = MathHelper.c(d0);
        int i1 = MathHelper.a(axisalignedbb.c);
        int j1 = MathHelper.c(axisalignedbb.f);
        boolean flag = false;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int k1 = i2; k1 < j2; ++k1) {
            for (int l1 = k2; l1 < l2; ++l1) {
                for (int i22 = i1; i22 < j1; ++i22) {
                    blockposition_mutableblockposition.d(k1, l1, i22);
                    Fluid fluid = this.H.b_(blockposition_mutableblockposition);
                    if (!fluid.a(TagsFluid.a) || !(d0 < (double)((float)blockposition_mutableblockposition.v() + fluid.a((IBlockAccess)this.H, (BlockPosition)blockposition_mutableblockposition)))) continue;
                    if (!fluid.b()) {
                        return EnumStatus.c;
                    }
                    flag = true;
                }
            }
        }
        return flag ? EnumStatus.b : null;
    }

    private void C() {
        double d0 = -0.04f;
        double d1 = this.aP() ? 0.0 : (double)-0.04f;
        double d2 = 0.0;
        this.p = 0.05f;
        if (this.aM == EnumStatus.e && this.aL != EnumStatus.e && this.aL != EnumStatus.d) {
            this.aJ = this.e(1.0);
            this.a(EnumMoveType.a, new Vec3D(0.0, (double)(this.k() - this.dd()) + 0.101 - this.dn(), 0.0));
            this.f(this.dj().d(1.0, 0.0, 1.0));
            this.aN = 0.0;
            this.aL = EnumStatus.a;
        } else {
            if (this.aL == EnumStatus.a) {
                d2 = (this.aJ - this.dn()) / (double)this.dd();
                this.p = 0.9f;
            } else if (this.aL == EnumStatus.c) {
                d1 = -7.0E-4;
                this.p = 0.9f;
            } else if (this.aL == EnumStatus.b) {
                d2 = 0.01f;
                this.p = 0.45f;
            } else if (this.aL == EnumStatus.e) {
                this.p = 0.9f;
            } else if (this.aL == EnumStatus.d) {
                this.p = this.aK;
                if (this.cK() instanceof EntityHuman) {
                    this.aK /= 2.0f;
                }
            }
            Vec3D vec3d = this.dj();
            this.o(vec3d.c * (double)this.p, vec3d.d + d1, vec3d.e * (double)this.p);
            this.r *= this.p;
            if (d2 > 0.0) {
                Vec3D vec3d1 = this.dj();
                this.o(vec3d1.c, (vec3d1.d + d2 * 0.06153846016296973) * 0.75, vec3d1.e);
            }
        }
    }

    private void D() {
        if (this.bM()) {
            float f2 = 0.0f;
            if (this.aF) {
                this.r -= 1.0f;
            }
            if (this.aG) {
                this.r += 1.0f;
            }
            if (this.aG != this.aF && !this.aH && !this.aI) {
                f2 += 0.005f;
            }
            this.f(this.dw() + this.r);
            if (this.aH) {
                f2 += 0.04f;
            }
            if (this.aI) {
                f2 -= 0.005f;
            }
            this.f(this.dj().b(MathHelper.a(-this.dw() * ((float)Math.PI / 180)) * f2, 0.0, MathHelper.b(this.dw() * ((float)Math.PI / 180)) * f2));
            this.a(this.aG && !this.aF || this.aH, this.aF && !this.aG || this.aH);
        }
    }

    protected float p() {
        return 0.0f;
    }

    public boolean a(Entity entity) {
        return entity.dc() < this.dc();
    }

    @Override
    public void i(Entity passenger) {
        if (this.u(passenger)) {
            float f2 = this.p();
            float f1 = (float)((this.dB() ? (double)0.01f : this.bv()) + passenger.bu());
            if (this.cM().size() > 1) {
                int i2 = this.cM().indexOf(passenger);
                f2 = i2 == 0 ? 0.2f : -0.6f;
                if (passenger instanceof EntityAnimal) {
                    f2 += 0.2f;
                }
            }
            Vec3D vec3d = new Vec3D(f2, 0.0, 0.0).b(-this.dw() * ((float)Math.PI / 180) - 1.5707964f);
            passenger.e(this.dl() + vec3d.c, this.dn() + (double)f1, this.dr() + vec3d.e);
            passenger.f(passenger.dw() + this.r);
            passenger.r(passenger.ck() + this.r);
            this.b(passenger);
            if (passenger instanceof EntityAnimal && this.cM().size() == this.v()) {
                int j2 = passenger.af() % 2 == 0 ? 90 : 270;
                passenger.s(((EntityAnimal)passenger).aT + (float)j2);
                passenger.r(passenger.ck() + (float)j2);
            }
        }
    }

    @Override
    public Vec3D b(EntityLiving passenger) {
        double d1;
        Vec3D vec3d = EntityBoat.a(this.dc() * MathHelper.g, (double)passenger.dc(), passenger.dw());
        double d0 = this.dl() + vec3d.c;
        BlockPosition blockposition = BlockPosition.a(d0, this.cD().e, d1 = this.dr() + vec3d.e);
        BlockPosition blockposition1 = blockposition.d();
        if (!this.H.B(blockposition1)) {
            double d3;
            ArrayList list = Lists.newArrayList();
            double d2 = this.H.i(blockposition);
            if (DismountUtil.a(d2)) {
                list.add(new Vec3D(d0, (double)blockposition.v() + d2, d1));
            }
            if (DismountUtil.a(d3 = this.H.i(blockposition1))) {
                list.add(new Vec3D(d0, (double)blockposition1.v() + d3, d1));
            }
            for (EntityPose entitypose : passenger.fr()) {
                for (Vec3D vec3d1 : list) {
                    if (!DismountUtil.a(this.H, vec3d1, passenger, entitypose)) continue;
                    passenger.b(entitypose);
                    return vec3d1;
                }
            }
        }
        return super.b(passenger);
    }

    protected void b(Entity entity) {
        entity.s(this.dw());
        float f2 = MathHelper.g(entity.dw() - this.dw());
        float f1 = MathHelper.a(f2, -105.0f, 105.0f);
        entity.L += f1 - f2;
        entity.f(entity.dw() + f1 - f2);
        entity.r(entity.dw());
    }

    @Override
    public void j(Entity passenger) {
        this.b(passenger);
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        nbt.a("Type", this.t().c());
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        if (nbt.b("Type", 8)) {
            this.a(EnumBoatType.a(nbt.l("Type")));
        }
    }

    @Override
    public EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        return player.fz() ? EnumInteractionResult.d : (this.q < 60.0f ? (!this.H.B ? (player.k(this) ? EnumInteractionResult.b : EnumInteractionResult.d) : EnumInteractionResult.a) : EnumInteractionResult.d);
    }

    @Override
    protected void a(double heightDifference, boolean onGround, IBlockData state, BlockPosition landedPosition) {
        this.aN = this.dj().d;
        if (!this.bL()) {
            if (onGround) {
                if (this.aa > 3.0f) {
                    if (this.aL != EnumStatus.d) {
                        this.n();
                        return;
                    }
                    this.a(this.aa, 1.0f, this.dG().k());
                    if (!this.H.B && !this.dB()) {
                        Vehicle vehicle = (Vehicle)this.getBukkitEntity();
                        VehicleDestroyEvent destroyEvent = new VehicleDestroyEvent(vehicle, null);
                        this.H.getCraftServer().getPluginManager().callEvent((Event)destroyEvent);
                        if (!destroyEvent.isCancelled()) {
                            this.ah();
                            if (this.H.W().b(GameRules.h)) {
                                int i2;
                                for (i2 = 0; i2 < 3; ++i2) {
                                    this.a(this.t().b());
                                }
                                for (i2 = 0; i2 < 2; ++i2) {
                                    this.a((IMaterial)Items.ox);
                                }
                            }
                        }
                    }
                }
                this.n();
            } else if (!this.H.b_(this.dg().d()).a(TagsFluid.a) && heightDifference < 0.0) {
                this.aa -= (float)heightDifference;
            }
        }
    }

    public boolean c(int paddle) {
        return this.am.a(paddle == 0 ? j : k) != false && this.cK() != null;
    }

    @Override
    public void a(float wobbleStrength) {
        this.am.b(h, Float.valueOf(wobbleStrength));
    }

    public float q() {
        return this.am.a(h).floatValue();
    }

    public void d(int wobbleTicks) {
        this.am.b(f, wobbleTicks);
    }

    public int r() {
        return this.am.a(f);
    }

    private void b(int wobbleTicks) {
        this.am.b(l, wobbleTicks);
    }

    private int E() {
        return this.am.a(l);
    }

    public float b(float tickDelta) {
        return MathHelper.i(tickDelta, this.aS, this.aR);
    }

    public void l(int side) {
        this.am.b(g, side);
    }

    public int s() {
        return this.am.a(g);
    }

    @Override
    public void a(EnumBoatType variant) {
        this.am.b(i, variant.ordinal());
    }

    public EnumBoatType t() {
        return EnumBoatType.a(this.am.a(i));
    }

    @Override
    protected boolean o(Entity passenger) {
        return this.cM().size() < this.v() && !this.a(TagsFluid.a);
    }

    protected int v() {
        return 2;
    }

    @Override
    @Nullable
    public EntityLiving cK() {
        EntityLiving entityliving1;
        Entity entity = this.cN();
        EntityLiving entityliving = entity instanceof EntityLiving ? (entityliving1 = (EntityLiving)entity) : null;
        return entityliving;
    }

    public void a(boolean pressingLeft, boolean pressingRight, boolean pressingForward, boolean pressingBack) {
        this.aF = pressingLeft;
        this.aG = pressingRight;
        this.aH = pressingForward;
        this.aI = pressingBack;
    }

    @Override
    public boolean aX() {
        return this.aL == EnumStatus.b || this.aL == EnumStatus.c;
    }

    @Override
    public ItemStack dt() {
        return new ItemStack(this.i());
    }

    public static enum EnumBoatType implements INamable
    {
        a(Blocks.n, "oak"),
        b(Blocks.o, "spruce"),
        c(Blocks.p, "birch"),
        d(Blocks.q, "jungle"),
        e(Blocks.r, "acacia"),
        f(Blocks.s, "cherry"),
        g(Blocks.t, "dark_oak"),
        h(Blocks.u, "mangrove"),
        i(Blocks.v, "bamboo");

        private final String k;
        private final Block l;
        public static final INamable.a<EnumBoatType> j;
        private static final IntFunction<EnumBoatType> m;

        private EnumBoatType(Block block, String s2) {
            this.k = s2;
            this.l = block;
        }

        @Override
        public String c() {
            return this.k;
        }

        public String a() {
            return this.k;
        }

        public Block b() {
            return this.l;
        }

        public String toString() {
            return this.k;
        }

        public static EnumBoatType a(int type) {
            return m.apply(type);
        }

        public static EnumBoatType a(String name) {
            return j.a(name, a);
        }

        static {
            j = INamable.a(EnumBoatType::values);
            m = ByIdMap.a(Enum::ordinal, EnumBoatType.values(), ByIdMap.a.a);
        }
    }

    public static enum EnumStatus {
        a,
        b,
        c,
        d,
        e;

    }
}

