/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartChest;
import net.minecraft.world.entity.vehicle.EntityMinecartCommandBlock;
import net.minecraft.world.entity.vehicle.EntityMinecartFurnace;
import net.minecraft.world.entity.vehicle.EntityMinecartHopper;
import net.minecraft.world.entity.vehicle.EntityMinecartMobSpawner;
import net.minecraft.world.entity.vehicle.EntityMinecartRideable;
import net.minecraft.world.entity.vehicle.EntityMinecartTNT;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.BlockPoweredRail;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftLocation;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.vehicle.VehicleUpdateEvent;
import org.bukkit.util.Vector;

public abstract class EntityMinecartAbstract
extends Entity {
    private static final DataWatcherObject<Integer> c = DataWatcher.a(EntityMinecartAbstract.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> d = DataWatcher.a(EntityMinecartAbstract.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Float> e = DataWatcher.a(EntityMinecartAbstract.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Integer> f = DataWatcher.a(EntityMinecartAbstract.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> g = DataWatcher.a(EntityMinecartAbstract.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> h = DataWatcher.a(EntityMinecartAbstract.class, DataWatcherRegistry.k);
    private static final ImmutableMap<EntityPose, ImmutableList<Integer>> i = ImmutableMap.of((Object)((Object)EntityPose.a), (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)((Object)EntityPose.f), (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)((Object)EntityPose.d), (Object)ImmutableList.of((Object)0, (Object)1));
    protected static final float b = 0.95f;
    private boolean j;
    private static final Map<BlockPropertyTrackPosition, Pair<BaseBlockPosition, BaseBlockPosition>> k = SystemUtils.a(Maps.newEnumMap(BlockPropertyTrackPosition.class), enummap -> {
        BaseBlockPosition baseblockposition = EnumDirection.e.q();
        BaseBlockPosition baseblockposition1 = EnumDirection.f.q();
        BaseBlockPosition baseblockposition2 = EnumDirection.c.q();
        BaseBlockPosition baseblockposition3 = EnumDirection.d.q();
        BaseBlockPosition baseblockposition4 = baseblockposition.o();
        BaseBlockPosition baseblockposition5 = baseblockposition1.o();
        BaseBlockPosition baseblockposition6 = baseblockposition2.o();
        BaseBlockPosition baseblockposition7 = baseblockposition3.o();
        enummap.put(BlockPropertyTrackPosition.a, Pair.of((Object)baseblockposition2, (Object)baseblockposition3));
        enummap.put(BlockPropertyTrackPosition.b, Pair.of((Object)baseblockposition, (Object)baseblockposition1));
        enummap.put(BlockPropertyTrackPosition.c, Pair.of((Object)baseblockposition4, (Object)baseblockposition1));
        enummap.put(BlockPropertyTrackPosition.d, Pair.of((Object)baseblockposition, (Object)baseblockposition5));
        enummap.put(BlockPropertyTrackPosition.e, Pair.of((Object)baseblockposition2, (Object)baseblockposition7));
        enummap.put(BlockPropertyTrackPosition.f, Pair.of((Object)baseblockposition6, (Object)baseblockposition3));
        enummap.put(BlockPropertyTrackPosition.g, Pair.of((Object)baseblockposition3, (Object)baseblockposition1));
        enummap.put(BlockPropertyTrackPosition.h, Pair.of((Object)baseblockposition3, (Object)baseblockposition));
        enummap.put(BlockPropertyTrackPosition.i, Pair.of((Object)baseblockposition2, (Object)baseblockposition));
        enummap.put(BlockPropertyTrackPosition.j, Pair.of((Object)baseblockposition2, (Object)baseblockposition1));
    });
    private int l;
    private double m;
    private double n;
    private double o;
    private double p;
    private double q;
    private double r;
    private double s;
    private double t;
    public boolean slowWhenEmpty = true;
    private double derailedX = 0.5;
    private double derailedY = 0.5;
    private double derailedZ = 0.5;
    private double flyingX = 0.95f;
    private double flyingY = 0.95f;
    private double flyingZ = 0.95f;
    public double maxSpeed = 0.4;

    protected EntityMinecartAbstract(EntityTypes<?> type, World world) {
        super(type, world);
        this.F = true;
    }

    protected EntityMinecartAbstract(EntityTypes<?> type, World world, double x2, double y2, double z2) {
        this(type, world);
        this.e(x2, y2, z2);
        this.I = x2;
        this.J = y2;
        this.K = z2;
    }

    public static EntityMinecartAbstract a(World world, double x2, double y2, double z2, EnumMinecartType type) {
        return type == EnumMinecartType.b ? new EntityMinecartChest(world, x2, y2, z2) : (type == EnumMinecartType.c ? new EntityMinecartFurnace(world, x2, y2, z2) : (type == EnumMinecartType.d ? new EntityMinecartTNT(world, x2, y2, z2) : (type == EnumMinecartType.e ? new EntityMinecartMobSpawner(world, x2, y2, z2) : (type == EnumMinecartType.f ? new EntityMinecartHopper(world, x2, y2, z2) : (type == EnumMinecartType.g ? new EntityMinecartCommandBlock(world, x2, y2, z2) : new EntityMinecartRideable(world, x2, y2, z2))))));
    }

    @Override
    protected Entity.MovementEmission aQ() {
        return Entity.MovementEmission.c;
    }

    @Override
    protected void a_() {
        this.am.a(c, 0);
        this.am.a(d, 1);
        this.am.a(e, Float.valueOf(0.0f));
        this.am.a(f, Block.i(Blocks.a.o()));
        this.am.a(g, 6);
        this.am.a(h, false);
    }

    @Override
    public boolean h(Entity other) {
        boolean collides = EntityBoat.a(this, other);
        if (!collides) {
            return false;
        }
        VehicleEntityCollisionEvent collisionEvent = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)other.getBukkitEntity());
        return collisionEvent.callEvent();
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return true;
    }

    @Override
    protected Vec3D a(EnumDirection.EnumAxis portalAxis, BlockUtil.Rectangle portalRect) {
        return EntityLiving.i(super.a(portalAxis, portalRect));
    }

    @Override
    public double bv() {
        return 0.0;
    }

    @Override
    public Vec3D b(EntityLiving passenger) {
        EnumDirection enumdirection = this.cB();
        if (enumdirection.o() == EnumDirection.EnumAxis.b) {
            return super.b(passenger);
        }
        int[][] aint = DismountUtil.a(enumdirection);
        BlockPosition blockposition = this.dg();
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        ImmutableList<EntityPose> immutablelist = passenger.fr();
        for (EntityPose entitypose : immutablelist) {
            EntitySize entitysize = passenger.a(entitypose);
            float f2 = Math.min(entitysize.a, 1.0f) / 2.0f;
            UnmodifiableIterator unmodifiableiterator1 = ((ImmutableList)i.get((Object)entitypose)).iterator();
            while (unmodifiableiterator1.hasNext()) {
                int i2 = (Integer)unmodifiableiterator1.next();
                int[][] aint1 = aint;
                int j2 = aint.length;
                for (int k2 = 0; k2 < j2; ++k2) {
                    Vec3D vec3d;
                    AxisAlignedBB axisalignedbb;
                    int[] aint2 = aint1[k2];
                    blockposition_mutableblockposition.d(blockposition.u() + aint2[0], blockposition.v() + i2, blockposition.w() + aint2[1]);
                    double d0 = this.H.a(DismountUtil.a((IBlockAccess)this.H, (BlockPosition)blockposition_mutableblockposition), () -> DismountUtil.a((IBlockAccess)this.H, blockposition_mutableblockposition.d()));
                    if (!DismountUtil.a(d0) || !DismountUtil.a(this.H, passenger, (axisalignedbb = new AxisAlignedBB(-f2, 0.0, -f2, f2, entitysize.b, f2)).c(vec3d = Vec3D.a(blockposition_mutableblockposition, d0)))) continue;
                    passenger.b(entitypose);
                    return vec3d;
                }
            }
        }
        double d1 = this.cD().e;
        blockposition_mutableblockposition.b((double)blockposition.u(), d1, (double)blockposition.w());
        for (EntityPose entitypose1 : immutablelist) {
            double d2 = passenger.a((EntityPose)entitypose1).b;
            int l2 = MathHelper.c(d1 - (double)blockposition_mutableblockposition.v() + d2);
            double d3 = DismountUtil.a(blockposition_mutableblockposition, l2, blockposition1 -> this.H.a_((BlockPosition)blockposition1).k(this.H, (BlockPosition)blockposition1));
            if (!(d1 + d2 <= d3)) continue;
            passenger.b(entitypose1);
            break;
        }
        return super.b(passenger);
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (!this.H.B && !this.dB()) {
            boolean flag;
            if (this.b(source)) {
                return false;
            }
            Vehicle vehicle = (Vehicle)this.getBukkitEntity();
            CraftEntity passenger = source.d() == null ? null : source.d().getBukkitEntity();
            VehicleDamageEvent event = new VehicleDamageEvent(vehicle, (org.bukkit.entity.Entity)passenger, (double)amount);
            this.H.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
            amount = (float)event.getDamage();
            this.d(-this.r());
            this.c(10);
            this.bj();
            this.a(this.p() + amount * 10.0f);
            this.a(GameEvent.p, source.d());
            boolean bl = flag = source.d() instanceof EntityHuman && ((EntityHuman)source.d()).fK().d;
            if (flag || this.p() > 40.0f) {
                VehicleDestroyEvent destroyEvent = new VehicleDestroyEvent(vehicle, (org.bukkit.entity.Entity)passenger);
                this.H.getCraftServer().getPluginManager().callEvent((Event)destroyEvent);
                if (destroyEvent.isCancelled()) {
                    this.a(40.0f);
                    return true;
                }
                this.bx();
                if (flag && !this.aa()) {
                    this.ai();
                } else {
                    this.a(source);
                }
            }
            return true;
        }
        return true;
    }

    @Override
    protected float aF() {
        IBlockData iblockdata = this.H.a_(this.dg());
        return iblockdata.a(TagsBlock.M) ? 1.0f : super.aF();
    }

    public void a(DamageSource damageSource) {
        this.ah();
        if (this.H.W().b(GameRules.h)) {
            ItemStack itemstack = new ItemStack(this.i());
            if (this.aa()) {
                itemstack.a(this.ab());
            }
            this.b(itemstack);
        }
    }

    abstract Item i();

    @Override
    public void q(float yaw) {
        this.d(-this.r());
        this.c(10);
        this.a(this.p() + this.p() * 10.0f);
    }

    @Override
    public boolean bm() {
        return !this.dB();
    }

    private static Pair<BaseBlockPosition, BaseBlockPosition> a(BlockPropertyTrackPosition shape) {
        return k.get(shape);
    }

    @Override
    public EnumDirection cB() {
        return this.j ? this.cA().g().h() : this.cA().h();
    }

    @Override
    public void l() {
        double prevX = this.dl();
        double prevY = this.dn();
        double prevZ = this.dr();
        float prevYaw = this.dw();
        float prevPitch = this.dy();
        if (this.q() > 0) {
            this.c(this.q() - 1);
        }
        if (this.p() > 0.0f) {
            this.a(this.p() - 1.0f);
        }
        this.ap();
        if (this.H.B) {
            if (this.l > 0) {
                double d0 = this.dl() + (this.m - this.dl()) / (double)this.l;
                double d1 = this.dn() + (this.n - this.dn()) / (double)this.l;
                double d2 = this.dr() + (this.o - this.dr()) / (double)this.l;
                double d3 = MathHelper.d(this.p - (double)this.dw());
                this.f(this.dw() + (float)d3 / (float)this.l);
                this.e(this.dy() + (float)(this.q - (double)this.dy()) / (float)this.l);
                --this.l;
                this.e(d0, d1, d2);
                this.a(this.dw(), this.dy());
            } else {
                this.an();
                this.a(this.dw(), this.dy());
            }
        } else {
            double d6;
            BlockPosition blockposition;
            IBlockData iblockdata;
            int k2;
            int j2;
            int i2;
            if (!this.aP()) {
                double d0 = this.aT() ? -0.005 : -0.04;
                this.f(this.dj().b(0.0, d0, 0.0));
            }
            if (this.H.a_(new BlockPosition(i2 = MathHelper.a(this.dl()), (j2 = MathHelper.a(this.dn())) - 1, k2 = MathHelper.a(this.dr()))).a(TagsBlock.M)) {
                --j2;
            }
            if (BlockMinecartTrackAbstract.g(iblockdata = this.H.a_(blockposition = new BlockPosition(i2, j2, k2)))) {
                this.c(blockposition, iblockdata);
                if (iblockdata.a(Blocks.hg)) {
                    this.a(i2, j2, k2, iblockdata.c(BlockPoweredRail.e));
                }
            } else {
                this.k();
            }
            this.aL();
            this.e(0.0f);
            double d4 = this.I - this.dl();
            double d5 = this.K - this.dr();
            if (d4 * d4 + d5 * d5 > 0.001) {
                this.f((float)(MathHelper.d(d5, d4) * 180.0 / Math.PI));
                if (this.j) {
                    this.f(this.dw() + 180.0f);
                }
            }
            if ((d6 = (double)MathHelper.g(this.dw() - this.L)) < -170.0 || d6 >= 170.0) {
                this.f(this.dw() + 180.0f);
                this.j = !this.j;
            }
            this.a(this.dw(), this.dy());
            CraftWorld bworld = this.H.getWorld();
            Location from = new Location((org.bukkit.World)bworld, prevX, prevY, prevZ, prevYaw, prevPitch);
            Location to = CraftLocation.toBukkit(this.de(), (org.bukkit.World)bworld, this.dw(), this.dy());
            Vehicle vehicle = (Vehicle)this.getBukkitEntity();
            this.H.getCraftServer().getPluginManager().callEvent((Event)new VehicleUpdateEvent(vehicle));
            if (!from.equals((Object)to)) {
                this.H.getCraftServer().getPluginManager().callEvent((Event)new VehicleMoveEvent(vehicle, from, to));
            }
            if (this.s() == EnumMinecartType.a && this.dj().i() > 0.01) {
                List<Entity> list = this.H.a((Entity)this, this.cD().c(0.2f, 0.0, 0.2f), IEntitySelector.a(this));
                if (!list.isEmpty()) {
                    for (int l2 = 0; l2 < list.size(); ++l2) {
                        VehicleEntityCollisionEvent collisionEvent;
                        Entity entity = list.get(l2);
                        if (!(entity instanceof EntityHuman || entity instanceof EntityIronGolem || entity instanceof EntityMinecartAbstract || this.bM() || entity.bL())) {
                            collisionEvent = new VehicleEntityCollisionEvent(vehicle, (org.bukkit.entity.Entity)entity.getBukkitEntity());
                            this.H.getCraftServer().getPluginManager().callEvent((Event)collisionEvent);
                            if (collisionEvent.isCancelled()) continue;
                            entity.k(this);
                            continue;
                        }
                        if (!this.v(entity)) {
                            collisionEvent = new VehicleEntityCollisionEvent(vehicle, (org.bukkit.entity.Entity)entity.getBukkitEntity());
                            this.H.getCraftServer().getPluginManager().callEvent((Event)collisionEvent);
                            if (collisionEvent.isCancelled()) continue;
                        }
                        entity.g(this);
                    }
                }
            } else {
                for (Entity entity1 : this.H.a_(this, this.cD().c(0.2f, 0.0, 0.2f))) {
                    if (this.u(entity1) || !entity1.bn() || !(entity1 instanceof EntityMinecartAbstract)) continue;
                    VehicleEntityCollisionEvent collisionEvent = new VehicleEntityCollisionEvent(vehicle, (org.bukkit.entity.Entity)entity1.getBukkitEntity());
                    this.H.getCraftServer().getPluginManager().callEvent((Event)collisionEvent);
                    if (collisionEvent.isCancelled()) continue;
                    entity1.g(this);
                }
            }
            this.aZ();
            if (this.bg()) {
                this.at();
                this.aa *= 0.5f;
            }
            this.al = false;
        }
    }

    protected double j() {
        return this.aT() ? this.maxSpeed / 2.0 : this.maxSpeed;
    }

    public void a(int x2, int y2, int z2, boolean powered) {
    }

    protected void k() {
        double d0 = this.j();
        Vec3D vec3d = this.dj();
        this.o(MathHelper.a(vec3d.c, -d0, d0), vec3d.d, MathHelper.a(vec3d.e, -d0, d0));
        if (this.N) {
            this.f(new Vec3D(this.dj().c * this.derailedX, this.dj().d * this.derailedY, this.dj().e * this.derailedZ));
        }
        this.a(EnumMoveType.a, this.dj());
        if (!this.N) {
            this.f(new Vec3D(this.dj().c * this.flyingX, this.dj().d * this.flyingY, this.dj().e * this.flyingZ));
        }
    }

    protected void c(BlockPosition pos, IBlockData state) {
        double d18;
        Vec3D vec3d4;
        double d17;
        double d16;
        double d15;
        this.n();
        double d0 = this.dl();
        double d1 = this.dn();
        double d2 = this.dr();
        Vec3D vec3d = this.q(d0, d1, d2);
        d1 = pos.v();
        boolean flag = false;
        boolean flag1 = false;
        if (state.a(Blocks.bo)) {
            flag = state.c(BlockPoweredRail.e);
            flag1 = !flag;
        }
        double d3 = 0.0078125;
        if (this.aT()) {
            d3 *= 0.2;
        }
        Vec3D vec3d1 = this.dj();
        BlockPropertyTrackPosition blockpropertytrackposition = state.c(((BlockMinecartTrackAbstract)state.b()).c());
        switch (blockpropertytrackposition) {
            case c: {
                this.f(vec3d1.b(-d3, 0.0, 0.0));
                d1 += 1.0;
                break;
            }
            case d: {
                this.f(vec3d1.b(d3, 0.0, 0.0));
                d1 += 1.0;
                break;
            }
            case e: {
                this.f(vec3d1.b(0.0, 0.0, d3));
                d1 += 1.0;
                break;
            }
            case f: {
                this.f(vec3d1.b(0.0, 0.0, -d3));
                d1 += 1.0;
            }
        }
        vec3d1 = this.dj();
        Pair<BaseBlockPosition, BaseBlockPosition> pair = EntityMinecartAbstract.a(blockpropertytrackposition);
        BaseBlockPosition baseblockposition = (BaseBlockPosition)pair.getFirst();
        BaseBlockPosition baseblockposition1 = (BaseBlockPosition)pair.getSecond();
        double d4 = baseblockposition1.u() - baseblockposition.u();
        double d5 = baseblockposition1.w() - baseblockposition.w();
        double d6 = Math.sqrt(d4 * d4 + d5 * d5);
        double d7 = vec3d1.c * d4 + vec3d1.e * d5;
        if (d7 < 0.0) {
            d4 = -d4;
            d5 = -d5;
        }
        double d8 = Math.min(2.0, vec3d1.h());
        vec3d1 = new Vec3D(d8 * d4 / d6, vec3d1.d, d8 * d5 / d6);
        this.f(vec3d1);
        Entity entity = this.cN();
        if (entity instanceof EntityHuman) {
            Vec3D vec3d2 = entity.dj();
            double d9 = vec3d2.i();
            double d10 = this.dj().i();
            if (d9 > 1.0E-4 && d10 < 0.01) {
                this.f(this.dj().b(vec3d2.c * 0.1, 0.0, vec3d2.e * 0.1));
                flag1 = false;
            }
        }
        if (flag1) {
            double d11 = this.dj().h();
            if (d11 < 0.03) {
                this.f(Vec3D.b);
            } else {
                this.f(this.dj().d(0.5, 0.0, 0.5));
            }
        }
        double d11 = (double)pos.u() + 0.5 + (double)baseblockposition.u() * 0.5;
        double d12 = (double)pos.w() + 0.5 + (double)baseblockposition.w() * 0.5;
        double d13 = (double)pos.u() + 0.5 + (double)baseblockposition1.u() * 0.5;
        double d14 = (double)pos.w() + 0.5 + (double)baseblockposition1.w() * 0.5;
        d4 = d13 - d11;
        d5 = d14 - d12;
        if (d4 == 0.0) {
            d15 = d2 - (double)pos.w();
        } else if (d5 == 0.0) {
            d15 = d0 - (double)pos.u();
        } else {
            d16 = d0 - d11;
            d17 = d2 - d12;
            d15 = (d16 * d4 + d17 * d5) * 2.0;
        }
        d0 = d11 + d4 * d15;
        d2 = d12 + d5 * d15;
        this.e(d0, d1, d2);
        d16 = this.bM() ? 0.75 : 1.0;
        d17 = this.j();
        vec3d1 = this.dj();
        this.a(EnumMoveType.a, new Vec3D(MathHelper.a(d16 * vec3d1.c, -d17, d17), 0.0, MathHelper.a(d16 * vec3d1.e, -d17, d17)));
        if (baseblockposition.v() != 0 && MathHelper.a(this.dl()) - pos.u() == baseblockposition.u() && MathHelper.a(this.dr()) - pos.w() == baseblockposition.w()) {
            this.e(this.dl(), this.dn() + (double)baseblockposition.v(), this.dr());
        } else if (baseblockposition1.v() != 0 && MathHelper.a(this.dl()) - pos.u() == baseblockposition1.u() && MathHelper.a(this.dr()) - pos.w() == baseblockposition1.w()) {
            this.e(this.dl(), this.dn() + (double)baseblockposition1.v(), this.dr());
        }
        this.o();
        Vec3D vec3d3 = this.q(this.dl(), this.dn(), this.dr());
        if (vec3d3 != null && vec3d != null) {
            double d19 = (vec3d.d - vec3d3.d) * 0.05;
            vec3d4 = this.dj();
            d18 = vec3d4.h();
            if (d18 > 0.0) {
                this.f(vec3d4.d((d18 + d19) / d18, 1.0, (d18 + d19) / d18));
            }
            this.e(this.dl(), vec3d3.d, this.dr());
        }
        int i2 = MathHelper.a(this.dl());
        int j2 = MathHelper.a(this.dr());
        if (i2 != pos.u() || j2 != pos.w()) {
            vec3d4 = this.dj();
            d18 = vec3d4.h();
            this.o(d18 * (double)(i2 - pos.u()), vec3d4.d, d18 * (double)(j2 - pos.w()));
        }
        if (flag) {
            vec3d4 = this.dj();
            d18 = vec3d4.h();
            if (d18 > 0.01) {
                double d20 = 0.06;
                this.f(vec3d4.b(vec3d4.c / d18 * 0.06, 0.0, vec3d4.e / d18 * 0.06));
            } else {
                Vec3D vec3d5 = this.dj();
                double d21 = vec3d5.c;
                double d22 = vec3d5.e;
                if (blockpropertytrackposition == BlockPropertyTrackPosition.b) {
                    if (this.a(pos.g())) {
                        d21 = 0.02;
                    } else if (this.a(pos.h())) {
                        d21 = -0.02;
                    }
                } else {
                    if (blockpropertytrackposition != BlockPropertyTrackPosition.a) {
                        return;
                    }
                    if (this.a(pos.e())) {
                        d22 = 0.02;
                    } else if (this.a(pos.f())) {
                        d22 = -0.02;
                    }
                }
                this.o(d21, vec3d5.d, d22);
            }
        }
    }

    private boolean a(BlockPosition pos) {
        return this.H.a_(pos).g(this.H, pos);
    }

    protected void o() {
        double d0 = this.bM() || !this.slowWhenEmpty ? 0.997 : 0.96;
        Vec3D vec3d = this.dj();
        vec3d = vec3d.d(d0, 0.0, d0);
        if (this.aT()) {
            vec3d = vec3d.a((double)0.95f);
        }
        this.f(vec3d);
    }

    @Nullable
    public Vec3D a(double x2, double y2, double z2, double offset) {
        IBlockData iblockdata;
        int k2;
        int j2;
        int i2 = MathHelper.a(x2);
        if (this.H.a_(new BlockPosition(i2, (j2 = MathHelper.a(y2)) - 1, k2 = MathHelper.a(z2))).a(TagsBlock.M)) {
            --j2;
        }
        if (BlockMinecartTrackAbstract.g(iblockdata = this.H.a_(new BlockPosition(i2, j2, k2)))) {
            BlockPropertyTrackPosition blockpropertytrackposition = iblockdata.c(((BlockMinecartTrackAbstract)iblockdata.b()).c());
            y2 = j2;
            if (blockpropertytrackposition.b()) {
                y2 = j2 + 1;
            }
            Pair<BaseBlockPosition, BaseBlockPosition> pair = EntityMinecartAbstract.a(blockpropertytrackposition);
            BaseBlockPosition baseblockposition = (BaseBlockPosition)pair.getFirst();
            BaseBlockPosition baseblockposition1 = (BaseBlockPosition)pair.getSecond();
            double d4 = baseblockposition1.u() - baseblockposition.u();
            double d5 = baseblockposition1.w() - baseblockposition.w();
            double d6 = Math.sqrt(d4 * d4 + d5 * d5);
            if (baseblockposition.v() != 0 && MathHelper.a(x2 += (d4 /= d6) * offset) - i2 == baseblockposition.u() && MathHelper.a(z2 += (d5 /= d6) * offset) - k2 == baseblockposition.w()) {
                y2 += (double)baseblockposition.v();
            } else if (baseblockposition1.v() != 0 && MathHelper.a(x2) - i2 == baseblockposition1.u() && MathHelper.a(z2) - k2 == baseblockposition1.w()) {
                y2 += (double)baseblockposition1.v();
            }
            return this.q(x2, y2, z2);
        }
        return null;
    }

    @Nullable
    public Vec3D q(double x2, double y2, double z2) {
        IBlockData iblockdata;
        int k2;
        int j2;
        int i2 = MathHelper.a(x2);
        if (this.H.a_(new BlockPosition(i2, (j2 = MathHelper.a(y2)) - 1, k2 = MathHelper.a(z2))).a(TagsBlock.M)) {
            --j2;
        }
        if (BlockMinecartTrackAbstract.g(iblockdata = this.H.a_(new BlockPosition(i2, j2, k2)))) {
            double d12;
            BlockPropertyTrackPosition blockpropertytrackposition = iblockdata.c(((BlockMinecartTrackAbstract)iblockdata.b()).c());
            Pair<BaseBlockPosition, BaseBlockPosition> pair = EntityMinecartAbstract.a(blockpropertytrackposition);
            BaseBlockPosition baseblockposition = (BaseBlockPosition)pair.getFirst();
            BaseBlockPosition baseblockposition1 = (BaseBlockPosition)pair.getSecond();
            double d3 = (double)i2 + 0.5 + (double)baseblockposition.u() * 0.5;
            double d4 = (double)j2 + 0.0625 + (double)baseblockposition.v() * 0.5;
            double d5 = (double)k2 + 0.5 + (double)baseblockposition.w() * 0.5;
            double d6 = (double)i2 + 0.5 + (double)baseblockposition1.u() * 0.5;
            double d7 = (double)j2 + 0.0625 + (double)baseblockposition1.v() * 0.5;
            double d8 = (double)k2 + 0.5 + (double)baseblockposition1.w() * 0.5;
            double d9 = d6 - d3;
            double d10 = (d7 - d4) * 2.0;
            double d11 = d8 - d5;
            if (d9 == 0.0) {
                d12 = z2 - (double)k2;
            } else if (d11 == 0.0) {
                d12 = x2 - (double)i2;
            } else {
                double d13 = x2 - d3;
                double d14 = z2 - d5;
                d12 = (d13 * d9 + d14 * d11) * 2.0;
            }
            x2 = d3 + d9 * d12;
            y2 = d4 + d10 * d12;
            z2 = d5 + d11 * d12;
            if (d10 < 0.0) {
                y2 += 1.0;
            } else if (d10 > 0.0) {
                y2 += 0.5;
            }
            return new Vec3D(x2, y2, z2);
        }
        return null;
    }

    @Override
    public AxisAlignedBB A_() {
        AxisAlignedBB axisalignedbb = this.cD();
        return this.y() ? axisalignedbb.g((double)Math.abs(this.w()) / 16.0) : axisalignedbb;
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        if (nbt.q("CustomDisplayTile")) {
            this.b(GameProfileSerializer.a(this.H.a(Registries.e), nbt.p("DisplayState")));
            this.l(nbt.h("DisplayOffset"));
        }
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        if (this.y()) {
            nbt.a("CustomDisplayTile", true);
            nbt.a("DisplayState", GameProfileSerializer.a(this.t()));
            nbt.a("DisplayOffset", this.w());
        }
    }

    @Override
    public void g(Entity entity) {
        if (!(this.H.B || entity.ae || this.ae)) {
            if (!this.H.paperConfig().collisions.allowVehicleCollisions && this.H.paperConfig().collisions.onlyPlayersCollide && !(entity instanceof EntityHuman)) {
                return;
            }
            if (!this.u(entity)) {
                double d1;
                VehicleEntityCollisionEvent collisionEvent = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
                this.H.getCraftServer().getPluginManager().callEvent((Event)collisionEvent);
                if (collisionEvent.isCancelled()) {
                    return;
                }
                double d0 = entity.dl() - this.dl();
                double d2 = d0 * d0 + (d1 = entity.dr() - this.dr()) * d1;
                if (d2 >= (double)1.0E-4f) {
                    d2 = Math.sqrt(d2);
                    d0 /= d2;
                    d1 /= d2;
                    double d3 = 1.0 / d2;
                    if (d3 > 1.0) {
                        d3 = 1.0;
                    }
                    d0 *= d3;
                    d1 *= d3;
                    d0 *= (double)0.1f;
                    d1 *= (double)0.1f;
                    d0 *= 0.5;
                    d1 *= 0.5;
                    if (entity instanceof EntityMinecartAbstract) {
                        Vec3D vec3d1;
                        double d5;
                        double d4 = entity.dl() - this.dl();
                        Vec3D vec3d = new Vec3D(d4, 0.0, d5 = entity.dr() - this.dr()).d();
                        double d6 = Math.abs(vec3d.b(vec3d1 = new Vec3D(MathHelper.b(this.dw() * ((float)Math.PI / 180)), 0.0, MathHelper.a(this.dw() * ((float)Math.PI / 180))).d()));
                        if (d6 < (double)0.8f) {
                            return;
                        }
                        Vec3D vec3d2 = this.dj();
                        Vec3D vec3d3 = entity.dj();
                        if (((EntityMinecartAbstract)entity).s() == EnumMinecartType.c && this.s() != EnumMinecartType.c) {
                            this.f(vec3d2.d(0.2, 1.0, 0.2));
                            this.j(vec3d3.c - d0, 0.0, vec3d3.e - d1);
                            entity.f(vec3d3.d(0.95, 1.0, 0.95));
                        } else if (((EntityMinecartAbstract)entity).s() != EnumMinecartType.c && this.s() == EnumMinecartType.c) {
                            entity.f(vec3d3.d(0.2, 1.0, 0.2));
                            entity.j(vec3d2.c + d0, 0.0, vec3d2.e + d1);
                            this.f(vec3d2.d(0.95, 1.0, 0.95));
                        } else {
                            double d7 = (vec3d3.c + vec3d2.c) / 2.0;
                            double d8 = (vec3d3.e + vec3d2.e) / 2.0;
                            this.f(vec3d2.d(0.2, 1.0, 0.2));
                            this.j(d7 - d0, 0.0, d8 - d1);
                            entity.f(vec3d3.d(0.2, 1.0, 0.2));
                            entity.j(d7 + d0, 0.0, d8 + d1);
                        }
                    } else {
                        this.j(-d0, 0.0, -d1);
                        entity.j(d0 / 4.0, 0.0, d1 / 4.0);
                    }
                }
            }
        }
    }

    @Override
    public void a(double x2, double y2, double z2, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.m = x2;
        this.n = y2;
        this.o = z2;
        this.p = yaw;
        this.q = pitch;
        this.l = interpolationSteps + 2;
        this.o(this.r, this.s, this.t);
    }

    @Override
    public void l(double x2, double y2, double z2) {
        this.r = x2;
        this.s = y2;
        this.t = z2;
        this.o(this.r, this.s, this.t);
    }

    public void a(float damageWobbleStrength) {
        this.am.b(e, Float.valueOf(damageWobbleStrength));
    }

    public float p() {
        return this.am.a(e).floatValue();
    }

    public void c(int wobbleTicks) {
        this.am.b(c, wobbleTicks);
    }

    public int q() {
        return this.am.a(c);
    }

    public void d(int wobbleSide) {
        this.am.b(d, wobbleSide);
    }

    public int r() {
        return this.am.a(d);
    }

    public abstract EnumMinecartType s();

    public IBlockData t() {
        return !this.y() ? this.v() : Block.a(this.aj().a(f));
    }

    public IBlockData v() {
        return Blocks.a.o();
    }

    public int w() {
        return !this.y() ? this.x() : this.aj().a(g).intValue();
    }

    public int x() {
        return 6;
    }

    public void b(IBlockData state) {
        this.aj().b(f, Block.i(state));
        this.a(true);
    }

    public void l(int offset) {
        this.aj().b(g, offset);
        this.a(true);
    }

    public boolean y() {
        return this.aj().a(h);
    }

    public void a(boolean present) {
        this.aj().b(h, present);
    }

    @Override
    public ItemStack dt() {
        return new ItemStack(switch (this.s()) {
            case EnumMinecartType.c -> Items.mY;
            case EnumMinecartType.b -> Items.mX;
            case EnumMinecartType.d -> Items.mZ;
            case EnumMinecartType.f -> Items.na;
            case EnumMinecartType.g -> Items.tO;
            default -> Items.mW;
        });
    }

    public Vector getFlyingVelocityMod() {
        return new Vector(this.flyingX, this.flyingY, this.flyingZ);
    }

    public void setFlyingVelocityMod(Vector flying) {
        this.flyingX = flying.getX();
        this.flyingY = flying.getY();
        this.flyingZ = flying.getZ();
    }

    public Vector getDerailedVelocityMod() {
        return new Vector(this.derailedX, this.derailedY, this.derailedZ);
    }

    public void setDerailedVelocityMod(Vector derailed) {
        this.derailedX = derailed.getX();
        this.derailedY = derailed.getY();
        this.derailedZ = derailed.getZ();
    }

    public static enum EnumMinecartType {
        a,
        b,
        c,
        d,
        e,
        f,
        g;

    }
}

