/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.flag;

import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlagUniverse;
import org.slf4j.Logger;

public class FeatureFlagRegistry {
    private static final Logger a = LogUtils.getLogger();
    private final FeatureFlagUniverse b;
    private final Map<MinecraftKey, FeatureFlag> c;
    private final FeatureFlagSet d;

    FeatureFlagRegistry(FeatureFlagUniverse universe, FeatureFlagSet featureSet, Map<MinecraftKey, FeatureFlag> featureFlags) {
        this.b = universe;
        this.c = featureFlags;
        this.d = featureSet;
    }

    public boolean a(FeatureFlagSet features) {
        return features.a(this.d);
    }

    public FeatureFlagSet a() {
        return this.d;
    }

    public FeatureFlagSet a(Iterable<MinecraftKey> features) {
        return this.a(features, (MinecraftKey feature) -> a.warn("Unknown feature flag: {}", feature));
    }

    public FeatureFlagSet a(FeatureFlag ... features) {
        return FeatureFlagSet.a(this.b, Arrays.asList(features));
    }

    public FeatureFlagSet a(Iterable<MinecraftKey> features, Consumer<MinecraftKey> unknownFlagConsumer) {
        Set set = Sets.newIdentityHashSet();
        for (MinecraftKey resourceLocation : features) {
            FeatureFlag featureFlag = this.c.get(resourceLocation);
            if (featureFlag == null) {
                unknownFlagConsumer.accept(resourceLocation);
                continue;
            }
            set.add(featureFlag);
        }
        return FeatureFlagSet.a(this.b, set);
    }

    public Set<MinecraftKey> b(FeatureFlagSet features) {
        HashSet<MinecraftKey> set = new HashSet<MinecraftKey>();
        this.c.forEach((identifier, featureFlag) -> {
            if (features.b((FeatureFlag)featureFlag)) {
                set.add((MinecraftKey)identifier);
            }
        });
        return set;
    }

    public Codec<FeatureFlagSet> b() {
        return MinecraftKey.a.listOf().comapFlatMap(featureIds -> {
            HashSet set = new HashSet();
            FeatureFlagSet featureFlagSet = this.a((Iterable<MinecraftKey>)featureIds, set::add);
            if (!set.isEmpty()) {
                return DataResult.error(() -> "Unknown feature ids: " + set, (Object)featureFlagSet);
            }
            return DataResult.success((Object)featureFlagSet);
        }, features -> List.copyOf(this.b((FeatureFlagSet)features)));
    }

    public static class a {
        private final FeatureFlagUniverse a;
        private int b;
        private final Map<MinecraftKey, FeatureFlag> c = new LinkedHashMap<MinecraftKey, FeatureFlag>();

        public a(String universe) {
            this.a = new FeatureFlagUniverse(universe);
        }

        public FeatureFlag a(String feature) {
            return this.a(new MinecraftKey("minecraft", feature));
        }

        public FeatureFlag a(MinecraftKey feature) {
            FeatureFlag featureFlag;
            FeatureFlag featureFlag2;
            if (this.b >= 64) {
                throw new IllegalStateException("Too many feature flags");
            }
            if ((featureFlag2 = this.c.put(feature, featureFlag = new FeatureFlag(this.a, this.b++))) != null) {
                throw new IllegalStateException("Duplicate feature flag " + feature);
            }
            return featureFlag;
        }

        public FeatureFlagRegistry a() {
            FeatureFlagSet featureFlagSet = FeatureFlagSet.a(this.a, this.c.values());
            return new FeatureFlagRegistry(this.a, featureFlagSet, Map.copyOf(this.c));
        }
    }
}

