/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.event.entity.EntityDamageItemEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.arguments.blocks.ArgumentBlock;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.AdventureModeCheck;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBed;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.ItemRecord;
import net.minecraft.world.item.ItemSign;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentDurability;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockSapling;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.BlockWitherSkull;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityJukeBox;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_19_R3.block.CapturedBlockState;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftLocation;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftMagicNumbers;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.slf4j.Logger;

public final class ItemStack {
    public static final Codec<ItemStack> a = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.i.q().fieldOf("id").forGetter(itemstack -> itemstack.u), (App)Codec.INT.fieldOf("Count").forGetter(itemstack -> itemstack.s), (App)NBTTagCompound.a.optionalFieldOf("tag").forGetter(itemstack -> Optional.ofNullable(itemstack.v))).apply((Applicative)instance, ItemStack::new));
    private static final Logger j = LogUtils.getLogger();
    public static final ItemStack b = new ItemStack((IMaterial)null);
    public static final DecimalFormat c = SystemUtils.a(new DecimalFormat("#.##"), (T decimalformat) -> decimalformat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    public static final String d = "Enchantments";
    public static final String e = "display";
    public static final String f = "Name";
    public static final String g = "Lore";
    public static final String h = "Damage";
    public static final String i = "color";
    private static final String k = "Unbreakable";
    private static final String l = "RepairCost";
    private static final String m = "CanDestroy";
    private static final String n = "CanPlaceOn";
    private static final String o = "HideFlags";
    private static final IChatBaseComponent p = IChatBaseComponent.c("item.disabled").a(EnumChatFormat.m);
    private static final int q = 0;
    private static final ChatModifier r = ChatModifier.a.a(EnumChatFormat.f).b(true);
    private int s;
    private int t;
    @Deprecated
    private Item u;
    @Nullable
    private NBTTagCompound v;
    private boolean w;
    @Nullable
    private net.minecraft.world.entity.Entity x;
    @Nullable
    private AdventureModeCheck y;
    @Nullable
    private AdventureModeCheck z;
    private static final Comparator<? super NBTTagCompound> enchantSorter = Comparator.comparing(o2 -> o2.l("id"));
    private CraftItemStack bukkitStack;

    public Optional<TooltipComponent> a() {
        return this.c().h(this);
    }

    private void processEnchantOrder(@Nullable NBTTagCompound tag) {
        if (tag == null || !tag.b(d, 9)) {
            return;
        }
        NBTTagList list = tag.c(d, 10);
        if (list.size() < 2) {
            return;
        }
        try {
            list.sort(enchantSorter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processText() {
        NBTTagCompound display = this.b(e);
        if (display != null) {
            String json;
            if (display.b(f, 8) && (json = display.l(f)) != null && json.contains("\u00a7")) {
                try {
                    display.a(f, this.convert(json));
                }
                catch (JsonParseException jsonparseexception) {
                    display.r(f);
                }
            }
            if (display.b(g, 9)) {
                NBTTagList list = display.c(g, 8);
                for (int index = 0; index < list.size(); ++index) {
                    String json2 = list.j(index);
                    if (json2 == null || !json2.contains("\u00a7")) continue;
                    try {
                        list.d(index, this.convert(json2));
                        continue;
                    }
                    catch (JsonParseException e2) {
                        list.d(index, NBTTagString.a(CraftChatMessage.toJSON(IChatBaseComponent.b(""))));
                    }
                }
            }
        }
    }

    private NBTTagString convert(String json) {
        LiteralContents literalContents;
        IChatBaseComponent component = IChatBaseComponent.ChatSerializer.a(json);
        ComponentContents componentContents = component.b();
        if (componentContents instanceof LiteralContents && (literalContents = (LiteralContents)componentContents).a().contains("\u00a7") && component.c().isEmpty()) {
            component = CraftChatMessage.fromString(literalContents.a())[0];
        }
        return NBTTagString.a(CraftChatMessage.toJSON(component));
    }

    public ItemStack(IMaterial item) {
        this(item, 1);
    }

    public ItemStack(Holder<Item> entry) {
        this(entry.a(), 1);
    }

    private ItemStack(IMaterial item, int count, Optional<NBTTagCompound> nbt) {
        this(item, count);
        nbt.ifPresent(this::c);
    }

    public ItemStack(Holder<Item> itemEntry, int count) {
        this(itemEntry.a(), count);
    }

    public ItemStack(IMaterial item, int count) {
        this.u = item == null ? null : item.k();
        this.s = count;
        if (this.u != null && this.u.o()) {
            this.b(this.j());
        }
        this.O();
    }

    public void convertStack(int version) {
        if (0 < version && version < CraftMagicNumbers.INSTANCE.getDataVersion()) {
            NBTTagCompound savedStack = new NBTTagCompound();
            this.b(savedStack);
            savedStack = (NBTTagCompound)MinecraftServer.getServer().L.update(DataConverterTypes.m, new Dynamic<NBTTagCompound>(DynamicOpsNBT.a, savedStack), version, CraftMagicNumbers.INSTANCE.getDataVersion()).getValue();
            this.load(savedStack);
        }
    }

    private void O() {
        if (this.w && this == b) {
            throw new AssertionError((Object)"TRAP");
        }
        this.w = false;
        this.w = this.b();
    }

    private void load(NBTTagCompound nbttagcompound) {
        this.u = BuiltInRegistries.i.a(new MinecraftKey(nbttagcompound.l("id")));
        this.s = nbttagcompound.f("Count");
        if (nbttagcompound.b("tag", 10)) {
            this.v = nbttagcompound.p("tag").h();
            this.processEnchantOrder(this.v);
            this.processText();
            this.c().b(this.v);
        }
        if (this.c().o()) {
            this.b(this.j());
        }
    }

    private ItemStack(NBTTagCompound nbt) {
        this.load(nbt);
        this.O();
    }

    public static ItemStack a(NBTTagCompound nbt) {
        try {
            return new ItemStack(nbt);
        }
        catch (RuntimeException runtimeexception) {
            j.debug("Tried to load invalid item: {}", (Object)nbt, (Object)runtimeexception);
            return b;
        }
    }

    public boolean b() {
        return this == b || this.u == null || this.u == Items.a || this.s <= 0;
    }

    public boolean a(FeatureFlagSet enabledFeatures) {
        return this.b() || this.c().a(enabledFeatures);
    }

    public ItemStack a(int amount) {
        int j2 = Math.min(amount, this.s);
        ItemStack itemstack = this.o();
        itemstack.f(j2);
        this.h(j2);
        return itemstack;
    }

    public Item c() {
        return this.w ? Items.a : this.u;
    }

    public Holder<Item> d() {
        return this.c().j();
    }

    public boolean a(TagKey<Item> tag) {
        return this.c().j().a(tag);
    }

    public boolean a(Item item) {
        return this.c() == item;
    }

    public boolean a(Predicate<Holder<Item>> predicate) {
        return predicate.test(this.c().j());
    }

    public boolean a(Holder<Item> itemEntry) {
        return this.c().j() == itemEntry;
    }

    public Stream<TagKey<Item>> e() {
        return this.c().j().c();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public EnumInteractionResult useOn(ItemActionContext itemactioncontext, EnumHand enumhand) {
        EntityHuman entityhuman = itemactioncontext.o();
        BlockPosition blockposition = itemactioncontext.a();
        ShapeDetectorBlock shapedetectorblock = new ShapeDetectorBlock(itemactioncontext.q(), blockposition, false);
        if (entityhuman != null && !entityhuman.fK().e && !this.a(itemactioncontext.q().u_().d(Registries.e), shapedetectorblock)) {
            return EnumInteractionResult.d;
        }
        NBTTagCompound oldData = this.getTagClone();
        int oldCount = this.K();
        WorldServer world = (WorldServer)itemactioncontext.q();
        if (!(this.c() instanceof ItemBucket)) {
            world.captureBlockStates = true;
            if (this.c() == Items.qG) {
                world.captureTreeGeneration = true;
            }
        }
        Item item = this.c();
        EnumInteractionResult enuminteractionresult = item.a(itemactioncontext);
        NBTTagCompound newData = this.getTagClone();
        int newCount = this.K();
        this.f(oldCount);
        this.setTagClone(oldData);
        world.captureBlockStates = false;
        if (enuminteractionresult.a() && world.captureTreeGeneration && world.capturedBlockStates.size() > 0) {
            void var16_22;
            world.captureTreeGeneration = false;
            Location location = CraftLocation.toBukkit(blockposition, (World)world.getWorld());
            TreeType treeType = BlockSapling.treeType;
            BlockSapling.treeType = null;
            ArrayList<CraftBlockState> blocks = new ArrayList<CraftBlockState>(world.capturedBlockStates.values());
            world.capturedBlockStates.clear();
            Object var16_20 = null;
            if (treeType != null) {
                boolean isBonemeal = this.c() == Items.qG;
                StructureGrowEvent structureGrowEvent = new StructureGrowEvent(location, treeType, isBonemeal, (Player)entityhuman.getBukkitEntity(), blocks);
                Bukkit.getPluginManager().callEvent((Event)structureGrowEvent);
            }
            BlockFertilizeEvent fertilizeEvent = new BlockFertilizeEvent((org.bukkit.block.Block)CraftBlock.at(world, blockposition), (Player)entityhuman.getBukkitEntity(), blocks);
            fertilizeEvent.setCancelled(var16_22 != null && var16_22.isCancelled());
            Bukkit.getPluginManager().callEvent((Event)fertilizeEvent);
            if (!fertilizeEvent.isCancelled()) {
                if (this.K() == oldCount && Objects.equals(this.v, oldData)) {
                    this.c(newData);
                    this.f(newCount);
                }
                for (CraftBlockState blockstate : blocks) {
                    world.a(blockstate.getPosition(), blockstate.getHandle(), blockstate.getFlag());
                    if (!(blockstate instanceof CapturedBlockState)) continue;
                    CapturedBlockState capturedBlockState = (CapturedBlockState)blockstate;
                    capturedBlockState.checkTreeBlockHack();
                }
                entityhuman.b(StatisticList.c.b(item));
            }
            ItemSign.openSign = null;
            return enuminteractionresult;
        }
        world.captureTreeGeneration = false;
        if (entityhuman != null && enuminteractionresult.c()) {
            BlockMultiPlaceEvent placeEvent = null;
            ArrayList<BlockState> blocks = new ArrayList<BlockState>(world.capturedBlockStates.values());
            world.capturedBlockStates.clear();
            if (blocks.size() > 1) {
                placeEvent = CraftEventFactory.callBlockMultiPlaceEvent(world, entityhuman, enumhand, blocks, blockposition.u(), blockposition.v(), blockposition.w());
            } else if (blocks.size() == 1 && item != Items.pJ) {
                placeEvent = CraftEventFactory.callBlockPlaceEvent(world, entityhuman, enumhand, (BlockState)blocks.get(0), blockposition.u(), blockposition.v(), blockposition.w());
            }
            if (placeEvent != null && (placeEvent.isCancelled() || !placeEvent.canBuild())) {
                enuminteractionresult = EnumInteractionResult.e;
                placeEvent.getPlayer().updateInventory();
                world.capturedTileEntities.clear();
                world.preventPoiUpdated = true;
                for (BlockState blockState : blocks) {
                    blockState.update(true, false);
                }
                world.preventPoiUpdated = false;
                BlockPosition placedPos = ((CraftBlock)placeEvent.getBlock()).getPosition();
                for (EnumDirection dir : EnumDirection.values()) {
                    ((EntityPlayer)entityhuman).b.a(new PacketPlayOutBlockChange(world, placedPos.a(dir)));
                }
                ItemSign.openSign = null;
            } else {
                BlockPosition position;
                IBlockData iBlockData;
                if (this.K() == oldCount && Objects.equals(this.v, oldData)) {
                    this.c(newData);
                    this.f(newCount);
                }
                for (Map.Entry<BlockPosition, TileEntity> entry : world.capturedTileEntities.entrySet()) {
                    world.a(entry.getValue());
                }
                for (BlockState blockState : blocks) {
                    int updateFlag = ((CraftBlockState)blockState).getFlag();
                    IBlockData oldBlock = ((CraftBlockState)blockState).getHandle();
                    BlockPosition newblockposition = ((CraftBlockState)blockState).getPosition();
                    IBlockData block = world.a_(newblockposition);
                    if (!(block.b() instanceof BlockTileEntity)) {
                        block.b().onPlace(block, world, newblockposition, oldBlock, true, itemactioncontext);
                    }
                    world.notifyAndUpdatePhysics(newblockposition, null, oldBlock, block, world.a_(newblockposition), updateFlag, 512);
                }
                if (this.u instanceof ItemRecord) {
                    TileEntity tileentity = world.c_(blockposition);
                    if (tileentity instanceof TileEntityJukeBox) {
                        TileEntityJukeBox tileEntityJukeBox = (TileEntityJukeBox)tileentity;
                        tileEntityJukeBox.b(this.o());
                        world.a(GameEvent.c, blockposition, GameEvent.a.a(entityhuman, world.a_(blockposition)));
                    }
                    this.h(1);
                    entityhuman.a(StatisticList.al);
                }
                if (this.u == Items.to) {
                    TileEntity tileEntity;
                    BlockPosition bp = blockposition;
                    if (!world.a_(blockposition).d().e()) {
                        bp = !world.a_(blockposition).d().b() ? null : bp.a(itemactioncontext.k());
                    }
                    if (bp != null && (tileEntity = world.c_(bp)) instanceof TileEntitySkull) {
                        BlockWitherSkull.a((net.minecraft.world.level.World)world, bp, (TileEntitySkull)tileEntity);
                    }
                }
                if ((this.u instanceof ItemSign || this.u instanceof HangingSignItem) && ItemSign.openSign != null) {
                    try {
                        entityhuman.a((TileEntitySign)world.c_(ItemSign.openSign));
                    }
                    finally {
                        ItemSign.openSign = null;
                    }
                }
                if (placeEvent != null && this.u instanceof ItemBed && (iBlockData = world.a_(position = ((CraftBlock)placeEvent.getBlock()).getPosition())).b() instanceof BlockBed) {
                    world.b(position, Blocks.a);
                    iBlockData.a((GeneratorAccess)world, position, 3);
                }
                if (this.u instanceof ItemBlock) {
                    SoundEffectType soundeffecttype = ((ItemBlock)this.u).e().m(null);
                    world.a(entityhuman, blockposition, soundeffecttype.e(), SoundCategory.e, (soundeffecttype.a() + 1.0f) / 2.0f, soundeffecttype.b() * 0.8f);
                }
                entityhuman.b(StatisticList.c.b(item));
            }
        }
        world.capturedTileEntities.clear();
        world.capturedBlockStates.clear();
        return enuminteractionresult;
    }

    public float a(IBlockData state) {
        return this.c().a(this, state);
    }

    public InteractionResultWrapper<ItemStack> a(net.minecraft.world.level.World world, EntityHuman user, EnumHand hand) {
        return this.c().a(world, user, hand);
    }

    public ItemStack a(net.minecraft.world.level.World world, EntityLiving user) {
        return this.c().a(this, world, user);
    }

    public NBTTagCompound b(NBTTagCompound nbt) {
        MinecraftKey minecraftkey = BuiltInRegistries.i.b(this.c());
        nbt.a("id", minecraftkey == null ? "minecraft:air" : minecraftkey.toString());
        nbt.a("Count", (byte)this.s);
        if (this.v != null) {
            nbt.a("tag", this.v.h());
        }
        return nbt;
    }

    public int f() {
        return this.c().l();
    }

    public boolean g() {
        return this.f() > 1 && (!this.h() || !this.i());
    }

    public boolean h() {
        if (!this.w && this.c().n() > 0) {
            NBTTagCompound nbttagcompound = this.u();
            return nbttagcompound == null || !nbttagcompound.q(k);
        }
        return false;
    }

    public boolean i() {
        return this.h() && this.j() > 0;
    }

    public int j() {
        return this.v == null ? 0 : this.v.h(h);
    }

    public void b(int damage) {
        this.v().a(h, Math.max(0, damage));
    }

    public int k() {
        return this.c().n();
    }

    public boolean hurt(int amount, RandomSource random, @Nullable EntityLiving player) {
        int j2;
        if (!this.h()) {
            return false;
        }
        if (amount > 0) {
            j2 = EnchantmentManager.a(Enchantments.w, this);
            int k2 = 0;
            for (int l2 = 0; j2 > 0 && l2 < amount; ++l2) {
                if (!EnchantmentDurability.a(this, j2, random)) continue;
                ++k2;
            }
            int originalDamage = amount;
            amount -= k2;
            if (player instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)player;
                PlayerItemDamageEvent event = new PlayerItemDamageEvent((Player)serverPlayer.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(this), amount, originalDamage);
                event.getPlayer().getServer().getPluginManager().callEvent((Event)event);
                if (amount != event.getDamage() || event.isCancelled()) {
                    event.getPlayer().updateInventory();
                }
                if (event.isCancelled()) {
                    return false;
                }
                amount = event.getDamage();
            } else if (player != null) {
                EntityDamageItemEvent event = new EntityDamageItemEvent((Entity)player.getBukkitLivingEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(this), amount);
                if (!event.callEvent()) {
                    return false;
                }
                amount = event.getDamage();
            }
            if (amount <= 0) {
                return false;
            }
        }
        if (player instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)player;
            if (amount != 0) {
                CriterionTriggers.t.a(serverPlayer, this, this.j() + amount);
            }
        }
        j2 = this.j() + amount;
        this.b(j2);
        return j2 >= this.k();
    }

    public <T extends EntityLiving> void a(int amount, T entity, Consumer<T> breakCallback) {
        if (!(entity.H.B || entity instanceof EntityHuman && ((EntityHuman)entity).fK().d || !this.h() || !this.hurt(amount, entity.dZ(), entity))) {
            breakCallback.accept(entity);
            Item item = this.c();
            if (this.s == 1 && entity instanceof EntityHuman) {
                CraftEventFactory.callPlayerItemBreakEvent((EntityHuman)entity, this);
            }
            this.h(1);
            if (entity instanceof EntityHuman) {
                ((EntityHuman)entity).b(StatisticList.d.b(item));
            }
            this.b(0);
        }
    }

    public boolean l() {
        return this.u.e(this);
    }

    public int m() {
        return this.u.f(this);
    }

    public int n() {
        return this.u.g(this);
    }

    public boolean a(Slot slot, ClickAction clickType, EntityHuman player) {
        return this.c().a(this, slot, clickType, player);
    }

    public boolean a(ItemStack stack, Slot slot, ClickAction clickType, EntityHuman player, SlotAccess cursorStackReference) {
        return this.c().a(this, stack, slot, clickType, player, cursorStackReference);
    }

    public void a(EntityLiving target, EntityHuman attacker) {
        Item item = this.c();
        if (item.a(this, target, (EntityLiving)attacker)) {
            attacker.b(StatisticList.c.b(item));
        }
    }

    public void a(net.minecraft.world.level.World world, IBlockData state, BlockPosition pos, EntityHuman miner) {
        Item item = this.c();
        if (item.a(this, world, state, pos, miner)) {
            miner.b(StatisticList.c.b(item));
        }
    }

    public boolean b(IBlockData state) {
        return this.c().a_(state);
    }

    public EnumInteractionResult a(EntityHuman user, EntityLiving entity, EnumHand hand) {
        return this.c().a(this, user, entity, hand);
    }

    public ItemStack o() {
        return this.copy(false);
    }

    public ItemStack copy(boolean originalItem) {
        if (!originalItem && this.b()) {
            return b;
        }
        ItemStack itemstack = new ItemStack(originalItem ? this.u : this.c(), this.s);
        itemstack.e(this.J());
        if (this.v != null) {
            itemstack.v = this.v.h();
        }
        return itemstack;
    }

    public ItemStack c(int count) {
        ItemStack itemstack = this.o();
        itemstack.f(count);
        return itemstack;
    }

    public static boolean a(ItemStack left, ItemStack right) {
        return left.b() && right.b() ? true : (!left.b() && !right.b() ? (left.v == null && right.v != null ? false : left.v == null || left.v.equals(right.v)) : false);
    }

    public static boolean b(ItemStack left, ItemStack right) {
        return left.b() && right.b() ? true : (!left.b() && !right.b() ? left.b(right) : false);
    }

    private boolean b(ItemStack stack) {
        return this.s != stack.s ? false : (!this.a(stack.c()) ? false : (this.v == null && stack.v != null ? false : this.v == null || this.v.equals(stack.v)));
    }

    public static boolean c(ItemStack left, ItemStack right) {
        return left == right ? true : (!left.b() && !right.b() ? left.a(right) : false);
    }

    public boolean a(ItemStack stack) {
        return !stack.b() && this.a(stack.c());
    }

    public static boolean d(ItemStack stack, ItemStack otherStack) {
        return stack.a(otherStack.c()) && ItemStack.a(stack, otherStack);
    }

    public String p() {
        return this.c().j(this);
    }

    public String toString() {
        return this.s + " " + this.c();
    }

    public void a(net.minecraft.world.level.World world, net.minecraft.world.entity.Entity entity, int slot, boolean selected) {
        if (this.t > 0) {
            --this.t;
        }
        if (this.c() != null) {
            this.c().a(this, world, entity, slot, selected);
        }
    }

    public void a(net.minecraft.world.level.World world, EntityHuman player, int amount) {
        player.a(StatisticList.b.b(this.c()), amount);
        this.c().b(this, world, player);
    }

    public int q() {
        return this.c().b(this);
    }

    public EnumAnimation r() {
        return this.c().c(this);
    }

    public void a(net.minecraft.world.level.World world, EntityLiving user, int remainingUseTicks) {
        this.c().a(this, world, user, remainingUseTicks);
    }

    public boolean s() {
        return this.c().l(this);
    }

    public boolean t() {
        return !this.w && this.v != null && !this.v.g();
    }

    @Nullable
    public NBTTagCompound u() {
        return this.v;
    }

    @Nullable
    private NBTTagCompound getTagClone() {
        return this.v == null ? null : this.v.h();
    }

    private void setTagClone(@Nullable NBTTagCompound nbtttagcompound) {
        this.c(nbtttagcompound == null ? null : nbtttagcompound.h());
    }

    public NBTTagCompound v() {
        if (this.v == null) {
            this.c(new NBTTagCompound());
        }
        return this.v;
    }

    public NBTTagCompound a(String key) {
        if (this.v != null && this.v.b(key, 10)) {
            return this.v.p(key);
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.a(key, nbttagcompound);
        return nbttagcompound;
    }

    @Nullable
    public NBTTagCompound b(String key) {
        return this.v != null && this.v.b(key, 10) ? this.v.p(key) : null;
    }

    public void c(String key) {
        if (this.v != null && this.v.e(key)) {
            this.v.r(key);
            if (this.v.g()) {
                this.v = null;
            }
        }
    }

    public NBTTagList w() {
        return this.v != null ? this.v.c(d, 10) : new NBTTagList();
    }

    public org.bukkit.inventory.ItemStack asBukkitMirror() {
        return CraftItemStack.asCraftMirror(this);
    }

    public org.bukkit.inventory.ItemStack asBukkitCopy() {
        return CraftItemStack.asCraftMirror(this.o());
    }

    public static ItemStack fromBukkitCopy(org.bukkit.inventory.ItemStack itemstack) {
        return CraftItemStack.asNMSCopy(itemstack);
    }

    public org.bukkit.inventory.ItemStack getBukkitStack() {
        if (this.bukkitStack == null || this.bukkitStack.handle != this) {
            this.bukkitStack = CraftItemStack.asCraftMirror(this);
        }
        return this.bukkitStack;
    }

    public void c(@Nullable NBTTagCompound nbt) {
        this.v = nbt;
        this.processEnchantOrder(this.v);
        if (this.c().o()) {
            this.b(this.j());
        }
        if (nbt != null) {
            this.c().b(nbt);
        }
    }

    public IChatBaseComponent x() {
        NBTTagCompound nbttagcompound = this.b(e);
        if (nbttagcompound != null && nbttagcompound.b(f, 8)) {
            try {
                IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.ChatSerializer.a(nbttagcompound.l(f));
                if (ichatmutablecomponent != null) {
                    return ichatmutablecomponent;
                }
                nbttagcompound.r(f);
            }
            catch (Exception exception) {
                nbttagcompound.r(f);
            }
        }
        return this.c().m(this);
    }

    public ItemStack a(@Nullable IChatBaseComponent name) {
        NBTTagCompound nbttagcompound = this.a(e);
        if (name != null) {
            nbttagcompound.a(f, IChatBaseComponent.ChatSerializer.a(name));
        } else {
            nbttagcompound.r(f);
        }
        return this;
    }

    public void y() {
        NBTTagCompound nbttagcompound = this.b(e);
        if (nbttagcompound != null) {
            nbttagcompound.r(f);
            if (nbttagcompound.g()) {
                this.c(e);
            }
        }
        if (this.v != null && this.v.g()) {
            this.v = null;
        }
    }

    public boolean z() {
        NBTTagCompound nbttagcompound = this.b(e);
        return nbttagcompound != null && nbttagcompound.b(f, 8);
    }

    public List<IChatBaseComponent> a(@Nullable EntityHuman player, TooltipFlag context) {
        int i2;
        Integer integer;
        ArrayList list = Lists.newArrayList();
        IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.h().b(this.x()).a(this.B().e);
        if (this.z()) {
            ichatmutablecomponent.a(EnumChatFormat.u);
        }
        list.add(ichatmutablecomponent);
        if (!context.a() && !this.z() && this.a(Items.rb) && (integer = ItemWorldMap.d(this)) != null) {
            list.add(IChatBaseComponent.b("#" + integer).a(EnumChatFormat.h));
        }
        if (ItemStack.a(i2 = this.P(), HideFlags.f)) {
            this.c().a(this, player == null ? null : player.H, list, context);
        }
        if (this.t()) {
            if (ItemStack.a(i2, HideFlags.h) && player != null) {
                ArmorTrim.a(this, player.H.u_(), list);
            }
            if (ItemStack.a(i2, HideFlags.a)) {
                ItemStack.a(list, this.w());
            }
            if (this.v.b(e, 10)) {
                NBTTagCompound nbttagcompound = this.v.p(e);
                if (ItemStack.a(i2, HideFlags.g) && nbttagcompound.b(i, 99)) {
                    if (context.a()) {
                        list.add(IChatBaseComponent.a("item.color", new Object[]{String.format(Locale.ROOT, "#%06X", nbttagcompound.h(i))}).a(EnumChatFormat.h));
                    } else {
                        list.add(IChatBaseComponent.c("item.dyed").a(EnumChatFormat.h, EnumChatFormat.u));
                    }
                }
                if (nbttagcompound.d(g) == 9) {
                    NBTTagList nbttaglist = nbttagcompound.c(g, 8);
                    for (int j2 = 0; j2 < nbttaglist.size(); ++j2) {
                        String s2 = nbttaglist.j(j2);
                        try {
                            IChatMutableComponent ichatmutablecomponent1 = IChatBaseComponent.ChatSerializer.a(s2);
                            if (ichatmutablecomponent1 == null) continue;
                            list.add(ChatComponentUtils.a(ichatmutablecomponent1, r));
                            continue;
                        }
                        catch (Exception exception) {
                            nbttagcompound.r(g);
                        }
                    }
                }
            }
        }
        if (ItemStack.a(i2, HideFlags.b)) {
            for (EnumItemSlot enumitemslot : EnumItemSlot.values()) {
                Multimap<AttributeBase, AttributeModifier> multimap = this.a(enumitemslot);
                if (multimap.isEmpty()) continue;
                list.add(CommonComponents.a);
                list.add(IChatBaseComponent.c("item.modifiers." + enumitemslot.d()).a(EnumChatFormat.h));
                for (Map.Entry entry : multimap.entries()) {
                    AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                    double d0 = attributemodifier.d();
                    boolean flag = false;
                    if (player != null) {
                        if (attributemodifier.a() == Item.m) {
                            d0 += player.c(GenericAttributes.f);
                            d0 += (double)EnchantmentManager.a(this, EnumMonsterType.a);
                            flag = true;
                        } else if (attributemodifier.a() == Item.n) {
                            d0 += player.c(GenericAttributes.h);
                            flag = true;
                        }
                    }
                    double d1 = attributemodifier.c() != AttributeModifier.Operation.b && attributemodifier.c() != AttributeModifier.Operation.c ? (((AttributeBase)entry.getKey()).equals(GenericAttributes.c) ? d0 * 10.0 : d0) : d0 * 100.0;
                    if (flag) {
                        list.add(CommonComponents.a().b(IChatBaseComponent.a("attribute.modifier.equals." + attributemodifier.c().a(), new Object[]{c.format(d1), IChatBaseComponent.c(((AttributeBase)entry.getKey()).c())})).a(EnumChatFormat.c));
                        continue;
                    }
                    if (d0 > 0.0) {
                        list.add(IChatBaseComponent.a("attribute.modifier.plus." + attributemodifier.c().a(), new Object[]{c.format(d1), IChatBaseComponent.c(((AttributeBase)entry.getKey()).c())}).a(EnumChatFormat.j));
                        continue;
                    }
                    if (!(d0 < 0.0)) continue;
                    list.add(IChatBaseComponent.a("attribute.modifier.take." + attributemodifier.c().a(), new Object[]{c.format(d1 *= -1.0), IChatBaseComponent.c(((AttributeBase)entry.getKey()).c())}).a(EnumChatFormat.m));
                }
            }
        }
        if (this.t()) {
            NBTTagList nbttaglist1;
            if (ItemStack.a(i2, HideFlags.c) && this.v.q(k)) {
                list.add(IChatBaseComponent.c("item.unbreakable").a(EnumChatFormat.j));
            }
            if (ItemStack.a(i2, HideFlags.d) && this.v.b(m, 9) && !(nbttaglist1 = this.v.c(m, 8)).isEmpty()) {
                list.add(CommonComponents.a);
                list.add(IChatBaseComponent.c("item.canBreak").a(EnumChatFormat.h));
                for (int k2 = 0; k2 < nbttaglist1.size(); ++k2) {
                    list.addAll(ItemStack.d(nbttaglist1.j(k2)));
                }
            }
            if (ItemStack.a(i2, HideFlags.e) && this.v.b(n, 9) && !(nbttaglist1 = this.v.c(n, 8)).isEmpty()) {
                list.add(CommonComponents.a);
                list.add(IChatBaseComponent.c("item.canPlace").a(EnumChatFormat.h));
                for (int k3 = 0; k3 < nbttaglist1.size(); ++k3) {
                    list.addAll(ItemStack.d(nbttaglist1.j(k3)));
                }
            }
        }
        if (context.a()) {
            if (this.i()) {
                list.add(IChatBaseComponent.a("item.durability", this.k() - this.j(), this.k()));
            }
            list.add(IChatBaseComponent.b(BuiltInRegistries.i.b(this.c()).toString()).a(EnumChatFormat.i));
            if (this.t()) {
                list.add(IChatBaseComponent.a("item.nbt_tags", this.v.e().size()).a(EnumChatFormat.i));
            }
        }
        if (player != null && !this.c().a(player.Y().G())) {
            list.add(p);
        }
        return list;
    }

    private static boolean a(int flags, HideFlags tooltipSection) {
        return (flags & tooltipSection.a()) == 0;
    }

    private int P() {
        return this.t() && this.v.b(o, 99) ? this.v.h(o) : 0;
    }

    public void a(HideFlags tooltipSection) {
        NBTTagCompound nbttagcompound = this.v();
        nbttagcompound.a(o, nbttagcompound.h(o) | tooltipSection.a());
    }

    public static void a(List<IChatBaseComponent> tooltip, NBTTagList enchantments) {
        for (int i2 = 0; i2 < enchantments.size(); ++i2) {
            NBTTagCompound nbttagcompound = enchantments.a(i2);
            BuiltInRegistries.g.b(EnchantmentManager.b(nbttagcompound)).ifPresent(enchantment -> tooltip.add(enchantment.d(EnchantmentManager.a(nbttagcompound))));
        }
    }

    private static Collection<IChatBaseComponent> d(String tag) {
        try {
            return ArgumentBlock.b(BuiltInRegistries.f.p(), tag, true).map(argumentblock_a -> Lists.newArrayList((Object[])new IChatBaseComponent[]{argumentblock_a.a().b().f().a(EnumChatFormat.i)}), argumentblock_b -> argumentblock_b.a().a().map(holder -> ((Block)holder.a()).f().a(EnumChatFormat.i)).collect(Collectors.toList()));
        }
        catch (CommandSyntaxException commandsyntaxexception) {
            return Lists.newArrayList((Object[])new IChatBaseComponent[]{IChatBaseComponent.b("missingno").a(EnumChatFormat.i)});
        }
    }

    public boolean A() {
        return this.c().i(this);
    }

    public EnumItemRarity B() {
        return this.c().n(this);
    }

    public boolean C() {
        return !this.c().d_(this) ? false : !this.D();
    }

    public void a(Enchantment enchantment, int level) {
        this.v();
        if (!this.v.b(d, 9)) {
            this.v.a(d, new NBTTagList());
        }
        NBTTagList nbttaglist = this.v.c(d, 10);
        nbttaglist.add(EnchantmentManager.a(EnchantmentManager.a(enchantment), (int)((byte)level)));
        this.processEnchantOrder(this.v);
    }

    public boolean D() {
        return this.v != null && this.v.b(d, 9) ? !this.v.c(d, 10).isEmpty() : false;
    }

    public void a(String key, NBTBase element) {
        this.v().a(key, element);
    }

    public boolean E() {
        return this.x instanceof EntityItemFrame;
    }

    public void a(@Nullable net.minecraft.world.entity.Entity holder) {
        this.x = holder;
    }

    @Nullable
    public EntityItemFrame F() {
        return this.x instanceof EntityItemFrame ? (EntityItemFrame)this.G() : null;
    }

    @Nullable
    public net.minecraft.world.entity.Entity G() {
        return !this.w ? this.x : null;
    }

    public int H() {
        return this.t() && this.v.b(l, 3) ? this.v.h(l) : 0;
    }

    public void d(int repairCost) {
        if (repairCost == 0) {
            this.c(l);
            return;
        }
        this.v().a(l, repairCost);
    }

    public Multimap<AttributeBase, AttributeModifier> a(EnumItemSlot slot) {
        HashMultimap object;
        if (this.t() && this.v.b("AttributeModifiers", 9)) {
            object = HashMultimap.create();
            NBTTagList nbttaglist = this.v.c("AttributeModifiers", 10);
            for (int i2 = 0; i2 < nbttaglist.size(); ++i2) {
                AttributeModifier attributemodifier;
                Optional<AttributeBase> optional;
                NBTTagCompound nbttagcompound = nbttaglist.a(i2);
                if (nbttagcompound.b("Slot", 8) && !nbttagcompound.l("Slot").equals(slot.d()) || !(optional = BuiltInRegistries.u.b(MinecraftKey.a(nbttagcompound.l("AttributeName")))).isPresent() || (attributemodifier = AttributeModifier.a(nbttagcompound)) == null || attributemodifier.a().getLeastSignificantBits() == 0L || attributemodifier.a().getMostSignificantBits() == 0L) continue;
                ((Multimap)object).put((Object)optional.get(), (Object)attributemodifier);
            }
        } else {
            object = this.c().a(slot);
        }
        return object;
    }

    public void a(AttributeBase attribute, AttributeModifier modifier, @Nullable EnumItemSlot slot) {
        this.v();
        if (!this.v.b("AttributeModifiers", 9)) {
            this.v.a("AttributeModifiers", new NBTTagList());
        }
        NBTTagList nbttaglist = this.v.c("AttributeModifiers", 10);
        NBTTagCompound nbttagcompound = modifier.e();
        nbttagcompound.a("AttributeName", BuiltInRegistries.u.b(attribute).toString());
        if (slot != null) {
            nbttagcompound.a("Slot", slot.d());
        }
        nbttaglist.add(nbttagcompound);
    }

    @Deprecated
    public void setItem(Item item) {
        this.bukkitStack = null;
        this.u = item;
    }

    public IChatBaseComponent I() {
        IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.h().b(this.x());
        if (this.z()) {
            ichatmutablecomponent.a(EnumChatFormat.u);
        }
        IChatMutableComponent ichatmutablecomponent1 = ChatComponentUtils.a(ichatmutablecomponent);
        if (!this.w) {
            ichatmutablecomponent1.a(this.B().e).a(chatmodifier -> chatmodifier.a(new ChatHoverable(ChatHoverable.EnumHoverAction.b, new ChatHoverable.c(this))));
        }
        return ichatmutablecomponent1;
    }

    public boolean a(IRegistry<Block> blockRegistry, ShapeDetectorBlock pos) {
        if (this.z == null) {
            this.z = new AdventureModeCheck(n);
        }
        return this.z.a(this, blockRegistry, pos);
    }

    public boolean b(IRegistry<Block> blockRegistry, ShapeDetectorBlock pos) {
        if (this.y == null) {
            this.y = new AdventureModeCheck(m);
        }
        return this.y.a(this, blockRegistry, pos);
    }

    public int J() {
        return this.t;
    }

    public void e(int bobbingAnimationTime) {
        this.t = bobbingAnimationTime;
    }

    public int K() {
        return this.w ? 0 : this.s;
    }

    public void f(int count) {
        this.s = count;
        this.O();
    }

    public void g(int amount) {
        this.f(this.s + amount);
    }

    public void h(int amount) {
        this.g(-amount);
    }

    public void b(net.minecraft.world.level.World world, EntityLiving user, int remainingUseTicks) {
        this.c().a(world, user, this, remainingUseTicks);
    }

    public void a(EntityItem entity) {
        this.c().a(entity);
    }

    public boolean L() {
        return this.c().u();
    }

    public SoundEffect M() {
        return this.c().ae_();
    }

    public SoundEffect N() {
        return this.c().af_();
    }

    public static enum HideFlags {
        a,
        b,
        c,
        d,
        e,
        f,
        g,
        h;

        private final int i = 1 << this.ordinal();

        public int a() {
            return this.i;
        }
    }
}

