/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.alchemy;

import com.google.common.collect.Lists;
import io.papermc.paper.potion.PaperPotionMix;
import io.papermc.paper.potion.PotionMix;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.IMaterial;
import org.bukkit.NamespacedKey;

public class PotionBrewer {
    public static final int a = 20;
    private static final List<PredicatedCombination<PotionRegistry>> b = Lists.newArrayList();
    private static final List<PredicatedCombination<Item>> c = Lists.newArrayList();
    private static final Object2ObjectLinkedOpenHashMap<NamespacedKey, PaperPotionMix> CUSTOM_MIXES = new Object2ObjectLinkedOpenHashMap();
    private static final List<RecipeItemStack> d = Lists.newArrayList();
    private static final Predicate<ItemStack> e = stack -> {
        for (RecipeItemStack ingredient : d) {
            if (!ingredient.a((ItemStack)stack)) continue;
            return true;
        }
        return false;
    };

    public static boolean a(ItemStack stack) {
        return PotionBrewer.b(stack) || PotionBrewer.c(stack) || PotionBrewer.isCustomIngredient(stack);
    }

    protected static boolean b(ItemStack stack) {
        int j2 = c.size();
        for (int i2 = 0; i2 < j2; ++i2) {
            if (!PotionBrewer.c.get((int)i2).b.a(stack)) continue;
            return true;
        }
        return false;
    }

    protected static boolean c(ItemStack stack) {
        int j2 = b.size();
        for (int i2 = 0; i2 < j2; ++i2) {
            if (!PotionBrewer.b.get((int)i2).b.a(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean a(PotionRegistry potion) {
        int j2 = b.size();
        for (int i2 = 0; i2 < j2; ++i2) {
            if (PotionBrewer.b.get((int)i2).c != potion) continue;
            return true;
        }
        return false;
    }

    public static boolean a(ItemStack input, ItemStack ingredient) {
        if (PotionBrewer.hasCustomMix(input, ingredient)) {
            return true;
        }
        if (!e.test(input)) {
            return false;
        }
        return PotionBrewer.b(input, ingredient) || PotionBrewer.c(input, ingredient);
    }

    protected static boolean b(ItemStack input, ItemStack ingredient) {
        Item item = input.c();
        int j2 = c.size();
        for (int i2 = 0; i2 < j2; ++i2) {
            PredicatedCombination<Item> mix = c.get(i2);
            if (mix.a != item || !mix.b.a(ingredient)) continue;
            return true;
        }
        return false;
    }

    protected static boolean c(ItemStack input, ItemStack ingredient) {
        PotionRegistry potion = PotionUtil.d(input);
        int j2 = b.size();
        for (int i2 = 0; i2 < j2; ++i2) {
            PredicatedCombination<PotionRegistry> mix = b.get(i2);
            if (mix.a != potion || !mix.b.a(ingredient)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack d(ItemStack ingredient, ItemStack input) {
        if (!input.b()) {
            int i2;
            for (PaperPotionMix mix : CUSTOM_MIXES.values()) {
                if (!mix.input().a(input) || !mix.ingredient().a(ingredient)) continue;
                return mix.result().o();
            }
            PotionRegistry potion = PotionUtil.d(input);
            Item item = input.c();
            int j2 = c.size();
            for (i2 = 0; i2 < j2; ++i2) {
                PredicatedCombination<Item> mix = c.get(i2);
                if (mix.a != item || !mix.b.a(ingredient)) continue;
                return PotionUtil.a(new ItemStack((IMaterial)mix.c), potion);
            }
            int l2 = b.size();
            for (i2 = 0; i2 < l2; ++i2) {
                PredicatedCombination<PotionRegistry> mix2 = b.get(i2);
                if (mix2.a != potion || !mix2.b.a(ingredient)) continue;
                return PotionUtil.a(new ItemStack(item), (PotionRegistry)mix2.c);
            }
        }
        return input;
    }

    public static boolean isCustomIngredient(ItemStack stack) {
        for (PaperPotionMix mix : CUSTOM_MIXES.values()) {
            if (!mix.ingredient().a(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCustomInput(ItemStack stack) {
        for (PaperPotionMix mix : CUSTOM_MIXES.values()) {
            if (!mix.input().a(stack)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasCustomMix(ItemStack input, ItemStack ingredient) {
        for (PaperPotionMix mix : CUSTOM_MIXES.values()) {
            if (!mix.input().a(input) || !mix.ingredient().a(ingredient)) continue;
            return true;
        }
        return false;
    }

    public static void addPotionMix(PotionMix mix) {
        if (CUSTOM_MIXES.containsKey((Object)mix.getKey())) {
            throw new IllegalArgumentException("Duplicate recipe ignored with ID " + mix.getKey());
        }
        CUSTOM_MIXES.putAndMoveToFirst((Object)mix.getKey(), (Object)new PaperPotionMix(mix));
    }

    public static boolean removePotionMix(NamespacedKey key) {
        return CUSTOM_MIXES.remove((Object)key) != null;
    }

    public static void reload() {
        b.clear();
        c.clear();
        d.clear();
        CUSTOM_MIXES.clear();
        PotionBrewer.a();
    }

    public static void a() {
        PotionBrewer.a(Items.rr);
        PotionBrewer.a(Items.up);
        PotionBrewer.a(Items.us);
        PotionBrewer.a(Items.rr, Items.oC, Items.up);
        PotionBrewer.a(Items.up, Items.uo, Items.us);
        PotionBrewer.a(Potions.c, Items.rA, Potions.d);
        PotionBrewer.a(Potions.c, Items.ro, Potions.d);
        PotionBrewer.a(Potions.c, Items.tF, Potions.d);
        PotionBrewer.a(Potions.c, Items.rv, Potions.d);
        PotionBrewer.a(Potions.c, Items.rt, Potions.d);
        PotionBrewer.a(Potions.c, Items.qI, Potions.d);
        PotionBrewer.a(Potions.c, Items.rw, Potions.d);
        PotionBrewer.a(Potions.c, Items.qg, Potions.e);
        PotionBrewer.a(Potions.c, Items.li, Potions.d);
        PotionBrewer.a(Potions.c, Items.rq, Potions.f);
        PotionBrewer.a(Potions.f, Items.tm, Potions.g);
        PotionBrewer.a(Potions.g, Items.li, Potions.h);
        PotionBrewer.a(Potions.g, Items.ru, Potions.i);
        PotionBrewer.a(Potions.h, Items.ru, Potions.j);
        PotionBrewer.a(Potions.i, Items.li, Potions.j);
        PotionBrewer.a(Potions.f, Items.rw, Potions.n);
        PotionBrewer.a(Potions.n, Items.li, Potions.o);
        PotionBrewer.a(Potions.f, Items.tF, Potions.k);
        PotionBrewer.a(Potions.k, Items.li, Potions.l);
        PotionBrewer.a(Potions.k, Items.qg, Potions.m);
        PotionBrewer.a(Potions.k, Items.ru, Potions.s);
        PotionBrewer.a(Potions.l, Items.ru, Potions.t);
        PotionBrewer.a(Potions.s, Items.li, Potions.t);
        PotionBrewer.a(Potions.s, Items.qg, Potions.u);
        PotionBrewer.a(Potions.f, Items.ny, Potions.v);
        PotionBrewer.a(Potions.v, Items.li, Potions.w);
        PotionBrewer.a(Potions.v, Items.qg, Potions.x);
        PotionBrewer.a(Potions.p, Items.ru, Potions.s);
        PotionBrewer.a(Potions.q, Items.ru, Potions.t);
        PotionBrewer.a(Potions.f, Items.qI, Potions.p);
        PotionBrewer.a(Potions.p, Items.li, Potions.q);
        PotionBrewer.a(Potions.p, Items.qg, Potions.r);
        PotionBrewer.a(Potions.f, Items.qk, Potions.y);
        PotionBrewer.a(Potions.y, Items.li, Potions.z);
        PotionBrewer.a(Potions.f, Items.rA, Potions.A);
        PotionBrewer.a(Potions.A, Items.qg, Potions.B);
        PotionBrewer.a(Potions.A, Items.ru, Potions.C);
        PotionBrewer.a(Potions.B, Items.ru, Potions.D);
        PotionBrewer.a(Potions.C, Items.qg, Potions.D);
        PotionBrewer.a(Potions.E, Items.ru, Potions.C);
        PotionBrewer.a(Potions.F, Items.ru, Potions.C);
        PotionBrewer.a(Potions.G, Items.ru, Potions.D);
        PotionBrewer.a(Potions.f, Items.rt, Potions.E);
        PotionBrewer.a(Potions.E, Items.li, Potions.F);
        PotionBrewer.a(Potions.E, Items.qg, Potions.G);
        PotionBrewer.a(Potions.f, Items.ro, Potions.H);
        PotionBrewer.a(Potions.H, Items.li, Potions.I);
        PotionBrewer.a(Potions.H, Items.qg, Potions.J);
        PotionBrewer.a(Potions.f, Items.rv, Potions.K);
        PotionBrewer.a(Potions.K, Items.li, Potions.L);
        PotionBrewer.a(Potions.K, Items.qg, Potions.M);
        PotionBrewer.a(Potions.c, Items.ru, Potions.N);
        PotionBrewer.a(Potions.N, Items.li, Potions.O);
        PotionBrewer.a(Potions.f, Items.uQ, Potions.Q);
        PotionBrewer.a(Potions.Q, Items.li, Potions.R);
    }

    private static void a(Item input, Item ingredient, Item output) {
        if (!(input instanceof ItemPotion)) {
            throw new IllegalArgumentException("Expected a potion, got: " + BuiltInRegistries.i.b(input));
        }
        if (!(output instanceof ItemPotion)) {
            throw new IllegalArgumentException("Expected a potion, got: " + BuiltInRegistries.i.b(output));
        }
        c.add(new PredicatedCombination<Item>(input, RecipeItemStack.a(ingredient), output));
    }

    private static void a(Item item) {
        if (!(item instanceof ItemPotion)) {
            throw new IllegalArgumentException("Expected a potion, got: " + BuiltInRegistries.i.b(item));
        }
        d.add(RecipeItemStack.a(item));
    }

    private static void a(PotionRegistry input, Item item, PotionRegistry output) {
        b.add(new PredicatedCombination<PotionRegistry>(input, RecipeItemStack.a(item), output));
    }

    static class PredicatedCombination<T> {
        final T a;
        final RecipeItemStack b;
        final T c;

        public PredicatedCombination(T input, RecipeItemStack ingredient, T output) {
            this.a = input;
            this.b = ingredient;
            this.c = output;
        }
    }
}

