/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.armortrim;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.EnumArmorMaterial;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import org.slf4j.Logger;

public class ArmorTrim {
    public static final Codec<ArmorTrim> a = RecordCodecBuilder.create(instance -> instance.group((App)TrimMaterial.b.fieldOf("material").forGetter(ArmorTrim::b), (App)TrimPattern.b.fieldOf("pattern").forGetter(ArmorTrim::a)).apply((Applicative)instance, ArmorTrim::new));
    private static final Logger c = LogUtils.getLogger();
    public static final String b = "Trim";
    private static final IChatBaseComponent d = IChatBaseComponent.c(SystemUtils.a("item", new MinecraftKey("smithing_template.upgrade"))).a(EnumChatFormat.h);
    private final Holder<TrimMaterial> e;
    private final Holder<TrimPattern> f;
    private final Function<ArmorMaterial, MinecraftKey> g;
    private final Function<ArmorMaterial, MinecraftKey> h;

    public ArmorTrim(Holder<TrimMaterial> material, Holder<TrimPattern> pattern) {
        this.e = material;
        this.f = pattern;
        this.g = SystemUtils.b(armorMaterial -> {
            MinecraftKey resourceLocation = ((TrimPattern)pattern.a()).a();
            String string = this.c((ArmorMaterial)armorMaterial);
            return resourceLocation.a(path -> "trims/models/armor/" + path + "_leggings_" + string);
        });
        this.h = SystemUtils.b(armorMaterial -> {
            MinecraftKey resourceLocation = ((TrimPattern)pattern.a()).a();
            String string = this.c((ArmorMaterial)armorMaterial);
            return resourceLocation.a(path -> "trims/models/armor/" + path + "_" + string);
        });
    }

    private String c(ArmorMaterial armorMaterial) {
        Map<EnumArmorMaterial, String> map = this.e.a().d();
        if (armorMaterial instanceof EnumArmorMaterial && map.containsKey(armorMaterial)) {
            return map.get(armorMaterial);
        }
        return this.e.a().a();
    }

    public boolean a(Holder<TrimPattern> pattern, Holder<TrimMaterial> material) {
        return pattern == this.f && material == this.e;
    }

    public Holder<TrimPattern> a() {
        return this.f;
    }

    public Holder<TrimMaterial> b() {
        return this.e;
    }

    public MinecraftKey a(ArmorMaterial armorMaterial) {
        return this.g.apply(armorMaterial);
    }

    public MinecraftKey b(ArmorMaterial armorMaterial) {
        return this.h.apply(armorMaterial);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object object) {
        void armorTrim2;
        if (!(object instanceof ArmorTrim)) {
            return false;
        }
        ArmorTrim armorTrim = (ArmorTrim)object;
        return armorTrim2.f == this.f && armorTrim2.e == this.e;
    }

    public static boolean a(IRegistryCustom registryManager, ItemStack stack, ArmorTrim trim) {
        if (stack.a(TagsItem.aG)) {
            stack.v().a(b, (NBTBase)a.encodeStart(RegistryOps.a(DynamicOpsNBT.a, registryManager), (Object)trim).result().orElseThrow());
            return true;
        }
        return false;
    }

    public static Optional<ArmorTrim> a(IRegistryCustom registryManager, ItemStack stack) {
        if (stack.a(TagsItem.aG) && stack.u() != null && stack.u().e(b)) {
            NBTTagCompound compoundTag = stack.b(b);
            ArmorTrim armorTrim = a.parse(RegistryOps.a(DynamicOpsNBT.a, registryManager), (Object)compoundTag).resultOrPartial(arg_0 -> ((Logger)c).error(arg_0)).orElse(null);
            return Optional.ofNullable(armorTrim);
        }
        return Optional.empty();
    }

    public static void a(ItemStack stack, IRegistryCustom registryManager, List<IChatBaseComponent> tooltip) {
        Optional<ArmorTrim> optional = ArmorTrim.a(registryManager, stack);
        if (optional.isPresent()) {
            ArmorTrim armorTrim = optional.get();
            tooltip.add(d);
            tooltip.add(CommonComponents.a().b(armorTrim.a().a().a(armorTrim.b())));
            tooltip.add(CommonComponents.a().b(armorTrim.b().a().e()));
        }
    }
}

