/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import co.aikar.util.Counter;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.NonNullList;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipes;
import net.minecraft.world.level.World;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftShapelessRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import top.leavesmc.leaves.LeavesConfig;

public class ShapelessRecipes
implements RecipeCrafting {
    private final MinecraftKey a;
    final String b;
    final CraftingBookCategory c;
    final ItemStack d;
    final NonNullList<RecipeItemStack> e;
    private final boolean isBukkit;

    public ShapelessRecipes(MinecraftKey id, String group, CraftingBookCategory category, ItemStack output, NonNullList<RecipeItemStack> input) {
        this(id, group, category, output, input, false);
    }

    public ShapelessRecipes(MinecraftKey id, String group, CraftingBookCategory category, ItemStack output, NonNullList<RecipeItemStack> input, boolean isBukkit) {
        this.a = id;
        this.b = group;
        this.c = category;
        this.d = output;
        this.e = input;
        this.isBukkit = isBukkit;
    }

    public ShapelessRecipe toBukkitRecipe() {
        CraftItemStack result = CraftItemStack.asCraftMirror(this.d);
        CraftShapelessRecipe recipe = new CraftShapelessRecipe(result, this);
        recipe.setGroup(this.b);
        recipe.setCategory(CraftRecipe.getCategory(this.d()));
        for (RecipeItemStack list : this.e) {
            recipe.addIngredient(CraftRecipe.toBukkit(list));
        }
        return recipe;
    }

    @Override
    public MinecraftKey e() {
        return this.a;
    }

    @Override
    public RecipeSerializer<?> ai_() {
        return RecipeSerializer.b;
    }

    @Override
    public String c() {
        return this.b;
    }

    @Override
    public CraftingBookCategory d() {
        return this.c;
    }

    @Override
    public ItemStack a(IRegistryCustom registryManager) {
        return this.d;
    }

    @Override
    public NonNullList<RecipeItemStack> a() {
        return this.e;
    }

    @Override
    public boolean a(InventoryCrafting inventory, World world) {
        if (LeavesConfig.simplerVanillaShapelessRecipes && !this.isBukkit) {
            ArrayList ingredients = Lists.newArrayList((Object[])this.e.toArray(new RecipeItemStack[0]));
            block0: for (int index = 0; index < inventory.b(); ++index) {
                ItemStack itemStack = inventory.a(index);
                if (itemStack.b()) continue;
                for (int i2 = 0; i2 < ingredients.size(); ++i2) {
                    if (!((RecipeItemStack)ingredients.get(i2)).a(itemStack)) continue;
                    ingredients.remove(i2);
                    continue block0;
                }
                return false;
            }
            return ingredients.isEmpty();
        }
        AutoRecipeStackManager autorecipestackmanager = new AutoRecipeStackManager();
        boolean i3 = false;
        ArrayList<ItemStack> providedItems = new ArrayList<ItemStack>();
        Counter matchedProvided = new Counter();
        Counter matchedIngredients = new Counter();
        for (int j2 = 0; j2 < inventory.b(); ++j2) {
            ItemStack itemstack = inventory.a(j2);
            if (itemstack.b()) continue;
            itemstack = itemstack.o();
            providedItems.add(itemstack);
            for (RecipeItemStack ingredient : this.e) {
                if (!ingredient.a(itemstack)) continue;
                matchedProvided.increment((Object)itemstack);
                matchedIngredients.increment((Object)ingredient);
            }
        }
        if (matchedProvided.isEmpty() || matchedIngredients.isEmpty()) {
            return false;
        }
        ArrayList<RecipeItemStack> ingredients = new ArrayList<RecipeItemStack>(this.e);
        providedItems.sort(Comparator.comparingInt(c2 -> (int)matchedProvided.getCount(c2)).reversed());
        ingredients.sort(Comparator.comparingInt(c2 -> (int)matchedIngredients.getCount(c2)));
        block4: for (ItemStack provided : providedItems) {
            Iterator itIngredient = ingredients.iterator();
            while (itIngredient.hasNext()) {
                RecipeItemStack ingredient = (RecipeItemStack)itIngredient.next();
                if (!ingredient.a(provided)) continue;
                itIngredient.remove();
                continue block4;
            }
            return false;
        }
        return ingredients.isEmpty();
    }

    @Override
    public ItemStack a(InventoryCrafting inventory, IRegistryCustom registryManager) {
        return this.d.o();
    }

    @Override
    public boolean a(int width, int height) {
        return width * height >= this.e.size();
    }

    public static class a
    implements RecipeSerializer<ShapelessRecipes> {
        public ShapelessRecipes a(MinecraftKey id, JsonObject json) {
            String s2 = ChatDeserializer.a(json, "group", "");
            CraftingBookCategory craftingbookcategory = CraftingBookCategory.e.a(ChatDeserializer.a(json, "category", (String)null), CraftingBookCategory.d);
            NonNullList<RecipeItemStack> nonnulllist = net.minecraft.world.item.crafting.ShapelessRecipes$a.a(ChatDeserializer.u(json, "ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (nonnulllist.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe");
            }
            ItemStack itemstack = ShapedRecipes.a(ChatDeserializer.t(json, "result"));
            return new ShapelessRecipes(id, s2, craftingbookcategory, itemstack, nonnulllist);
        }

        private static NonNullList<RecipeItemStack> a(JsonArray json) {
            NonNullList<RecipeItemStack> nonnulllist = NonNullList.a();
            for (int i2 = 0; i2 < json.size(); ++i2) {
                RecipeItemStack recipeitemstack = RecipeItemStack.a(json.get(i2));
                if (recipeitemstack.d()) continue;
                nonnulllist.add(recipeitemstack);
            }
            return nonnulllist;
        }

        public ShapelessRecipes a(MinecraftKey id, PacketDataSerializer buf) {
            String s2 = buf.s();
            CraftingBookCategory craftingbookcategory = buf.b(CraftingBookCategory.class);
            int i2 = buf.m();
            NonNullList<RecipeItemStack> nonnulllist = NonNullList.a(i2, RecipeItemStack.a);
            for (int j2 = 0; j2 < nonnulllist.size(); ++j2) {
                nonnulllist.set(j2, RecipeItemStack.b(buf));
            }
            ItemStack itemstack = buf.r();
            return new ShapelessRecipes(id, s2, craftingbookcategory, itemstack, nonnulllist);
        }

        @Override
        public void a(PacketDataSerializer buf, ShapelessRecipes recipe) {
            buf.a(recipe.b);
            buf.a(recipe.c);
            buf.d(recipe.e.size());
            for (RecipeItemStack recipeitemstack : recipe.e) {
                recipeitemstack.a(buf);
            }
            buf.a(recipe.d);
        }
    }
}

