/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheck;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class StructureManager {
    public final GeneratorAccess a;
    private final WorldOptions b;
    private final StructureCheck c;

    public StructureManager(GeneratorAccess world, WorldOptions options, StructureCheck locator) {
        this.a = world;
        this.b = options;
        this.c = locator;
    }

    public StructureManager a(RegionLimitedWorldAccess region) {
        if (region.C() != this.a) {
            throw new IllegalStateException("Using invalid structure manager (source level: " + region.C() + ", region: " + region);
        }
        return new StructureManager(region, this.b, this.c);
    }

    public List<StructureStart> a(ChunkCoordIntPair pos, Predicate<Structure> predicate) {
        return this.startsForStructure(pos, predicate, null);
    }

    public List<StructureStart> startsForStructure(ChunkCoordIntPair pos, Predicate<Structure> predicate, @Nullable WorldAccess levelAccessor) {
        Map<Structure, LongSet> map = (levelAccessor == null ? this.a : levelAccessor).a(pos.e, pos.f, ChunkStatus.e).h();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry<Structure, LongSet> entry : map.entrySet()) {
            Structure structure = entry.getKey();
            if (!predicate.test(structure)) continue;
            this.a(structure, entry.getValue(), arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        }
        return builder.build();
    }

    public List<StructureStart> a(SectionPosition sectionPos, Structure structure) {
        LongSet longSet = this.a.a(sectionPos.a(), sectionPos.c(), ChunkStatus.e).b(structure);
        ImmutableList.Builder builder = ImmutableList.builder();
        this.a(structure, longSet, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    public void a(Structure structure, LongSet structureStartPositions, Consumer<StructureStart> consumer) {
        LongIterator longIterator = structureStartPositions.iterator();
        while (longIterator.hasNext()) {
            long l2 = (Long)longIterator.next();
            SectionPosition sectionPos = SectionPosition.a(new ChunkCoordIntPair(l2), this.a.ak());
            StructureStart structureStart = this.a(sectionPos, structure, this.a.a(sectionPos.a(), sectionPos.c(), ChunkStatus.d));
            if (structureStart == null || !structureStart.b()) continue;
            consumer.accept(structureStart);
        }
    }

    @Nullable
    public StructureStart a(SectionPosition pos, Structure structure, StructureAccess holder) {
        return holder.a(structure);
    }

    public void a(SectionPosition pos, Structure structure, StructureStart structureStart, StructureAccess holder) {
        holder.a(structure, structureStart);
    }

    public void a(SectionPosition pos, Structure structure, long reference, StructureAccess holder) {
        holder.a(structure, reference);
    }

    public boolean a() {
        return this.b.c();
    }

    public StructureStart a(BlockPosition pos, Structure structure) {
        for (StructureStart structureStart : this.a(SectionPosition.a(pos), structure)) {
            if (!structureStart.a().b(pos)) continue;
            return structureStart;
        }
        return StructureStart.b;
    }

    public StructureStart a(BlockPosition pos, ResourceKey<Structure> structure) {
        Structure structure2 = this.b().d(Registries.ax).a(structure);
        return structure2 == null ? StructureStart.b : this.b(pos, structure2);
    }

    public StructureStart a(BlockPosition pos, TagKey<Structure> structureTag) {
        return this.getStructureWithPieceAt(pos, structureTag, null);
    }

    public StructureStart getStructureWithPieceAt(BlockPosition pos, TagKey<Structure> structureTag, @Nullable WorldAccess levelAccessor) {
        IRegistry<Structure> registry = this.b().d(Registries.ax);
        for (StructureStart structureStart : this.startsForStructure(new ChunkCoordIntPair(pos), structure -> registry.c(registry.a((Structure)structure)).map(reference -> reference.a(structureTag)).orElse(false), levelAccessor)) {
            if (!this.a(pos, structureStart)) continue;
            return structureStart;
        }
        return StructureStart.b;
    }

    public StructureStart b(BlockPosition pos, Structure structure) {
        for (StructureStart structureStart : this.a(SectionPosition.a(pos), structure)) {
            if (!this.a(pos, structureStart)) continue;
            return structureStart;
        }
        return StructureStart.b;
    }

    public boolean a(BlockPosition pos, StructureStart structureStart) {
        for (StructurePiece structurePiece : structureStart.i()) {
            if (!structurePiece.f().b(pos)) continue;
            return true;
        }
        return false;
    }

    public boolean a(BlockPosition pos) {
        SectionPosition sectionPos = SectionPosition.a(pos);
        return this.a.a(sectionPos.a(), sectionPos.c(), ChunkStatus.e).w();
    }

    public Map<Structure, LongSet> b(BlockPosition pos) {
        SectionPosition sectionPos = SectionPosition.a(pos);
        return this.a.a(sectionPos.a(), sectionPos.c(), ChunkStatus.e).h();
    }

    public StructureCheckResult a(ChunkCoordIntPair chunkPos, Structure structure, boolean skipExistingChunk) {
        return this.c.a(chunkPos, structure, skipExistingChunk);
    }

    public void a(StructureStart structureStart) {
        structureStart.e();
        this.c.a(structureStart.c(), structureStart.h());
    }

    public IRegistryCustom b() {
        return this.a.u_();
    }
}

