/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.INamable;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.slf4j.Logger;

public class BiomeSettingsGeneration {
    private static final Logger c = LogUtils.getLogger();
    public static final BiomeSettingsGeneration a = new BiomeSettingsGeneration((Map<WorldGenStage.Features, HolderSet<WorldGenCarverWrapper<?>>>)ImmutableMap.of(), (List<HolderSet<PlacedFeature>>)ImmutableList.of());
    public static final MapCodec<BiomeSettingsGeneration> b = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.simpleMap(WorldGenStage.Features.c, (Codec)WorldGenCarverWrapper.c.promotePartial(SystemUtils.a("Carver: ", arg_0 -> ((Logger)c).error(arg_0))), (Keyable)INamable.a(WorldGenStage.Features.values())).fieldOf("carvers").forGetter(generationSettings -> generationSettings.d), (App)PlacedFeature.d.promotePartial(SystemUtils.a("Features: ", arg_0 -> ((Logger)c).error(arg_0))).fieldOf("features").forGetter(generationSettings -> generationSettings.e)).apply((Applicative)instance, BiomeSettingsGeneration::new));
    private final Map<WorldGenStage.Features, HolderSet<WorldGenCarverWrapper<?>>> d;
    private final List<HolderSet<PlacedFeature>> e;
    private final Supplier<List<WorldGenFeatureConfigured<?, ?>>> f;
    private final Supplier<Set<PlacedFeature>> g;

    BiomeSettingsGeneration(Map<WorldGenStage.Features, HolderSet<WorldGenCarverWrapper<?>>> carvers, List<HolderSet<PlacedFeature>> features) {
        this.d = carvers;
        this.e = features;
        this.f = Suppliers.memoize(() -> (List)features.stream().flatMap(HolderSet::a).map(Holder::a).flatMap(PlacedFeature::a).filter(feature -> feature.b() == WorldGenerator.h).collect(ImmutableList.toImmutableList()));
        this.g = Suppliers.memoize(() -> features.stream().flatMap(HolderSet::a).map(Holder::a).collect(Collectors.toSet()));
    }

    public Iterable<Holder<WorldGenCarverWrapper<?>>> a(WorldGenStage.Features carverStep) {
        return Objects.requireNonNullElseGet((Iterable)this.d.get(carverStep), List::of);
    }

    public List<WorldGenFeatureConfigured<?, ?>> a() {
        return this.f.get();
    }

    public List<HolderSet<PlacedFeature>> b() {
        return this.e;
    }

    public boolean a(PlacedFeature feature) {
        return this.g.get().contains(feature);
    }

    public static class a
    extends b {
        private final HolderGetter<PlacedFeature> a;
        private final HolderGetter<WorldGenCarverWrapper<?>> b;

        public a(HolderGetter<PlacedFeature> placedFeatureLookup, HolderGetter<WorldGenCarverWrapper<?>> configuredCarverLookup) {
            this.a = placedFeatureLookup;
            this.b = configuredCarverLookup;
        }

        public a a(WorldGenStage.Decoration featureStep, ResourceKey<PlacedFeature> featureKey) {
            this.a(featureStep.ordinal(), this.a.b(featureKey));
            return this;
        }

        public a a(WorldGenStage.Features carverStep, ResourceKey<WorldGenCarverWrapper<?>> carverKey) {
            this.a(carverStep, this.b.b(carverKey));
            return this;
        }
    }

    public static class b {
        private final Map<WorldGenStage.Features, List<Holder<WorldGenCarverWrapper<?>>>> a = Maps.newLinkedHashMap();
        private final List<List<Holder<PlacedFeature>>> b = Lists.newArrayList();

        public b a(WorldGenStage.Decoration featureStep, Holder<PlacedFeature> featureEntry) {
            return this.a(featureStep.ordinal(), featureEntry);
        }

        public b a(int ordinal, Holder<PlacedFeature> featureEntry) {
            this.a(ordinal);
            this.b.get(ordinal).add(featureEntry);
            return this;
        }

        public b a(WorldGenStage.Features carverStep, Holder<WorldGenCarverWrapper<?>> carverEntry) {
            this.a.computeIfAbsent(carverStep, step -> Lists.newArrayList()).add(carverEntry);
            return this;
        }

        private void a(int size) {
            while (this.b.size() <= size) {
                this.b.add(Lists.newArrayList());
            }
        }

        public BiomeSettingsGeneration a() {
            return new BiomeSettingsGeneration((Map)this.a.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> HolderSet.a((List)entry.getValue()))), (List)this.b.stream().map(HolderSet::a).collect(ImmutableList.toImmutableList()));
        }
    }
}

