/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BigDripleafStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.Tilt;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class BigDripleafBlock
extends BlockFacingHorizontal
implements IBlockFragilePlantElement,
IBlockWaterlogged {
    private static final BlockStateBoolean a = BlockProperties.C;
    private static final BlockStateEnum<Tilt> b = BlockProperties.bl;
    private static final int c = -1;
    private static final Object2IntMap<Tilt> d = (Object2IntMap)SystemUtils.a(new Object2IntArrayMap(), (T object2intarraymap) -> {
        object2intarraymap.defaultReturnValue(-1);
        object2intarraymap.put((Object)Tilt.b, 10);
        object2intarraymap.put((Object)Tilt.c, 10);
        object2intarraymap.put((Object)Tilt.d, 100);
    });
    private static final int e = 5;
    private static final int f = 6;
    private static final int g = 11;
    private static final int h = 13;
    private static final Map<Tilt, VoxelShape> i = ImmutableMap.of((Object)Tilt.a, (Object)Block.a(0.0, 11.0, 0.0, 16.0, 15.0, 16.0), (Object)Tilt.b, (Object)Block.a(0.0, 11.0, 0.0, 16.0, 15.0, 16.0), (Object)Tilt.c, (Object)Block.a(0.0, 11.0, 0.0, 16.0, 13.0, 16.0), (Object)Tilt.d, (Object)VoxelShapes.a());
    private static final VoxelShape j = Block.a(0.0, 13.0, 0.0, 16.0, 16.0, 16.0);
    private static final Map<EnumDirection, VoxelShape> k = ImmutableMap.of((Object)EnumDirection.c, (Object)VoxelShapes.b(BigDripleafStemBlock.a, j, OperatorBoolean.e), (Object)EnumDirection.d, (Object)VoxelShapes.b(BigDripleafStemBlock.b, j, OperatorBoolean.e), (Object)EnumDirection.f, (Object)VoxelShapes.b(BigDripleafStemBlock.c, j, OperatorBoolean.e), (Object)EnumDirection.e, (Object)VoxelShapes.b(BigDripleafStemBlock.d, j, OperatorBoolean.e));
    private final Map<IBlockData, VoxelShape> l;

    protected BigDripleafBlock(BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)((IBlockData)((IBlockData)this.D.b().a(a, false)).a(BlockFacingHorizontal.aD, EnumDirection.c)).a(b, Tilt.a));
        this.l = this.a(BigDripleafBlock::h);
    }

    private static VoxelShape h(IBlockData state) {
        return VoxelShapes.a(i.get(state.c(b)), k.get(state.c(BlockFacingHorizontal.aD)));
    }

    public static void a(GeneratorAccess world, RandomSource random, BlockPosition pos, EnumDirection direction) {
        int j2;
        int i2 = MathHelper.a(random, 2, 5);
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = pos.j();
        for (j2 = 0; j2 < i2 && BigDripleafBlock.a((LevelHeightAccessor)world, (BlockPosition)blockposition_mutableblockposition, world.a_(blockposition_mutableblockposition)); ++j2) {
            blockposition_mutableblockposition.c(EnumDirection.b);
        }
        int k2 = pos.v() + j2 - 1;
        blockposition_mutableblockposition.q(pos.v());
        while (blockposition_mutableblockposition.v() < k2) {
            BigDripleafStemBlock.a(world, (BlockPosition)blockposition_mutableblockposition, world.b_(blockposition_mutableblockposition), direction);
            blockposition_mutableblockposition.c(EnumDirection.b);
        }
        BigDripleafBlock.a(world, (BlockPosition)blockposition_mutableblockposition, world.b_(blockposition_mutableblockposition), direction);
    }

    private static boolean n(IBlockData state) {
        return state.h() || state.a(Blocks.G) || state.a(Blocks.rz);
    }

    protected static boolean a(LevelHeightAccessor world, BlockPosition pos, IBlockData state) {
        return !world.u(pos) && BigDripleafBlock.n(state);
    }

    protected static boolean a(GeneratorAccess world, BlockPosition pos, Fluid fluidState, EnumDirection direction) {
        IBlockData iblockdata = (IBlockData)((IBlockData)Blocks.rx.o().a(a, fluidState.a(FluidTypes.c))).a(BlockFacingHorizontal.aD, direction);
        return world.a(pos, iblockdata, 3);
    }

    @Override
    public void a(World world, IBlockData state, MovingObjectPositionBlock hit, IProjectile projectile) {
        this.setTiltAndScheduleTick(state, world, hit.a(), Tilt.d, SoundEffects.gq, projectile);
    }

    @Override
    public Fluid c_(IBlockData state) {
        return state.c(a) != false ? FluidTypes.c.a(false) : super.c_(state);
    }

    @Override
    public boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        BlockPosition blockposition1 = pos.d();
        IBlockData iblockdata1 = world.a_(blockposition1);
        return iblockdata1.a(this) || iblockdata1.a(Blocks.ry) || iblockdata1.a(TagsBlock.bt);
    }

    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (direction == EnumDirection.a && !state.a(world, pos)) {
            return Blocks.a.o();
        }
        if (state.c(a).booleanValue()) {
            world.a(pos, FluidTypes.c, FluidTypes.c.a(world));
        }
        return direction == EnumDirection.b && neighborState.a(this) ? Blocks.ry.l(state) : super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public boolean a(IWorldReader world, BlockPosition pos, IBlockData state, boolean isClient) {
        IBlockData iblockdata1 = world.a_(pos.c());
        return BigDripleafBlock.n(iblockdata1);
    }

    @Override
    public boolean a(World world, RandomSource random, BlockPosition pos, IBlockData state) {
        return true;
    }

    @Override
    public void a(WorldServer world, RandomSource random, BlockPosition pos, IBlockData state) {
        IBlockData iblockdata1;
        BlockPosition blockposition1 = pos.c();
        if (BigDripleafBlock.a((LevelHeightAccessor)world, blockposition1, iblockdata1 = world.a_(blockposition1))) {
            EnumDirection enumdirection = state.c(BlockFacingHorizontal.aD);
            BigDripleafStemBlock.a((GeneratorAccess)world, pos, state.r(), enumdirection);
            BigDripleafBlock.a((GeneratorAccess)world, blockposition1, iblockdata1.r(), enumdirection);
        }
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(world, pos)).callEvent()) {
            return;
        }
        if (!world.B && state.c(b) == Tilt.a && BigDripleafBlock.a(pos, entity) && !world.r(pos)) {
            PlayerInteractEvent cancellable;
            if (entity instanceof EntityHuman) {
                cancellable = CraftEventFactory.callPlayerInteractEvent((EntityHuman)entity, Action.PHYSICAL, pos, null, null, null);
            } else {
                cancellable = new EntityInteractEvent((Entity)entity.getBukkitEntity(), world.getWorld().getBlockAt(pos.u(), pos.v(), pos.w()));
                world.getCraftServer().getPluginManager().callEvent((Event)((EntityInteractEvent)cancellable));
            }
            if (cancellable.isCancelled()) {
                return;
            }
            this.setTiltAndScheduleTick(state, world, pos, Tilt.b, null, entity);
        }
    }

    @Override
    public void a(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        if (world.r(pos)) {
            BigDripleafBlock.d(state, world, pos);
        } else {
            Tilt tilt = state.c(b);
            if (tilt == Tilt.b) {
                this.setTiltAndScheduleTick(state, world, pos, Tilt.c, SoundEffects.gq, null);
            } else if (tilt == Tilt.c) {
                this.setTiltAndScheduleTick(state, world, pos, Tilt.d, SoundEffects.gq, null);
            } else if (tilt == Tilt.d) {
                BigDripleafBlock.d(state, world, pos);
            }
        }
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, Block sourceBlock, BlockPosition sourcePos, boolean notify) {
        if (world.r(pos)) {
            BigDripleafBlock.d(state, world, pos);
        }
    }

    private static void a(World world, BlockPosition pos, SoundEffect soundEvent) {
        float f2 = MathHelper.b(world.z, 0.8f, 1.2f);
        world.a((EntityHuman)null, pos, soundEvent, SoundCategory.e, 1.0f, f2);
    }

    private static boolean a(BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        return entity.ax() && entity.de().d > (double)((float)pos.v() + 0.6875f);
    }

    private void setTiltAndScheduleTick(IBlockData iblockdata, World world, BlockPosition blockposition, Tilt tilt, @Nullable SoundEffect soundeffect, @Nullable net.minecraft.world.entity.Entity entity) {
        int i2;
        if (!BigDripleafBlock.setTilt(iblockdata, world, blockposition, tilt, entity)) {
            return;
        }
        if (soundeffect != null) {
            BigDripleafBlock.a(world, blockposition, soundeffect);
        }
        if ((i2 = d.getInt((Object)tilt)) != -1) {
            world.a(blockposition, (Block)this, i2);
        }
    }

    private static void d(IBlockData state, World world, BlockPosition pos) {
        BigDripleafBlock.setTilt(state, world, pos, Tilt.a, null);
        if (state.c(b) != Tilt.a) {
            BigDripleafBlock.a(world, pos, SoundEffects.gr);
        }
    }

    private static boolean setTilt(IBlockData iblockdata, World world, BlockPosition blockposition, Tilt tilt, @Nullable net.minecraft.world.entity.Entity entity) {
        if (entity != null && CraftEventFactory.callEntityChangeBlockEvent(entity, blockposition, (IBlockData)iblockdata.a(b, tilt)).isCancelled()) {
            return false;
        }
        Tilt tilt1 = iblockdata.c(b);
        world.a(blockposition, (IBlockData)iblockdata.a(b, tilt), 2);
        if (tilt.a() && tilt != tilt1) {
            world.a((net.minecraft.world.entity.Entity)null, GameEvent.c, blockposition);
        }
        return true;
    }

    @Override
    public VoxelShape c(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return i.get(state.c(b));
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return this.l.get(state);
    }

    @Override
    public IBlockData a(BlockActionContext ctx) {
        IBlockData iblockdata = ctx.q().a_(ctx.a().d());
        Fluid fluid = ctx.q().b_(ctx.a());
        boolean flag = iblockdata.a(Blocks.rx) || iblockdata.a(Blocks.ry);
        return (IBlockData)((IBlockData)this.o().a(a, fluid.a(FluidTypes.c))).a(BlockFacingHorizontal.aD, flag ? iblockdata.c(BlockFacingHorizontal.aD) : ctx.g().g());
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(a, BlockFacingHorizontal.aD, b);
    }
}

