/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemSword;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBamboo;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyBambooSize;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;

public class BlockBambooSapling
extends Block
implements IBlockFragilePlantElement {
    protected static final float a = 4.0f;
    protected static final VoxelShape b = Block.a(4.0, 0.0, 4.0, 12.0, 12.0, 12.0);

    public BlockBambooSapling(BlockBase.Info settings) {
        super(settings);
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        Vec3D vec3d = state.n(world, pos);
        return b.a(vec3d.c, vec3d.d, vec3d.e);
    }

    @Override
    public void b(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        if (random.i() < (float)world.spigotConfig.bambooModifier / 300.0f && world.w(pos.c()) && world.b(pos.c(), 0) >= 9) {
            this.a(world, pos);
        }
    }

    @Override
    public boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        return world.a_(pos.d()).a(TagsBlock.ar);
    }

    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (!state.a(world, pos)) {
            return Blocks.a.o();
        }
        if (direction == EnumDirection.b && neighborState.a(Blocks.mV)) {
            world.a(pos, Blocks.mV.o(), 2);
        }
        return super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public ItemStack a(IBlockAccess world, BlockPosition pos, IBlockData state) {
        return new ItemStack(Items.dt);
    }

    @Override
    public boolean a(IWorldReader world, BlockPosition pos, IBlockData state, boolean isClient) {
        return world.a_(pos.c()).h();
    }

    @Override
    public boolean a(World world, RandomSource random, BlockPosition pos, IBlockData state) {
        return true;
    }

    @Override
    public void a(WorldServer world, RandomSource random, BlockPosition pos, IBlockData state) {
        this.a(world, pos);
    }

    @Override
    public float a(IBlockData state, EntityHuman player, IBlockAccess world, BlockPosition pos) {
        return player.eK().c() instanceof ItemSword ? 1.0f : super.a(state, player, world, pos);
    }

    protected void a(World world, BlockPosition pos) {
        CraftEventFactory.handleBlockSpreadEvent(world, pos, pos.c(), (IBlockData)Blocks.mV.o().a(BlockBamboo.h, BlockPropertyBambooSize.b), 3);
    }
}

