/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.crafting.RecipeCampfire;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCampfire;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.entity.Entity;

public class BlockCampfire
extends BlockTileEntity
implements IBlockWaterlogged {
    protected static final VoxelShape a = Block.a(0.0, 0.0, 0.0, 16.0, 7.0, 16.0);
    public static final BlockStateBoolean b = BlockProperties.r;
    public static final BlockStateBoolean c = BlockProperties.y;
    public static final BlockStateBoolean d = BlockProperties.C;
    public static final BlockStateDirection e = BlockProperties.R;
    private static final VoxelShape f = Block.a(6.0, 0.0, 6.0, 10.0, 16.0, 10.0);
    private static final int g = 5;
    private final boolean h;
    private final int i;

    public BlockCampfire(boolean emitsParticles, int fireDamage, BlockBase.Info settings) {
        super(settings);
        this.h = emitsParticles;
        this.i = fireDamage;
        this.k((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.D.b().a(b, true)).a(c, false)).a(d, false)).a(e, EnumDirection.c));
    }

    @Override
    public EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
        ItemStack itemstack;
        TileEntityCampfire tileentitycampfire;
        Optional<RecipeCampfire> optional;
        TileEntity tileentity = world.c_(pos);
        if (tileentity instanceof TileEntityCampfire && (optional = (tileentitycampfire = (TileEntityCampfire)tileentity).a(itemstack = player.b(hand))).isPresent()) {
            if (!world.B && tileentitycampfire.a(player, player.fK().d ? itemstack.o() : itemstack, optional.get().d())) {
                player.a(StatisticList.av);
                return EnumInteractionResult.a;
            }
            return EnumInteractionResult.b;
        }
        return EnumInteractionResult.d;
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(world, pos)).callEvent()) {
            return;
        }
        if (state.c(b).booleanValue() && entity instanceof EntityLiving && !EnchantmentManager.j((EntityLiving)entity)) {
            CraftEventFactory.blockDamage = CraftBlock.at(world, pos);
            entity.a(world.af().a(), (float)this.i);
            CraftEventFactory.blockDamage = null;
        }
        super.a(state, world, pos, entity);
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, IBlockData newState, boolean moved) {
        if (!state.a(newState.b())) {
            TileEntity tileentity = world.c_(pos);
            if (tileentity instanceof TileEntityCampfire) {
                InventoryUtils.a(world, pos, ((TileEntityCampfire)tileentity).c());
            }
            super.a(state, world, pos, newState, moved);
        }
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext ctx) {
        BlockPosition blockposition;
        World world = ctx.q();
        boolean flag = world.b_(blockposition = ctx.a()).a() == FluidTypes.c;
        return (IBlockData)((IBlockData)((IBlockData)((IBlockData)this.o().a(d, flag)).a(c, this.n(world.a_(blockposition.d())))).a(b, !flag)).a(e, ctx.g());
    }

    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (state.c(d).booleanValue()) {
            world.a(pos, FluidTypes.c, FluidTypes.c.a(world));
        }
        return direction == EnumDirection.a ? (IBlockData)state.a(c, this.n(neighborState)) : super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    private boolean n(IBlockData state) {
        return state.a(Blocks.ii);
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return a;
    }

    @Override
    public EnumRenderType b_(IBlockData state) {
        return EnumRenderType.c;
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, RandomSource random) {
        if (state.c(b).booleanValue()) {
            if (random.a(10) == 0) {
                world.a((double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, SoundEffects.cX, SoundCategory.e, 0.5f + random.i(), random.i() * 0.7f + 0.6f, false);
            }
            if (this.h && random.a(5) == 0) {
                for (int i2 = 0; i2 < random.a(1) + 1; ++i2) {
                    world.a(Particles.V, (double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, (double)(random.i() / 2.0f), 5.0E-5, random.i() / 2.0f);
                }
            }
        }
    }

    public static void a(@Nullable net.minecraft.world.entity.Entity entity, GeneratorAccess world, BlockPosition pos, IBlockData state) {
        TileEntity tileentity;
        if (world.k_()) {
            for (int i2 = 0; i2 < 20; ++i2) {
                BlockCampfire.a((World)world, pos, state.c(c), true);
            }
        }
        if ((tileentity = world.c_(pos)) instanceof TileEntityCampfire) {
            ((TileEntityCampfire)tileentity).f();
        }
        world.a(entity, GameEvent.c, pos);
    }

    @Override
    public boolean a(GeneratorAccess world, BlockPosition pos, IBlockData state, Fluid fluidState) {
        if (!state.c(BlockProperties.C).booleanValue() && fluidState.a() == FluidTypes.c) {
            boolean flag = state.c(b);
            if (flag) {
                if (!world.k_()) {
                    world.a((EntityHuman)null, pos, SoundEffects.iP, SoundCategory.e, 1.0f, 1.0f);
                }
                BlockCampfire.a((net.minecraft.world.entity.Entity)null, world, pos, state);
            }
            world.a(pos, (IBlockData)((IBlockData)state.a(d, true)).a(b, false), 3);
            world.a(pos, fluidState.a(), fluidState.a().a(world));
            return true;
        }
        return false;
    }

    @Override
    public void a(World world, IBlockData state, MovingObjectPositionBlock hit, IProjectile projectile) {
        BlockPosition blockposition = hit.a();
        if (!world.B && projectile.bK() && projectile.a(world, blockposition) && !state.c(b).booleanValue() && !state.c(d).booleanValue()) {
            if (CraftEventFactory.callBlockIgniteEvent(world, blockposition, projectile).isCancelled()) {
                return;
            }
            world.a(blockposition, (IBlockData)state.a(BlockProperties.r, true), 11);
        }
    }

    public static void a(World world, BlockPosition pos, boolean isSignal, boolean lotsOfSmoke) {
        RandomSource randomsource = world.r_();
        ParticleType particletype = isSignal ? Particles.aq : Particles.ap;
        world.b(particletype, true, (double)pos.u() + 0.5 + randomsource.j() / 3.0 * (double)(randomsource.h() ? 1 : -1), (double)pos.v() + randomsource.j() + randomsource.j(), (double)pos.w() + 0.5 + randomsource.j() / 3.0 * (double)(randomsource.h() ? 1 : -1), 0.0, 0.07, 0.0);
        if (lotsOfSmoke) {
            world.a(Particles.ab, (double)pos.u() + 0.5 + randomsource.j() / 4.0 * (double)(randomsource.h() ? 1 : -1), (double)pos.v() + 0.4, (double)pos.w() + 0.5 + randomsource.j() / 4.0 * (double)(randomsource.h() ? 1 : -1), 0.0, 0.005, 0.0);
        }
    }

    public static boolean a(World world, BlockPosition pos) {
        for (int i2 = 1; i2 <= 5; ++i2) {
            BlockPosition blockposition1 = pos.c(i2);
            IBlockData iblockdata = world.a_(blockposition1);
            if (BlockCampfire.g(iblockdata)) {
                return true;
            }
            boolean flag = VoxelShapes.c(f, iblockdata.b((IBlockAccess)world, pos, VoxelShapeCollision.a()), OperatorBoolean.i);
            if (!flag) continue;
            IBlockData iblockdata1 = world.a_(blockposition1.d());
            return BlockCampfire.g(iblockdata1);
        }
        return false;
    }

    public static boolean g(IBlockData state) {
        return state.b(b) && state.a(TagsBlock.aS) && state.c(b) != false;
    }

    @Override
    public Fluid c_(IBlockData state) {
        return state.c(d) != false ? FluidTypes.c.a(false) : super.c_(state);
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.a(e, rotation.a(state.c(e)));
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(e)));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c, d, e);
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityCampfire(pos, state);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World world, IBlockData state, TileEntityTypes<T> type) {
        return world.B ? (state.c(b).booleanValue() ? BlockCampfire.a(type, TileEntityTypes.G, TileEntityCampfire::c) : null) : (state.c(b) != false ? BlockCampfire.a(type, TileEntityTypes.G, TileEntityCampfire::a) : BlockCampfire.a(type, TileEntityTypes.G, TileEntityCampfire::b));
    }

    @Override
    public boolean a(IBlockData state, IBlockAccess world, BlockPosition pos, PathMode type) {
        return false;
    }

    public static boolean h(IBlockData state) {
        return state.a(TagsBlock.aS, (BlockBase.BlockData blockbase_blockdata) -> blockbase_blockdata.b(d) && blockbase_blockdata.b(b)) && state.c(d) == false && state.c(b) == false;
    }
}

