/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.TileInventory;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerEnchantTable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityEnchantTable;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockEnchantmentTable
extends BlockTileEntity {
    protected static final VoxelShape a = Block.a(0.0, 0.0, 0.0, 16.0, 12.0, 16.0);
    public static final List<BlockPosition> b = BlockPosition.a(-2, 0, -2, 2, 1, 2).filter(pos -> Math.abs(pos.u()) == 2 || Math.abs(pos.w()) == 2).map(BlockPosition::i).toList();

    protected BlockEnchantmentTable(BlockBase.Info settings) {
        super(settings);
    }

    public static boolean a(World world, BlockPosition tablePos, BlockPosition bookshelfOffset) {
        return world.a_(tablePos.a(bookshelfOffset)).a(Blocks.ck) && world.w(tablePos.b(bookshelfOffset.u() / 2, bookshelfOffset.v(), bookshelfOffset.w() / 2));
    }

    @Override
    @Override
    public boolean g_(IBlockData state) {
        return true;
    }

    @Override
    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return a;
    }

    @Override
    @Override
    public void a(IBlockData state, World world, BlockPosition pos, RandomSource random) {
        super.a(state, world, pos, random);
        for (BlockPosition blockPos : b) {
            if (random.a(16) != 0 || !BlockEnchantmentTable.a(world, pos, blockPos)) continue;
            world.a(Particles.t, (double)pos.u() + 0.5, (double)pos.v() + 2.0, (double)pos.w() + 0.5, (double)((float)blockPos.u() + random.i()) - 0.5, (double)((float)blockPos.v() - random.i() - 1.0f), (double)((float)blockPos.w() + random.i()) - 0.5);
        }
    }

    @Override
    @Override
    public EnumRenderType b_(IBlockData state) {
        return EnumRenderType.c;
    }

    @Override
    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityEnchantTable(pos, state);
    }

    @Override
    @Nullable
    @Override
    public <T extends TileEntity> BlockEntityTicker<T> a(World world, IBlockData state, TileEntityTypes<T> type) {
        return world.B ? BlockEnchantmentTable.a(type, TileEntityTypes.m, TileEntityEnchantTable::a) : null;
    }

    @Override
    @Override
    public EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
        if (world.B) {
            return EnumInteractionResult.a;
        }
        player.a(state.b(world, pos));
        return EnumInteractionResult.b;
    }

    @Override
    @Nullable
    @Override
    public ITileInventory b(IBlockData state, World world, BlockPosition pos) {
        TileEntity blockEntity = world.c_(pos);
        if (blockEntity instanceof TileEntityEnchantTable) {
            IChatBaseComponent component = ((INamableTileEntity)((Object)blockEntity)).G_();
            return new TileInventory((syncId, inventory, player) -> new ContainerEnchantTable(syncId, inventory, ContainerAccess.a(world, pos)), component);
        }
        return null;
    }

    @Override
    @Override
    public void a(World world, BlockPosition pos, IBlockData state, EntityLiving placer, ItemStack itemStack) {
        TileEntity blockEntity;
        if (itemStack.z() && (blockEntity = world.c_(pos)) instanceof TileEntityEnchantTable) {
            ((TileEntityEnchantTable)blockEntity).a(itemStack.x());
        }
    }

    @Override
    @Override
    public boolean a(IBlockData state, IBlockAccess world, BlockPosition pos, PathMode type) {
        return false;
    }
}

