/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.Particles;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyInstrument;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.bukkit.craftbukkit.v1_19_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.event.block.NotePlayEvent;

public class BlockNote
extends Block {
    public static final BlockStateEnum<BlockPropertyInstrument> a = BlockProperties.bf;
    public static final BlockStateBoolean b = BlockProperties.w;
    public static final BlockStateInteger c = BlockProperties.aR;
    public static final int d = 3;

    public BlockNote(BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)((IBlockData)((IBlockData)this.D.b().a(a, BlockPropertyInstrument.a)).a(c, 0)).a(b, false));
    }

    private static boolean a(GeneratorAccess world) {
        return world.G().b(FeatureFlags.c);
    }

    private IBlockData b(GeneratorAccess world, BlockPosition pos, IBlockData state) {
        if (BlockNote.a(world)) {
            IBlockData iblockdata1 = world.a_(pos.c());
            return (IBlockData)state.a(a, BlockPropertyInstrument.a(iblockdata1).orElseGet(() -> BlockPropertyInstrument.b(world.a_(pos.d()))));
        }
        return (IBlockData)state.a(a, BlockPropertyInstrument.b(world.a_(pos.d())));
    }

    @Override
    public IBlockData a(BlockActionContext ctx) {
        return this.b(ctx.q(), ctx.a(), this.o());
    }

    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        boolean flag = BlockNote.a(world) ? direction.o() == EnumDirection.EnumAxis.b : direction == EnumDirection.a;
        return flag ? this.b(world, pos, state) : super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, Block sourceBlock, BlockPosition sourcePos, boolean notify) {
        boolean flag1 = world.r(pos);
        if (flag1 != state.c(b)) {
            if (flag1) {
                this.a((Entity)null, state, world, pos);
                state = world.a_(pos);
            }
            world.a(pos, (IBlockData)state.a(b, flag1), 3);
        }
    }

    private void a(@Nullable Entity entity, IBlockData state, World world, BlockPosition pos) {
        if (!state.c(a).e() || world.a_(pos.c()).h()) {
            world.a(pos, (Block)this, 0, 0);
            world.a(entity, GameEvent.J, pos);
        }
    }

    @Override
    public EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
        ItemStack itemstack;
        if (BlockNote.a(world) && (itemstack = player.b(hand)).a(TagsItem.aF) && hit.b() == EnumDirection.b) {
            return EnumInteractionResult.d;
        }
        if (world.B) {
            return EnumInteractionResult.a;
        }
        state = (IBlockData)state.a(c);
        world.a(pos, state, 3);
        this.a(player, state, world, pos);
        player.a(StatisticList.ag);
        return EnumInteractionResult.b;
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, EntityHuman player) {
        if (!world.B) {
            this.a(player, state, world, pos);
            player.a(StatisticList.af);
        }
    }

    @Override
    public boolean a(IBlockData state, World world, BlockPosition pos, int type, int data) {
        Holder<SoundEffect> holder;
        float f2;
        BlockPropertyInstrument blockpropertyinstrument = state.c(a);
        NotePlayEvent event = CraftEventFactory.callNotePlayEvent(world, pos, blockpropertyinstrument, state.c(c));
        if (event.isCancelled()) {
            return false;
        }
        if (blockpropertyinstrument.b()) {
            byte k2 = event.getNote().getId();
            f2 = (float)Math.pow(2.0, (double)(k2 - 12) / 12.0);
            world.a(Particles.X, (double)pos.u() + 0.5, (double)pos.v() + 1.2, (double)pos.w() + 0.5, (double)k2 / 24.0, 0.0, 0.0);
        } else {
            f2 = 1.0f;
        }
        if (blockpropertyinstrument.d()) {
            MinecraftKey minecraftkey = this.a(world, pos);
            if (minecraftkey == null) {
                return false;
            }
            holder = Holder.a(SoundEffect.a(minecraftkey));
        } else {
            holder = CraftBlockData.toNMS(event.getInstrument(), BlockPropertyInstrument.class).a();
        }
        world.a((EntityHuman)null, (double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, holder, SoundCategory.c, 3.0f, f2, world.z.g());
        return true;
    }

    @Nullable
    private MinecraftKey a(World world, BlockPosition pos) {
        TileEntity tileentity = world.c_(pos.c());
        if (tileentity instanceof TileEntitySkull) {
            TileEntitySkull tileentityskull = (TileEntitySkull)tileentity;
            return tileentityskull.f();
        }
        return null;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(a, b, c);
    }
}

