/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.jetbrains.annotations.Nullable;

public class DecoratedPotBlock
extends BlockTileEntity {
    private static final VoxelShape a = Block.a(1.0, 0.0, 1.0, 15.0, 16.0, 15.0);
    private static final BlockStateDirection b = BlockProperties.R;
    private static final BlockStateBoolean c = BlockProperties.C;

    protected DecoratedPotBlock(BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)((IBlockData)this.D.b().a(b, EnumDirection.c)).a(c, false));
    }

    @Override
    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (state.c(c).booleanValue()) {
            world.a(pos, FluidTypes.c, FluidTypes.c.a(world));
        }
        return super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    @Override
    public IBlockData a(BlockActionContext ctx) {
        Fluid fluidState = ctx.q().b_(ctx.a());
        return (IBlockData)((IBlockData)this.o().a(b, ctx.g())).a(c, fluidState.a() == FluidTypes.c);
    }

    @Override
    @Override
    public boolean a(IBlockData state, IBlockAccess world, BlockPosition pos, PathMode type) {
        return false;
    }

    @Override
    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return a;
    }

    @Override
    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c);
    }

    @Override
    @Nullable
    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new DecoratedPotBlockEntity(pos, state);
    }

    @Override
    @Override
    public void a(World world, BlockPosition pos, IBlockData state, EntityHuman player) {
        TileEntity tileEntity;
        if (!world.B && (tileEntity = world.c_(pos)) instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity decoratedPotBlockEntity = (DecoratedPotBlockEntity)tileEntity;
            decoratedPotBlockEntity.a(world, pos, player.eK(), player);
        }
        super.a(world, pos, state, player);
    }

    @Override
    @Override
    public void a(IBlockData state, World world, BlockPosition pos, IBlockData newState, boolean moved) {
        DecoratedPotBlockEntity decoratedPotBlockEntity;
        TileEntity blockEntity;
        if (!world.B && (blockEntity = world.c_(pos)) instanceof DecoratedPotBlockEntity && !(decoratedPotBlockEntity = (DecoratedPotBlockEntity)blockEntity).g()) {
            InventoryUtils.a(world, (double)pos.u(), (double)pos.v(), (double)pos.w(), decoratedPotBlockEntity.d());
            world.a(null, pos, SoundEffects.fn, SoundCategory.h, 1.0f, 1.0f);
        }
        super.a(state, world, pos, newState, moved);
    }

    @Override
    @Override
    public Fluid c_(IBlockData state) {
        if (state.c(c).booleanValue()) {
            return FluidTypes.c.a(false);
        }
        return super.c_(state);
    }
}

