/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.SculkSensorBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.SculkSensorPhase;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class SculkSensorBlock
extends BlockTileEntity
implements IBlockWaterlogged {
    public static final int a = 40;
    public static final int b = 1;
    public static final BlockStateEnum<SculkSensorPhase> c = BlockProperties.bo;
    public static final BlockStateInteger d = BlockProperties.aT;
    public static final BlockStateBoolean e = BlockProperties.C;
    protected static final VoxelShape f = Block.a(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    private final int g;

    public SculkSensorBlock(BlockBase.Info settings, int range) {
        super(settings);
        this.k((IBlockData)((IBlockData)((IBlockData)this.D.b().a(c, SculkSensorPhase.a)).a(d, 0)).a(e, false));
        this.g = range;
    }

    public int d() {
        return this.g;
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext ctx) {
        BlockPosition blockposition = ctx.a();
        Fluid fluid = ctx.q().b_(blockposition);
        return (IBlockData)this.o().a(e, fluid.a() == FluidTypes.c);
    }

    @Override
    public Fluid c_(IBlockData state) {
        return state.c(e) != false ? FluidTypes.c.a(false) : super.c_(state);
    }

    @Override
    public void a(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        if (SculkSensorBlock.h(state) != SculkSensorPhase.b) {
            if (SculkSensorBlock.h(state) == SculkSensorPhase.c) {
                world.a(pos, (IBlockData)state.a(c, SculkSensorPhase.a), 3);
            }
        } else {
            SculkSensorBlock.a((World)world, pos, state);
        }
    }

    @Override
    public void a(World world, BlockPosition pos, IBlockData state, net.minecraft.world.entity.Entity entity) {
        if (!world.k_() && SculkSensorBlock.n(state) && entity.ae() != EntityTypes.bi) {
            PlayerInteractEvent cancellable;
            if (entity instanceof EntityHuman) {
                cancellable = CraftEventFactory.callPlayerInteractEvent((EntityHuman)entity, Action.PHYSICAL, pos, null, null, null);
            } else {
                cancellable = new EntityInteractEvent((Entity)entity.getBukkitEntity(), world.getWorld().getBlockAt(pos.u(), pos.v(), pos.w()));
                world.getCraftServer().getPluginManager().callEvent((Event)((EntityInteractEvent)cancellable));
            }
            if (cancellable.isCancelled()) {
                return;
            }
            TileEntity tileentity = world.c_(pos);
            if (tileentity instanceof SculkSensorBlockEntity) {
                SculkSensorBlockEntity sculksensorblockentity = (SculkSensorBlockEntity)tileentity;
                if (world instanceof WorldServer) {
                    WorldServer worldserver = (WorldServer)world;
                    sculksensorblockentity.c().b(worldserver, GameEvent.T, GameEvent.a.a(entity), entity.de());
                }
            }
        }
        super.a(world, pos, state, entity);
    }

    @Override
    public void b(IBlockData state, World world, BlockPosition pos, IBlockData oldState, boolean notify) {
        if (!world.k_() && !state.a(oldState.b())) {
            if (state.c(d) > 0 && !world.K().a(pos, this)) {
                world.a(pos, (IBlockData)state.a(d, 0), 18);
            }
            world.a(new BlockPosition(pos), state.b(), 1);
        }
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, IBlockData newState, boolean moved) {
        if (!state.a(newState.b())) {
            if (SculkSensorBlock.h(state) == SculkSensorPhase.b) {
                SculkSensorBlock.a(world, pos);
            }
            super.a(state, world, pos, newState, moved);
        }
    }

    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (state.c(e).booleanValue()) {
            world.a(pos, FluidTypes.c, FluidTypes.c.a(world));
        }
        return super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    private static void a(World world, BlockPosition pos) {
        world.a(pos, Blocks.qz);
        world.a(pos.a(EnumDirection.b.g()), Blocks.qz);
    }

    @Override
    @Nullable
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new SculkSensorBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public <T extends TileEntity> GameEventListener a(WorldServer world, T blockEntity) {
        return blockEntity instanceof SculkSensorBlockEntity ? ((SculkSensorBlockEntity)blockEntity).c() : null;
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World world, IBlockData state, TileEntityTypes<T> type) {
        return !world.B ? SculkSensorBlock.a(type, TileEntityTypes.I, (World world1, BlockPosition blockposition, IBlockData iblockdata1, ? super E sculksensorblockentity) -> sculksensorblockentity.c().a(world1)) : null;
    }

    @Override
    public EnumRenderType b_(IBlockData state) {
        return EnumRenderType.c;
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return f;
    }

    @Override
    public boolean f_(IBlockData state) {
        return true;
    }

    @Override
    public int a(IBlockData state, IBlockAccess world, BlockPosition pos, EnumDirection direction) {
        return state.c(d);
    }

    public static SculkSensorPhase h(IBlockData state) {
        return state.c(c);
    }

    public static boolean n(IBlockData state) {
        return SculkSensorBlock.h(state) == SculkSensorPhase.a;
    }

    public static void a(World world, BlockPosition pos, IBlockData state) {
        BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent((org.bukkit.block.Block)CraftBlock.at(world, pos), state.c(d).intValue(), 0);
        world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
        if (eventRedstone.getNewCurrent() > 0) {
            world.a(pos, (IBlockData)state.a(d, eventRedstone.getNewCurrent()), 3);
            return;
        }
        world.a(pos, (IBlockData)((IBlockData)state.a(c, SculkSensorPhase.c)).a(d, 0), 3);
        world.a(pos, state.b(), 1);
        if (!state.c(e).booleanValue()) {
            world.a((EntityHuman)null, pos, SoundEffects.ue, SoundCategory.e, 1.0f, world.z.i() * 0.2f + 0.8f);
        }
        SculkSensorBlock.a(world, pos);
    }

    public static void a(@Nullable net.minecraft.world.entity.Entity entity, World world, BlockPosition pos, IBlockData state, int power) {
        BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent((org.bukkit.block.Block)CraftBlock.at(world, pos), state.c(d).intValue(), power);
        world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
        if (eventRedstone.getNewCurrent() <= 0) {
            return;
        }
        power = eventRedstone.getNewCurrent();
        world.a(pos, (IBlockData)((IBlockData)state.a(c, SculkSensorPhase.b)).a(d, power), 3);
        world.a(pos, state.b(), 40);
        SculkSensorBlock.a(world, pos);
        world.a(entity, GameEvent.P, pos);
        if (!state.c(e).booleanValue()) {
            world.a((EntityHuman)null, (double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, SoundEffects.ud, SoundCategory.e, 1.0f, world.z.i() * 0.2f + 0.8f);
        }
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, RandomSource random) {
        EnumDirection enumdirection;
        if (SculkSensorBlock.h(state) == SculkSensorPhase.b && (enumdirection = EnumDirection.b(random)) != EnumDirection.b && enumdirection != EnumDirection.a) {
            double d0 = (double)pos.u() + 0.5 + (enumdirection.j() == 0 ? 0.5 - random.j() : (double)enumdirection.j() * 0.6);
            double d1 = (double)pos.v() + 0.25;
            double d2 = (double)pos.w() + 0.5 + (enumdirection.l() == 0 ? 0.5 - random.j() : (double)enumdirection.l() * 0.6);
            double d3 = (double)random.i() * 0.04;
            world.a(DustColorTransitionOptions.b, d0, d1, d2, 0.0, d3, 0.0);
        }
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(c, d, e);
    }

    @Override
    public boolean d_(IBlockData state) {
        return true;
    }

    @Override
    public int a(IBlockData state, World world, BlockPosition pos) {
        TileEntity tileentity = world.c_(pos);
        if (tileentity instanceof SculkSensorBlockEntity) {
            SculkSensorBlockEntity sculksensorblockentity = (SculkSensorBlockEntity)tileentity;
            return SculkSensorBlock.h(state) == SculkSensorPhase.b ? sculksensorblockentity.d() : 0;
        }
        return 0;
    }

    @Override
    public boolean a(IBlockData state, IBlockAccess world, BlockPosition pos, PathMode type) {
        return false;
    }

    @Override
    public boolean g_(IBlockData state) {
        return true;
    }

    @Override
    public void a(IBlockData state, WorldServer world, BlockPosition pos, ItemStack tool, boolean dropExperience) {
        super.a(state, world, pos, tool, dropExperience);
    }

    @Override
    public int getExpDrop(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, ItemStack itemstack, boolean flag) {
        if (flag) {
            return this.tryDropExperience(worldserver, blockposition, itemstack, ConstantInt.a(5));
        }
        return 0;
    }
}

