/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.SculkBehaviour;
import net.minecraft.world.level.block.SculkVeinBlock;
import net.minecraft.world.level.block.state.IBlockData;
import org.slf4j.Logger;

public class SculkSpreader {
    public static final int a = 24;
    public static final int b = 1000;
    public static final float c = 0.5f;
    private static final int e = 32;
    public static final int d = 11;
    final boolean f;
    private final TagKey<Block> g;
    private final int h;
    private final int i;
    private final int j;
    private final int k;
    private List<a> l = new ArrayList<a>();
    private static final Logger m = LogUtils.getLogger();

    public SculkSpreader(boolean worldGen, TagKey<Block> replaceableTag, int extraBlockChance, int maxDistance, int spreadChance, int decayChance) {
        this.f = worldGen;
        this.g = replaceableTag;
        this.h = extraBlockChance;
        this.i = maxDistance;
        this.j = spreadChance;
        this.k = decayChance;
    }

    public static SculkSpreader a() {
        return new SculkSpreader(false, TagsBlock.bG, 10, 4, 10, 5);
    }

    public static SculkSpreader b() {
        return new SculkSpreader(true, TagsBlock.bH, 50, 1, 5, 10);
    }

    public TagKey<Block> c() {
        return this.g;
    }

    public int d() {
        return this.h;
    }

    public int e() {
        return this.i;
    }

    public int f() {
        return this.j;
    }

    public int g() {
        return this.k;
    }

    public boolean h() {
        return this.f;
    }

    @VisibleForTesting
    public List<a> i() {
        return this.l;
    }

    public void j() {
        this.l.clear();
    }

    public void a(NBTTagCompound nbt) {
        if (nbt.b("cursors", 9)) {
            this.l.clear();
            List list = net.minecraft.world.level.block.SculkSpreader$a.b.listOf().parse(new Dynamic<NBTTagList>(DynamicOpsNBT.a, nbt.c("cursors", 10))).resultOrPartial(arg_0 -> ((Logger)m).error(arg_0)).orElseGet(ArrayList::new);
            int i2 = Math.min(list.size(), 32);
            for (int j2 = 0; j2 < i2; ++j2) {
                this.a((a)list.get(j2));
            }
        }
    }

    public void b(NBTTagCompound nbt) {
        net.minecraft.world.level.block.SculkSpreader$a.b.listOf().encodeStart((DynamicOps)DynamicOpsNBT.a, this.l).resultOrPartial(arg_0 -> ((Logger)m).error(arg_0)).ifPresent(cursorsNbt -> nbt.a("cursors", (NBTBase)cursorsNbt));
    }

    public void a(BlockPosition pos, int charge) {
        while (charge > 0) {
            int i2 = Math.min(charge, 1000);
            this.a(new a(pos, i2));
            charge -= i2;
        }
    }

    private void a(a cursor) {
        if (this.l.size() >= 32) {
            return;
        }
        this.l.add(cursor);
    }

    public void a(GeneratorAccess world, BlockPosition pos2, RandomSource random, boolean shouldConvertToBlock) {
        if (this.l.isEmpty()) {
            return;
        }
        ArrayList<a> list = new ArrayList<a>();
        HashMap<BlockPosition, a> map = new HashMap<BlockPosition, a>();
        Object2IntOpenHashMap object2IntMap = new Object2IntOpenHashMap();
        for (a chargeCursor : this.l) {
            chargeCursor.a(world, pos2, random, this, shouldConvertToBlock);
            if (chargeCursor.e <= 0) {
                world.c(3006, chargeCursor.a(), 0);
                continue;
            }
            BlockPosition blockPos = chargeCursor.a();
            object2IntMap.computeInt((Object)blockPos, (pos, charge) -> (charge == null ? 0 : charge) + chargeCursor.e);
            a chargeCursor2 = (a)map.get(blockPos);
            if (chargeCursor2 == null) {
                map.put(blockPos, chargeCursor);
                list.add(chargeCursor);
                continue;
            }
            if (!this.h() && chargeCursor.e + chargeCursor2.e <= 1000) {
                chargeCursor2.a(chargeCursor);
                continue;
            }
            list.add(chargeCursor);
            if (chargeCursor.e >= chargeCursor2.e) continue;
            map.put(blockPos, chargeCursor);
        }
        for (Object2IntMap.Entry entry : object2IntMap.object2IntEntrySet()) {
            Set<EnumDirection> collection;
            BlockPosition blockPos2 = (BlockPosition)entry.getKey();
            int i2 = entry.getIntValue();
            a chargeCursor3 = (a)map.get(blockPos2);
            Set<EnumDirection> set = collection = chargeCursor3 == null ? null : chargeCursor3.d();
            if (i2 <= 0 || collection == null) continue;
            int j2 = (int)(Math.log1p(i2) / (double)2.3f) + 1;
            int k2 = (j2 << 6) + MultifaceBlock.a(collection);
            world.c(3006, blockPos2, k2);
        }
        this.l = list;
    }

    public static class a {
        private static final ObjectArrayList<BaseBlockPosition> c = SystemUtils.a(new ObjectArrayList(18), objectArrayList -> BlockPosition.b(new BlockPosition(-1, -1, -1), new BlockPosition(1, 1, 1)).filter(pos -> (pos.u() == 0 || pos.v() == 0 || pos.w() == 0) && !pos.equals(BlockPosition.b)).map(BlockPosition::i).forEach(arg_0 -> ((ObjectArrayList)objectArrayList).add(arg_0)));
        public static final int a = 1;
        private BlockPosition d;
        int e;
        private int f;
        private int g;
        @Nullable
        private Set<EnumDirection> h;
        private static final Codec<Set<EnumDirection>> i = EnumDirection.g.listOf().xmap(directions -> Sets.newEnumSet((Iterable)directions, EnumDirection.class), Lists::newArrayList);
        public static final Codec<a> b = RecordCodecBuilder.create(instance -> instance.group((App)BlockPosition.a.fieldOf("pos").forGetter(a::a), (App)Codec.intRange((int)0, (int)1000).fieldOf("charge").orElse((Object)0).forGetter(a::b), (App)Codec.intRange((int)0, (int)1).fieldOf("decay_delay").orElse((Object)1).forGetter(a::c), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("update_delay").orElse((Object)0).forGetter(cursor -> cursor.f), (App)i.optionalFieldOf("facings").forGetter(cursor -> Optional.ofNullable(cursor.d()))).apply((Applicative)instance, a::new));

        private a(BlockPosition pos, int charge, int decay, int update, Optional<Set<EnumDirection>> faces) {
            this.d = pos;
            this.e = charge;
            this.g = decay;
            this.f = update;
            this.h = faces.orElse(null);
        }

        public a(BlockPosition pos, int charge) {
            this(pos, charge, 1, 0, Optional.empty());
        }

        public BlockPosition a() {
            return this.d;
        }

        public int b() {
            return this.e;
        }

        public int c() {
            return this.g;
        }

        @Nullable
        public Set<EnumDirection> d() {
            return this.h;
        }

        private boolean a(GeneratorAccess world, BlockPosition pos, boolean worldGen) {
            if (this.e <= 0) {
                return false;
            }
            if (worldGen) {
                return true;
            }
            if (world instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                return serverLevel.m(pos);
            }
            return false;
        }

        public void a(GeneratorAccess world, BlockPosition pos, RandomSource random, SculkSpreader spreadManager, boolean shouldConvertToBlock) {
            if (!this.a(world, pos, spreadManager.f)) {
                return;
            }
            if (this.f > 0) {
                --this.f;
                return;
            }
            IBlockData blockState = world.a_(this.d);
            SculkBehaviour sculkBehaviour = net.minecraft.world.level.block.SculkSpreader$a.a(blockState);
            if (shouldConvertToBlock && sculkBehaviour.a(world, this.d, blockState, this.h, spreadManager.h())) {
                if (sculkBehaviour.b()) {
                    blockState = world.a_(this.d);
                    sculkBehaviour = net.minecraft.world.level.block.SculkSpreader$a.a(blockState);
                }
                world.a(null, this.d, SoundEffects.tQ, SoundCategory.e, 1.0f, 1.0f);
            }
            this.e = sculkBehaviour.a(this, world, pos, random, spreadManager, shouldConvertToBlock);
            if (this.e <= 0) {
                sculkBehaviour.a(world, blockState, this.d, random);
                return;
            }
            BlockPosition blockPos = net.minecraft.world.level.block.SculkSpreader$a.a(world, this.d, random);
            if (blockPos != null) {
                sculkBehaviour.a(world, blockState, this.d, random);
                this.d = blockPos.i();
                if (spreadManager.h() && !this.d.a(new BaseBlockPosition(pos.u(), this.d.v(), pos.w()), 15.0)) {
                    this.e = 0;
                    return;
                }
                blockState = world.a_(blockPos);
            }
            if (blockState.b() instanceof SculkBehaviour) {
                this.h = MultifaceBlock.h(blockState);
            }
            this.g = sculkBehaviour.i_(this.g);
            this.f = sculkBehaviour.a();
        }

        void a(a cursor) {
            this.e += cursor.e;
            cursor.e = 0;
            this.f = Math.min(this.f, cursor.f);
        }

        private static SculkBehaviour a(IBlockData state) {
            SculkBehaviour sculkBehaviour;
            Block block = state.b();
            return block instanceof SculkBehaviour ? (sculkBehaviour = (SculkBehaviour)((Object)block)) : SculkBehaviour.r_;
        }

        private static List<BaseBlockPosition> a(RandomSource random) {
            return SystemUtils.a(c, random);
        }

        @Nullable
        private static BlockPosition a(GeneratorAccess world, BlockPosition pos, RandomSource random) {
            BlockPosition.MutableBlockPosition mutableBlockPos = pos.j();
            BlockPosition.MutableBlockPosition mutableBlockPos2 = pos.j();
            for (BaseBlockPosition vec3i : net.minecraft.world.level.block.SculkSpreader$a.a(random)) {
                mutableBlockPos2.a((BaseBlockPosition)pos, vec3i);
                IBlockData blockState = world.a_(mutableBlockPos2);
                if (!(blockState.b() instanceof SculkBehaviour) || !net.minecraft.world.level.block.SculkSpreader$a.a(world, pos, mutableBlockPos2)) continue;
                mutableBlockPos.g(mutableBlockPos2);
                if (!SculkVeinBlock.a(world, blockState, mutableBlockPos2)) continue;
                break;
            }
            return mutableBlockPos.equals(pos) ? null : mutableBlockPos;
        }

        private static boolean a(GeneratorAccess world, BlockPosition sourcePos, BlockPosition targetPos) {
            if (sourcePos.k(targetPos) == 1) {
                return true;
            }
            BlockPosition blockPos = targetPos.b(sourcePos);
            EnumDirection direction = EnumDirection.a(EnumDirection.EnumAxis.a, blockPos.u() < 0 ? EnumDirection.EnumAxisDirection.b : EnumDirection.EnumAxisDirection.a);
            EnumDirection direction2 = EnumDirection.a(EnumDirection.EnumAxis.b, blockPos.v() < 0 ? EnumDirection.EnumAxisDirection.b : EnumDirection.EnumAxisDirection.a);
            EnumDirection direction3 = EnumDirection.a(EnumDirection.EnumAxis.c, blockPos.w() < 0 ? EnumDirection.EnumAxisDirection.b : EnumDirection.EnumAxisDirection.a);
            if (blockPos.u() == 0) {
                return net.minecraft.world.level.block.SculkSpreader$a.a(world, sourcePos, direction2) || net.minecraft.world.level.block.SculkSpreader$a.a(world, sourcePos, direction3);
            }
            if (blockPos.v() == 0) {
                return net.minecraft.world.level.block.SculkSpreader$a.a(world, sourcePos, direction) || net.minecraft.world.level.block.SculkSpreader$a.a(world, sourcePos, direction3);
            }
            return net.minecraft.world.level.block.SculkSpreader$a.a(world, sourcePos, direction) || net.minecraft.world.level.block.SculkSpreader$a.a(world, sourcePos, direction2);
        }

        private static boolean a(GeneratorAccess world, BlockPosition pos, EnumDirection direction) {
            BlockPosition blockPos = pos.a(direction);
            return !world.a_(blockPos).d(world, blockPos, direction.g());
        }
    }
}

