/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SculkSensorBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.vibrations.VibrationListener;
import org.slf4j.Logger;

public class SculkSensorBlockEntity
extends TileEntity
implements VibrationListener.a {
    private static final Logger a = LogUtils.getLogger();
    private VibrationListener b;
    public int c;
    private static final String PAPER_LISTENER_RANGE_NBT_KEY = "Paper.ListenerRange";

    public SculkSensorBlockEntity(BlockPosition pos, IBlockData state) {
        super(TileEntityTypes.I, pos, state);
        this.b = new VibrationListener(new BlockPositionSource(this.p), ((SculkSensorBlock)state.b()).d(), this);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.c = nbt.h("last_vibration_frequency");
        if (nbt.b("listener", 10)) {
            VibrationListener.a(this).parse(new Dynamic<NBTTagCompound>(DynamicOpsNBT.a, nbt.p("listener"))).resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)).ifPresent(listener -> {
                this.b = listener;
            });
        }
        if (nbt.e(PAPER_LISTENER_RANGE_NBT_KEY)) {
            this.b.c = nbt.h(PAPER_LISTENER_RANGE_NBT_KEY);
        }
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("last_vibration_frequency", this.c);
        VibrationListener.a(this).encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.b).resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)).ifPresent(listenerNbt -> nbt.a("listener", (NBTBase)listenerNbt));
        if (this.b.c != ((SculkSensorBlock)Blocks.qz).d()) {
            nbt.a(PAPER_LISTENER_RANGE_NBT_KEY, this.b.c);
        }
    }

    public VibrationListener c() {
        return this.b;
    }

    public int d() {
        return this.c;
    }

    @Override
    public boolean w() {
        return true;
    }

    @Override
    public boolean a(WorldServer world, GameEventListener listener, BlockPosition pos, GameEvent event, @Nullable GameEvent.a emitter) {
        return !pos.equals(this.p()) || event != GameEvent.f && event != GameEvent.i ? SculkSensorBlock.n(this.q()) : false;
    }

    @Override
    public void a(WorldServer world, GameEventListener listener, BlockPosition pos, GameEvent event, @Nullable Entity entity, @Nullable Entity sourceEntity, float distance) {
        IBlockData blockState = this.q();
        if (SculkSensorBlock.n(blockState)) {
            this.c = VibrationListener.a(event);
            SculkSensorBlock.a(entity, world, this.p, blockState, SculkSensorBlockEntity.a(distance, listener.b()));
        }
    }

    @Override
    public void f() {
        this.e();
    }

    public static int a(float distance, int range) {
        double d2 = (double)distance / (double)range;
        return Math.max(1, 15 - MathHelper.a(d2 * 15.0));
    }

    public void a(int lastVibrationFrequency) {
        this.c = lastVibrationFrequency;
    }
}

