/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.vibrations.VibrationListener;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class SculkShriekerBlockEntity
extends TileEntity
implements VibrationListener.a {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = 8;
    private static final int c = 10;
    private static final int d = 20;
    private static final int e = 5;
    private static final int f = 6;
    private static final int g = 40;
    private static final Int2ObjectMap<SoundEffect> h = (Int2ObjectMap)SystemUtils.a(new Int2ObjectOpenHashMap(), (T warningSounds) -> {
        warningSounds.put(1, (Object)SoundEffects.zh);
        warningSounds.put(2, (Object)SoundEffects.zi);
        warningSounds.put(3, (Object)SoundEffects.zj);
        warningSounds.put(4, (Object)SoundEffects.zg);
    });
    private static final int i = 90;
    public int j;
    private VibrationListener k;

    public SculkShriekerBlockEntity(BlockPosition pos, IBlockData state) {
        super(TileEntityTypes.K, pos, state);
        this.k = new VibrationListener(new BlockPositionSource(this.p), 8, this);
    }

    public VibrationListener c() {
        return this.k;
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.b("warning_level", 99)) {
            this.j = nbt.h("warning_level");
        }
        if (nbt.b("listener", 10)) {
            VibrationListener.a(this).parse(new Dynamic<NBTTagCompound>(DynamicOpsNBT.a, nbt.p("listener"))).resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)).ifPresent(vibrationListener -> {
                this.k = vibrationListener;
            });
        }
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("warning_level", this.j);
        VibrationListener.a(this).encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.k).resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)).ifPresent(tag -> nbt.a("listener", (NBTBase)tag));
    }

    @Override
    public TagKey<GameEvent> a() {
        return GameEventTags.c;
    }

    @Override
    public boolean a(WorldServer world, GameEventListener listener, BlockPosition pos, GameEvent event, GameEvent.a emitter) {
        return this.q().c(SculkShriekerBlock.a) == false && SculkShriekerBlockEntity.a(emitter.a()) != null;
    }

    @Nullable
    public static EntityPlayer a(@Nullable Entity entity) {
        EntityPlayer player = SculkShriekerBlockEntity.tryGetPlayer0(entity);
        return player != null && player.H == entity.H ? player : null;
    }

    @Nullable
    private static EntityPlayer tryGetPlayer0(@Nullable Entity entity) {
        EntityItem itemEntity;
        Entity var9;
        IProjectile projectile;
        Entity var3;
        EntityLiving serverPlayer4;
        if (entity instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)entity;
            return serverPlayer;
        }
        if (entity != null && (serverPlayer4 = entity.cK()) instanceof EntityPlayer) {
            EntityPlayer serverPlayer2 = (EntityPlayer)serverPlayer4;
            return serverPlayer2;
        }
        if (entity instanceof IProjectile && (var3 = (projectile = (IProjectile)entity).v()) instanceof EntityPlayer) {
            EntityPlayer serverPlayer3 = (EntityPlayer)var3;
            return serverPlayer3;
        }
        if (entity instanceof EntityItem && (var9 = (itemEntity = (EntityItem)entity).v()) instanceof EntityPlayer) {
            EntityPlayer serverPlayer42 = (EntityPlayer)var9;
            return serverPlayer42;
        }
        return null;
    }

    @Override
    public void a(WorldServer world, GameEventListener listener, BlockPosition pos, GameEvent event, @Nullable Entity entity, @Nullable Entity sourceEntity, float distance) {
        this.a(world, SculkShriekerBlockEntity.a(sourceEntity != null ? sourceEntity : entity));
    }

    public void a(WorldServer world, @Nullable EntityPlayer player) {
        IBlockData blockState;
        if (player != null && !(blockState = this.q()).c(SculkShriekerBlock.a).booleanValue()) {
            this.j = 0;
            if (!this.b(world) || this.b(world, player)) {
                this.a(world, (Entity)player);
            }
        }
    }

    private boolean b(WorldServer world, EntityPlayer player) {
        OptionalInt optionalInt = WardenSpawnTracker.a(world, this.p(), player);
        optionalInt.ifPresent(warningLevel -> {
            this.j = warningLevel;
        });
        return optionalInt.isPresent();
    }

    private void a(WorldServer world, @Nullable Entity entity) {
        BlockPosition blockPos = this.p();
        IBlockData blockState = this.q();
        world.a(blockPos, (IBlockData)blockState.a(SculkShriekerBlock.a, true), 2);
        world.a(blockPos, blockState.b(), 90);
        world.c(3007, blockPos, 0);
        world.a(GameEvent.R, blockPos, GameEvent.a.a(entity));
    }

    private boolean b(WorldServer world) {
        return this.q().c(SculkShriekerBlock.c) != false && world.ah() != EnumDifficulty.a && world.W().b(GameRules.I);
    }

    public void a(WorldServer world) {
        if (this.b(world) && this.j > 0) {
            if (!this.c(world)) {
                this.d();
            }
            Warden.a(world, Vec3D.b(this.p()), null, 40);
        }
    }

    private void d() {
        SoundEffect soundEvent = (SoundEffect)h.get(this.j);
        if (soundEvent != null) {
            BlockPosition blockPos = this.p();
            int i2 = blockPos.u() + MathHelper.b(this.o.z, -10, 10);
            int j2 = blockPos.v() + MathHelper.b(this.o.z, -10, 10);
            int k2 = blockPos.w() + MathHelper.b(this.o.z, -10, 10);
            this.o.a((EntityHuman)null, (double)i2, (double)j2, (double)k2, soundEvent, SoundCategory.f, 5.0f, 1.0f);
        }
    }

    private boolean c(WorldServer world) {
        return this.j < 4 ? false : SpawnUtil.a(EntityTypes.bi, EnumMobSpawn.k, world, this.p(), 20, 5, 6, SpawnUtil.a.b).isPresent();
    }

    @Override
    public void f() {
        this.e();
    }
}

