/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class TileEntityConduit
extends TileEntity {
    private static final int b = 2;
    private static final int c = 13;
    private static final float d = -0.0375f;
    private static final int e = 16;
    private static final int f = 42;
    private static final int g = 8;
    private static final Block[] h = new Block[]{Blocks.hY, Blocks.hZ, Blocks.ih, Blocks.ia};
    public int a;
    private float i;
    private boolean j;
    private boolean k;
    private final List<BlockPosition> l = Lists.newArrayList();
    @Nullable
    private EntityLiving m;
    @Nullable
    private UUID n;
    private long r;

    public TileEntityConduit(BlockPosition pos, IBlockData state) {
        super(TileEntityTypes.z, pos, state);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.n = nbt.b("Target") ? nbt.a("Target") : null;
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (this.m != null) {
            nbt.a("Target", this.m.cs());
        }
    }

    public PacketPlayOutTileEntityData c() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    public NBTTagCompound aq_() {
        return this.o();
    }

    public static void a(World world, BlockPosition pos, IBlockData state, TileEntityConduit blockEntity) {
        ++blockEntity.a;
        long i2 = world.U();
        List<BlockPosition> list = blockEntity.l;
        if (i2 % 40L == 0L) {
            blockEntity.j = TileEntityConduit.a(world, pos, list);
            TileEntityConduit.a(blockEntity, list);
        }
        TileEntityConduit.a(world, pos, blockEntity);
        TileEntityConduit.a(world, pos, list, blockEntity.m, blockEntity.a);
        if (blockEntity.d()) {
            blockEntity.i += 1.0f;
        }
    }

    public static void b(World world, BlockPosition pos, IBlockData state, TileEntityConduit blockEntity) {
        ++blockEntity.a;
        long i2 = world.U();
        List<BlockPosition> list = blockEntity.l;
        if (i2 % 40L == 0L) {
            boolean flag = TileEntityConduit.a(world, pos, list);
            if (flag != blockEntity.j) {
                SoundEffect soundeffect = flag ? SoundEffects.eG : SoundEffects.eK;
                world.a((EntityHuman)null, pos, soundeffect, SoundCategory.e, 1.0f, 1.0f);
            }
            blockEntity.j = flag;
            TileEntityConduit.a(blockEntity, list);
            if (flag) {
                TileEntityConduit.b(world, pos, list);
                TileEntityConduit.a(world, pos, state, list, blockEntity);
            }
        }
        if (blockEntity.d()) {
            if (i2 % 80L == 0L) {
                world.a((EntityHuman)null, pos, SoundEffects.eH, SoundCategory.e, 1.0f, 1.0f);
            }
            if (i2 > blockEntity.r) {
                blockEntity.r = i2 + 60L + (long)world.r_().a(40);
                world.a((EntityHuman)null, pos, SoundEffects.eI, SoundCategory.e, 1.0f, 1.0f);
            }
        }
    }

    private static void a(TileEntityConduit blockEntity, List<BlockPosition> activatingBlocks) {
        blockEntity.a(activatingBlocks.size() >= 42);
    }

    private static boolean a(World world, BlockPosition pos, List<BlockPosition> activatingBlocks) {
        int k2;
        int j2;
        int i2;
        activatingBlocks.clear();
        for (i2 = -1; i2 <= 1; ++i2) {
            for (j2 = -1; j2 <= 1; ++j2) {
                for (k2 = -1; k2 <= 1; ++k2) {
                    BlockPosition blockposition1 = pos.b(i2, j2, k2);
                    if (world.B(blockposition1)) continue;
                    return false;
                }
            }
        }
        for (i2 = -2; i2 <= 2; ++i2) {
            for (j2 = -2; j2 <= 2; ++j2) {
                for (k2 = -2; k2 <= 2; ++k2) {
                    int l2 = Math.abs(i2);
                    int i1 = Math.abs(j2);
                    int j1 = Math.abs(k2);
                    if (l2 <= 1 && i1 <= 1 && j1 <= 1 || (i2 != 0 || i1 != 2 && j1 != 2) && (j2 != 0 || l2 != 2 && j1 != 2) && (k2 != 0 || l2 != 2 && i1 != 2)) continue;
                    BlockPosition blockposition2 = pos.b(i2, j2, k2);
                    IBlockData iblockdata = world.a_(blockposition2);
                    for (Block block : h) {
                        if (!iblockdata.a(block)) continue;
                        activatingBlocks.add(blockposition2);
                    }
                }
            }
        }
        return activatingBlocks.size() >= 16;
    }

    private static void b(World world, BlockPosition pos, List<BlockPosition> activatingBlocks) {
        int i1;
        int l2;
        int i2 = activatingBlocks.size();
        int j2 = i2 / 7 * 16;
        int k2 = pos.u();
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(k2, l2 = pos.v(), i1 = pos.w(), k2 + 1, l2 + 1, i1 + 1).g(j2).b(0.0, world.w_(), 0.0);
        List<EntityHuman> list1 = world.a(EntityHuman.class, axisalignedbb);
        if (!list1.isEmpty()) {
            for (EntityHuman entityhuman : list1) {
                if (!pos.a(entityhuman.dg(), (double)j2) || !entityhuman.aU()) continue;
                entityhuman.addEffect(new MobEffect(MobEffects.C, 260, 0, true, true), EntityPotionEffectEvent.Cause.CONDUIT);
            }
        }
    }

    private static void a(World world, BlockPosition pos, IBlockData state, List<BlockPosition> activatingBlocks, TileEntityConduit blockEntity) {
        EntityLiving entityliving = blockEntity.m;
        int i2 = activatingBlocks.size();
        if (i2 < 42) {
            blockEntity.m = null;
        } else if (blockEntity.m == null && blockEntity.n != null) {
            blockEntity.m = TileEntityConduit.a(world, pos, blockEntity.n);
            blockEntity.n = null;
        } else if (blockEntity.m == null) {
            List<EntityLiving> list1 = world.a(EntityLiving.class, TileEntityConduit.a(pos), entityliving1 -> entityliving1 instanceof IMonster && entityliving1.aU());
            if (!list1.isEmpty()) {
                blockEntity.m = list1.get(world.z.a(list1.size()));
            }
        } else if (!blockEntity.m.bq() || !pos.a(blockEntity.m.dg(), 8.0)) {
            blockEntity.m = null;
        }
        if (blockEntity.m != null) {
            CraftEventFactory.blockDamage = CraftBlock.at(world, pos);
            if (blockEntity.m.a(world.af().o(), 4.0f)) {
                world.a((EntityHuman)null, blockEntity.m.dl(), blockEntity.m.dn(), blockEntity.m.dr(), SoundEffects.eJ, SoundCategory.e, 1.0f, 1.0f);
            }
            CraftEventFactory.blockDamage = null;
        }
        if (entityliving != blockEntity.m) {
            world.a(pos, state, state, 2);
        }
    }

    private static void a(World world, BlockPosition pos, TileEntityConduit blockEntity) {
        if (blockEntity.n == null) {
            blockEntity.m = null;
        } else if (blockEntity.m == null || !blockEntity.m.cs().equals(blockEntity.n)) {
            blockEntity.m = TileEntityConduit.a(world, pos, blockEntity.n);
            if (blockEntity.m == null) {
                blockEntity.n = null;
            }
        }
    }

    private static AxisAlignedBB a(BlockPosition pos) {
        int i2 = pos.u();
        int j2 = pos.v();
        int k2 = pos.w();
        return new AxisAlignedBB(i2, j2, k2, i2 + 1, j2 + 1, k2 + 1).g(8.0);
    }

    @Nullable
    private static EntityLiving a(World world, BlockPosition pos, UUID uuid) {
        List<EntityLiving> list = world.a(EntityLiving.class, TileEntityConduit.a(pos), entityliving -> entityliving.cs().equals(uuid));
        return list.size() == 1 ? list.get(0) : null;
    }

    private static void a(World world, BlockPosition pos, List<BlockPosition> activatingBlocks, @Nullable Entity entity, int ticks) {
        float f2;
        RandomSource randomsource = world.z;
        double d0 = MathHelper.a((float)(ticks + 35) * 0.1f) / 2.0f + 0.5f;
        d0 = (d0 * d0 + d0) * (double)0.3f;
        Vec3D vec3d = new Vec3D((double)pos.u() + 0.5, (double)pos.v() + 1.5 + d0, (double)pos.w() + 0.5);
        for (BlockPosition blockposition1 : activatingBlocks) {
            if (randomsource.a(50) != 0) continue;
            BlockPosition blockposition2 = blockposition1.b(pos);
            f2 = -0.5f + randomsource.i() + (float)blockposition2.u();
            float f1 = -2.0f + randomsource.i() + (float)blockposition2.v();
            float f22 = -0.5f + randomsource.i() + (float)blockposition2.w();
            world.a(Particles.an, vec3d.c, vec3d.d, vec3d.e, (double)f2, (double)f1, f22);
        }
        if (entity != null) {
            Vec3D vec3d1 = new Vec3D(entity.dl(), entity.dp(), entity.dr());
            float f3 = (-0.5f + randomsource.i()) * (3.0f + entity.dc());
            float f4 = -1.0f + randomsource.i() * entity.dd();
            f2 = (-0.5f + randomsource.i()) * (3.0f + entity.dc());
            Vec3D vec3d2 = new Vec3D(f3, f4, f2);
            world.a(Particles.an, vec3d1.c, vec3d1.d, vec3d1.e, vec3d2.c, vec3d2.d, vec3d2.e);
        }
    }

    public boolean d() {
        return this.j;
    }

    public boolean f() {
        return this.k;
    }

    private void a(boolean eyeOpen) {
        this.k = eyeOpen;
    }

    public float a(float tickDelta) {
        return (this.i + tickDelta) * -0.0375f;
    }
}

