/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import io.papermc.paper.annotation.DoNotUse;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.IInventoryHolder;
import net.minecraft.world.IWorldInventory;
import net.minecraft.world.InventoryLargeChest;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerHopper;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockHopper;
import net.minecraft.world.level.block.entity.IHopper;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftInventoryDoubleChest;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftMagicNumbers;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.HopperInventorySearchEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.protocol.PcaSyncProtocol;

public class TileEntityHopper
extends TileEntityLootable
implements IHopper {
    public static final int f = 8;
    public static final int g = 5;
    private NonNullList<net.minecraft.world.item.ItemStack> j;
    private int k = -1;
    private long l;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 64;
    private static boolean skipPullModeEventFire;
    private static boolean skipPushModeEventFire;
    public static boolean skipHopperEvents;
    private static final BiPredicate<net.minecraft.world.item.ItemStack, Integer> STACK_SIZE_TEST;
    private static final BiPredicate<net.minecraft.world.item.ItemStack, Integer> IS_EMPTY_TEST;

    @Override
    public List<net.minecraft.world.item.ItemStack> getContents() {
        return this.j;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int ab_() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    public TileEntityHopper(BlockPosition pos, IBlockData state) {
        super(TileEntityTypes.r, pos, state);
        this.j = NonNullList.a(5, net.minecraft.world.item.ItemStack.b);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.j = NonNullList.a(this.b(), net.minecraft.world.item.ItemStack.b);
        if (!this.d(nbt)) {
            ContainerUtil.b(nbt, this.j);
        }
        this.k = nbt.h("TransferCooldown");
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (!this.e(nbt)) {
            ContainerUtil.a(nbt, this.j);
        }
        nbt.a("TransferCooldown", this.k);
    }

    @Override
    public int b() {
        return this.j.size();
    }

    @Override
    public net.minecraft.world.item.ItemStack a(int slot, int amount) {
        this.e((EntityHuman)null);
        return ContainerUtil.a(this.f(), slot, amount);
    }

    @Override
    public void a(int slot, net.minecraft.world.item.ItemStack stack) {
        this.e((EntityHuman)null);
        this.f().set(slot, stack);
        if (stack.K() > this.ab_()) {
            stack.f(this.ab_());
        }
    }

    @Override
    public void e() {
        super.e();
        if (LeavesConfig.pcaSyncProtocol) {
            PcaSyncProtocol.syncBlockEntityToClient(this);
        }
    }

    @Override
    protected IChatBaseComponent g() {
        return IChatBaseComponent.c("container.hopper");
    }

    public static void a(World world, BlockPosition pos, IBlockData state, TileEntityHopper blockEntity) {
        --blockEntity.k;
        blockEntity.l = world.U();
        if (!blockEntity.j()) {
            blockEntity.c(0);
            boolean result = TileEntityHopper.a(world, pos, state, blockEntity, () -> TileEntityHopper.a(world, blockEntity));
            if (!result && blockEntity.o.spigotConfig.hopperCheck > 1) {
                blockEntity.c(blockEntity.o.spigotConfig.hopperCheck);
            }
        }
    }

    private static boolean a(World world, BlockPosition pos, IBlockData state, TileEntityHopper blockEntity, BooleanSupplier booleansupplier) {
        if (world.B) {
            return false;
        }
        if (!blockEntity.j() && state.c(BlockHopper.b).booleanValue()) {
            boolean flag = false;
            if (!blockEntity.aa_()) {
                flag = TileEntityHopper.ejectItems(world, pos, state, blockEntity, blockEntity);
            }
            if (!blockEntity.i()) {
                flag |= booleansupplier.getAsBoolean();
            }
            if (flag) {
                blockEntity.c(world.spigotConfig.hopperTransfer);
                TileEntityHopper.a(world, pos, state);
                if (LeavesConfig.pcaSyncProtocol) {
                    PcaSyncProtocol.syncBlockEntityToClient(blockEntity);
                }
                return true;
            }
        }
        return false;
    }

    private boolean i() {
        net.minecraft.world.item.ItemStack itemstack;
        Iterator iterator = this.j.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while (!(itemstack = (net.minecraft.world.item.ItemStack)iterator.next()).b() && itemstack.K() == itemstack.f());
        return false;
    }

    private static boolean hopperPush(World level, IInventory destination, EnumDirection direction, TileEntityHopper hopper) {
        skipPushModeEventFire = skipHopperEvents;
        boolean foundItem = false;
        for (int i2 = 0; i2 < hopper.b(); ++i2) {
            net.minecraft.world.item.ItemStack origItemStack;
            net.minecraft.world.item.ItemStack item = hopper.a(i2);
            if (item.b()) continue;
            foundItem = true;
            net.minecraft.world.item.ItemStack movedItem = origItemStack = item;
            int originalItemCount = origItemStack.K();
            int movedItemCount = Math.min(level.spigotConfig.hopperAmount, originalItemCount);
            origItemStack.f(movedItemCount);
            if (!skipPushModeEventFire && (movedItem = TileEntityHopper.callPushMoveEvent(destination, movedItem, hopper)) == null) {
                origItemStack.f(originalItemCount);
                return false;
            }
            net.minecraft.world.item.ItemStack remainingItem = TileEntityHopper.a((IInventory)hopper, destination, movedItem, direction);
            int remainingItemCount = remainingItem.K();
            if (remainingItemCount != movedItemCount) {
                origItemStack = origItemStack.copy(true);
                origItemStack.f(originalItemCount);
                if (!origItemStack.b()) {
                    origItemStack.f(originalItemCount - movedItemCount + remainingItemCount);
                }
                hopper.a(i2, origItemStack);
                destination.e();
                return true;
            }
            origItemStack.f(originalItemCount);
        }
        if (foundItem && level.paperConfig().hopper.cooldownWhenFull) {
            hopper.c(level.spigotConfig.hopperTransfer);
        }
        return false;
    }

    private static boolean hopperPull(World level, IHopper hopper, IInventory container, net.minecraft.world.item.ItemStack origItemStack, int i2) {
        net.minecraft.world.item.ItemStack movedItem = origItemStack;
        int originalItemCount = origItemStack.K();
        int movedItemCount = Math.min(level.spigotConfig.hopperAmount, originalItemCount);
        movedItem.f(movedItemCount);
        if (!skipPullModeEventFire && (movedItem = TileEntityHopper.callPullMoveEvent(hopper, container, movedItem)) == null) {
            origItemStack.f(originalItemCount);
            return true;
        }
        net.minecraft.world.item.ItemStack remainingItem = TileEntityHopper.a(container, hopper, movedItem, null);
        int remainingItemCount = remainingItem.K();
        if (remainingItemCount != movedItemCount) {
            origItemStack = origItemStack.copy(true);
            origItemStack.f(originalItemCount);
            if (!origItemStack.b()) {
                origItemStack.f(originalItemCount - movedItemCount + remainingItemCount);
            }
            TileEntity.ignoreTileUpdates = true;
            container.a(i2, origItemStack);
            TileEntity.ignoreTileUpdates = false;
            container.e();
            return true;
        }
        origItemStack.f(originalItemCount);
        if (level.paperConfig().hopper.cooldownWhenFull) {
            TileEntityHopper.cooldownHopper(hopper);
        }
        return false;
    }

    @Nullable
    private static net.minecraft.world.item.ItemStack callPushMoveEvent(IInventory iinventory, net.minecraft.world.item.ItemStack itemstack, TileEntityHopper hopper) {
        Inventory destinationInventory = TileEntityHopper.getInventory(iinventory);
        InventoryMoveItemEvent event = new InventoryMoveItemEvent(hopper.getOwner(false).getInventory(), (ItemStack)CraftItemStack.asCraftMirror(itemstack), destinationInventory, true);
        boolean result = event.callEvent();
        if (!event.calledGetItem && !event.calledSetItem) {
            skipPushModeEventFire = true;
        }
        if (!result) {
            TileEntityHopper.cooldownHopper(hopper);
            return null;
        }
        if (event.calledSetItem) {
            return CraftItemStack.asNMSCopy(event.getItem());
        }
        return itemstack;
    }

    @Nullable
    private static net.minecraft.world.item.ItemStack callPullMoveEvent(IHopper hopper, IInventory container, net.minecraft.world.item.ItemStack itemstack) {
        Inventory sourceInventory = TileEntityHopper.getInventory(container);
        Inventory destination = TileEntityHopper.getInventory(hopper);
        InventoryMoveItemEvent event = new InventoryMoveItemEvent(sourceInventory, (ItemStack)CraftItemStack.asCraftMirror(itemstack), destination, false);
        boolean result = event.callEvent();
        if (!event.calledGetItem && !event.calledSetItem) {
            skipPullModeEventFire = true;
        }
        if (!result) {
            TileEntityHopper.cooldownHopper(hopper);
            return null;
        }
        if (event.calledSetItem) {
            return CraftItemStack.asNMSCopy(event.getItem());
        }
        return itemstack;
    }

    private static Inventory getInventory(IInventory container) {
        CraftInventory sourceInventory;
        if (container instanceof InventoryLargeChest) {
            InventoryLargeChest compoundContainer = (InventoryLargeChest)container;
            sourceInventory = new CraftInventoryDoubleChest(compoundContainer);
        } else if (container instanceof TileEntity) {
            TileEntity blockEntity = (TileEntity)((Object)container);
            sourceInventory = blockEntity.getOwner(false).getInventory();
        } else {
            sourceInventory = container.getOwner() != null ? container.getOwner().getInventory() : new CraftInventory(container);
        }
        return sourceInventory;
    }

    private static void cooldownHopper(IHopper hopper) {
        TileEntityHopper blockEntity;
        if (hopper instanceof TileEntityHopper && (blockEntity = (TileEntityHopper)hopper).k() != null) {
            blockEntity.c(blockEntity.k().spigotConfig.hopperTransfer);
        }
    }

    private static boolean allMatch(IInventory iinventory, EnumDirection enumdirection, BiPredicate<net.minecraft.world.item.ItemStack, Integer> test) {
        if (iinventory instanceof IWorldInventory) {
            for (int i2 : ((IWorldInventory)iinventory).a(enumdirection)) {
                if (test.test(iinventory.a(i2), i2)) continue;
                return false;
            }
        } else {
            int size = iinventory.b();
            for (int i3 = 0; i3 < size; ++i3) {
                if (test.test(iinventory.a(i3), i3)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean anyMatch(IInventory iinventory, EnumDirection enumdirection, BiPredicate<net.minecraft.world.item.ItemStack, Integer> test) {
        if (iinventory instanceof IWorldInventory) {
            for (int i2 : ((IWorldInventory)iinventory).a(enumdirection)) {
                if (!test.test(iinventory.a(i2), i2)) continue;
                return true;
            }
        } else {
            int size = iinventory.b();
            for (int i3 = 0; i3 < size; ++i3) {
                if (!test.test(iinventory.a(i3), i3)) continue;
                return true;
            }
        }
        return true;
    }

    private static boolean ejectItems(World world, BlockPosition blockposition, IBlockData iblockdata, IInventory iinventory, TileEntityHopper hopper) {
        IInventory iinventory1 = TileEntityHopper.b(world, blockposition, iblockdata);
        if (iinventory1 == null) {
            return false;
        }
        EnumDirection enumdirection = iblockdata.c(BlockHopper.a).g();
        if (TileEntityHopper.b(iinventory1, enumdirection)) {
            return false;
        }
        return TileEntityHopper.hopperPush(world, iinventory1, enumdirection, hopper);
    }

    private static IntStream a(IInventory inventory, EnumDirection side) {
        return inventory instanceof IWorldInventory ? IntStream.of(((IWorldInventory)inventory).a(side)) : IntStream.range(0, inventory.b());
    }

    private static boolean b(IInventory inventory, EnumDirection direction) {
        return TileEntityHopper.allMatch(inventory, direction, STACK_SIZE_TEST);
    }

    private static boolean c(IInventory inv, EnumDirection facing) {
        return TileEntityHopper.allMatch(inv, facing, IS_EMPTY_TEST);
    }

    public static boolean a(World world, IHopper hopper) {
        EntityItem entityitem;
        IInventory iinventory = TileEntityHopper.c(world, hopper);
        if (iinventory != null) {
            EnumDirection enumdirection = EnumDirection.a;
            skipPullModeEventFire = skipHopperEvents;
            return !TileEntityHopper.c(iinventory, enumdirection) && TileEntityHopper.anyMatch(iinventory, enumdirection, (item, i2) -> {
                if (!item.b() && TileEntityHopper.a((IInventory)hopper, iinventory, item, i2, enumdirection)) {
                    return TileEntityHopper.hopperPull(world, hopper, iinventory, item, i2);
                }
                return false;
            });
        }
        Iterator<EntityItem> iterator = TileEntityHopper.b(world, hopper).iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!TileEntityHopper.a((IInventory)hopper, entityitem = iterator.next()));
        return true;
    }

    @DoNotUse
    private static boolean a(IHopper ihopper, IInventory iinventory, int i2, EnumDirection enumdirection, World world) {
        net.minecraft.world.item.ItemStack itemstack = iinventory.a(i2);
        if (!itemstack.b() && TileEntityHopper.a((IInventory)ihopper, iinventory, itemstack, i2, enumdirection)) {
            return TileEntityHopper.hopperPull(world, ihopper, iinventory, itemstack, i2);
        }
        return false;
    }

    public static boolean a(IInventory inventory, EntityItem itemEntity) {
        boolean flag = false;
        InventoryPickupItemEvent event = new InventoryPickupItemEvent(TileEntityHopper.getInventory(inventory), (Item)itemEntity.getBukkitEntity());
        itemEntity.H.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        net.minecraft.world.item.ItemStack itemstack = itemEntity.i().o();
        net.minecraft.world.item.ItemStack itemstack1 = TileEntityHopper.a((IInventory)null, inventory, itemstack, (EnumDirection)null);
        if (itemstack1.b()) {
            flag = true;
            itemEntity.ai();
        } else {
            itemEntity.a(itemstack1);
        }
        return flag;
    }

    public static net.minecraft.world.item.ItemStack a(@Nullable IInventory from, IInventory to, net.minecraft.world.item.ItemStack stack, @Nullable EnumDirection side) {
        if (to instanceof IWorldInventory) {
            IWorldInventory iworldinventory = (IWorldInventory)to;
            if (side != null) {
                int[] aint = iworldinventory.a(side);
                for (int i2 = 0; i2 < aint.length && !stack.b(); ++i2) {
                    stack = TileEntityHopper.b(from, to, stack, aint[i2], side);
                }
                return stack;
            }
        }
        int j2 = to.b();
        for (int i3 = 0; i3 < j2 && !stack.b(); ++i3) {
            stack = TileEntityHopper.b(from, to, stack, i3, side);
        }
        return stack;
    }

    private static boolean a(IInventory inventory, net.minecraft.world.item.ItemStack stack, int slot, @Nullable EnumDirection side) {
        IWorldInventory iworldinventory;
        if (!inventory.b(slot, stack)) {
            return false;
        }
        if (inventory instanceof IWorldInventory && !(iworldinventory = (IWorldInventory)inventory).a(slot, stack, side)) {
            boolean flag = false;
            return flag;
        }
        boolean flag = true;
        return flag;
    }

    private static boolean a(IInventory hopperInventory, IInventory fromInventory, net.minecraft.world.item.ItemStack stack, int slot, EnumDirection facing) {
        IWorldInventory iworldinventory;
        if (!fromInventory.a(hopperInventory, slot, stack)) {
            return false;
        }
        if (fromInventory instanceof IWorldInventory && !(iworldinventory = (IWorldInventory)fromInventory).b(slot, stack, facing)) {
            boolean flag = false;
            return flag;
        }
        boolean flag = true;
        return flag;
    }

    private static net.minecraft.world.item.ItemStack b(@Nullable IInventory from, IInventory to, net.minecraft.world.item.ItemStack stack, int slot, @Nullable EnumDirection side) {
        net.minecraft.world.item.ItemStack itemstack1 = to.a(slot);
        if (TileEntityHopper.a(to, stack, slot, side)) {
            boolean flag = false;
            boolean flag1 = to.aa_();
            if (itemstack1.b()) {
                net.minecraft.world.item.ItemStack leftover = net.minecraft.world.item.ItemStack.b;
                if (!stack.b() && stack.K() > to.ab_()) {
                    leftover = stack;
                    stack = stack.a(to.ab_());
                }
                TileEntity.ignoreTileUpdates = true;
                to.a(slot, stack);
                TileEntity.ignoreTileUpdates = false;
                stack = leftover;
                flag = true;
            } else if (TileEntityHopper.a(itemstack1, stack)) {
                int j2 = Math.min(stack.f(), to.ab_()) - itemstack1.K();
                int k2 = Math.min(stack.K(), j2);
                stack.h(k2);
                itemstack1.g(k2);
                boolean bl = flag = k2 > 0;
            }
            if (flag) {
                TileEntityHopper tileentityhopper;
                if (flag1 && to instanceof TileEntityHopper && !(tileentityhopper = (TileEntityHopper)to).v()) {
                    int b0 = 0;
                    if (from instanceof TileEntityHopper) {
                        TileEntityHopper tileentityhopper1 = (TileEntityHopper)from;
                        if (tileentityhopper.l >= tileentityhopper1.l) {
                            b0 = 1;
                        }
                    }
                    tileentityhopper.c(tileentityhopper.o.spigotConfig.hopperTransfer - b0);
                }
                to.e();
            }
        }
        return stack;
    }

    @Nullable
    private static IInventory runHopperInventorySearchEvent(IInventory inventory, CraftBlock hopper, CraftBlock searchLocation, HopperInventorySearchEvent.ContainerType containerType) {
        HopperInventorySearchEvent event = new HopperInventorySearchEvent((Inventory)(inventory != null ? new CraftInventory(inventory) : null), containerType, (org.bukkit.block.Block)hopper, (org.bukkit.block.Block)searchLocation);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        CraftInventory craftInventory = (CraftInventory)event.getInventory();
        return craftInventory != null ? craftInventory.getInventory() : null;
    }

    @Nullable
    private static IInventory b(World world, BlockPosition pos, IBlockData state) {
        EnumDirection enumdirection = state.c(BlockHopper.a);
        BlockPosition searchPosition = pos.a(enumdirection);
        IInventory inventory = TileEntityHopper.a(world, pos.a(enumdirection));
        CraftBlock hopper = CraftBlock.at(world, pos);
        CraftBlock searchBlock = CraftBlock.at(world, searchPosition);
        return TileEntityHopper.runHopperInventorySearchEvent(inventory, hopper, searchBlock, HopperInventorySearchEvent.ContainerType.DESTINATION);
    }

    @Nullable
    private static IInventory c(World world, IHopper hopper) {
        IInventory inventory = TileEntityHopper.a(world, hopper.F(), hopper.G() + 1.0, hopper.I());
        BlockPosition blockPosition = BlockPosition.a(hopper.F(), hopper.G(), hopper.I());
        CraftBlock hopper1 = CraftBlock.at(world, blockPosition);
        CraftBlock container = CraftBlock.at(world, blockPosition.c());
        return TileEntityHopper.runHopperInventorySearchEvent(inventory, hopper1, container, HopperInventorySearchEvent.ContainerType.SOURCE);
    }

    public static List<EntityItem> b(World world, IHopper hopper) {
        double x2 = hopper.F();
        double y2 = hopper.G();
        double z2 = hopper.I();
        AxisAlignedBB bb = new AxisAlignedBB(x2 - 0.5, y2, z2 - 0.5, x2 + 0.5, y2 + 1.5, z2 + 0.5);
        return world.a(EntityItem.class, bb, Entity::bq);
    }

    @Nullable
    public static IInventory a(World world, BlockPosition pos) {
        return TileEntityHopper.getContainerAt(world, (double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, true);
    }

    @Nullable
    private static IInventory a(World world, double x2, double y2, double z2) {
        return TileEntityHopper.getContainerAt(world, x2, y2, z2, false);
    }

    @Nullable
    private static IInventory getContainerAt(World world, double x2, double y2, double z2, boolean optimizeEntities) {
        List<Entity> list;
        TileEntity tileentity;
        IInventory object = null;
        BlockPosition blockposition = BlockPosition.a(x2, y2, z2);
        if (!world.spigotConfig.hopperCanLoadChunks && !world.D(blockposition)) {
            return null;
        }
        IBlockData iblockdata = world.a_(blockposition);
        Block block = iblockdata.b();
        if (block instanceof IInventoryHolder) {
            object = ((IInventoryHolder)((Object)block)).a(iblockdata, world, blockposition);
        } else if (iblockdata.q() && (tileentity = world.c_(blockposition)) instanceof IInventory && (object = (IInventory)((Object)tileentity)) instanceof TileEntityChest && block instanceof BlockChest) {
            object = BlockChest.a((BlockChest)block, iblockdata, world, blockposition, true);
        }
        if (!(object != null || optimizeEntities && world.paperConfig().hopper.ignoreOccludingBlocks && CraftMagicNumbers.getMaterial(block).isOccluding() || (list = world.a((Entity)null, new AxisAlignedBB(x2 - 0.5, y2 - 0.5, z2 - 0.5, x2 + 0.5, y2 + 0.5, z2 + 0.5), IEntitySelector.d)).isEmpty())) {
            object = (IInventory)((Object)list.get(world.z.a(list.size())));
        }
        return object;
    }

    private static boolean a(net.minecraft.world.item.ItemStack first, net.minecraft.world.item.ItemStack second) {
        return first.a(second.c()) && first.j() == second.j() && first.K() < first.f() && net.minecraft.world.item.ItemStack.a(first, second);
    }

    @Override
    public double F() {
        return (double)this.p.u() + 0.5;
    }

    @Override
    public double G() {
        return (double)this.p.v() + 0.5;
    }

    @Override
    public double I() {
        return (double)this.p.w() + 0.5;
    }

    private void c(int transferCooldown) {
        this.k = transferCooldown;
    }

    private boolean j() {
        return this.k > 0;
    }

    private boolean v() {
        return this.k > 8;
    }

    @Override
    protected NonNullList<net.minecraft.world.item.ItemStack> f() {
        return this.j;
    }

    @Override
    protected void a(NonNullList<net.minecraft.world.item.ItemStack> list) {
        this.j = list;
    }

    public static void a(World world, BlockPosition pos, IBlockData state, Entity entity, TileEntityHopper blockEntity) {
        if (entity instanceof EntityItem && VoxelShapes.c(VoxelShapes.a(entity.cD().d(-pos.u(), -pos.v(), -pos.w())), blockEntity.as_(), OperatorBoolean.i)) {
            TileEntityHopper.a(world, pos, state, blockEntity, () -> TileEntityHopper.a((IInventory)blockEntity, (EntityItem)entity));
        }
    }

    @Override
    protected Container a(int syncId, PlayerInventory playerInventory) {
        return new ContainerHopper(syncId, playerInventory, this);
    }

    static {
        STACK_SIZE_TEST = (itemstack, i2) -> itemstack.K() >= itemstack.f();
        IS_EMPTY_TEST = (itemstack, i2) -> itemstack.b();
    }
}

