/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.gson.JsonParseException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.commands.DelegatingCommandSource;
import io.papermc.paper.event.player.PlayerSignCommandPreprocessEvent;
import io.papermc.paper.util.MCUtil;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.FormattedString;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_19_R3.command.CraftBlockCommandSender;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_19_R3.util.LazyPlayerSet;
import org.bukkit.entity.Player;
import org.spigotmc.SpigotConfig;

public class TileEntitySign
extends TileEntity
implements ICommandListener {
    private static final boolean CONVERT_LEGACY_SIGNS = Boolean.getBoolean("convertLegacySigns");
    public static final int a = 4;
    private static final int b = 90;
    private static final int c = 10;
    private static final String[] d = new String[]{"Text1", "Text2", "Text3", "Text4"};
    private static final String[] e = new String[]{"FilteredText1", "FilteredText2", "FilteredText3", "FilteredText4"};
    public final IChatBaseComponent[] f = new IChatBaseComponent[]{CommonComponents.a, CommonComponents.a, CommonComponents.a, CommonComponents.a};
    private final IChatBaseComponent[] g = new IChatBaseComponent[]{CommonComponents.a, CommonComponents.a, CommonComponents.a, CommonComponents.a};
    public boolean h = true;
    @Nullable
    private UUID i;
    @Nullable
    private FormattedString[] j;
    private boolean k;
    private EnumColor l = EnumColor.p;
    private boolean m;
    private static final Logger LOGGER = LogManager.getLogger();

    public TileEntitySign(BlockPosition pos, IBlockData state) {
        super(TileEntityTypes.h, pos, state);
    }

    public TileEntitySign(TileEntityTypes type, BlockPosition pos, IBlockData state) {
        super(type, pos, state);
    }

    public int c() {
        return 10;
    }

    public int d() {
        return 90;
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        super.b(nbt);
        for (int i2 = 0; i2 < 4; ++i2) {
            IChatBaseComponent ichatbasecomponent = this.f[i2];
            String s2 = IChatBaseComponent.ChatSerializer.a(ichatbasecomponent);
            nbt.a(d[i2], s2);
            IChatBaseComponent ichatbasecomponent1 = this.g[i2];
            if (ichatbasecomponent1.equals(ichatbasecomponent)) continue;
            nbt.a(e[i2], IChatBaseComponent.ChatSerializer.a(ichatbasecomponent1));
        }
        if (CONVERT_LEGACY_SIGNS) {
            nbt.a("Bukkit.isConverted", true);
        }
        nbt.a("Color", this.l.b());
        nbt.a("GlowingText", this.m);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        this.h = false;
        super.a(nbt);
        this.l = EnumColor.a(nbt.l("Color"), EnumColor.p);
        boolean oldSign = Boolean.getBoolean("convertLegacySigns") && !nbt.q("Bukkit.isConverted");
        for (int i2 = 0; i2 < 4; ++i2) {
            IChatBaseComponent ichatbasecomponent;
            String s2 = nbt.l(d[i2]);
            if (s2 != null && s2.length() > 2048) {
                s2 = "\"\"";
            }
            if (oldSign && !this.isLoadingStructure) {
                this.f[i2] = CraftChatMessage.fromString(s2)[0];
                continue;
            }
            this.f[i2] = ichatbasecomponent = this.a(s2);
            String s1 = e[i2];
            this.g[i2] = nbt.b(s1, 8) ? this.a(nbt.l(s1)) : ichatbasecomponent;
        }
        this.j = null;
        this.m = nbt.q("GlowingText");
    }

    private IChatBaseComponent a(String json) {
        IChatBaseComponent ichatbasecomponent = this.b(json);
        if (this.o instanceof WorldServer) {
            try {
                return ChatComponentUtils.a(this.b((EntityPlayer)null), ichatbasecomponent, (Entity)null, 0);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        return ichatbasecomponent;
    }

    private IChatBaseComponent b(String json) {
        try {
            IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.ChatSerializer.a(json);
            if (ichatmutablecomponent != null) {
                return ichatmutablecomponent;
            }
        }
        catch (JsonParseException jsonparseexception) {
            return IChatBaseComponent.h();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return CommonComponents.a;
    }

    public IChatBaseComponent a(int row, boolean filtered) {
        return this.c(filtered)[row];
    }

    public void a(int row, IChatBaseComponent text) {
        this.a(row, text, text);
    }

    public void a(int row, IChatBaseComponent text, IChatBaseComponent filteredText) {
        this.f[row] = text;
        this.g[row] = filteredText;
        this.j = null;
    }

    public FormattedString[] a(boolean filterText, Function<IChatBaseComponent, FormattedString> textOrderingFunction) {
        if (this.j == null || this.k != filterText) {
            this.k = filterText;
            this.j = new FormattedString[4];
            for (int i2 = 0; i2 < 4; ++i2) {
                this.j[i2] = textOrderingFunction.apply(this.a(i2, filterText));
            }
        }
        return this.j;
    }

    private IChatBaseComponent[] c(boolean filtered) {
        return filtered ? this.g : this.f;
    }

    public PacketPlayOutTileEntityData f() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    public NBTTagCompound aq_() {
        return this.o();
    }

    @Override
    public boolean t() {
        return true;
    }

    public boolean g() {
        return this.h;
    }

    public void a(boolean editable) {
        this.h = editable;
        if (!editable) {
            this.i = null;
        }
    }

    public void a(UUID editor) {
        this.i = editor;
    }

    @Nullable
    public UUID i() {
        return this.i;
    }

    public boolean a(EntityHuman player) {
        for (IChatBaseComponent ichatbasecomponent : this.c(player.U())) {
            ChatModifier chatmodifier = ichatbasecomponent.a();
            ChatClickable chatclickable = chatmodifier.h();
            if (chatclickable == null || chatclickable.a() != ChatClickable.EnumClickAction.c) continue;
            return true;
        }
        return false;
    }

    public boolean a(EntityPlayer player) {
        for (IChatBaseComponent ichatbasecomponent : this.c(player.U())) {
            PlayerSignCommandPreprocessEvent event;
            Object command;
            ChatModifier chatmodifier = ichatbasecomponent.a();
            ChatClickable chatclickable = chatmodifier.h();
            if (chatclickable == null || chatclickable.a() != ChatClickable.EnumClickAction.c) continue;
            Object object = command = chatclickable.b().startsWith("/") ? chatclickable.b() : "/" + chatclickable.b();
            if (SpigotConfig.logCommands) {
                LOGGER.info("{} issued server command: {}", (Object)player.cu(), command);
            }
            if (!(event = new PlayerSignCommandPreprocessEvent((Player)player.getBukkitEntity(), (String)command, (Set)new LazyPlayerSet(player.cH()), (Sign)MCUtil.toBukkitBlock(this.o, this.p).getState())).callEvent()) {
                return false;
            }
            player.cH().aC().a(this.b(((CraftPlayer)event.getPlayer()).getHandle()), event.getMessage());
        }
        return true;
    }

    @Override
    public void a(IChatBaseComponent message) {
    }

    @Override
    public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
        return wrapper.f() != null ? wrapper.f().getBukkitSender(wrapper) : new CraftBlockCommandSender(wrapper, this);
    }

    @Override
    public boolean d_() {
        return false;
    }

    @Override
    public boolean j_() {
        return false;
    }

    @Override
    public boolean M_() {
        return false;
    }

    public CommandListenerWrapper b(final @Nullable EntityPlayer player) {
        String s2 = player == null ? "Sign" : player.Z().getString();
        IChatBaseComponent object = player == null ? IChatBaseComponent.b("Sign") : player.G_();
        ICommandListener commandSource = this.o.paperConfig().misc.showSignClickCommandFailureMsgsToPlayer ? new DelegatingCommandSource(this){

            @Override
            public void a(IChatBaseComponent message) {
                player.a(message);
            }

            @Override
            public boolean j_() {
                return true;
            }
        } : this;
        return new CommandListenerWrapper(commandSource, Vec3D.b(this.p), Vec2F.a, (WorldServer)this.o, 2, s2, object, this.o.n(), player);
    }

    public EnumColor j() {
        return this.l;
    }

    public boolean a(EnumColor value) {
        if (value != this.j()) {
            this.l = value;
            this.w();
            return true;
        }
        return false;
    }

    public boolean v() {
        return this.m;
    }

    public boolean b(boolean glowingText) {
        if (this.m != glowingText) {
            this.m = glowingText;
            this.w();
            return true;
        }
        return false;
    }

    private void w() {
        this.e();
        if (this.o != null) {
            this.o.a(this.p(), this.q(), this.q(), 3);
        }
    }
}

