/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.types.Type;
import com.mojang.logging.LogUtils;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.HangingSignBlockEntity;
import net.minecraft.world.level.block.entity.SculkCatalystBlockEntity;
import net.minecraft.world.level.block.entity.SculkSensorBlockEntity;
import net.minecraft.world.level.block.entity.SculkShriekerBlockEntity;
import net.minecraft.world.level.block.entity.SuspiciousSandBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBanner;
import net.minecraft.world.level.block.entity.TileEntityBarrel;
import net.minecraft.world.level.block.entity.TileEntityBeacon;
import net.minecraft.world.level.block.entity.TileEntityBed;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.entity.TileEntityBell;
import net.minecraft.world.level.block.entity.TileEntityBlastFurnace;
import net.minecraft.world.level.block.entity.TileEntityBrewingStand;
import net.minecraft.world.level.block.entity.TileEntityCampfire;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.entity.TileEntityChestTrapped;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityComparator;
import net.minecraft.world.level.block.entity.TileEntityConduit;
import net.minecraft.world.level.block.entity.TileEntityDispenser;
import net.minecraft.world.level.block.entity.TileEntityDropper;
import net.minecraft.world.level.block.entity.TileEntityEnchantTable;
import net.minecraft.world.level.block.entity.TileEntityEndGateway;
import net.minecraft.world.level.block.entity.TileEntityEnderChest;
import net.minecraft.world.level.block.entity.TileEntityEnderPortal;
import net.minecraft.world.level.block.entity.TileEntityFurnaceFurnace;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntityJukeBox;
import net.minecraft.world.level.block.entity.TileEntityLectern;
import net.minecraft.world.level.block.entity.TileEntityLightDetector;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.entity.TileEntityShulkerBox;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.entity.TileEntitySmoker;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.piston.TileEntityPiston;
import net.minecraft.world.level.block.state.IBlockData;
import org.slf4j.Logger;

public class TileEntityTypes<T extends TileEntity> {
    private static final Logger O = LogUtils.getLogger();
    public static final TileEntityTypes<TileEntityFurnaceFurnace> a = TileEntityTypes.a("furnace", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityFurnaceFurnace::new, Blocks.cC));
    public static final TileEntityTypes<TileEntityChest> b = TileEntityTypes.a("chest", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityChest::new, Blocks.cu));
    public static final TileEntityTypes<TileEntityChestTrapped> c = TileEntityTypes.a("trapped_chest", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityChestTrapped::new, Blocks.gU));
    public static final TileEntityTypes<TileEntityEnderChest> d = TileEntityTypes.a("ender_chest", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityEnderChest::new, Blocks.fF));
    public static final TileEntityTypes<TileEntityJukeBox> e = TileEntityTypes.a("jukebox", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityJukeBox::new, Blocks.dS));
    public static final TileEntityTypes<TileEntityDispenser> f = TileEntityTypes.a("dispenser", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityDispenser::new, Blocks.aT));
    public static final TileEntityTypes<TileEntityDropper> g = TileEntityTypes.a("dropper", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityDropper::new, Blocks.hh));
    public static final TileEntityTypes<TileEntitySign> h = TileEntityTypes.a("sign", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntitySign::new, Blocks.cD, Blocks.cE, Blocks.cF, Blocks.cG, Blocks.cH, Blocks.cI, Blocks.cJ, Blocks.cQ, Blocks.cR, Blocks.cS, Blocks.cT, Blocks.cU, Blocks.cV, Blocks.cW, Blocks.oS, Blocks.oU, Blocks.oT, Blocks.oV, Blocks.cK, Blocks.cX, Blocks.cL, Blocks.cY));
    public static final TileEntityTypes<HangingSignBlockEntity> i = TileEntityTypes.a("hanging_sign", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(HangingSignBlockEntity::new, Blocks.cZ, Blocks.da, Blocks.db, Blocks.dc, Blocks.dd, Blocks.de, Blocks.df, Blocks.dg, Blocks.dh, Blocks.di, Blocks.dj, Blocks.dk, Blocks.dl, Blocks.dm, Blocks.dn, Blocks.do, Blocks.dp, Blocks.dq, Blocks.ds, Blocks.dt, Blocks.dr, Blocks.du));
    public static final TileEntityTypes<TileEntityMobSpawner> j = TileEntityTypes.a("mob_spawner", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityMobSpawner::new, Blocks.cs));
    public static final TileEntityTypes<TileEntityPiston> k = TileEntityTypes.a("piston", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityPiston::new, Blocks.bP));
    public static final TileEntityTypes<TileEntityBrewingStand> l = TileEntityTypes.a("brewing_stand", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityBrewingStand::new, Blocks.fr));
    public static final TileEntityTypes<TileEntityEnchantTable> m = TileEntityTypes.a("enchanting_table", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityEnchantTable::new, Blocks.fq));
    public static final TileEntityTypes<TileEntityEnderPortal> n = TileEntityTypes.a("end_portal", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityEnderPortal::new, Blocks.fw));
    public static final TileEntityTypes<TileEntityBeacon> o = TileEntityTypes.a("beacon", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityBeacon::new, Blocks.fN));
    public static final TileEntityTypes<TileEntitySkull> p = TileEntityTypes.a("skull", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntitySkull::new, Blocks.gD, Blocks.gE, Blocks.gL, Blocks.gM, Blocks.gN, Blocks.gO, Blocks.gH, Blocks.gI, Blocks.gF, Blocks.gG, Blocks.gJ, Blocks.gK, Blocks.gP, Blocks.gQ));
    public static final TileEntityTypes<TileEntityLightDetector> q = TileEntityTypes.a("daylight_detector", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityLightDetector::new, Blocks.gY));
    public static final TileEntityTypes<TileEntityHopper> r = TileEntityTypes.a("hopper", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityHopper::new, Blocks.hb));
    public static final TileEntityTypes<TileEntityComparator> s = TileEntityTypes.a("comparator", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityComparator::new, Blocks.gX));
    public static final TileEntityTypes<TileEntityBanner> t = TileEntityTypes.a("banner", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityBanner::new, Blocks.iI, Blocks.iJ, Blocks.iK, Blocks.iL, Blocks.iM, Blocks.iN, Blocks.iO, Blocks.iP, Blocks.iQ, Blocks.iR, Blocks.iS, Blocks.iT, Blocks.iU, Blocks.iV, Blocks.iW, Blocks.iX, Blocks.iY, Blocks.iZ, Blocks.ja, Blocks.jb, Blocks.jc, Blocks.jd, Blocks.je, Blocks.jf, Blocks.jg, Blocks.jh, Blocks.ji, Blocks.jj, Blocks.jk, Blocks.jl, Blocks.jm, Blocks.jn));
    public static final TileEntityTypes<TileEntityStructure> u = TileEntityTypes.a("structure_block", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityStructure::new, Blocks.oW));
    public static final TileEntityTypes<TileEntityEndGateway> v = TileEntityTypes.a("end_gateway", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityEndGateway::new, Blocks.kC));
    public static final TileEntityTypes<TileEntityCommand> w = TileEntityTypes.a("command_block", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityCommand::new, Blocks.fM, Blocks.kE, Blocks.kD));
    public static final TileEntityTypes<TileEntityShulkerBox> x = TileEntityTypes.a("shulker_box", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityShulkerBox::new, Blocks.kM, Blocks.lc, Blocks.kY, Blocks.kZ, Blocks.kW, Blocks.kU, Blocks.la, Blocks.kQ, Blocks.kV, Blocks.kS, Blocks.kP, Blocks.kO, Blocks.kT, Blocks.kX, Blocks.lb, Blocks.kN, Blocks.kR));
    public static final TileEntityTypes<TileEntityBed> y = TileEntityTypes.a("bed", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityBed::new, Blocks.bm, Blocks.bn, Blocks.bj, Blocks.bk, Blocks.bh, Blocks.bf, Blocks.bl, Blocks.bb, Blocks.bg, Blocks.bd, Blocks.ba, Blocks.aZ, Blocks.be, Blocks.bi, Blocks.aY, Blocks.bc));
    public static final TileEntityTypes<TileEntityConduit> z = TileEntityTypes.a("conduit", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityConduit::new, Blocks.mT));
    public static final TileEntityTypes<TileEntityBarrel> A = TileEntityTypes.a("barrel", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityBarrel::new, Blocks.nQ));
    public static final TileEntityTypes<TileEntitySmoker> B = TileEntityTypes.a("smoker", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntitySmoker::new, Blocks.nR));
    public static final TileEntityTypes<TileEntityBlastFurnace> C = TileEntityTypes.a("blast_furnace", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityBlastFurnace::new, Blocks.nS));
    public static final TileEntityTypes<TileEntityLectern> D = TileEntityTypes.a("lectern", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityLectern::new, Blocks.nW));
    public static final TileEntityTypes<TileEntityBell> E = TileEntityTypes.a("bell", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityBell::new, Blocks.nZ));
    public static final TileEntityTypes<TileEntityJigsaw> F = TileEntityTypes.a("jigsaw", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityJigsaw::new, Blocks.oX));
    public static final TileEntityTypes<TileEntityCampfire> G = TileEntityTypes.a("campfire", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityCampfire::new, Blocks.oc, Blocks.od));
    public static final TileEntityTypes<TileEntityBeehive> H = TileEntityTypes.a("beehive", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityBeehive::new, Blocks.pa, Blocks.pb));
    public static final TileEntityTypes<SculkSensorBlockEntity> I = TileEntityTypes.a("sculk_sensor", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(SculkSensorBlockEntity::new, Blocks.qz));
    public static final TileEntityTypes<SculkCatalystBlockEntity> J = TileEntityTypes.a("sculk_catalyst", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(SculkCatalystBlockEntity::new, Blocks.qC));
    public static final TileEntityTypes<SculkShriekerBlockEntity> K = TileEntityTypes.a("sculk_shrieker", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(SculkShriekerBlockEntity::new, Blocks.qD));
    public static final TileEntityTypes<ChiseledBookShelfBlockEntity> L = TileEntityTypes.a("chiseled_bookshelf", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(ChiseledBookShelfBlockEntity::new, Blocks.cl));
    public static final TileEntityTypes<SuspiciousSandBlockEntity> M = TileEntityTypes.a("suspicious_sand", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(SuspiciousSandBlockEntity::new, Blocks.J));
    public static final TileEntityTypes<DecoratedPotBlockEntity> N = TileEntityTypes.a("decorated_pot", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(DecoratedPotBlockEntity::new, Blocks.sj));
    private final a<? extends T> P;
    public final Set<Block> Q;
    private final Type<?> R;

    @Nullable
    public static MinecraftKey a(TileEntityTypes<?> type) {
        return BuiltInRegistries.l.b(type);
    }

    private static <T extends TileEntity> TileEntityTypes<T> a(String id, b<T> builder) {
        if (builder.b.isEmpty()) {
            O.warn("Block entity type {} requires at least one valid block to be defined!", (Object)id);
        }
        Type<?> type = SystemUtils.a(DataConverterTypes.l, id);
        return IRegistry.a(BuiltInRegistries.l, id, builder.a(type));
    }

    public TileEntityTypes(a<? extends T> factory, Set<Block> blocks, Type<?> type) {
        this.P = factory;
        this.Q = blocks;
        this.R = type;
    }

    @Nullable
    public T a(BlockPosition pos, IBlockData state) {
        return this.P.create(pos, state);
    }

    public boolean a(IBlockData state) {
        return this.Q.contains(state.b());
    }

    @Nullable
    public T a(IBlockAccess world, BlockPosition pos) {
        TileEntity blockEntity = world.c_(pos);
        if (blockEntity == null || blockEntity.u() != this) {
            return null;
        }
        return (T)blockEntity;
    }

    public static final class b<T extends TileEntity> {
        private final a<? extends T> a;
        final Set<Block> b;

        private b(a<? extends T> factory, Set<Block> blocks) {
            this.a = factory;
            this.b = blocks;
        }

        public static <T extends TileEntity> b<T> a(a<? extends T> factory, Block ... blocks) {
            return new b<T>(factory, (Set<Block>)ImmutableSet.copyOf((Object[])blocks));
        }

        public TileEntityTypes<T> a(Type<?> type) {
            return new TileEntityTypes<T>(this.a, this.b, type);
        }
    }

    @FunctionalInterface
    static interface a<T extends TileEntity> {
        public T create(BlockPosition var1, IBlockData var2);
    }
}

