/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.destroystokyo.paper.antixray.ChunkPacketInfo;
import com.destroystokyo.paper.util.maplist.IBlockDataList;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.util.CollisionUtil;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.QuartPos;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.material.Fluid;

public class ChunkSection {
    public static final int a = 16;
    public static final int b = 16;
    public static final int c = 4096;
    public static final int d = 2;
    private final int e;
    short f;
    private short g;
    private short h;
    public final DataPaletteBlock<IBlockData> i;
    private DataPaletteBlock<Holder<BiomeBase>> biomes;
    public short fluidStateCount;
    public final IBlockDataList tickingList = new IBlockDataList();
    protected int specialCollidingBlocks;
    private long[] knownBlockCollisionData;

    public ChunkSection(int i2, DataPaletteBlock<IBlockData> datapaletteblock, DataPaletteBlock<Holder<BiomeBase>> palettedcontainerro) {
        this.e = ChunkSection.a(i2);
        this.i = datapaletteblock;
        this.biomes = palettedcontainerro;
        this.h();
    }

    @Deprecated
    @DoNotUse
    public ChunkSection(int chunkPos, IRegistry<BiomeBase> biomeRegistry) {
        this(chunkPos, biomeRegistry, null, null);
    }

    public ChunkSection(int chunkPos, IRegistry<BiomeBase> biomeRegistry, ChunkCoordIntPair pos, World level) {
        this.e = ChunkSection.a(chunkPos);
        this.i = new DataPaletteBlock<IBlockData>(Block.o, Blocks.a.o(), DataPaletteBlock.d.d, level == null || level.chunkPacketBlockController == null ? null : level.chunkPacketBlockController.getPresetBlockStates(level, pos, this.g()));
        this.biomes = new DataPaletteBlock<Holder.c<BiomeBase>>(biomeRegistry.t(), biomeRegistry.f(Biomes.b), DataPaletteBlock.d.e, null);
    }

    private long[] initKnownDataField() {
        this.knownBlockCollisionData = new long[128];
        return this.knownBlockCollisionData;
    }

    public final boolean hasSpecialCollidingBlocks() {
        return this.specialCollidingBlocks != 0;
    }

    public static long getKnownBlockInfo(int blockIndex, long value) {
        int valueShift = blockIndex & 0x1F;
        return value >>> (valueShift << 1) & 3L;
    }

    public final long getKnownBlockInfo(int blockIndex) {
        if (this.knownBlockCollisionData == null) {
            return 0L;
        }
        int arrayIndex = blockIndex >>> 5;
        int valueShift = blockIndex & 0x1F;
        long value = this.knownBlockCollisionData[arrayIndex];
        return value >>> (valueShift << 1) & 3L;
    }

    public final long getKnownBlockInfoHorizontalRaw(int localY, int localZ) {
        if (this.knownBlockCollisionData == null) {
            return 0L;
        }
        int horizontalIndex = localZ << 4 | localY << 8;
        return this.knownBlockCollisionData[horizontalIndex >>> 5];
    }

    private void initBlockCollisionData() {
        this.specialCollidingBlocks = 0;
        if (this.f == 0) {
            this.knownBlockCollisionData = null;
            return;
        }
        this.initKnownDataField();
        for (int index = 0; index < 4096; ++index) {
            IBlockData state = this.i.a(index);
            this.setKnownBlockInfo(index, state);
            if (!CollisionUtil.isSpecialCollidingBlock(state)) continue;
            ++this.specialCollidingBlocks;
        }
    }

    private void setKnownBlockInfo(int blockIndex, IBlockData blockState) {
        int arrayIndex = blockIndex >>> 5;
        int valueShift = (blockIndex & 0x1F) << 1;
        long value = this.knownBlockCollisionData[arrayIndex];
        value &= 3L << valueShift ^ 0xFFFFFFFFFFFFFFFFL;
        this.knownBlockCollisionData[arrayIndex] = value |= blockState.getBlockCollisionBehavior() << valueShift;
    }

    public void updateKnownBlockInfo(int blockIndex, IBlockData from, IBlockData to) {
        if (CollisionUtil.isSpecialCollidingBlock(from)) {
            --this.specialCollidingBlocks;
        }
        if (CollisionUtil.isSpecialCollidingBlock(to)) {
            ++this.specialCollidingBlocks;
        }
        if (this.f == 0) {
            this.knownBlockCollisionData = null;
            return;
        }
        if (this.knownBlockCollisionData == null) {
            this.initKnownDataField();
        }
        int arrayIndex = blockIndex >>> 5;
        int valueShift = (blockIndex & 0x1F) << 1;
        long value = this.knownBlockCollisionData[arrayIndex];
        value &= 3L << valueShift ^ 0xFFFFFFFFFFFFFFFFL;
        this.knownBlockCollisionData[arrayIndex] = value |= to.getBlockCollisionBehavior() << valueShift;
    }

    public static int a(int chunkPos) {
        return chunkPos << 4;
    }

    public IBlockData a(int x2, int y2, int z2) {
        return this.i.a(x2, y2, z2);
    }

    public Fluid b(int x2, int y2, int z2) {
        return this.i.a(x2, y2, z2).r();
    }

    public void a() {
        this.i.a();
    }

    public void b() {
        this.i.b();
    }

    public IBlockData a(int x2, int y2, int z2, IBlockData state) {
        return this.a(x2, y2, z2, state, true);
    }

    public IBlockData a(int x2, int y2, int z2, IBlockData state, boolean lock) {
        IBlockData iblockdata1 = lock ? this.i.a(x2, y2, z2, state) : this.i.b(x2, y2, z2, state);
        Fluid fluid = iblockdata1.r();
        Fluid fluid1 = state.r();
        if (!iblockdata1.h()) {
            this.f = (short)(this.f - 1);
            if (iblockdata1.s()) {
                this.g = (short)(this.g - 1);
                this.tickingList.remove(x2, y2, z2);
            }
        }
        if (!fluid.c()) {
            this.h = (short)(this.h - 1);
            this.fluidStateCount = (short)(this.fluidStateCount - 1);
        }
        if (!state.h()) {
            this.f = (short)(this.f + 1);
            if (state.s()) {
                this.g = (short)(this.g + 1);
                this.tickingList.add(x2, y2, z2, state);
            }
        }
        if (!fluid1.c()) {
            this.h = (short)(this.h + 1);
            this.fluidStateCount = (short)(this.fluidStateCount - 1);
        }
        this.updateKnownBlockInfo(x2 | z2 << 4 | y2 << 8, iblockdata1, state);
        return iblockdata1;
    }

    public boolean c() {
        return this.f == 0;
    }

    public boolean d() {
        return this.e() || this.f();
    }

    public boolean e() {
        return this.g > 0;
    }

    public boolean f() {
        return this.h > 0;
    }

    public int g() {
        return this.e;
    }

    public void h() {
        this.tickingList.clear();
        this.f = 0;
        this.g = 0;
        this.h = 0;
        this.i.forEachLocation((iblockdata, i2) -> {
            Fluid fluid = iblockdata.r();
            if (!iblockdata.h()) {
                this.f = (short)(this.f + 1);
                if (iblockdata.s()) {
                    this.g = (short)(this.g + 1);
                    this.tickingList.add(i2, (IBlockData)iblockdata);
                }
            }
            if (!fluid.c()) {
                this.f = (short)(this.f + 1);
                if (fluid.f()) {
                    this.h = (short)(this.h + 1);
                }
                this.fluidStateCount = (short)(this.fluidStateCount + 1);
            }
        });
        this.initBlockCollisionData();
    }

    public DataPaletteBlock<IBlockData> i() {
        return this.i;
    }

    public PalettedContainerRO<Holder<BiomeBase>> j() {
        return this.biomes;
    }

    public void a(PacketDataSerializer buf) {
        this.f = buf.readShort();
        this.i.a(buf);
        DataPaletteBlock<Holder<BiomeBase>> datapaletteblock = this.biomes.e();
        datapaletteblock.a(buf);
        this.biomes = datapaletteblock;
    }

    public void b(PacketDataSerializer buf) {
        DataPaletteBlock<Holder<BiomeBase>> datapaletteblock = this.biomes.e();
        datapaletteblock.a(buf);
        this.biomes = datapaletteblock;
    }

    @Deprecated
    @DoNotUse
    public void c(PacketDataSerializer buf) {
        this.write(buf, null);
    }

    public void write(PacketDataSerializer buf, ChunkPacketInfo<IBlockData> chunkPacketInfo) {
        buf.writeShort(this.f);
        this.i.write(buf, chunkPacketInfo, this.g());
        this.biomes.write(buf, null, this.g());
    }

    public int k() {
        return 2 + this.i.c() + this.biomes.c();
    }

    public boolean a(Predicate<IBlockData> predicate) {
        return this.i.a(predicate);
    }

    public Holder<BiomeBase> c(int x2, int y2, int z2) {
        return this.biomes.a(x2, y2, z2);
    }

    public void setBiome(int i2, int j2, int k2, Holder<BiomeBase> biome) {
        this.biomes.c(i2, j2, k2, biome);
    }

    public void a(BiomeResolver biomeSupplier, Climate.Sampler sampler, int x2, int z2) {
        DataPaletteBlock<Holder<BiomeBase>> datapaletteblock = this.biomes.e();
        int k2 = QuartPos.a(this.g());
        boolean flag = true;
        for (int l2 = 0; l2 < 4; ++l2) {
            for (int i1 = 0; i1 < 4; ++i1) {
                for (int j1 = 0; j1 < 4; ++j1) {
                    datapaletteblock.b(l2, i1, j1, biomeSupplier.getNoiseBiome(x2 + l2, k2 + i1, z2 + j1, sampler));
                }
            }
        }
        this.biomes = datapaletteblock;
    }
}

