/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.profiling.jfr.callback.ProfiledDuration;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class ChunkStatus {
    public boolean isParallelCapable;
    public int writeRadius = -1;
    public int loadRange = 0;
    protected static final List<ChunkStatus> statuses = new ArrayList<ChunkStatus>();
    private ChunkStatus nextStatus;
    public final AtomicBoolean warnedAboutNoImmediateComplete = new AtomicBoolean();
    public static final int a = 8;
    private static final EnumSet<HeightMap.Type> p = EnumSet.of(HeightMap.Type.c, HeightMap.Type.a);
    public static final EnumSet<HeightMap.Type> b = EnumSet.of(HeightMap.Type.d, HeightMap.Type.b, HeightMap.Type.e, HeightMap.Type.f);
    private static final c q = (chunkstatus, worldserver, structuretemplatemanager, lightenginethreaded, function, ichunkaccess) -> {
        if (ichunkaccess instanceof ProtoChunk) {
            ProtoChunk protochunk = (ProtoChunk)ichunkaccess;
            if (!ichunkaccess.j().b(chunkstatus)) {
                protochunk.a(chunkstatus);
            }
        }
        return CompletableFuture.completedFuture(Either.left(ichunkaccess));
    };
    public static final ChunkStatus c = ChunkStatus.a("empty", (ChunkStatus)null, -1, p, Type.a, (ChunkStatus chunkstatus, WorldServer worldserver, ChunkGenerator chunkgenerator, List<IChunkAccess> list, IChunkAccess ichunkaccess) -> {});
    public static final ChunkStatus d = ChunkStatus.a("structure_starts", c, 0, p, Type.a, (chunkstatus, executor, worldserver, chunkgenerator, structuretemplatemanager, lightenginethreaded, function, list, ichunkaccess, flag) -> {
        if (!ichunkaccess.j().b(chunkstatus)) {
            if (worldserver.J.A().c()) {
                chunkgenerator.a(worldserver.u_(), worldserver.k().h(), worldserver.a(), ichunkaccess, structuretemplatemanager);
            }
            if (ichunkaccess instanceof ProtoChunk) {
                ProtoChunk protochunk = (ProtoChunk)ichunkaccess;
                protochunk.a(chunkstatus);
            }
            worldserver.a(ichunkaccess);
        }
        return CompletableFuture.completedFuture(Either.left(ichunkaccess));
    }, (chunkstatus, worldserver, structuretemplatemanager, lightenginethreaded, function, ichunkaccess) -> {
        if (!ichunkaccess.j().b(chunkstatus)) {
            if (ichunkaccess instanceof ProtoChunk) {
                ProtoChunk protochunk = (ProtoChunk)ichunkaccess;
                protochunk.a(chunkstatus);
            }
            worldserver.a(ichunkaccess);
        }
        return CompletableFuture.completedFuture(Either.left(ichunkaccess));
    });
    public static final ChunkStatus e = ChunkStatus.a("structure_references", d, 8, p, Type.a, (ChunkStatus chunkstatus, WorldServer worldserver, ChunkGenerator chunkgenerator, List<IChunkAccess> list, IChunkAccess ichunkaccess) -> {
        RegionLimitedWorldAccess regionlimitedworldaccess = new RegionLimitedWorldAccess(worldserver, list, chunkstatus, -1);
        chunkgenerator.a((GeneratorAccessSeed)regionlimitedworldaccess, worldserver.a().a(regionlimitedworldaccess), ichunkaccess);
    });
    public static final ChunkStatus f = ChunkStatus.a("biomes", e, 8, p, Type.a, (ChunkStatus chunkstatus, Executor executor, WorldServer worldserver, ChunkGenerator chunkgenerator, StructureTemplateManager structuretemplatemanager, LightEngineThreaded lightenginethreaded, Function<IChunkAccess, CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>>> function, List<IChunkAccess> list, IChunkAccess ichunkaccess, boolean flag) -> {
        if (!flag && ichunkaccess.j().b(chunkstatus)) {
            return CompletableFuture.completedFuture(Either.left(ichunkaccess));
        }
        RegionLimitedWorldAccess regionlimitedworldaccess = new RegionLimitedWorldAccess(worldserver, list, chunkstatus, -1);
        return chunkgenerator.a(executor, worldserver.k().i(), Blender.a(regionlimitedworldaccess), worldserver.a().a(regionlimitedworldaccess), ichunkaccess).thenApply(ichunkaccess1 -> {
            if (ichunkaccess1 instanceof ProtoChunk) {
                ((ProtoChunk)ichunkaccess1).a(chunkstatus);
            }
            return Either.left(ichunkaccess1);
        });
    });
    public static final ChunkStatus g = ChunkStatus.a("noise", f, 8, p, Type.a, (ChunkStatus chunkstatus, Executor executor, WorldServer worldserver, ChunkGenerator chunkgenerator, StructureTemplateManager structuretemplatemanager, LightEngineThreaded lightenginethreaded, Function<IChunkAccess, CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>>> function, List<IChunkAccess> list, IChunkAccess ichunkaccess, boolean flag) -> {
        if (!flag && ichunkaccess.j().b(chunkstatus)) {
            return CompletableFuture.completedFuture(Either.left(ichunkaccess));
        }
        RegionLimitedWorldAccess regionlimitedworldaccess = new RegionLimitedWorldAccess(worldserver, list, chunkstatus, 0);
        return chunkgenerator.a(executor, Blender.a(regionlimitedworldaccess), worldserver.k().i(), worldserver.a().a(regionlimitedworldaccess), ichunkaccess).thenApply(ichunkaccess1 -> {
            if (ichunkaccess1 instanceof ProtoChunk) {
                ProtoChunk protochunk = (ProtoChunk)ichunkaccess1;
                BelowZeroRetrogen belowzeroretrogen = protochunk.x();
                if (belowzeroretrogen != null) {
                    BelowZeroRetrogen.a(protochunk);
                    if (belowzeroretrogen.b()) {
                        belowzeroretrogen.b(protochunk);
                    }
                }
                protochunk.a(chunkstatus);
            }
            return Either.left(ichunkaccess1);
        });
    });
    public static final ChunkStatus h = ChunkStatus.a("surface", g, 8, p, Type.a, (ChunkStatus chunkstatus, WorldServer worldserver, ChunkGenerator chunkgenerator, List<IChunkAccess> list, IChunkAccess ichunkaccess) -> {
        RegionLimitedWorldAccess regionlimitedworldaccess = new RegionLimitedWorldAccess(worldserver, list, chunkstatus, 0);
        chunkgenerator.a(regionlimitedworldaccess, worldserver.a().a(regionlimitedworldaccess), worldserver.k().i(), ichunkaccess);
    });
    public static final ChunkStatus i = ChunkStatus.a("carvers", h, 8, p, Type.a, (ChunkStatus chunkstatus, WorldServer worldserver, ChunkGenerator chunkgenerator, List<IChunkAccess> list, IChunkAccess ichunkaccess) -> {
        RegionLimitedWorldAccess regionlimitedworldaccess = new RegionLimitedWorldAccess(worldserver, list, chunkstatus, 0);
        if (ichunkaccess instanceof ProtoChunk) {
            ProtoChunk protochunk = (ProtoChunk)ichunkaccess;
            Blender.a((GeneratorAccessSeed)regionlimitedworldaccess, protochunk);
        }
        chunkgenerator.a(regionlimitedworldaccess, worldserver.A(), worldserver.k().i(), worldserver.s_(), worldserver.a().a(regionlimitedworldaccess), ichunkaccess, WorldGenStage.Features.a);
    });
    public static final ChunkStatus j = ChunkStatus.a("liquid_carvers", i, 8, b, Type.a, (ChunkStatus chunkstatus, WorldServer worldserver, ChunkGenerator chunkgenerator, List<IChunkAccess> list, IChunkAccess ichunkaccess) -> {});
    public static final ChunkStatus k = ChunkStatus.a("features", j, 8, b, Type.a, (ChunkStatus chunkstatus, Executor executor, WorldServer worldserver, ChunkGenerator chunkgenerator, StructureTemplateManager structuretemplatemanager, LightEngineThreaded lightenginethreaded, Function<IChunkAccess, CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>>> function, List<IChunkAccess> list, IChunkAccess ichunkaccess, boolean flag) -> {
        ProtoChunk protochunk = (ProtoChunk)ichunkaccess;
        protochunk.a(lightenginethreaded);
        if (flag || !ichunkaccess.j().b(chunkstatus)) {
            HeightMap.a(ichunkaccess, EnumSet.of(HeightMap.Type.e, HeightMap.Type.f, HeightMap.Type.d, HeightMap.Type.b));
            RegionLimitedWorldAccess regionlimitedworldaccess = new RegionLimitedWorldAccess(worldserver, list, chunkstatus, 1);
            chunkgenerator.a((GeneratorAccessSeed)regionlimitedworldaccess, ichunkaccess, worldserver.a().a(regionlimitedworldaccess));
            Blender.a(regionlimitedworldaccess, ichunkaccess);
            protochunk.a(chunkstatus);
        }
        return CompletableFuture.completedFuture(Either.left(ichunkaccess));
    });
    public static final ChunkStatus l = ChunkStatus.a("light", k, 1, b, Type.a, (chunkstatus, executor, worldserver, chunkgenerator, structuretemplatemanager, lightenginethreaded, function, list, ichunkaccess, flag) -> ChunkStatus.a(chunkstatus, lightenginethreaded, ichunkaccess), (chunkstatus, worldserver, structuretemplatemanager, lightenginethreaded, function, ichunkaccess) -> ChunkStatus.a(chunkstatus, lightenginethreaded, ichunkaccess));
    public static final ChunkStatus m = ChunkStatus.a("spawn", l, 0, b, Type.a, (ChunkStatus chunkstatus, WorldServer worldserver, ChunkGenerator chunkgenerator, List<IChunkAccess> list, IChunkAccess ichunkaccess) -> {
        if (!ichunkaccess.y()) {
            chunkgenerator.a(new RegionLimitedWorldAccess(worldserver, list, chunkstatus, -1));
        }
    });
    public static final ChunkStatus n = ChunkStatus.a("heightmaps", m, 0, b, Type.a, (ChunkStatus chunkstatus, WorldServer worldserver, ChunkGenerator chunkgenerator, List<IChunkAccess> list, IChunkAccess ichunkaccess) -> {});
    public static final ChunkStatus o = ChunkStatus.a("full", n, 0, b, Type.b, (chunkstatus, executor, worldserver, chunkgenerator, structuretemplatemanager, lightenginethreaded, function, list, ichunkaccess, flag) -> (CompletableFuture)function.apply(ichunkaccess), (chunkstatus, worldserver, structuretemplatemanager, lightenginethreaded, function, ichunkaccess) -> (CompletableFuture)function.apply(ichunkaccess));
    private static final List<ChunkStatus> r = ImmutableList.of((Object)o, (Object)k, (Object)j, (Object)f, (Object)d, (Object)d, (Object)d, (Object)d, (Object)d, (Object)d, (Object)d, (Object)d, (Object[])new ChunkStatus[0]);
    private static final IntList s = (IntList)SystemUtils.a(new IntArrayList(ChunkStatus.a().size()), (T intarraylist) -> {
        int i2 = 0;
        for (int j2 = ChunkStatus.a().size() - 1; j2 >= 0; --j2) {
            while (i2 + 1 < r.size() && j2 <= r.get(i2 + 1).c()) {
                ++i2;
            }
            intarraylist.add(0, i2);
        }
    });
    private final String t;
    private final int u;
    private final ChunkStatus v;
    private final b w;
    private final c x;
    private final int y;
    private final Type z;
    private final EnumSet<HeightMap.Type> A;

    public final ChunkStatus getNextStatus() {
        return this.nextStatus;
    }

    public final boolean isEmptyLoadStatus() {
        return this.x == q;
    }

    public final boolean isEmptyGenStatus() {
        return this == c || this == n || this == j;
    }

    private static CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> a(ChunkStatus status, LightEngineThreaded lightingProvider, IChunkAccess chunk) {
        boolean flag = ChunkStatus.a(status, chunk);
        if (!chunk.j().b(status)) {
            ((ProtoChunk)chunk).a(status);
        }
        return lightingProvider.a(chunk, flag).thenApply(Either::left);
    }

    private static ChunkStatus a(String id, @Nullable ChunkStatus previous, int taskMargin, EnumSet<HeightMap.Type> heightMapTypes, Type chunkType, d task) {
        return ChunkStatus.a(id, previous, taskMargin, heightMapTypes, chunkType, (b)task);
    }

    private static ChunkStatus a(String id, @Nullable ChunkStatus previous, int taskMargin, EnumSet<HeightMap.Type> heightMapTypes, Type chunkType, b task) {
        return ChunkStatus.a(id, previous, taskMargin, heightMapTypes, chunkType, task, q);
    }

    private static ChunkStatus a(String id, @Nullable ChunkStatus previous, int taskMargin, EnumSet<HeightMap.Type> heightMapTypes, Type chunkType, b task, c loadTask) {
        return IRegistry.a(BuiltInRegistries.o, id, new ChunkStatus(id, previous, taskMargin, heightMapTypes, chunkType, task, loadTask));
    }

    public static List<ChunkStatus> a() {
        ChunkStatus chunkstatus;
        ArrayList list = Lists.newArrayList();
        for (chunkstatus = o; chunkstatus.e() != chunkstatus; chunkstatus = chunkstatus.e()) {
            list.add(chunkstatus);
        }
        list.add(chunkstatus);
        Collections.reverse(list);
        return list;
    }

    private static boolean a(ChunkStatus status, IChunkAccess chunk) {
        return chunk.j().b(status) && chunk.v();
    }

    public static ChunkStatus a(int level) {
        return level >= r.size() ? c : (level < 0 ? o : r.get(level));
    }

    public static int b() {
        return r.size();
    }

    public static int a(ChunkStatus status) {
        return s.getInt(status.c());
    }

    ChunkStatus(String id, @Nullable ChunkStatus previous, int taskMargin, EnumSet<HeightMap.Type> heightMapTypes, Type chunkType, b generationTask, c loadTask) {
        this.t = id;
        this.v = previous == null ? this : previous;
        this.w = generationTask;
        this.x = loadTask;
        this.y = taskMargin;
        this.z = chunkType;
        this.A = heightMapTypes;
        this.u = previous == null ? 0 : previous.c() + 1;
        this.nextStatus = this;
        if (statuses.size() > 0) {
            ChunkStatus.statuses.get((int)(ChunkStatus.statuses.size() - 1)).nextStatus = this;
        }
        statuses.add(this);
    }

    public int c() {
        return this.u;
    }

    public String d() {
        return this.t;
    }

    public ChunkStatus e() {
        return this.v;
    }

    public CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> a(Executor executor, WorldServer world, ChunkGenerator generator, StructureTemplateManager structureTemplateManager, LightEngineThreaded lightingProvider, Function<IChunkAccess, CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>>> fullChunkConverter, List<IChunkAccess> chunks, boolean regenerate) {
        IChunkAccess ichunkaccess = chunks.get(chunks.size() / 2);
        ProfiledDuration profiledduration = JvmProfiler.e.a(ichunkaccess.f(), world.ab(), this.t);
        CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> completablefuture = this.w.doWork(this, executor, world, generator, structureTemplateManager, lightingProvider, fullChunkConverter, chunks, ichunkaccess, regenerate);
        return profiledduration != null ? completablefuture.thenApply(either -> {
            profiledduration.finish();
            return either;
        }) : completablefuture;
    }

    public CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> a(WorldServer world, StructureTemplateManager structureTemplateManager, LightEngineThreaded lightingProvider, Function<IChunkAccess, CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>>> fullChunkConverter, IChunkAccess chunk) {
        return this.x.doWork(this, world, structureTemplateManager, lightingProvider, fullChunkConverter, chunk);
    }

    public int f() {
        return this.y;
    }

    public Type g() {
        return this.z;
    }

    public static ChunkStatus getStatus(String name) {
        try {
            MinecraftKey key = new MinecraftKey(name);
            return BuiltInRegistries.o.b(key).orElse(null);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static ChunkStatus a(String id) {
        return BuiltInRegistries.o.a(MinecraftKey.a(id));
    }

    public EnumSet<HeightMap.Type> h() {
        return this.A;
    }

    public boolean b(ChunkStatus chunkStatus) {
        return this.c() >= chunkStatus.c();
    }

    public String toString() {
        return BuiltInRegistries.o.b(this).toString();
    }

    private static interface c {
        public CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> doWork(ChunkStatus var1, WorldServer var2, StructureTemplateManager var3, LightEngineThreaded var4, Function<IChunkAccess, CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>>> var5, IChunkAccess var6);
    }

    public static enum Type {
        a,
        b;

    }

    private static interface b {
        public CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> doWork(ChunkStatus var1, Executor var2, WorldServer var3, ChunkGenerator var4, StructureTemplateManager var5, LightEngineThreaded var6, Function<IChunkAccess, CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>>> var7, List<IChunkAccess> var8, IChunkAccess var9, boolean var10);
    }

    private static interface d
    extends b {
        @Override
        default public CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> doWork(ChunkStatus targetStatus, Executor executor, WorldServer world, ChunkGenerator generator, StructureTemplateManager structureTemplateManager, LightEngineThreaded lightingProvider, Function<IChunkAccess, CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>>> fullChunkConverter, List<IChunkAccess> chunks, IChunkAccess chunk, boolean regenerate) {
            if (regenerate || !chunk.j().b(targetStatus)) {
                this.doWork(targetStatus, world, generator, chunks, chunk);
                if (chunk instanceof ProtoChunk) {
                    ProtoChunk protochunk = (ProtoChunk)chunk;
                    protochunk.a(targetStatus);
                }
            }
            return CompletableFuture.completedFuture(Either.left(chunk));
        }

        public void doWork(ChunkStatus var1, WorldServer var2, ChunkGenerator var3, List<IChunkAccess> var4, IChunkAccess var5);
    }
}

