/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import ca.spottedleaf.starlight.common.light.SWMRNibbleArray;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.QuartPos;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.gameevent.GameEventListenerRegistry;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.ticks.SerializableTickContainer;
import net.minecraft.world.ticks.TickContainerAccess;
import org.bukkit.craftbukkit.v1_19_R3.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_19_R3.persistence.DirtyCraftPersistentDataContainer;
import org.slf4j.Logger;

public abstract class IChunkAccess
implements IBlockAccess,
BiomeManager.Provider,
StructureAccess {
    private static final Logger l = LogUtils.getLogger();
    private static final LongSet m = new LongOpenHashSet();
    protected final ShortList[] a;
    protected volatile boolean b;
    private volatile boolean n;
    protected final ChunkCoordIntPair c;
    public final long coordinateKey;
    public final int locX;
    public final int locZ;
    private long o;
    @Nullable
    @Deprecated
    private BiomeSettingsGeneration p;
    @Nullable
    protected NoiseChunk d;
    protected final ChunkConverter e;
    @Nullable
    protected BlendingData f;
    public final Map<HeightMap.Type, HeightMap> g = Maps.newEnumMap(HeightMap.Type.class);
    private final Map<Structure, StructureStart> q = Maps.newHashMap();
    private final Map<Structure, LongSet> r = Maps.newHashMap();
    protected final Map<BlockPosition, NBTTagCompound> h = Maps.newHashMap();
    public final Map<BlockPosition, TileEntity> i = Maps.newHashMap();
    protected final LevelHeightAccessor j;
    protected final ChunkSection[] k;
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    public DirtyCraftPersistentDataContainer persistentDataContainer = new DirtyCraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    private volatile SWMRNibbleArray[] blockNibbles;
    private volatile SWMRNibbleArray[] skyNibbles;
    private volatile boolean[] skyEmptinessMap;
    private volatile boolean[] blockEmptinessMap;
    public final IRegistry<BiomeBase> biomeRegistry;

    public SWMRNibbleArray[] getBlockNibbles() {
        return this.blockNibbles;
    }

    public void setBlockNibbles(SWMRNibbleArray[] nibbles) {
        this.blockNibbles = nibbles;
    }

    public SWMRNibbleArray[] getSkyNibbles() {
        return this.skyNibbles;
    }

    public void setSkyNibbles(SWMRNibbleArray[] nibbles) {
        this.skyNibbles = nibbles;
    }

    public boolean[] getSkyEmptinessMap() {
        return this.skyEmptinessMap;
    }

    public void setSkyEmptinessMap(boolean[] emptinessMap) {
        this.skyEmptinessMap = emptinessMap;
    }

    public boolean[] getBlockEmptinessMap() {
        return this.blockEmptinessMap;
    }

    public void setBlockEmptinessMap(boolean[] emptinessMap) {
        this.blockEmptinessMap = emptinessMap;
    }

    public IChunkAccess(ChunkCoordIntPair pos, ChunkConverter upgradeData, LevelHeightAccessor heightLimitView, IRegistry<BiomeBase> biome, long inhabitedTime, @Nullable ChunkSection[] sectionArrayInitializer, @Nullable BlendingData blendingData) {
        this.locX = pos.e;
        this.locZ = pos.f;
        this.c = pos;
        this.coordinateKey = ChunkCoordIntPair.c(this.locX, this.locZ);
        this.e = upgradeData;
        this.j = heightLimitView;
        this.k = new ChunkSection[heightLimitView.aj()];
        this.o = inhabitedTime;
        this.a = new ShortList[heightLimitView.aj()];
        this.f = blendingData;
        if (sectionArrayInitializer != null) {
            if (this.k.length == sectionArrayInitializer.length) {
                System.arraycopy(sectionArrayInitializer, 0, this.k, 0, this.k.length);
            } else {
                l.warn("Could not set level chunk sections, array length is {} instead of {}", (Object)sectionArrayInitializer.length, (Object)this.k.length);
            }
        }
        IChunkAccess.replaceMissingSections(heightLimitView, biome, this.k, pos);
        this.biomeRegistry = biome;
    }

    private static void replaceMissingSections(LevelHeightAccessor world, IRegistry<BiomeBase> biome, ChunkSection[] sectionArray, ChunkCoordIntPair pos) {
        for (int i2 = 0; i2 < sectionArray.length; ++i2) {
            if (sectionArray[i2] != null) continue;
            sectionArray[i2] = new ChunkSection(world.g(i2), biome, pos, world instanceof World ? (World)world : null);
        }
    }

    public GameEventListenerRegistry a(int ySectionCoord) {
        return GameEventListenerRegistry.a;
    }

    public abstract IBlockData getBlockState(int var1, int var2, int var3);

    @Nullable
    public abstract IBlockData a(BlockPosition var1, IBlockData var2, boolean var3);

    public abstract void a(TileEntity var1);

    public abstract void a(Entity var1);

    @Nullable
    public ChunkSection a() {
        ChunkSection[] achunksection = this.d();
        for (int i2 = achunksection.length - 1; i2 >= 0; --i2) {
            ChunkSection chunksection = achunksection[i2];
            if (chunksection.c()) continue;
            return chunksection;
        }
        return null;
    }

    public int b() {
        ChunkSection chunksection = this.a();
        return chunksection == null ? this.v_() : chunksection.g();
    }

    public Set<BlockPosition> c() {
        HashSet set = Sets.newHashSet(this.h.keySet());
        set.addAll(this.i.keySet());
        return set;
    }

    public ChunkSection[] d() {
        return this.k;
    }

    public ChunkSection b(int yIndex) {
        return this.d()[yIndex];
    }

    public Collection<Map.Entry<HeightMap.Type, HeightMap>> e() {
        return Collections.unmodifiableSet(this.g.entrySet());
    }

    public void a(HeightMap.Type type, long[] heightmap) {
        this.a(type).a(this, type, heightmap);
    }

    public HeightMap a(HeightMap.Type type) {
        return this.g.computeIfAbsent(type, heightmap_type1 -> new HeightMap(this, (HeightMap.Type)heightmap_type1));
    }

    public boolean b(HeightMap.Type type) {
        return this.g.get(type) != null;
    }

    public int a(HeightMap.Type type, int x2, int z2) {
        HeightMap heightmap = this.g.get(type);
        if (heightmap == null) {
            if (SharedConstants.aO && this instanceof Chunk) {
                l.error("Unprimed heightmap: " + type + " " + x2 + " " + z2);
            }
            HeightMap.a(this, EnumSet.of(type));
            heightmap = this.g.get(type);
        }
        return heightmap.a(x2 & 0xF, z2 & 0xF) - 1;
    }

    public ChunkCoordIntPair f() {
        return this.c;
    }

    @Override
    @Nullable
    public StructureStart a(Structure structure) {
        return this.q.get(structure);
    }

    @Override
    public void a(Structure structure, StructureStart start) {
        this.q.put(structure, start);
        this.b = true;
    }

    public Map<Structure, StructureStart> g() {
        return Collections.unmodifiableMap(this.q);
    }

    public void a(Map<Structure, StructureStart> structureStarts) {
        this.q.clear();
        this.q.putAll(structureStarts);
        this.b = true;
    }

    @Override
    public LongSet b(Structure structure) {
        return this.r.getOrDefault(structure, m);
    }

    @Override
    public void a(Structure structure, long reference) {
        this.r.computeIfAbsent(structure, structure1 -> new LongOpenHashSet()).add(reference);
        this.b = true;
    }

    @Override
    public Map<Structure, LongSet> h() {
        return Collections.unmodifiableMap(this.r);
    }

    @Override
    public void b(Map<Structure, LongSet> structureReferences) {
        this.r.clear();
        this.r.putAll(structureReferences);
        this.b = true;
    }

    public boolean a(int lowerHeight, int upperHeight) {
        if (lowerHeight < this.v_()) {
            lowerHeight = this.v_();
        }
        if (upperHeight >= this.ai()) {
            upperHeight = this.ai() - 1;
        }
        for (int k2 = lowerHeight; k2 <= upperHeight; k2 += 16) {
            if (this.b(this.e(k2)).c()) continue;
            return false;
        }
        return true;
    }

    public void a(boolean needsSaving) {
        this.b = needsSaving;
        if (!needsSaving) {
            this.persistentDataContainer.dirty(false);
        }
    }

    public boolean i() {
        return this.b || this.persistentDataContainer.dirty();
    }

    public abstract ChunkStatus j();

    public abstract void d(BlockPosition var1);

    public void e(BlockPosition pos) {
        l.warn("Trying to mark a block for PostProcessing @ {}, but this operation is not supported.", (Object)pos);
    }

    public ShortList[] k() {
        return this.a;
    }

    public void a(short packedPos, int index) {
        IChunkAccess.a(this.k(), index).add(packedPos);
    }

    public void a(NBTTagCompound nbt) {
        this.h.put(TileEntity.c(nbt), nbt);
    }

    @Nullable
    public NBTTagCompound f(BlockPosition pos) {
        return this.h.get(pos);
    }

    @Nullable
    public abstract NBTTagCompound g(BlockPosition var1);

    public abstract Stream<BlockPosition> n();

    public abstract TickContainerAccess<Block> o();

    public abstract TickContainerAccess<FluidType> p();

    public abstract a q();

    public ChunkConverter r() {
        return this.e;
    }

    public boolean s() {
        return this.f != null;
    }

    @Nullable
    public BlendingData t() {
        return this.f;
    }

    public void a(BlendingData blendingData) {
        this.f = blendingData;
    }

    public long u() {
        return this.o;
    }

    public void a(long delta) {
        this.o += delta;
    }

    public void b(long inhabitedTime) {
        this.o = inhabitedTime;
    }

    public static ShortList a(ShortList[] lists, int index) {
        if (lists[index] == null) {
            lists[index] = new ShortArrayList();
        }
        return lists[index];
    }

    public boolean v() {
        return this.n;
    }

    public void b(boolean lightOn) {
        this.n = lightOn;
        this.a(true);
    }

    @Override
    public int v_() {
        return this.j.v_();
    }

    @Override
    public int w_() {
        return this.j.w_();
    }

    public NoiseChunk a(Function<IChunkAccess, NoiseChunk> chunkNoiseSamplerCreator) {
        if (this.d == null) {
            this.d = chunkNoiseSamplerCreator.apply(this);
        }
        return this.d;
    }

    @Deprecated
    public BiomeSettingsGeneration a(Supplier<BiomeSettingsGeneration> generationSettingsCreator) {
        if (this.p == null) {
            this.p = generationSettingsCreator.get();
        }
        return this.p;
    }

    @Override
    public Holder<BiomeBase> getNoiseBiome(int biomeX, int biomeY, int biomeZ) {
        try {
            int l2 = QuartPos.a(this.v_());
            int i1 = l2 + QuartPos.a(this.w_()) - 1;
            int j1 = MathHelper.a(biomeY, l2, i1);
            int k1 = this.e(QuartPos.c(j1));
            return this.k[k1].c(biomeX & 3, j1 & 3, biomeZ & 3);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Getting biome");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Biome being got");
            crashreportsystemdetails.a("Location", () -> CrashReportSystemDetails.a((LevelHeightAccessor)this, biomeX, biomeY, biomeZ));
            throw new ReportedException(crashreport);
        }
    }

    public void setBiome(int i2, int j2, int k2, Holder<BiomeBase> biome) {
        try {
            int l2 = QuartPos.a(this.v_());
            int i1 = l2 + QuartPos.a(this.w_()) - 1;
            int j1 = MathHelper.a(j2, l2, i1);
            int k1 = this.e(QuartPos.c(j1));
            this.k[k1].setBiome(i2 & 3, j1 & 3, k2 & 3, biome);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Setting biome");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Biome being set");
            crashreportsystemdetails.a("Location", () -> CrashReportSystemDetails.a((LevelHeightAccessor)this, i2, j2, k2));
            throw new ReportedException(crashreport);
        }
    }

    public void a(BiomeResolver biomeSupplier, Climate.Sampler sampler) {
        ChunkCoordIntPair chunkcoordintpair = this.f();
        int i2 = QuartPos.a(chunkcoordintpair.d());
        int j2 = QuartPos.a(chunkcoordintpair.e());
        LevelHeightAccessor levelheightaccessor = this.z();
        for (int k2 = levelheightaccessor.ak(); k2 < levelheightaccessor.al(); ++k2) {
            ChunkSection chunksection = this.b(this.f(k2));
            chunksection.a(biomeSupplier, sampler, i2, j2);
        }
    }

    public boolean w() {
        return !this.h().isEmpty();
    }

    @Nullable
    public BelowZeroRetrogen x() {
        return null;
    }

    public boolean y() {
        return this.x() != null;
    }

    public LevelHeightAccessor z() {
        return this;
    }

    public record a(SerializableTickContainer<Block> a, SerializableTickContainer<FluidType> b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "blocks;fluids", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "blocks;fluids", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "blocks;fluids", "a", "b"}, this, o2);
        }
    }
}

