/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.visitors.CollectFields;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.util.Unit;
import net.minecraft.util.thread.Mailbox;
import net.minecraft.util.thread.PairedQueue;
import net.minecraft.util.thread.ThreadedMailbox;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.RegionFileCache;
import org.slf4j.Logger;

public class IOWorker
implements ChunkScanAccess,
AutoCloseable {
    private static final Logger a = LogUtils.getLogger();
    private final AtomicBoolean b = new AtomicBoolean();
    private final ThreadedMailbox<PairedQueue.b> c;
    private final RegionFileCache d;
    private final Map<ChunkCoordIntPair, a> e = Maps.newLinkedHashMap();
    private final Long2ObjectLinkedOpenHashMap<CompletableFuture<BitSet>> f = new Long2ObjectLinkedOpenHashMap();
    private static final int g = 1024;

    protected IOWorker(Path directory, boolean dsync, String name) {
        this.d = new RegionFileCache(directory, dsync);
        this.c = new ThreadedMailbox<PairedQueue.b>(new PairedQueue.a(Priority.values().length), SystemUtils.g(), "IOWorker-" + name);
    }

    public boolean a(ChunkCoordIntPair chunkPos, int checkRadius) {
        ChunkCoordIntPair chunkPos2 = new ChunkCoordIntPair(chunkPos.e - checkRadius, chunkPos.f - checkRadius);
        ChunkCoordIntPair chunkPos3 = new ChunkCoordIntPair(chunkPos.e + checkRadius, chunkPos.f + checkRadius);
        for (int i2 = chunkPos2.h(); i2 <= chunkPos3.h(); ++i2) {
            for (int j2 = chunkPos2.i(); j2 <= chunkPos3.i(); ++j2) {
                BitSet bitSet = this.a(i2, j2).join();
                if (bitSet.isEmpty()) continue;
                ChunkCoordIntPair chunkPos4 = ChunkCoordIntPair.a(i2, j2);
                int k2 = Math.max(chunkPos2.e - chunkPos4.e, 0);
                int l2 = Math.max(chunkPos2.f - chunkPos4.f, 0);
                int m2 = Math.min(chunkPos3.e - chunkPos4.e, 31);
                int n2 = Math.min(chunkPos3.f - chunkPos4.f, 31);
                for (int o2 = k2; o2 <= m2; ++o2) {
                    for (int p2 = l2; p2 <= n2; ++p2) {
                        int q2 = p2 * 32 + o2;
                        if (!bitSet.get(q2)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<BitSet> a(int chunkX, int chunkZ) {
        long l2 = ChunkCoordIntPair.c(chunkX, chunkZ);
        Long2ObjectLinkedOpenHashMap<CompletableFuture<BitSet>> long2ObjectLinkedOpenHashMap = this.f;
        synchronized (long2ObjectLinkedOpenHashMap) {
            CompletableFuture<BitSet> completableFuture = (CompletableFuture<BitSet>)this.f.getAndMoveToFirst(l2);
            if (completableFuture == null) {
                completableFuture = this.b(chunkX, chunkZ);
                this.f.putAndMoveToFirst(l2, completableFuture);
                if (this.f.size() > 1024) {
                    this.f.removeLast();
                }
            }
            return completableFuture;
        }
    }

    private CompletableFuture<BitSet> b(int chunkX, int chunkZ) {
        return CompletableFuture.supplyAsync(() -> {
            ChunkCoordIntPair chunkPos2 = ChunkCoordIntPair.a(chunkX, chunkZ);
            ChunkCoordIntPair chunkPos22 = ChunkCoordIntPair.b(chunkX, chunkZ);
            BitSet bitSet = new BitSet();
            ChunkCoordIntPair.a(chunkPos2, chunkPos22).forEach(chunkPos -> {
                NBTTagCompound compoundTag;
                CollectFields collectFields = new CollectFields(new FieldSelector(NBTTagInt.a, "DataVersion"), new FieldSelector(NBTTagCompound.b, "blending_data"));
                try {
                    this.a((ChunkCoordIntPair)chunkPos, collectFields).join();
                }
                catch (Exception exception) {
                    a.warn("Failed to scan chunk {}", chunkPos, (Object)exception);
                    return;
                }
                NBTBase tag = collectFields.d();
                if (tag instanceof NBTTagCompound && this.a(compoundTag = (NBTTagCompound)tag)) {
                    int i2 = chunkPos.k() * 32 + chunkPos.j();
                    bitSet.set(i2);
                }
            });
            return bitSet;
        }, SystemUtils.f());
    }

    private boolean a(NBTTagCompound nbt) {
        if (!nbt.b("DataVersion", 99) || nbt.h("DataVersion") < 3088) {
            return true;
        }
        return nbt.b("blending_data", 10);
    }

    public CompletableFuture<Void> a(ChunkCoordIntPair pos, @Nullable NBTTagCompound nbt) {
        return this.a(() -> {
            a pendingStore = this.e.computeIfAbsent(pos, pos2 -> new a(nbt));
            pendingStore.a = nbt;
            return Either.left(pendingStore.b);
        }).thenCompose(Function.identity());
    }

    public CompletableFuture<Optional<NBTTagCompound>> a(ChunkCoordIntPair pos) {
        return this.a(() -> {
            a pendingStore = this.e.get(pos);
            if (pendingStore != null) {
                return Either.left(Optional.ofNullable(pendingStore.a));
            }
            try {
                NBTTagCompound compoundTag = this.d.a(pos);
                return Either.left(Optional.ofNullable(compoundTag));
            }
            catch (Exception exception) {
                a.warn("Failed to read chunk {}", (Object)pos, (Object)exception);
                return Either.right(exception);
            }
        });
    }

    public CompletableFuture<Void> a(boolean sync) {
        CompletionStage completableFuture = this.a(() -> Either.left(CompletableFuture.allOf((CompletableFuture[])this.e.values().stream().map(pendingStore -> pendingStore.b).toArray(CompletableFuture[]::new)))).thenCompose(Function.identity());
        if (sync) {
            return ((CompletableFuture)completableFuture).thenCompose(void_ -> this.a(() -> {
                try {
                    this.d.a();
                    return Either.left(null);
                }
                catch (Exception exception) {
                    a.warn("Failed to synchronize chunks", (Throwable)exception);
                    return Either.right(exception);
                }
            }));
        }
        return ((CompletableFuture)completableFuture).thenCompose(void_ -> this.a(() -> Either.left(null)));
    }

    @Override
    @Override
    public CompletableFuture<Void> a(ChunkCoordIntPair pos, StreamTagVisitor scanner) {
        return this.a(() -> {
            try {
                a pendingStore = this.e.get(pos);
                if (pendingStore != null) {
                    if (pendingStore.a != null) {
                        pendingStore.a.b(scanner);
                    }
                } else {
                    this.d.a(pos, scanner);
                }
                return Either.left(null);
            }
            catch (Exception exception) {
                a.warn("Failed to bulk scan chunk {}", (Object)pos, (Object)exception);
                return Either.right(exception);
            }
        });
    }

    private <T> CompletableFuture<T> a(Supplier<Either<T, Exception>> task) {
        return this.c.c(listener -> new PairedQueue.b(Priority.a.ordinal(), () -> this.a(listener, (Supplier)task)));
    }

    private void a() {
        if (this.e.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<ChunkCoordIntPair, a>> iterator = this.e.entrySet().iterator();
        Map.Entry<ChunkCoordIntPair, a> entry = iterator.next();
        iterator.remove();
        this.a(entry.getKey(), entry.getValue());
        this.b();
    }

    private void b() {
        this.c.a(new PairedQueue.b(Priority.b.ordinal(), this::a));
    }

    private void a(ChunkCoordIntPair pos, a result) {
        try {
            this.d.a(pos, result.a);
            result.b.complete(null);
        }
        catch (Exception exception) {
            a.error("Failed to store chunk {}", (Object)pos, (Object)exception);
            result.b.completeExceptionally(exception);
        }
    }

    @Override
    @Override
    public void close() throws IOException {
        if (!this.b.compareAndSet(false, true)) {
            return;
        }
        this.c.b((? super Mailbox<Source> listener) -> new PairedQueue.b(Priority.c.ordinal(), () -> listener.a(Unit.a))).join();
        this.c.close();
        try {
            this.d.close();
        }
        catch (Exception exception) {
            a.error("Failed to close storage", (Throwable)exception);
        }
    }

    private /* synthetic */ void a(Mailbox processorHandle, Supplier supplier) {
        if (!this.b.get()) {
            processorHandle.a((Either)supplier.get());
        }
        this.b();
    }

    static final class Priority
    extends Enum<Priority> {
        public static final /* enum */ Priority a = new Priority();
        public static final /* enum */ Priority b = new Priority();
        public static final /* enum */ Priority c = new Priority();
        private static final /* synthetic */ Priority[] d;

        public static Priority[] values() {
            return (Priority[])d.clone();
        }

        public static Priority valueOf(String string) {
            return Enum.valueOf(Priority.class, string);
        }

        private static /* synthetic */ Priority[] a() {
            return new Priority[]{a, b, c};
        }

        static {
            d = Priority.a();
        }
    }

    static class a {
        @Nullable
        NBTTagCompound a;
        final CompletableFuture<Void> b = new CompletableFuture();

        public a(@Nullable NBTTagCompound nbt) {
            this.a = nbt;
        }
    }
}

