/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.destroystokyo.paper.exception.ServerInternalException;
import com.destroystokyo.paper.util.SneakyThrow;
import com.google.common.annotations.VisibleForTesting;
import com.mojang.logging.LogUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Random;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkRegionLoader;
import net.minecraft.world.level.chunk.storage.RegionFileBitSet;
import net.minecraft.world.level.chunk.storage.RegionFileCache;
import net.minecraft.world.level.chunk.storage.RegionFileCompression;
import org.slf4j.Logger;

public class RegionFile
implements AutoCloseable {
    private static final Logger c = LogUtils.getLogger();
    private static final int d = 4096;
    @VisibleForTesting
    protected static final int a = 1024;
    private static final int e = 5;
    private static final int f = 0;
    private static final ByteBuffer g = ByteBuffer.allocateDirect(1);
    private static final String h = ".mcc";
    private static final int i = 128;
    private static final int j = 256;
    private static final int k = 0;
    private final FileChannel l;
    private final Path m;
    final RegionFileCompression n;
    private final ByteBuffer o;
    private final IntBuffer p;
    private final IntBuffer q;
    @VisibleForTesting
    protected final RegionFileBitSet b;
    public final ReentrantLock fileLock = new ReentrantLock(true);
    public final Path regionFile;
    private static final NBTTagCompound OVERSIZED_COMPOUND = new NBTTagCompound();
    final boolean canRecalcHeader;
    private final ChunkStatus[] statuses = new ChunkStatus[1024];
    private boolean closed;
    private final byte[] oversized = new byte[1024];
    private int oversizedCount = 0;
    public static final int MAX_CHUNK_SIZE = 524288000;

    private static long roundToSectors(long bytes) {
        long sectors = bytes >>> 12;
        long remainingBytes = bytes & 0xFFFL;
        long sign = -remainingBytes;
        return sectors + (sign >>> 63);
    }

    private NBTTagCompound attemptRead(long sector, int chunkDataLength, long fileLength) throws IOException {
        try {
            if (chunkDataLength < 0) {
                return null;
            }
            long offset = sector * 4096L + 4L;
            if (offset + (long)chunkDataLength > fileLength) {
                return null;
            }
            ByteBuffer chunkData = ByteBuffer.allocate(chunkDataLength);
            if (chunkDataLength != this.l.read(chunkData, offset)) {
                return null;
            }
            ((Buffer)chunkData).flip();
            byte compressionType = chunkData.get();
            if (compressionType < 0) {
                return OVERSIZED_COMPOUND;
            }
            RegionFileCompression compression = RegionFileCompression.a(compressionType);
            if (compression == null) {
                return null;
            }
            InputStream input = compression.a(new ByteArrayInputStream(chunkData.array(), chunkData.position(), chunkDataLength - chunkData.position()));
            return NBTCompressedStreamTools.a(new DataInputStream(input));
        }
        catch (Exception ex) {
            return null;
        }
    }

    private int getLength(long sector) throws IOException {
        ByteBuffer length = ByteBuffer.allocate(4);
        if (4 != this.l.read(length, sector * 4096L)) {
            return -1;
        }
        return length.getInt(0);
    }

    private void backupRegionFile() {
        Path backup = this.regionFile.getParent().resolve(this.regionFile.getFileName() + "." + new Random().nextLong() + ".backup");
        this.backupRegionFile(backup);
    }

    private void backupRegionFile(Path to) {
        try {
            this.l.force(true);
            c.warn("Backing up regionfile \"" + this.regionFile.toAbsolutePath() + "\" to " + to.toAbsolutePath());
            Files.copy(this.regionFile, to, StandardCopyOption.COPY_ATTRIBUTES);
            c.warn("Backed up the regionfile to " + to.toAbsolutePath());
        }
        catch (IOException ex) {
            c.error("Failed to backup to " + to.toAbsolutePath(), (Throwable)ex);
        }
    }

    private static boolean inSameRegionfile(ChunkCoordIntPair first, ChunkCoordIntPair second) {
        return (first.e & 0xFFFFFFE0) == (second.e & 0xFFFFFFE0) && (first.f & 0xFFFFFFE0) == (second.f & 0xFFFFFFE0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean recalculateHeader() throws IOException {
        if (!this.canRecalcHeader) {
            return false;
        }
        ChunkCoordIntPair ourLowerLeftPosition = RegionFileCache.getRegionFileCoordinates(this.regionFile);
        if (ourLowerLeftPosition == null) {
            c.error("Unable to get chunk location of regionfile " + this.regionFile.toAbsolutePath() + ", cannot recover header");
            return false;
        }
        RegionFile regionFile = this;
        synchronized (regionFile) {
            int chunkZ;
            int chunkX;
            c.warn("Corrupt regionfile header detected! Attempting to re-calculate header offsets for regionfile " + this.regionFile.toAbsolutePath(), new Throwable());
            this.backupRegionFile();
            NBTTagCompound[] compounds = new NBTTagCompound[1024];
            int[] rawLengths = new int[1024];
            int[] sectorOffsets = new int[1024];
            boolean[] hasAikarOversized = new boolean[1024];
            long fileLength = this.l.size();
            long totalSectors = RegionFile.roundToSectors(fileLength);
            long maxSector = Math.min(0x7FFFFFL, totalSectors);
            for (long i2 = 2L; i2 < maxSector; ++i2) {
                int chunkDataLength = this.getLength(i2);
                NBTTagCompound compound = this.attemptRead(i2, chunkDataLength, fileLength);
                if (compound == null || compound == OVERSIZED_COMPOUND) continue;
                ChunkCoordIntPair chunkPos = ChunkRegionLoader.getChunkCoordinate(compound);
                if (!RegionFile.inSameRegionfile(ourLowerLeftPosition, chunkPos)) {
                    c.error("Ignoring absolute chunk " + chunkPos + " in regionfile as it is not contained in the bounds of the regionfile '" + this.regionFile.toAbsolutePath() + "'. It should be in regionfile (" + (chunkPos.e >> 5) + "," + (chunkPos.f >> 5) + ")");
                    continue;
                }
                int location = chunkPos.e & 0x1F | (chunkPos.f & 0x1F) << 5;
                NBTTagCompound nBTTagCompound = compounds[location];
                if (nBTTagCompound != null && ChunkRegionLoader.getLastWorldSaveTime(nBTTagCompound) > ChunkRegionLoader.getLastWorldSaveTime(compound)) continue;
                Path aikarOversizedFile = this.getOversizedFile(chunkPos.e, chunkPos.f);
                int isAikarOversized = 0;
                if (Files.exists(aikarOversizedFile, new LinkOption[0])) {
                    try {
                        NBTTagCompound aikarOversizedCompound = this.getOversizedData(chunkPos.e, chunkPos.f);
                        if (ChunkRegionLoader.getLastWorldSaveTime(compound) == ChunkRegionLoader.getLastWorldSaveTime(aikarOversizedCompound)) {
                            isAikarOversized = 1;
                        }
                    }
                    catch (Exception ex) {
                        c.error("Failed to read aikar oversized data for absolute chunk (" + chunkPos.e + "," + chunkPos.f + ") in regionfile " + this.regionFile.toAbsolutePath() + ", oversized data for this chunk will be lost", (Throwable)ex);
                    }
                }
                hasAikarOversized[location] = isAikarOversized;
                compounds[location] = compound;
                rawLengths[location] = chunkDataLength + 4;
                sectorOffsets[location] = (int)i2;
                int chunkSectorLength = (int)RegionFile.roundToSectors(rawLengths[location]);
                i2 += (long)chunkSectorLength;
                --i2;
            }
            Path containingFolder = this.m;
            Path[] regionFiles = (Path[])Files.list(containingFolder).toArray(Path[]::new);
            boolean[] oversized = new boolean[1024];
            RegionFileCompression[] oversizedCompressionTypes = new RegionFileCompression[1024];
            if (regionFiles != null) {
                int lowerXBound = ourLowerLeftPosition.e;
                int lowerZBound = ourLowerLeftPosition.f;
                int upperXBound = lowerXBound + 32 - 1;
                int upperZBound = lowerZBound + 32 - 1;
                for (Path regionFile2 : regionFiles) {
                    byte[] chunkData;
                    ChunkCoordIntPair oversizedCoords = RegionFile.getOversizedChunkPair(regionFile2);
                    if (oversizedCoords == null || oversizedCoords.e < lowerXBound || oversizedCoords.e > upperXBound || oversizedCoords.f < lowerZBound || oversizedCoords.f > upperZBound) continue;
                    int location = oversizedCoords.e & 0x1F | (oversizedCoords.f & 0x1F) << 5;
                    try {
                        chunkData = Files.readAllBytes(regionFile2);
                    }
                    catch (Exception ex) {
                        c.error("Failed to read oversized chunk data in file " + regionFile2.toAbsolutePath() + ", data will be lost", (Throwable)ex);
                        continue;
                    }
                    NBTTagCompound compound = null;
                    RegionFileCompression compression = null;
                    for (RegionFileCompression compressionType : RegionFileCompression.d.values()) {
                        try {
                            DataInputStream in = new DataInputStream(compressionType.a(new ByteArrayInputStream(chunkData)));
                            compound = NBTCompressedStreamTools.a(in);
                            compression = compressionType;
                            break;
                        }
                        catch (Exception ex) {
                        }
                    }
                    if (compound == null) {
                        c.error("Failed to read oversized chunk data in file " + regionFile2.toAbsolutePath() + ", it's corrupt. Its data will be lost");
                        continue;
                    }
                    if (!ChunkRegionLoader.getChunkCoordinate(compound).equals(oversizedCoords)) {
                        c.error("Can't use oversized chunk stored in " + regionFile2.toAbsolutePath() + ", got absolute chunkpos: " + ChunkRegionLoader.getChunkCoordinate(compound) + ", expected " + oversizedCoords);
                        continue;
                    }
                    if (compounds[location] != null && ChunkRegionLoader.getLastWorldSaveTime(compound) <= ChunkRegionLoader.getLastWorldSaveTime(compounds[location])) continue;
                    oversized[location] = true;
                    oversizedCompressionTypes[location] = compression;
                }
            }
            int[] calculatedOffsets = new int[1024];
            RegionFileBitSet newSectorAllocations = new RegionFileBitSet();
            newSectorAllocations.a(0, 2);
            for (chunkX = 0; chunkX < 32; ++chunkX) {
                for (chunkZ = 0; chunkZ < 32; ++chunkZ) {
                    int n2 = chunkX | chunkZ << 5;
                    if (oversized[n2]) continue;
                    int sectorOffset = sectorOffsets[n2];
                    int rawLength = rawLengths[n2];
                    int sectorLength = (int)RegionFile.roundToSectors(rawLength);
                    if (newSectorAllocations.tryAllocate(sectorOffset, sectorLength)) {
                        calculatedOffsets[n2] = sectorOffset << 8 | (sectorLength > 255 ? 255 : sectorLength);
                        continue;
                    }
                    c.error("Failed to allocate space for local chunk (overlapping data??) at (" + chunkX + "," + chunkZ + ") in regionfile " + this.regionFile.toAbsolutePath() + ", chunk will be regenerated");
                }
            }
            for (chunkX = 0; chunkX < 32; ++chunkX) {
                for (chunkZ = 0; chunkZ < 32; ++chunkZ) {
                    int n3 = chunkX | chunkZ << 5;
                    if (!oversized[n3]) continue;
                    int sectorOffset = newSectorAllocations.a(1);
                    int sectorLength = 1;
                    try {
                        this.l.write(this.createExternalStub(oversizedCompressionTypes[n3]), sectorOffset * 4096);
                        calculatedOffsets[n3] = sectorOffset << 8 | (sectorLength > 255 ? 255 : sectorLength);
                        continue;
                    }
                    catch (IOException ex) {
                        newSectorAllocations.b(sectorOffset, sectorLength);
                        c.error("Failed to write new oversized chunk data holder, local chunk at (" + chunkX + "," + chunkZ + ") in regionfile " + this.regionFile.toAbsolutePath() + " will be regenerated");
                    }
                }
            }
            this.oversizedCount = 0;
            for (chunkX = 0; chunkX < 32; ++chunkX) {
                for (chunkZ = 0; chunkZ < 32; ++chunkZ) {
                    int n4 = chunkX | chunkZ << 5;
                    int isAikarOversized = hasAikarOversized[n4] ? 1 : 0;
                    this.oversizedCount += isAikarOversized;
                    this.oversized[n4] = (byte)isAikarOversized;
                }
            }
            if (this.oversizedCount > 0) {
                try {
                    this.writeOversizedMeta();
                }
                catch (Exception ex) {
                    c.error("Failed to write aikar oversized chunk meta, all aikar style oversized chunk data will be lost for regionfile " + this.regionFile.toAbsolutePath(), (Throwable)ex);
                    Files.deleteIfExists(this.getOversizedMetaFile());
                }
            } else {
                Files.deleteIfExists(this.getOversizedMetaFile());
            }
            this.b.copyFrom(newSectorAllocations);
            c.info("Starting summary of changes for regionfile " + this.regionFile.toAbsolutePath());
            for (int chunkX2 = 0; chunkX2 < 32; ++chunkX2) {
                for (chunkZ = 0; chunkZ < 32; ++chunkZ) {
                    int newOffset;
                    int n5 = chunkX2 | chunkZ << 5;
                    int oldOffset = this.p.get(n5);
                    if (oldOffset == (newOffset = calculatedOffsets[n5])) continue;
                    this.p.put(n5, newOffset);
                    if (oldOffset == 0) {
                        c.info("Found missing data for local chunk (" + chunkX2 + "," + chunkZ + ") in regionfile " + this.regionFile.toAbsolutePath());
                        continue;
                    }
                    if (newOffset == 0) {
                        c.warn("Data for local chunk (" + chunkX2 + "," + chunkZ + ") could not be recovered in regionfile " + this.regionFile.toAbsolutePath() + ", it will be regenerated");
                        continue;
                    }
                    c.info("Local chunk (" + chunkX2 + "," + chunkZ + ") changed to point to newer data or correct chunk in regionfile " + this.regionFile.toAbsolutePath());
                }
            }
            c.info("End of change summary for regionfile " + this.regionFile.toAbsolutePath());
            for (int i3 = 0; i3 < 1024; ++i3) {
                this.q.put(i3, calculatedOffsets[i3] != 0 ? (int)System.currentTimeMillis() : 0);
            }
            try {
                this.a();
                this.l.force(true);
                c.info("Successfully wrote new header to disk for regionfile " + this.regionFile.toAbsolutePath());
            }
            catch (IOException ex) {
                c.error("Failed to write new header to disk for regionfile " + this.regionFile.toAbsolutePath(), (Throwable)ex);
            }
        }
        return true;
    }

    public void setStatus(int x2, int z2, ChunkStatus status) {
        if (this.closed) {
            throw new IllegalStateException("RegionFile is closed");
        }
        this.statuses[RegionFile.getChunkLocation((int)x2, (int)z2)] = status;
    }

    public ChunkStatus getStatusIfCached(int x2, int z2) {
        if (this.closed) {
            throw new IllegalStateException("RegionFile is closed");
        }
        int location = RegionFile.getChunkLocation(x2, z2);
        return this.statuses[location];
    }

    public RegionFile(Path file, Path directory, boolean dsync) throws IOException {
        this(file, directory, RegionFileCompression.b, dsync);
    }

    public RegionFile(Path file, Path directory, boolean dsync, boolean canRecalcHeader) throws IOException {
        this(file, directory, RegionFileCompression.b, dsync, canRecalcHeader);
    }

    public RegionFile(Path file, Path directory, RegionFileCompression outputChunkStreamVersion, boolean dsync) throws IOException {
        this(file, directory, outputChunkStreamVersion, dsync, false);
    }

    public RegionFile(Path file, Path directory, RegionFileCompression outputChunkStreamVersion, boolean dsync, boolean canRecalcHeader) throws IOException {
        this.canRecalcHeader = canRecalcHeader;
        this.o = ByteBuffer.allocateDirect(8192);
        this.regionFile = file;
        this.initOversizedState();
        this.b = new RegionFileBitSet();
        this.n = outputChunkStreamVersion;
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            throw new IllegalArgumentException("Expected directory, got " + directory.toAbsolutePath());
        }
        this.m = directory;
        this.p = this.o.asIntBuffer();
        ((Buffer)this.p).limit(1024);
        ((Buffer)this.o).position(4096);
        this.q = this.o.asIntBuffer();
        this.l = dsync ? FileChannel.open(file, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.DSYNC) : FileChannel.open(file, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        this.b.a(0, 2);
        ((Buffer)this.o).position(0);
        int i2 = this.l.read(this.o, 0L);
        if (i2 != -1) {
            long j2;
            if (i2 != 8192) {
                c.warn("Region file {} has truncated header: {}", (Object)file, (Object)i2);
            }
            long regionFileSize = j2 = Files.size(file);
            boolean needsHeaderRecalc = false;
            boolean hasBackedUp = false;
            for (int k2 = 0; k2 < 1024; ++k2) {
                boolean failedToAllocate;
                int i1;
                int headerLocation = k2;
                int l2 = this.p.get(k2);
                if (l2 == 0) continue;
                int offset = i1 = RegionFile.b(l2);
                int j1 = RegionFile.a(l2);
                if (j1 == 255) {
                    ByteBuffer realLen = ByteBuffer.allocate(4);
                    this.l.read(realLen, i1 * 4096);
                    j1 = (realLen.getInt(0) + 4) / 4096 + 1;
                }
                int sectorLength = j1;
                if (i1 < 2) {
                    c.warn("Region file {} has invalid sector at index: {}; sector {} overlaps with header", new Object[]{file, k2, i1});
                } else if (j1 == 0) {
                    c.warn("Region file {} has an invalid sector at index: {}; size has to be > 0", (Object)file, (Object)k2);
                } else if ((long)i1 * 4096L > j2) {
                    c.warn("Region file {} has an invalid sector at index: {}; sector {} is out of bounds", new Object[]{file, k2, i1});
                }
                if (offset < 2 || sectorLength <= 0 || (long)offset * 4096L > regionFileSize) {
                    if (canRecalcHeader) {
                        c.error("Detected invalid header for regionfile " + this.regionFile.toAbsolutePath() + "! Recalculating header...");
                        needsHeaderRecalc = true;
                        break;
                    }
                    c.error("Detected invalid header for regionfile " + this.regionFile.toAbsolutePath() + "! Cannot recalculate, removing local chunk (" + (headerLocation & 0x1F) + "," + (headerLocation >>> 5) + ") from header");
                    if (!hasBackedUp) {
                        hasBackedUp = true;
                        this.backupRegionFile();
                    }
                    this.q.put(headerLocation, 0);
                    this.p.put(headerLocation, 0);
                    continue;
                }
                boolean bl = failedToAllocate = !this.b.tryAllocate(offset, sectorLength);
                if (failedToAllocate) {
                    c.error("Overlapping allocation by local chunk (" + (headerLocation & 0x1F) + "," + (headerLocation >>> 5) + ") in regionfile " + this.regionFile.toAbsolutePath());
                }
                if (failedToAllocate & !canRecalcHeader) {
                    c.error("Detected invalid header for regionfile " + this.regionFile.toAbsolutePath() + "! Cannot recalculate, removing local chunk (" + (headerLocation & 0x1F) + "," + (headerLocation >>> 5) + ") from header");
                    if (!hasBackedUp) {
                        hasBackedUp = true;
                        this.backupRegionFile();
                    }
                    this.q.put(headerLocation, 0);
                    this.p.put(headerLocation, 0);
                    continue;
                }
                needsHeaderRecalc |= failedToAllocate;
            }
            if (needsHeaderRecalc) {
                c.error("Recalculating regionfile " + this.regionFile.toAbsolutePath() + ", header gave erroneous offsets & locations");
                this.recalculateHeader();
            }
        }
    }

    private Path f(ChunkCoordIntPair chunkPos) {
        String s2 = "c." + chunkPos.e + "." + chunkPos.f + h;
        return this.m.resolve(s2);
    }

    private static ChunkCoordIntPair getOversizedChunkPair(Path file) {
        String fileName = file.getFileName().toString();
        if (!fileName.startsWith("c.") || !fileName.endsWith(h)) {
            return null;
        }
        String[] split = fileName.split("\\.");
        if (split.length != 4) {
            return null;
        }
        try {
            int x2 = Integer.parseInt(split[1]);
            int z2 = Integer.parseInt(split[2]);
            return new ChunkCoordIntPair(x2, z2);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    @Nullable
    public synchronized DataInputStream a(ChunkCoordIntPair pos) throws IOException {
        int i2 = this.g(pos);
        if (i2 == 0) {
            return null;
        }
        int j2 = RegionFile.b(i2);
        int k2 = RegionFile.a(i2);
        if (k2 == 255) {
            ByteBuffer realLen = ByteBuffer.allocate(4);
            this.l.read(realLen, j2 * 4096);
            k2 = (realLen.getInt(0) + 4) / 4096 + 1;
        }
        int l2 = k2 * 4096;
        ByteBuffer bytebuffer = ByteBuffer.allocate(l2);
        this.l.read(bytebuffer, j2 * 4096);
        ((Buffer)bytebuffer).flip();
        if (bytebuffer.remaining() < 5) {
            c.error("Chunk {} header is truncated: expected {} but read {}", new Object[]{pos, l2, bytebuffer.remaining()});
            if (this.canRecalcHeader && this.recalculateHeader()) {
                return this.a(pos);
            }
            return null;
        }
        int i1 = bytebuffer.getInt();
        byte b0 = bytebuffer.get();
        if (i1 == 0) {
            c.warn("Chunk {} is allocated, but stream is missing", (Object)pos);
            if (this.canRecalcHeader && this.recalculateHeader()) {
                return this.a(pos);
            }
            return null;
        }
        int j1 = i1 - 1;
        if (RegionFile.a(b0)) {
            DataInputStream ret;
            if (j1 != 0) {
                c.warn("Chunk has both internal and external streams");
                if (this.canRecalcHeader && this.recalculateHeader()) {
                    return this.a(pos);
                }
            }
            if ((ret = this.a(pos, RegionFile.b(b0))) == null && this.canRecalcHeader && this.recalculateHeader()) {
                return this.a(pos);
            }
            return ret;
        }
        if (j1 > bytebuffer.remaining()) {
            c.error("Chunk {} stream is truncated: expected {} but read {}", new Object[]{pos, j1, bytebuffer.remaining()});
            if (this.canRecalcHeader && this.recalculateHeader()) {
                return this.a(pos);
            }
            return null;
        }
        if (j1 < 0) {
            c.error("Declared size {} of chunk {} is negative", (Object)i1, (Object)pos);
            if (this.canRecalcHeader && this.recalculateHeader()) {
                return this.a(pos);
            }
            return null;
        }
        DataInputStream ret = this.a(pos, b0, RegionFile.a(bytebuffer, j1));
        if (ret == null && this.canRecalcHeader && this.recalculateHeader()) {
            return this.a(pos);
        }
        return ret;
    }

    private static int b() {
        return (int)(SystemUtils.d() / 1000L);
    }

    private static boolean a(byte flags) {
        return (flags & 0x80) != 0;
    }

    private static byte b(byte flags) {
        return (byte)(flags & 0xFFFFFF7F);
    }

    @Nullable
    private DataInputStream a(ChunkCoordIntPair pos, byte flags, InputStream stream) throws IOException {
        RegionFileCompression regionfilecompression = RegionFileCompression.a(flags);
        if (regionfilecompression == null) {
            c.error("Chunk {} has invalid chunk stream version {}", (Object)pos, (Object)flags);
            return null;
        }
        return new DataInputStream(regionfilecompression.a(stream));
    }

    @Nullable
    private DataInputStream a(ChunkCoordIntPair pos, byte flags) throws IOException {
        Path path = this.f(pos);
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            c.error("External chunk path {} is not file", (Object)path);
            return null;
        }
        return this.a(pos, flags, Files.newInputStream(path, new OpenOption[0]));
    }

    private static ByteArrayInputStream a(ByteBuffer buffer, int length) {
        return new ByteArrayInputStream(buffer.array(), buffer.position(), length);
    }

    private int a(int offset, int size) {
        return offset << 8 | size;
    }

    private static int a(int sectorData) {
        return sectorData & 0xFF;
    }

    private static int b(int sectorData) {
        return sectorData >> 8 & 0xFFFFFF;
    }

    private static int c(int byteCount) {
        return (byteCount + 4096 - 1) / 4096;
    }

    public synchronized boolean b(ChunkCoordIntPair pos) {
        int i2 = this.g(pos);
        if (i2 == 0) {
            return false;
        }
        int j2 = RegionFile.b(i2);
        int k2 = RegionFile.a(i2);
        ByteBuffer bytebuffer = ByteBuffer.allocate(5);
        try {
            this.l.read(bytebuffer, j2 * 4096);
            ((Buffer)bytebuffer).flip();
            if (bytebuffer.remaining() != 5) {
                return false;
            }
            int l2 = bytebuffer.getInt();
            byte b0 = bytebuffer.get();
            if (RegionFile.a(b0)) {
                if (!RegionFileCompression.b(RegionFile.b(b0))) {
                    return false;
                }
                if (!Files.isRegularFile(this.f(pos), new LinkOption[0])) {
                    return false;
                }
            } else {
                if (!RegionFileCompression.b(b0)) {
                    return false;
                }
                if (l2 == 0) {
                    return false;
                }
                int i1 = l2 - 1;
                if (i1 < 0 || i1 > 4096 * k2) {
                    return false;
                }
            }
            return true;
        }
        catch (IOException ioexception) {
            SneakyThrow.sneaky((Throwable)ioexception);
            return false;
        }
    }

    public DataOutputStream c(ChunkCoordIntPair pos) throws IOException {
        return new DataOutputStream(this.n.a(new ChunkBuffer(pos)));
    }

    public void a() throws IOException {
        this.l.force(true);
    }

    public void d(ChunkCoordIntPair pos) throws IOException {
        int i2 = RegionFile.h(pos);
        int j2 = this.p.get(i2);
        if (j2 != 0) {
            this.p.put(i2, 0);
            this.q.put(i2, RegionFile.b());
            this.d();
            Files.deleteIfExists(this.f(pos));
            this.b.b(RegionFile.b(j2), RegionFile.a(j2));
        }
    }

    protected synchronized void a(ChunkCoordIntPair pos, ByteBuffer buf) throws IOException {
        b regionfile_b;
        int k1;
        int i2 = RegionFile.h(pos);
        int j2 = this.p.get(i2);
        int k2 = RegionFile.b(j2);
        int l2 = RegionFile.a(j2);
        int i1 = buf.remaining();
        int j1 = RegionFile.c(i1);
        if (j1 >= 256) {
            Path path = this.f(pos);
            c.warn("Saving oversized chunk {} ({} bytes} to external file {}", new Object[]{pos, i1, path});
            j1 = 1;
            k1 = this.b.a(j1);
            regionfile_b = this.a(path, buf);
            ByteBuffer bytebuffer1 = this.c();
            this.l.write(bytebuffer1, k1 * 4096);
        } else {
            k1 = this.b.a(j1);
            regionfile_b = () -> Files.deleteIfExists(this.f(pos));
            this.l.write(buf, k1 * 4096);
        }
        this.p.put(i2, this.a(k1, j1));
        this.q.put(i2, RegionFile.b());
        this.d();
        regionfile_b.run();
        if (k2 != 0) {
            this.b.b(k2, l2);
        }
    }

    private ByteBuffer c() {
        return this.createExternalStub(this.n);
    }

    private ByteBuffer createExternalStub(RegionFileCompression version) {
        ByteBuffer bytebuffer = ByteBuffer.allocate(5);
        bytebuffer.putInt(1);
        bytebuffer.put((byte)(version.a() | 0x80));
        ((Buffer)bytebuffer).flip();
        return bytebuffer;
    }

    private b a(Path path, ByteBuffer buf) throws IOException {
        Path path1 = Files.createTempFile(this.m, "tmp", (String)null, new FileAttribute[0]);
        FileChannel filechannel = FileChannel.open(path1, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        try {
            ((Buffer)buf).position(5);
            filechannel.write(buf);
        }
        catch (Throwable throwable) {
            ServerInternalException.reportInternalException((Throwable)throwable);
            if (filechannel != null) {
                try {
                    filechannel.close();
                }
                catch (Throwable throwable1) {
                    throwable.addSuppressed(throwable1);
                }
            }
            throw throwable;
        }
        if (filechannel != null) {
            filechannel.close();
        }
        return () -> Files.move(path1, path, StandardCopyOption.REPLACE_EXISTING);
    }

    private void d() throws IOException {
        ((Buffer)this.o).position(0);
        this.l.write(this.o, 0L);
    }

    private int g(ChunkCoordIntPair pos) {
        return this.p.get(RegionFile.h(pos));
    }

    public boolean e(ChunkCoordIntPair pos) {
        return this.g(pos) != 0;
    }

    private static int getChunkLocation(int x2, int z2) {
        return (x2 & 0x1F) + (z2 & 0x1F) * 32;
    }

    private static int h(ChunkCoordIntPair pos) {
        return pos.j() + pos.k() * 32;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.fileLock.lock();
        RegionFile regionFile = this;
        synchronized (regionFile) {
            try {
                this.closed = true;
                try {
                    this.e();
                }
                finally {
                    try {
                        this.l.force(true);
                    }
                    finally {
                        this.l.close();
                    }
                }
            }
            finally {
                this.fileLock.unlock();
            }
        }
    }

    private void e() throws IOException {
        int j2;
        int i2 = (int)this.l.size();
        if (i2 != (j2 = RegionFile.c(i2) * 4096)) {
            ByteBuffer bytebuffer = g.duplicate();
            ((Buffer)bytebuffer).position(0);
            this.l.write(bytebuffer, j2 - 1);
        }
    }

    private synchronized void initOversizedState() throws IOException {
        Path metaFile = this.getOversizedMetaFile();
        if (Files.exists(metaFile, new LinkOption[0])) {
            byte[] read = Files.readAllBytes(metaFile);
            System.arraycopy(read, 0, this.oversized, 0, this.oversized.length);
            for (byte temp : this.oversized) {
                this.oversizedCount += temp;
            }
        }
    }

    private static int getChunkIndex(int x2, int z2) {
        return (x2 & 0x1F) + (z2 & 0x1F) * 32;
    }

    synchronized boolean isOversized(int x2, int z2) {
        return this.oversized[RegionFile.getChunkIndex(x2, z2)] == 1;
    }

    synchronized void setOversized(int x2, int z2, boolean oversized) throws IOException {
        Path oversizedMetaFile;
        Path oversizedFile;
        int offset = RegionFile.getChunkIndex(x2, z2);
        boolean previous = this.oversized[offset] == 1;
        this.oversized[offset] = (byte)(oversized ? 1 : 0);
        if (!previous && oversized) {
            ++this.oversizedCount;
        } else if (!oversized && previous) {
            --this.oversizedCount;
        }
        if (previous && !oversized && Files.exists(oversizedFile = this.getOversizedFile(x2, z2), new LinkOption[0])) {
            Files.delete(oversizedFile);
        }
        if (this.oversizedCount > 0) {
            if (previous != oversized) {
                this.writeOversizedMeta();
            }
        } else if (previous && Files.exists(oversizedMetaFile = this.getOversizedMetaFile(), new LinkOption[0])) {
            Files.delete(oversizedMetaFile);
        }
    }

    private void writeOversizedMeta() throws IOException {
        Files.write(this.getOversizedMetaFile(), this.oversized, new OpenOption[0]);
    }

    private Path getOversizedMetaFile() {
        return this.regionFile.getParent().resolve(this.regionFile.getFileName().toString().replaceAll("\\.mca$", "") + ".oversized.nbt");
    }

    private Path getOversizedFile(int x2, int z2) {
        return this.regionFile.getParent().resolve(this.regionFile.getFileName().toString().replaceAll("\\.mca$", "") + "_oversized_" + x2 + "_" + z2 + ".nbt");
    }

    synchronized NBTTagCompound getOversizedData(int x2, int z2) throws IOException {
        Path file = this.getOversizedFile(x2, z2);
        try (DataInputStream out = new DataInputStream(new BufferedInputStream(new InflaterInputStream(Files.newInputStream(file, new OpenOption[0]))));){
            NBTTagCompound nBTTagCompound = NBTCompressedStreamTools.a(out);
            return nBTTagCompound;
        }
    }

    private class ChunkBuffer
    extends ByteArrayOutputStream {
        private final ChunkCoordIntPair b;

        public ChunkBuffer(ChunkCoordIntPair chunkcoordintpair) {
            super(8096);
            super.write(0);
            super.write(0);
            super.write(0);
            super.write(0);
            super.write(RegionFile.this.n.a());
            this.b = chunkcoordintpair;
        }

        @Override
        public void write(int b2) {
            if (this.count > 524288000) {
                throw new RegionFileCache.RegionFileSizeException("Region file too large: " + this.count);
            }
            super.write(b2);
        }

        @Override
        public void write(byte[] b2, int off, int len) {
            if (this.count + len > 524288000) {
                throw new RegionFileCache.RegionFileSizeException("Region file too large: " + (this.count + len));
            }
            super.write(b2, off, len);
        }

        @Override
        public void close() throws IOException {
            ByteBuffer bytebuffer = ByteBuffer.wrap(this.buf, 0, this.count);
            bytebuffer.putInt(0, this.count - 5 + 1);
            RegionFile.this.a(this.b, bytebuffer);
        }
    }

    private static interface b {
        public void run() throws IOException;
    }
}

