/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.storage.RegionFileCache;
import org.slf4j.Logger;

public class RegionFileSection<R>
extends RegionFileCache
implements AutoCloseable {
    private static final Logger a = LogUtils.getLogger();
    private static final String b = "Sections";
    private final Long2ObjectMap<Optional<R>> e = new Long2ObjectOpenHashMap();
    private final LongLinkedOpenHashSet f = new LongLinkedOpenHashSet();
    private final Function<Runnable, Codec<R>> g;
    private final Function<Runnable, R> h;
    private final DataFixer i;
    private final DataFixTypes j;
    public final IRegistryCustom k;
    protected final LevelHeightAccessor c;

    public RegionFileSection(Path path, Function<Runnable, Codec<R>> codecFactory, Function<Runnable, R> factory, DataFixer dataFixer, DataFixTypes dataFixTypes, boolean dsync, IRegistryCustom dynamicRegistryManager, LevelHeightAccessor world) {
        super(path, dsync);
        this.g = codecFactory;
        this.h = factory;
        this.i = dataFixer;
        this.j = dataFixTypes;
        this.k = dynamicRegistryManager;
        this.c = world;
    }

    protected void a(BooleanSupplier shouldKeepTicking) {
        while (this.a() && shouldKeepTicking.getAsBoolean()) {
            ChunkCoordIntPair chunkPos = SectionPosition.a(this.f.firstLong()).r();
            this.d(chunkPos);
        }
    }

    public boolean a() {
        return !this.f.isEmpty();
    }

    @Nullable
    public Optional<R> c(long pos) {
        return (Optional)this.e.get(pos);
    }

    public Optional<R> d(long pos) {
        if (this.e(pos)) {
            return Optional.empty();
        }
        Optional<R> optional = this.c(pos);
        if (optional != null) {
            return optional;
        }
        this.b(SectionPosition.a(pos).r());
        optional = this.c(pos);
        if (optional == null) {
            throw SystemUtils.b(new IllegalStateException());
        }
        return optional;
    }

    protected boolean e(long pos) {
        int i2 = SectionPosition.c(SectionPosition.c(pos));
        return this.c.d(i2);
    }

    protected R f(long pos) {
        if (this.e(pos)) {
            throw SystemUtils.b(new IllegalArgumentException("sectionPos out of bounds"));
        }
        Optional<R> optional = this.d(pos);
        if (optional.isPresent()) {
            return optional.get();
        }
        R object = this.h.apply(() -> this.a(pos));
        this.e.put(pos, Optional.of(object));
        return object;
    }

    private void b(ChunkCoordIntPair pos) {
        throw new IllegalStateException("Only chunk system can load in state, offending class:" + this.getClass().getName());
    }

    private CompletableFuture<Optional<NBTTagCompound>> c(ChunkCoordIntPair pos) {
        try {
            return CompletableFuture.completedFuture(Optional.ofNullable(this.a(pos)));
        }
        catch (Throwable thr) {
            return CompletableFuture.failedFuture(thr);
        }
    }

    private <T> void a(ChunkCoordIntPair pos, DynamicOps<T> ops, @Nullable T data) {
        throw new IllegalStateException("Only chunk system can load in state, offending class:" + this.getClass().getName());
    }

    private void d(ChunkCoordIntPair pos) {
        RegistryOps<NBTBase> registryOps = RegistryOps.a(DynamicOpsNBT.a, this.k);
        Dynamic<NBTBase> dynamic = this.a(pos, registryOps);
        NBTBase tag = dynamic.getValue();
        if (tag instanceof NBTTagCompound) {
            try {
                this.a(pos, (NBTTagCompound)tag);
            }
            catch (IOException ioexception) {
                a.error("Error writing data to disk", (Throwable)ioexception);
            }
        } else {
            a.error("Expected compound tag, got {}", (Object)tag);
        }
    }

    private <T> Dynamic<T> a(ChunkCoordIntPair chunkPos, DynamicOps<T> ops) {
        HashMap map = Maps.newHashMap();
        for (int i2 = this.c.ak(); i2 < this.c.al(); ++i2) {
            long l2 = RegionFileSection.a(chunkPos, i2);
            this.f.remove(l2);
            Optional optional = (Optional)this.e.get(l2);
            if (optional == null || !optional.isPresent()) continue;
            DataResult dataResult = this.g.apply(() -> this.a(l2)).encodeStart(ops, optional.get());
            String string = Integer.toString(i2);
            dataResult.resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)).ifPresent(object -> map.put(ops.createString(string), object));
        }
        return new Dynamic<Object>(ops, ops.createMap((Map)ImmutableMap.of((Object)ops.createString(b), (Object)ops.createMap((Map)map), (Object)ops.createString("DataVersion"), (Object)ops.createInt(SharedConstants.b().d().c()))));
    }

    private static long a(ChunkCoordIntPair chunkPos, int y2) {
        return SectionPosition.b(chunkPos.e, y2, chunkPos.f);
    }

    protected void b(long pos) {
    }

    protected void a(long pos) {
        Optional optional = (Optional)this.e.get(pos);
        if (optional != null && optional.isPresent()) {
            this.f.add(pos);
        } else {
            a.warn("No data for position: {}", (Object)SectionPosition.a(pos));
        }
    }

    private static int a(Dynamic<?> dynamic) {
        return dynamic.get("DataVersion").asInt(1945);
    }

    public void a(ChunkCoordIntPair pos) {
        if (this.a()) {
            for (int i2 = this.c.ak(); i2 < this.c.al(); ++i2) {
                long l2 = RegionFileSection.a(pos, i2);
                if (!this.f.contains(l2)) continue;
                this.d(pos);
                return;
            }
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    private /* synthetic */ void lambda$readColumn$3(long m2, boolean bl, Object sections) {
        this.b(m2);
        if (bl) {
            this.a(m2);
        }
    }

    private /* synthetic */ Optional lambda$readColumn$2(long m2, Dynamic dynamicx) {
        return this.g.apply(() -> this.a(m2)).parse(dynamicx).resultOrPartial(arg_0 -> ((Logger)a).error(arg_0));
    }
}

