/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.entity;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.World;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityTypeTest;
import org.slf4j.Logger;

public class EntityLookup<T extends EntityAccess> {
    private static final Logger a = LogUtils.getLogger();
    private final Int2ObjectMap<T> b = new Int2ObjectLinkedOpenHashMap();
    private final Map<UUID, T> c = Maps.newHashMap();

    public <U extends T> void a(EntityTypeTest<T, U> filter, AbortableIterationConsumer<U> consumer) {
        for (EntityAccess entityAccess : this.b.values()) {
            EntityAccess entityAccess2 = (EntityAccess)filter.a(entityAccess);
            if (entityAccess2 == null || !consumer.accept(entityAccess2).a()) continue;
            return;
        }
    }

    public Iterable<T> a() {
        return Iterables.unmodifiableIterable((Iterable)this.b.values());
    }

    public void a(T entity) {
        UUID uUID = entity.cs();
        if (this.c.containsKey(uUID)) {
            a.warn("Duplicate entity UUID {}: {}", (Object)uUID, entity);
            if (entity instanceof Entity) {
                EntityAccess old;
                Entity entityCast = (Entity)entity;
                if (World.DEBUG_ENTITIES) {
                    entityCast.addedToWorldStack = WorldServer.getAddToWorldStackTrace(entityCast);
                }
                if ((old = (EntityAccess)this.c.get(entity.cs())) instanceof Entity) {
                    Entity oldCast = (Entity)old;
                    if (old != null && oldCast.af() != entity.af() && oldCast.valid) {
                        a.error("Overwrote an existing entity " + oldCast + " with " + entity);
                        if (World.DEBUG_ENTITIES) {
                            if (oldCast.addedToWorldStack != null) {
                                oldCast.addedToWorldStack.printStackTrace();
                            } else {
                                a.error("Oddly, the old entity was not added to the world in the normal way. Plugins?");
                            }
                            entityCast.addedToWorldStack.printStackTrace();
                        }
                    }
                }
            }
        } else {
            this.c.put(uUID, entity);
            this.b.put(entity.af(), entity);
        }
    }

    public void b(T entity) {
        this.c.remove(entity.cs());
        this.b.remove(entity.af());
    }

    @Nullable
    public T a(int id) {
        return (T)((EntityAccess)this.b.get(id));
    }

    @Nullable
    public T a(UUID uuid) {
        return (T)((EntityAccess)this.c.get(uuid));
    }

    public int b() {
        return this.c.size();
    }
}

