/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent.vibrations;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationInfo;
import net.minecraft.world.level.gameevent.vibrations.VibrationSelector;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockReceiveGameEvent;

public class VibrationListener
implements GameEventListener {
    @VisibleForTesting
    public static final Object2IntMap<GameEvent> a = Object2IntMaps.unmodifiable((Object2IntMap)((Object2IntMap)SystemUtils.a(new Object2IntOpenHashMap(), object2intopenhashmap -> {
        object2intopenhashmap.put((Object)GameEvent.T, 1);
        object2intopenhashmap.put((Object)GameEvent.E, 2);
        object2intopenhashmap.put((Object)GameEvent.z, 2);
        object2intopenhashmap.put((Object)GameEvent.U, 3);
        object2intopenhashmap.put((Object)GameEvent.o, 4);
        object2intopenhashmap.put((Object)GameEvent.C, 5);
        object2intopenhashmap.put((Object)GameEvent.V, 5);
        object2intopenhashmap.put((Object)GameEvent.S, 6);
        object2intopenhashmap.put((Object)GameEvent.w, 6);
        object2intopenhashmap.put((Object)GameEvent.c, 6);
        object2intopenhashmap.put((Object)GameEvent.J, 6);
        object2intopenhashmap.put((Object)GameEvent.r, 6);
        object2intopenhashmap.put((Object)GameEvent.O, 7);
        object2intopenhashmap.put((Object)GameEvent.m, 7);
        object2intopenhashmap.put((Object)GameEvent.M, 7);
        object2intopenhashmap.put((Object)GameEvent.t, 7);
        object2intopenhashmap.put((Object)GameEvent.N, 8);
        object2intopenhashmap.put((Object)GameEvent.n, 8);
        object2intopenhashmap.put((Object)GameEvent.s, 8);
        object2intopenhashmap.put((Object)GameEvent.p, 8);
        object2intopenhashmap.put((Object)GameEvent.x, 9);
        object2intopenhashmap.put((Object)GameEvent.Q, 9);
        object2intopenhashmap.put((Object)GameEvent.v, 9);
        object2intopenhashmap.put((Object)GameEvent.d, 10);
        object2intopenhashmap.put((Object)GameEvent.e, 10);
        object2intopenhashmap.put((Object)GameEvent.g, 10);
        object2intopenhashmap.put((Object)GameEvent.l, 10);
        object2intopenhashmap.put((Object)GameEvent.h, 11);
        object2intopenhashmap.put((Object)GameEvent.a, 11);
        object2intopenhashmap.put((Object)GameEvent.b, 11);
        object2intopenhashmap.put((Object)GameEvent.u, 12);
        object2intopenhashmap.put((Object)GameEvent.i, 12);
        object2intopenhashmap.put((Object)GameEvent.B, 12);
        object2intopenhashmap.put((Object)GameEvent.q, 13);
        object2intopenhashmap.put((Object)GameEvent.f, 13);
        object2intopenhashmap.put((Object)GameEvent.A, 13);
        object2intopenhashmap.put((Object)GameEvent.j, 14);
        object2intopenhashmap.put((Object)GameEvent.K, 14);
        object2intopenhashmap.put((Object)GameEvent.L, 15);
        object2intopenhashmap.put((Object)GameEvent.k, 15);
        object2intopenhashmap.put((Object)GameEvent.y, 15);
        object2intopenhashmap.put((Object)GameEvent.I, 15);
        object2intopenhashmap.put((Object)GameEvent.D, 15);
    })));
    protected final PositionSource b;
    public int c;
    protected final a d;
    @Nullable
    protected VibrationInfo e;
    protected int f;
    private final VibrationSelector g;

    public static Codec<VibrationListener> a(a callback) {
        return RecordCodecBuilder.create(instance -> instance.group((App)PositionSource.b.fieldOf("source").forGetter(vibrationlistener -> vibrationlistener.b), (App)ExtraCodecs.h.fieldOf("range").forGetter(vibrationlistener -> vibrationlistener.c), (App)VibrationInfo.a.optionalFieldOf("event").forGetter(vibrationlistener -> Optional.ofNullable(vibrationlistener.e)), (App)Codec.optionalField((String)"selector", VibrationSelector.a).xmap(o2 -> o2.orElseGet(VibrationSelector::new), Optional::of).forGetter(vibrationlistener -> vibrationlistener.g), (App)ExtraCodecs.h.fieldOf("event_delay").orElse((Object)0).forGetter(vibrationlistener -> vibrationlistener.f)).apply((Applicative)instance, (positionsource, integer, optional, vibrationselector, integer1) -> new VibrationListener((PositionSource)positionsource, (int)integer, callback, optional.orElse(null), (VibrationSelector)vibrationselector, (int)integer1)));
    }

    private VibrationListener(PositionSource positionSource, int range, a callback, @Nullable VibrationInfo vibration, VibrationSelector selector, int delay) {
        this.b = positionSource;
        this.c = range;
        this.d = callback;
        this.e = vibration;
        this.f = delay;
        this.g = selector;
    }

    public VibrationListener(PositionSource positionSource, int range, a callback) {
        this(positionSource, range, callback, null, new VibrationSelector(), 0);
    }

    public static int a(GameEvent event) {
        return a.getOrDefault((Object)event, 0);
    }

    public void a(World world) {
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (this.e == null) {
                this.g.a(worldserver.U()).ifPresent(vibrationinfo -> {
                    this.e = vibrationinfo;
                    Vec3D vec3d = this.e.c();
                    this.f = MathHelper.d(this.e.b());
                    worldserver.a(new VibrationParticleOption(this.b, this.f), vec3d.c, vec3d.d, vec3d.e, 1, 0.0, 0.0, 0.0, 0.0);
                    this.d.f();
                    this.g.a();
                });
            }
            if (this.e != null) {
                --this.f;
                if (this.f <= 0) {
                    this.f = 0;
                    this.d.a(worldserver, this, BlockPosition.a(this.e.c()), this.e.a(), this.e.a(worldserver).orElse(null), this.e.b(worldserver).orElse(null), this.e.b());
                    this.e = null;
                }
            }
        }
    }

    @Override
    public PositionSource a() {
        return this.b;
    }

    @Override
    public int b() {
        return this.c;
    }

    @Override
    public boolean a(WorldServer world, GameEvent event, GameEvent.a emitter, Vec3D emitterPos) {
        if (this.e != null) {
            return false;
        }
        if (!this.d.a(event, emitter)) {
            return false;
        }
        Optional<Vec3D> optional = this.b.a(world);
        if (optional.isEmpty()) {
            return false;
        }
        Vec3D vec3d1 = optional.get();
        boolean defaultCancel = !this.d.a(world, this, BlockPosition.a(emitterPos), event, emitter);
        net.minecraft.world.entity.Entity entity = emitter.a();
        BlockReceiveGameEvent event1 = new BlockReceiveGameEvent(org.bukkit.GameEvent.getByKey((NamespacedKey)CraftNamespacedKey.fromMinecraft(BuiltInRegistries.b.b(event))), (Block)CraftBlock.at(world, BlockPosition.a(vec3d1)), (Entity)(entity == null ? null : entity.getBukkitEntity()));
        event1.setCancelled(defaultCancel);
        world.getCraftServer().getPluginManager().callEvent((Event)event1);
        if (event1.isCancelled()) {
            return false;
        }
        if (VibrationListener.a(world, emitterPos, vec3d1)) {
            return false;
        }
        this.a(world, event, emitter, emitterPos, vec3d1);
        return true;
    }

    public void b(WorldServer world, GameEvent event, GameEvent.a emitter, Vec3D emitterPos) {
        this.b.a(world).ifPresent(vec3d1 -> this.a(world, event, emitter, emitterPos, (Vec3D)vec3d1));
    }

    public void a(WorldServer world, GameEvent event, GameEvent.a emitter, Vec3D emitterPos, Vec3D listenerPos) {
        this.g.a(new VibrationInfo(event, (float)emitterPos.f(listenerPos), emitterPos, emitter.a()), world.U());
    }

    private static boolean a(World world, Vec3D start, Vec3D end) {
        Vec3D vec3d2 = new Vec3D((double)MathHelper.a(start.c) + 0.5, (double)MathHelper.a(start.d) + 0.5, (double)MathHelper.a(start.e) + 0.5);
        Vec3D vec3d3 = new Vec3D((double)MathHelper.a(end.c) + 0.5, (double)MathHelper.a(end.d) + 0.5, (double)MathHelper.a(end.e) + 0.5);
        for (EnumDirection enumdirection : EnumDirection.values()) {
            Vec3D vec3d4 = vec3d2.a(enumdirection, (double)1.0E-5f);
            if (world.a(new ClipBlockStateContext(vec3d4, vec3d3, iblockdata -> iblockdata.a(TagsBlock.bl))).c() == MovingObjectPosition.EnumMovingObjectType.b) continue;
            return false;
        }
        return true;
    }

    public static interface a {
        default public TagKey<GameEvent> a() {
            return GameEventTags.a;
        }

        default public boolean w() {
            return false;
        }

        default public boolean a(GameEvent gameEvent, GameEvent.a emitter) {
            if (!gameEvent.a(this.a())) {
                return false;
            }
            net.minecraft.world.entity.Entity entity = emitter.a();
            if (entity != null) {
                if (entity.F_()) {
                    return false;
                }
                if (entity.bP() && gameEvent.a(GameEventTags.d)) {
                    if (this.w() && entity instanceof EntityPlayer) {
                        EntityPlayer entityplayer = (EntityPlayer)entity;
                        CriterionTriggers.Y.a(entityplayer);
                    }
                    return false;
                }
                if (entity.aR()) {
                    return false;
                }
            }
            return emitter.b() != null ? !emitter.b().a(TagsBlock.bm) : true;
        }

        public boolean a(WorldServer var1, GameEventListener var2, BlockPosition var3, GameEvent var4, GameEvent.a var5);

        public void a(WorldServer var1, GameEventListener var2, BlockPosition var3, GameEvent var4, @Nullable net.minecraft.world.entity.Entity var5, @Nullable net.minecraft.world.entity.Entity var6, float var7);

        default public void f() {
        }
    }
}

