/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.BitSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.LongStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;

public final class BelowZeroRetrogen {
    private static final BitSet c = new BitSet(0);
    private static final Codec<BitSet> d = Codec.LONG_STREAM.xmap(serializedBedrockBitSet -> BitSet.valueOf(serializedBedrockBitSet.toArray()), bedrockBitSet -> LongStream.of(bedrockBitSet.toLongArray()));
    private static final Codec<ChunkStatus> e = BuiltInRegistries.o.q().comapFlatMap(status -> status == ChunkStatus.c ? DataResult.error(() -> "target_status cannot be empty") : DataResult.success((Object)status), Function.identity());
    public static final Codec<BelowZeroRetrogen> a = RecordCodecBuilder.create(instance -> instance.group((App)e.fieldOf("target_status").forGetter(BelowZeroRetrogen::a), (App)d.optionalFieldOf("missing_bedrock").forGetter(belowZeroRetrogen -> belowZeroRetrogen.h.isEmpty() ? Optional.empty() : Optional.of(belowZeroRetrogen.h))).apply((Applicative)instance, BelowZeroRetrogen::new));
    private static final Set<ResourceKey<BiomeBase>> f = Set.of(Biomes.aa, Biomes.Z);
    public static final LevelHeightAccessor b = new LevelHeightAccessor(){

        @Override
        @Override
        public int w_() {
            return 64;
        }

        @Override
        @Override
        public int v_() {
            return -64;
        }
    };
    private final ChunkStatus g;
    private final BitSet h;

    private BelowZeroRetrogen(ChunkStatus targetStatus, Optional<BitSet> missingBedrock) {
        this.g = targetStatus;
        this.h = missingBedrock.orElse(c);
    }

    @Nullable
    public static BelowZeroRetrogen a(NBTTagCompound nbt) {
        ChunkStatus chunkStatus = ChunkStatus.a(nbt.l("target_status"));
        if (chunkStatus == ChunkStatus.c) {
            return null;
        }
        return new BelowZeroRetrogen(chunkStatus, Optional.of(BitSet.valueOf(nbt.o("missing_bedrock"))));
    }

    public static void a(ProtoChunk chunk) {
        int i2 = 4;
        BlockPosition.b(0, 0, 0, 15, 4, 15).forEach(pos -> {
            if (chunk.a_((BlockPosition)pos).a(Blocks.F)) {
                chunk.a((BlockPosition)pos, Blocks.rD.o(), false);
            }
        });
    }

    public void b(ProtoChunk chunk) {
        LevelHeightAccessor levelHeightAccessor = chunk.z();
        int i2 = levelHeightAccessor.v_();
        int j2 = levelHeightAccessor.ai() - 1;
        for (int k2 = 0; k2 < 16; ++k2) {
            for (int l2 = 0; l2 < 16; ++l2) {
                if (!this.a(k2, l2)) continue;
                BlockPosition.b(k2, i2, l2, k2, j2, l2).forEach(pos -> chunk.a((BlockPosition)pos, Blocks.a.o(), false));
            }
        }
    }

    public ChunkStatus a() {
        return this.g;
    }

    public boolean b() {
        return !this.h.isEmpty();
    }

    public boolean a(int x2, int z2) {
        return this.h.get((z2 & 0xF) * 16 + (x2 & 0xF));
    }

    public static BiomeResolver a(BiomeResolver biomeSupplier, IChunkAccess chunk) {
        if (!chunk.y()) {
            return biomeSupplier;
        }
        Predicate<ResourceKey> predicate = f::contains;
        return (x2, y2, z2, noise) -> {
            Holder<BiomeBase> holder = biomeSupplier.getNoiseBiome(x2, y2, z2, noise);
            if (holder.a(predicate)) {
                return holder;
            }
            return chunk.getNoiseBiome(x2, 0, z2);
        };
    }
}

