/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.primitives.Longs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.MarsagliaPolarGaussian;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.Xoroshiro128PlusPlus;

public class XoroshiroRandomSource
implements RandomSource {
    private static final float b = 5.9604645E-8f;
    private static final double c = (double)1.110223E-16f;
    private Xoroshiro128PlusPlus d;
    private final MarsagliaPolarGaussian e = new MarsagliaPolarGaussian(this);

    public XoroshiroRandomSource(long seed) {
        this.d = new Xoroshiro128PlusPlus(RandomSupport.b(seed));
    }

    public XoroshiroRandomSource(long seedLo, long seedHi) {
        this.d = new Xoroshiro128PlusPlus(seedLo, seedHi);
    }

    @Override
    @Override
    public RandomSource d() {
        return new XoroshiroRandomSource(this.d.a(), this.d.a());
    }

    @Override
    @Override
    public PositionalRandomFactory e() {
        return new a(this.d.a(), this.d.a());
    }

    @Override
    @Override
    public void b(long seed) {
        this.d = new Xoroshiro128PlusPlus(RandomSupport.b(seed));
        this.e.a();
    }

    @Override
    @Override
    public int f() {
        return (int)this.d.a();
    }

    @Override
    @Override
    public int a(int bound) {
        if (bound <= 0) {
            throw new IllegalArgumentException("Bound must be positive");
        }
        long l2 = Integer.toUnsignedLong(this.f());
        long m2 = l2 * (long)bound;
        long n2 = m2 & 0xFFFFFFFFL;
        if (n2 < (long)bound) {
            int i2 = Integer.remainderUnsigned(~bound + 1, bound);
            while (n2 < (long)i2) {
                l2 = Integer.toUnsignedLong(this.f());
                m2 = l2 * (long)bound;
                n2 = m2 & 0xFFFFFFFFL;
            }
        }
        long o2 = m2 >> 32;
        return (int)o2;
    }

    @Override
    @Override
    public long g() {
        return this.d.a();
    }

    @Override
    @Override
    public boolean h() {
        return (this.d.a() & 1L) != 0L;
    }

    @Override
    @Override
    public float i() {
        return (float)this.c(24) * 5.9604645E-8f;
    }

    @Override
    @Override
    public double j() {
        return (double)this.c(53) * (double)1.110223E-16f;
    }

    @Override
    @Override
    public double k() {
        return this.e.b();
    }

    @Override
    @Override
    public void b(int count) {
        for (int i2 = 0; i2 < count; ++i2) {
            this.d.a();
        }
    }

    private long c(int bits) {
        return this.d.a() >>> 64 - bits;
    }

    public static class a
    implements PositionalRandomFactory {
        private static final HashFunction a = Hashing.md5();
        private final long b;
        private final long c;

        public a(long seedLo, long seedHi) {
            this.b = seedLo;
            this.c = seedHi;
        }

        @Override
        @Override
        public RandomSource a(int x2, int y2, int z2) {
            long l2 = MathHelper.b(x2, y2, z2);
            long m2 = l2 ^ this.b;
            return new XoroshiroRandomSource(m2, this.c);
        }

        @Override
        @Override
        public RandomSource a(String seed) {
            byte[] bs = a.hashString((CharSequence)seed, Charsets.UTF_8).asBytes();
            long l2 = Longs.fromBytes((byte)bs[0], (byte)bs[1], (byte)bs[2], (byte)bs[3], (byte)bs[4], (byte)bs[5], (byte)bs[6], (byte)bs[7]);
            long m2 = Longs.fromBytes((byte)bs[8], (byte)bs[9], (byte)bs[10], (byte)bs[11], (byte)bs[12], (byte)bs[13], (byte)bs[14], (byte)bs[15]);
            return new XoroshiroRandomSource(l2 ^ this.b, m2 ^ this.c);
        }

        @Override
        @VisibleForTesting
        @Override
        public void a(StringBuilder info) {
            info.append("seedLo: ").append(this.b).append(", seedHi: ").append(this.c);
        }
    }
}

