/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IWorldWriter;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureTreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacer;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTree;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.VoxelShapeBitSet;
import net.minecraft.world.phys.shapes.VoxelShapeDiscrete;

public class WorldGenTrees
extends WorldGenerator<WorldGenFeatureTreeConfiguration> {
    private static final int a = 19;

    public WorldGenTrees(Codec<WorldGenFeatureTreeConfiguration> configCodec) {
        super(configCodec);
    }

    private static boolean e(VirtualLevelReadable world, BlockPosition pos) {
        return world.a(pos, (IBlockData state) -> state.a(Blocks.fe));
    }

    public static boolean b(VirtualLevelReadable world, BlockPosition pos) {
        return world.a(pos, (IBlockData state) -> state.a(Blocks.G));
    }

    public static boolean c(VirtualLevelReadable world, BlockPosition pos) {
        return world.a(pos, (IBlockData state) -> state.h() || state.a(TagsBlock.N));
    }

    private static boolean f(VirtualLevelReadable world, BlockPosition pos) {
        return world.a(pos, (IBlockData state) -> {
            Material material = state.d();
            return material == Material.g || material == Material.i || material == Material.h;
        });
    }

    private static void b(IWorldWriter world, BlockPosition pos, IBlockData state) {
        world.a(pos, state, 19);
    }

    public static boolean d(VirtualLevelReadable world, BlockPosition pos) {
        return WorldGenTrees.c(world, pos) || WorldGenTrees.f(world, pos) || WorldGenTrees.b(world, pos);
    }

    private boolean a(GeneratorAccessSeed world, RandomSource random, BlockPosition pos, BiConsumer<BlockPosition, IBlockData> rootPlacerReplacer, BiConsumer<BlockPosition, IBlockData> trunkPlacerReplacer, WorldGenFoilagePlacer.b blockPlacer, WorldGenFeatureTreeConfiguration config) {
        int i2 = config.d.a(random);
        int j2 = config.f.a(random, i2, config);
        int k2 = i2 - j2;
        int l2 = config.f.a(random, k2);
        BlockPosition blockPos = config.g.map(rootPlacer -> rootPlacer.a(pos, random)).orElse(pos);
        int m2 = Math.min(pos.v(), blockPos.v());
        int n2 = Math.max(pos.v(), blockPos.v()) + i2 + 1;
        if (m2 < world.v_() + 1 || n2 > world.ai()) {
            return false;
        }
        OptionalInt optionalInt = config.h.c();
        int o2 = this.a((VirtualLevelReadable)world, i2, blockPos, config);
        if (o2 < i2 && (optionalInt.isEmpty() || o2 < optionalInt.getAsInt())) {
            return false;
        }
        if (config.g.isPresent() && !config.g.get().a(world, rootPlacerReplacer, random, pos, blockPos, config)) {
            return false;
        }
        List<WorldGenFoilagePlacer.a> list = config.d.a((VirtualLevelReadable)world, trunkPlacerReplacer, random, o2, blockPos, config);
        list.forEach(node -> treeConfiguration.f.a((VirtualLevelReadable)world, blockPlacer, random, config, o2, (WorldGenFoilagePlacer.a)node, j2, l2));
        return true;
    }

    private int a(VirtualLevelReadable world, int height, BlockPosition pos, WorldGenFeatureTreeConfiguration config) {
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int i2 = 0; i2 <= height + 1; ++i2) {
            int j2 = config.h.a(height, i2);
            for (int k2 = -j2; k2 <= j2; ++k2) {
                for (int l2 = -j2; l2 <= j2; ++l2) {
                    mutableBlockPos.a(pos, k2, i2, l2);
                    if (config.d.b(world, mutableBlockPos) && (config.j || !WorldGenTrees.e(world, mutableBlockPos))) continue;
                    return i2 - 2;
                }
            }
        }
        return height;
    }

    @Override
    @Override
    protected void a(IWorldWriter world, BlockPosition pos, IBlockData state) {
        WorldGenTrees.b(world, pos, state);
    }

    @Override
    @Override
    public final boolean a(FeaturePlaceContext<WorldGenFeatureTreeConfiguration> context) {
        final GeneratorAccessSeed worldGenLevel = context.b();
        RandomSource randomSource = context.d();
        BlockPosition blockPos = context.e();
        WorldGenFeatureTreeConfiguration treeConfiguration = context.f();
        HashSet set = Sets.newHashSet();
        HashSet set2 = Sets.newHashSet();
        final HashSet set3 = Sets.newHashSet();
        HashSet set4 = Sets.newHashSet();
        BiConsumer<BlockPosition, IBlockData> biConsumer = (pos, state) -> {
            set.add(pos.i());
            worldGenLevel.a((BlockPosition)pos, (IBlockData)state, 19);
        };
        BiConsumer<BlockPosition, IBlockData> biConsumer2 = (pos, state) -> {
            set2.add(pos.i());
            worldGenLevel.a((BlockPosition)pos, (IBlockData)state, 19);
        };
        WorldGenFoilagePlacer.b foliageSetter = new WorldGenFoilagePlacer.b(){

            @Override
            @Override
            public void a(BlockPosition pos, IBlockData state) {
                set3.add(pos.i());
                worldGenLevel.a(pos, state, 19);
            }

            @Override
            @Override
            public boolean a(BlockPosition pos) {
                return set3.contains(pos);
            }
        };
        BiConsumer<BlockPosition, IBlockData> biConsumer3 = (pos, state) -> {
            set4.add(pos.i());
            worldGenLevel.a((BlockPosition)pos, (IBlockData)state, 19);
        };
        boolean bl = this.a(worldGenLevel, randomSource, blockPos, biConsumer, biConsumer2, foliageSetter, treeConfiguration);
        if (!bl || set2.isEmpty() && set3.isEmpty()) {
            return false;
        }
        if (!treeConfiguration.i.isEmpty()) {
            WorldGenFeatureTree.a context2 = new WorldGenFeatureTree.a(worldGenLevel, biConsumer3, randomSource, set2, set3, set);
            treeConfiguration.i.forEach(decorator -> decorator.a(context2));
        }
        return StructureBoundingBox.a(Iterables.concat((Iterable)set, (Iterable)set2, (Iterable)set3, (Iterable)set4)).map(box -> {
            VoxelShapeDiscrete discreteVoxelShape = WorldGenTrees.a((GeneratorAccess)worldGenLevel, box, (Set<BlockPosition>)set2, (Set<BlockPosition>)set4, set);
            DefinedStructure.a(worldGenLevel, 3, discreteVoxelShape, box.g(), box.h(), box.i());
            return true;
        }).orElse(false);
    }

    private static VoxelShapeDiscrete a(GeneratorAccess world, StructureBoundingBox box, Set<BlockPosition> trunkPositions, Set<BlockPosition> decorationPositions, Set<BlockPosition> set) {
        ArrayList list = Lists.newArrayList();
        VoxelShapeBitSet discreteVoxelShape = new VoxelShapeBitSet(box.c(), box.d(), box.e());
        int i2 = 6;
        for (int j2 = 0; j2 < 6; ++j2) {
            list.add(Sets.newHashSet());
        }
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (BlockPosition blockPos : Lists.newArrayList((Iterable)Sets.union(decorationPositions, set))) {
            if (!box.b(blockPos)) continue;
            ((VoxelShapeDiscrete)discreteVoxelShape).c(blockPos.u() - box.g(), blockPos.v() - box.h(), blockPos.w() - box.i());
        }
        for (BlockPosition blockPos2 : Lists.newArrayList(trunkPositions)) {
            if (box.b(blockPos2)) {
                ((VoxelShapeDiscrete)discreteVoxelShape).c(blockPos2.u() - box.g(), blockPos2.v() - box.h(), blockPos2.w() - box.i());
            }
            for (EnumDirection direction : EnumDirection.values()) {
                IBlockData blockState;
                mutableBlockPos.a((BaseBlockPosition)blockPos2, direction);
                if (trunkPositions.contains(mutableBlockPos) || !(blockState = world.a_(mutableBlockPos)).b(BlockProperties.aC)) continue;
                ((Set)list.get(0)).add(mutableBlockPos.i());
                WorldGenTrees.b(world, mutableBlockPos, (IBlockData)blockState.a(BlockProperties.aC, 1));
                if (!box.b(mutableBlockPos)) continue;
                ((VoxelShapeDiscrete)discreteVoxelShape).c(mutableBlockPos.u() - box.g(), mutableBlockPos.v() - box.h(), mutableBlockPos.w() - box.i());
            }
        }
        for (int k2 = 1; k2 < 6; ++k2) {
            Set set2 = (Set)list.get(k2 - 1);
            Set set3 = (Set)list.get(k2);
            for (BlockPosition blockPos3 : set2) {
                if (box.b(blockPos3)) {
                    ((VoxelShapeDiscrete)discreteVoxelShape).c(blockPos3.u() - box.g(), blockPos3.v() - box.h(), blockPos3.w() - box.i());
                }
                for (EnumDirection direction2 : EnumDirection.values()) {
                    int l2;
                    IBlockData blockState2;
                    mutableBlockPos.a((BaseBlockPosition)blockPos3, direction2);
                    if (set2.contains(mutableBlockPos) || set3.contains(mutableBlockPos) || !(blockState2 = world.a_(mutableBlockPos)).b(BlockProperties.aC) || (l2 = blockState2.c(BlockProperties.aC).intValue()) <= k2 + 1) continue;
                    IBlockData blockState3 = (IBlockData)blockState2.a(BlockProperties.aC, k2 + 1);
                    WorldGenTrees.b(world, mutableBlockPos, blockState3);
                    if (box.b(mutableBlockPos)) {
                        ((VoxelShapeDiscrete)discreteVoxelShape).c(mutableBlockPos.u() - box.g(), mutableBlockPos.v() - box.h(), mutableBlockPos.w() - box.i());
                    }
                    set3.add(mutableBlockPos.i());
                }
            }
        }
        return discreteVoxelShape;
    }
}

