/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.configurations;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.SystemUtils;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfiguration;

public class MultifaceGrowthConfiguration
implements WorldGenFeatureConfiguration {
    public static final Codec<MultifaceGrowthConfiguration> a = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f.q().fieldOf("block").flatXmap(MultifaceGrowthConfiguration::a, DataResult::success).orElse((Object)((MultifaceBlock)Blocks.ff)).forGetter(config -> config.b), (App)Codec.intRange((int)1, (int)64).fieldOf("search_range").orElse((Object)10).forGetter(config -> config.c), (App)Codec.BOOL.fieldOf("can_place_on_floor").orElse((Object)false).forGetter(config -> config.d), (App)Codec.BOOL.fieldOf("can_place_on_ceiling").orElse((Object)false).forGetter(config -> config.e), (App)Codec.BOOL.fieldOf("can_place_on_wall").orElse((Object)false).forGetter(config -> config.f), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance_of_spreading").orElse((Object)Float.valueOf(0.5f)).forGetter(config -> Float.valueOf(config.g)), (App)RegistryCodecs.a(Registries.e).fieldOf("can_be_placed_on").forGetter(config -> config.h)).apply((Applicative)instance, MultifaceGrowthConfiguration::new));
    public final MultifaceBlock b;
    public final int c;
    public final boolean d;
    public final boolean e;
    public final boolean f;
    public final float g;
    public final HolderSet<Block> h;
    private final ObjectArrayList<EnumDirection> i;

    private static DataResult<MultifaceBlock> a(Block block) {
        DataResult dataResult;
        if (block instanceof MultifaceBlock) {
            MultifaceBlock multifaceBlock = (MultifaceBlock)block;
            dataResult = DataResult.success((Object)multifaceBlock);
        } else {
            dataResult = DataResult.error(() -> "Growth block should be a multiface block");
        }
        return dataResult;
    }

    public MultifaceGrowthConfiguration(MultifaceBlock lichen, int searchRange, boolean placeOnFloor, boolean placeOnCeiling, boolean placeOnWalls, float spreadChance, HolderSet<Block> canPlaceOn) {
        this.b = lichen;
        this.c = searchRange;
        this.d = placeOnFloor;
        this.e = placeOnCeiling;
        this.f = placeOnWalls;
        this.g = spreadChance;
        this.h = canPlaceOn;
        this.i = new ObjectArrayList(6);
        if (placeOnCeiling) {
            this.i.add((Object)EnumDirection.b);
        }
        if (placeOnFloor) {
            this.i.add((Object)EnumDirection.a);
        }
        if (placeOnWalls) {
            EnumDirection.EnumDirectionLimit.a.forEach(arg_0 -> this.i.add(arg_0));
        }
    }

    public List<EnumDirection> a(RandomSource random, EnumDirection excluded) {
        return SystemUtils.a(this.i.stream().filter(direction -> direction != excluded), random);
    }

    public List<EnumDirection> a(RandomSource random) {
        return SystemUtils.a(this.i, random);
    }
}

