/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.trunkplacers;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.WorldGenTrees;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureTreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacers;

public abstract class TrunkPlacer {
    public static final Codec<TrunkPlacer> c = BuiltInRegistries.X.q().dispatch(TrunkPlacer::a, TrunkPlacers::a);
    private static final int a = 32;
    private static final int b = 24;
    public static final int d = 80;
    protected final int e;
    protected final int f;
    protected final int g;

    protected static <P extends TrunkPlacer> Products.P3<RecordCodecBuilder.Mu<P>, Integer, Integer, Integer> a(RecordCodecBuilder.Instance<P> instance) {
        return instance.group((App)Codec.intRange((int)0, (int)32).fieldOf("base_height").forGetter(placer -> placer.e), (App)Codec.intRange((int)0, (int)24).fieldOf("height_rand_a").forGetter(placer -> placer.f), (App)Codec.intRange((int)0, (int)24).fieldOf("height_rand_b").forGetter(placer -> placer.g));
    }

    public TrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight) {
        this.e = baseHeight;
        this.f = firstRandomHeight;
        this.g = secondRandomHeight;
    }

    protected abstract TrunkPlacers<?> a();

    public abstract List<WorldGenFoilagePlacer.a> a(VirtualLevelReadable var1, BiConsumer<BlockPosition, IBlockData> var2, RandomSource var3, int var4, BlockPosition var5, WorldGenFeatureTreeConfiguration var6);

    public int a(RandomSource random) {
        return this.e + random.a(this.f + 1) + random.a(this.g + 1);
    }

    private static boolean c(VirtualLevelReadable world, BlockPosition pos) {
        return world.a(pos, (IBlockData state) -> WorldGenerator.b(state) && !state.a(Blocks.i) && !state.a(Blocks.fk));
    }

    protected static void a(VirtualLevelReadable world, BiConsumer<BlockPosition, IBlockData> replacer, RandomSource random, BlockPosition pos, WorldGenFeatureTreeConfiguration config) {
        if (config.k || !TrunkPlacer.c(world, pos)) {
            replacer.accept(pos, config.c.a(random, pos));
        }
    }

    protected boolean b(VirtualLevelReadable world, BiConsumer<BlockPosition, IBlockData> replacer, RandomSource random, BlockPosition pos, WorldGenFeatureTreeConfiguration config) {
        return this.a(world, replacer, random, pos, config, Function.identity());
    }

    protected boolean a(VirtualLevelReadable world, BiConsumer<BlockPosition, IBlockData> replacer, RandomSource random, BlockPosition pos, WorldGenFeatureTreeConfiguration config, Function<IBlockData, IBlockData> function) {
        if (this.a(world, pos)) {
            replacer.accept(pos, function.apply(config.b.a(random, pos)));
            return true;
        }
        return false;
    }

    protected void a(VirtualLevelReadable world, BiConsumer<BlockPosition, IBlockData> replacer, RandomSource random, BlockPosition.MutableBlockPosition pos, WorldGenFeatureTreeConfiguration config) {
        if (this.b(world, pos)) {
            this.b(world, replacer, random, pos, config);
        }
    }

    protected boolean a(VirtualLevelReadable world, BlockPosition pos) {
        return WorldGenTrees.d(world, pos);
    }

    public boolean b(VirtualLevelReadable world, BlockPosition pos) {
        return this.a(world, pos) || world.a(pos, (IBlockData state) -> state.a(TagsBlock.s));
    }
}

