/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.flat;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureFillConfiguration;
import net.minecraft.world.level.levelgen.flat.WorldGenFlatLayerInfo;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.BuiltinStructureSets;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import org.slf4j.Logger;

public class GeneratorSettingsFlat {
    private static final Logger b = LogUtils.getLogger();
    public static final Codec<GeneratorSettingsFlat> a = RecordCodecBuilder.create(instance -> instance.group((App)RegistryCodecs.a(Registries.az).optionalFieldOf("structure_overrides").forGetter(config -> config.c), (App)WorldGenFlatLayerInfo.a.listOf().fieldOf("layers").forGetter(GeneratorSettingsFlat::e), (App)Codec.BOOL.fieldOf("lakes").orElse((Object)false).forGetter(config -> config.i), (App)Codec.BOOL.fieldOf("features").orElse((Object)false).forGetter(config -> config.h), (App)BiomeBase.c.optionalFieldOf("biome").orElseGet(Optional::empty).forGetter(config -> Optional.of(config.e)), RegistryOps.d(Biomes.b), RegistryOps.d(MiscOverworldPlacements.g), RegistryOps.d(MiscOverworldPlacements.h)).apply((Applicative)instance, GeneratorSettingsFlat::new)).comapFlatMap(GeneratorSettingsFlat::a, Function.identity()).stable();
    private final Optional<HolderSet<StructureSet>> c;
    private final List<WorldGenFlatLayerInfo> d = Lists.newArrayList();
    private final Holder<BiomeBase> e;
    private final List<IBlockData> f;
    private boolean g;
    private boolean h;
    private boolean i;
    private final List<Holder<PlacedFeature>> j;

    private static DataResult<GeneratorSettingsFlat> a(GeneratorSettingsFlat config) {
        int i2 = config.d.stream().mapToInt(WorldGenFlatLayerInfo::a).sum();
        if (i2 > DimensionManager.c) {
            return DataResult.error(() -> "Sum of layer heights is > " + DimensionManager.c, (Object)config);
        }
        return DataResult.success((Object)config);
    }

    private GeneratorSettingsFlat(Optional<HolderSet<StructureSet>> structureOverrides, List<WorldGenFlatLayerInfo> layers, boolean lakes, boolean features, Optional<Holder<BiomeBase>> biome, Holder.c<BiomeBase> fallback, Holder<PlacedFeature> undergroundLavaLakeFeature, Holder<PlacedFeature> surfaceLavaLakeFeature) {
        this(structureOverrides, GeneratorSettingsFlat.a(biome, fallback), List.of(undergroundLavaLakeFeature, surfaceLavaLakeFeature));
        if (lakes) {
            this.b();
        }
        if (features) {
            this.a();
        }
        this.d.addAll(layers);
        this.g();
    }

    private static Holder<BiomeBase> a(Optional<? extends Holder<BiomeBase>> biome, Holder<BiomeBase> fallback) {
        if (biome.isEmpty()) {
            b.error("Unknown biome, defaulting to plains");
            return fallback;
        }
        return biome.get();
    }

    public GeneratorSettingsFlat(Optional<HolderSet<StructureSet>> structureOverrides, Holder<BiomeBase> biome, List<Holder<PlacedFeature>> features) {
        this.c = structureOverrides;
        this.e = biome;
        this.f = Lists.newArrayList();
        this.j = features;
    }

    public GeneratorSettingsFlat a(List<WorldGenFlatLayerInfo> layers, Optional<HolderSet<StructureSet>> structureOverrides, Holder<BiomeBase> biome) {
        GeneratorSettingsFlat flatLevelGeneratorSettings = new GeneratorSettingsFlat(structureOverrides, biome, this.j);
        for (WorldGenFlatLayerInfo flatLayerInfo : layers) {
            flatLevelGeneratorSettings.d.add(new WorldGenFlatLayerInfo(flatLayerInfo.a(), flatLayerInfo.b().b()));
            flatLevelGeneratorSettings.g();
        }
        if (this.h) {
            flatLevelGeneratorSettings.a();
        }
        if (this.i) {
            flatLevelGeneratorSettings.b();
        }
        return flatLevelGeneratorSettings;
    }

    public void a() {
        this.h = true;
    }

    public void b() {
        this.i = true;
    }

    public BiomeSettingsGeneration a(Holder<BiomeBase> biomeEntry) {
        boolean bl;
        if (!biomeEntry.equals(this.e)) {
            return biomeEntry.a().d();
        }
        BiomeSettingsGeneration biomeGenerationSettings = this.d().a().d();
        BiomeSettingsGeneration.b plainBuilder = new BiomeSettingsGeneration.b();
        if (this.i) {
            for (Holder<PlacedFeature> holder : this.j) {
                plainBuilder.a(WorldGenStage.Decoration.b, holder);
            }
        }
        boolean bl2 = bl = (!this.g || biomeEntry.a(Biomes.a)) && this.h;
        if (bl) {
            List<HolderSet<PlacedFeature>> list = biomeGenerationSettings.b();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (i2 == WorldGenStage.Decoration.d.ordinal() || i2 == WorldGenStage.Decoration.e.ordinal() || this.i && i2 == WorldGenStage.Decoration.b.ordinal()) continue;
                HolderSet<PlacedFeature> holderSet = list.get(i2);
                for (Holder holder : holderSet) {
                    plainBuilder.a(i2, (Holder<PlacedFeature>)holder);
                }
            }
        }
        List<IBlockData> list2 = this.f();
        for (int j2 = 0; j2 < list2.size(); ++j2) {
            IBlockData blockState = list2.get(j2);
            if (HeightMap.Type.e.e().test(blockState)) continue;
            list2.set(j2, null);
            plainBuilder.a(WorldGenStage.Decoration.k, PlacementUtils.a(WorldGenerator.ac, new WorldGenFeatureFillConfiguration(j2, blockState), new PlacementModifier[0]));
        }
        return plainBuilder.a();
    }

    public Optional<HolderSet<StructureSet>> c() {
        return this.c;
    }

    public Holder<BiomeBase> d() {
        return this.e;
    }

    public List<WorldGenFlatLayerInfo> e() {
        return this.d;
    }

    public List<IBlockData> f() {
        return this.f;
    }

    public void g() {
        this.f.clear();
        for (WorldGenFlatLayerInfo flatLayerInfo : this.d) {
            for (int i2 = 0; i2 < flatLayerInfo.a(); ++i2) {
                this.f.add(flatLayerInfo.b());
            }
        }
        this.g = this.f.stream().allMatch(state -> state.a(Blocks.a));
    }

    public static GeneratorSettingsFlat a(HolderGetter<BiomeBase> biomeLookup, HolderGetter<StructureSet> structureSetLookup, HolderGetter<PlacedFeature> featureLookup) {
        HolderSet.a holderSet = HolderSet.a(structureSetLookup.b(BuiltinStructureSets.r), structureSetLookup.b(BuiltinStructureSets.a));
        GeneratorSettingsFlat flatLevelGeneratorSettings = new GeneratorSettingsFlat(Optional.of(holderSet), GeneratorSettingsFlat.a(biomeLookup), GeneratorSettingsFlat.b(featureLookup));
        flatLevelGeneratorSettings.e().add(new WorldGenFlatLayerInfo(1, Blocks.F));
        flatLevelGeneratorSettings.e().add(new WorldGenFlatLayerInfo(2, Blocks.j));
        flatLevelGeneratorSettings.e().add(new WorldGenFlatLayerInfo(1, Blocks.i));
        flatLevelGeneratorSettings.g();
        return flatLevelGeneratorSettings;
    }

    public static Holder<BiomeBase> a(HolderGetter<BiomeBase> biomeLookup) {
        return biomeLookup.b(Biomes.b);
    }

    public static List<Holder<PlacedFeature>> b(HolderGetter<PlacedFeature> featureLookup) {
        return List.of(featureLookup.b(MiscOverworldPlacements.g), featureLookup.b(MiscOverworldPlacements.h));
    }
}

