/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.function.Function;
import net.minecraft.commands.arguments.blocks.ArgumentBlock;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyStructureMode;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.slf4j.Logger;

public abstract class DefinedStructurePiece
extends StructurePiece {
    private static final Logger h = LogUtils.getLogger();
    protected final String a;
    protected DefinedStructure b;
    protected DefinedStructureInfo c;
    protected BlockPosition d;

    public DefinedStructurePiece(WorldGenFeatureStructurePieceType type, int length, StructureTemplateManager structureTemplateManager, MinecraftKey id, String template, DefinedStructureInfo placementData, BlockPosition pos) {
        super(type, length, structureTemplateManager.a(id).b(placementData, pos));
        this.a(EnumDirection.c);
        this.a = template;
        this.d = pos;
        this.b = structureTemplateManager.a(id);
        this.c = placementData;
    }

    public DefinedStructurePiece(WorldGenFeatureStructurePieceType type, NBTTagCompound nbt, StructureTemplateManager structureTemplateManager, Function<MinecraftKey, DefinedStructureInfo> placementDataGetter) {
        super(type, nbt);
        this.a(EnumDirection.c);
        this.a = nbt.l("Template");
        this.d = new BlockPosition(nbt.h("TPX"), nbt.h("TPY"), nbt.h("TPZ"));
        MinecraftKey resourceLocation = this.b();
        this.b = structureTemplateManager.a(resourceLocation);
        this.c = placementDataGetter.apply(resourceLocation);
        this.f = this.b.b(this.c, this.d);
    }

    protected MinecraftKey b() {
        return new MinecraftKey(this.a);
    }

    @Override
    @Override
    protected void a(StructurePieceSerializationContext context, NBTTagCompound nbt) {
        nbt.a("TPX", this.d.u());
        nbt.a("TPY", this.d.v());
        nbt.a("TPZ", this.d.w());
        nbt.a("Template", this.a);
    }

    @Override
    @Override
    public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pivot) {
        this.c.a(chunkBox);
        this.f = this.b.b(this.c, this.d);
        if (this.b.a(world, this.d, pivot, this.c, random, 2)) {
            List<DefinedStructure.BlockInfo> list = this.b.a(this.d, this.c, Blocks.oW);
            for (DefinedStructure.BlockInfo structureBlockInfo : list) {
                BlockPropertyStructureMode structureMode;
                if (structureBlockInfo.c == null || (structureMode = BlockPropertyStructureMode.valueOf(structureBlockInfo.c.l("mode"))) != BlockPropertyStructureMode.d) continue;
                this.a(structureBlockInfo.c.l("metadata"), structureBlockInfo.a, world, random, chunkBox);
            }
            List<DefinedStructure.BlockInfo> list2 = this.b.a(this.d, this.c, Blocks.oX);
            for (DefinedStructure.BlockInfo structureBlockInfo2 : list2) {
                if (structureBlockInfo2.c == null) continue;
                String string = structureBlockInfo2.c.l("final_state");
                IBlockData blockState = Blocks.a.o();
                try {
                    blockState = ArgumentBlock.a(world.a(Registries.e), string, true).a();
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    h.error("Error while parsing blockstate {} in jigsaw block @ {}", (Object)string, (Object)structureBlockInfo2.a);
                }
                world.a(structureBlockInfo2.a, blockState, 3);
            }
        }
    }

    protected abstract void a(String var1, BlockPosition var2, WorldAccess var3, RandomSource var4, StructureBoundingBox var5);

    @Override
    @Deprecated
    @Override
    public void a(int x2, int y2, int z2) {
        super.a(x2, y2, z2);
        this.d = this.d.b(x2, y2, z2);
    }

    @Override
    @Override
    public EnumBlockRotation a() {
        return this.c.d();
    }

    public DefinedStructure c() {
        return this.b;
    }

    public BlockPosition d() {
        return this.d;
    }

    public DefinedStructureInfo e() {
        return this.c;
    }
}

