/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.ImmutableSet;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.entity.TileEntityDispenser;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.material.Fluid;
import org.slf4j.Logger;

public abstract class StructurePiece {
    private static final Logger a = LogUtils.getLogger();
    protected static final IBlockData e = Blocks.mY.o();
    protected StructureBoundingBox f;
    @Nullable
    private EnumDirection b;
    private EnumBlockMirror c;
    private EnumBlockRotation d;
    protected int g;
    private final WorldGenFeatureStructurePieceType h;
    private static final Set<Block> i = ImmutableSet.builder().add((Object)Blocks.fn).add((Object)Blocks.co).add((Object)Blocks.cp).add((Object)Blocks.dT).add((Object)Blocks.kc).add((Object)Blocks.kh).add((Object)Blocks.kf).add((Object)Blocks.kd).add((Object)Blocks.ke).add((Object)Blocks.cN).add((Object)Blocks.eW).build();

    protected StructurePiece(WorldGenFeatureStructurePieceType type, int length, StructureBoundingBox boundingBox) {
        this.h = type;
        this.g = length;
        this.f = boundingBox;
    }

    public StructurePiece(WorldGenFeatureStructurePieceType type, NBTTagCompound nbt) {
        this(type, nbt.h("GD"), (StructureBoundingBox)StructureBoundingBox.a.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c("BB")).resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)).orElseThrow(() -> new IllegalArgumentException("Invalid boundingbox")));
        int i2 = nbt.h("O");
        this.a(i2 == -1 ? null : EnumDirection.b(i2));
    }

    protected static StructureBoundingBox a(int x2, int y2, int z2, EnumDirection orientation, int width, int height, int depth) {
        if (orientation.o() == EnumDirection.EnumAxis.c) {
            return new StructureBoundingBox(x2, y2, z2, x2 + width - 1, y2 + height - 1, z2 + depth - 1);
        }
        return new StructureBoundingBox(x2, y2, z2, x2 + depth - 1, y2 + height - 1, z2 + width - 1);
    }

    protected static EnumDirection a(RandomSource random) {
        return EnumDirection.EnumDirectionLimit.a.a(random);
    }

    public final NBTTagCompound a(StructurePieceSerializationContext context) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        compoundTag.a("id", BuiltInRegistries.S.b(this.k()).toString());
        StructureBoundingBox.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.f).resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)).ifPresent(tag -> compoundTag.a("BB", (NBTBase)tag));
        EnumDirection direction = this.i();
        compoundTag.a("O", direction == null ? -1 : direction.e());
        compoundTag.a("GD", this.g);
        this.a(context, compoundTag);
        return compoundTag;
    }

    protected abstract void a(StructurePieceSerializationContext var1, NBTTagCompound var2);

    public void a(StructurePiece start, StructurePieceAccessor holder, RandomSource random) {
    }

    public abstract void a(GeneratorAccessSeed var1, StructureManager var2, ChunkGenerator var3, RandomSource var4, StructureBoundingBox var5, ChunkCoordIntPair var6, BlockPosition var7);

    public StructureBoundingBox f() {
        return this.f;
    }

    public int g() {
        return this.g;
    }

    public void a(int chainLength) {
        this.g = chainLength;
    }

    public boolean a(ChunkCoordIntPair pos, int offset) {
        int i2 = pos.d();
        int j2 = pos.e();
        return this.f.a(i2 - offset, j2 - offset, i2 + 15 + offset, j2 + 15 + offset);
    }

    public BlockPosition h() {
        return new BlockPosition(this.f.f());
    }

    protected BlockPosition.MutableBlockPosition b(int x2, int y2, int z2) {
        return new BlockPosition.MutableBlockPosition(this.a(x2, z2), this.b(y2), this.b(x2, z2));
    }

    protected int a(int x2, int z2) {
        EnumDirection direction = this.i();
        if (direction == null) {
            return x2;
        }
        switch (direction) {
            case c: 
            case d: {
                return this.f.g() + x2;
            }
            case e: {
                return this.f.j() - z2;
            }
            case f: {
                return this.f.g() + z2;
            }
        }
        return x2;
    }

    protected int b(int y2) {
        if (this.i() == null) {
            return y2;
        }
        return y2 + this.f.h();
    }

    protected int b(int x2, int z2) {
        EnumDirection direction = this.i();
        if (direction == null) {
            return z2;
        }
        switch (direction) {
            case c: {
                return this.f.l() - z2;
            }
            case d: {
                return this.f.i() + z2;
            }
            case e: 
            case f: {
                return this.f.i() + x2;
            }
        }
        return z2;
    }

    protected void a(GeneratorAccessSeed world, IBlockData block, int x2, int y2, int z2, StructureBoundingBox box) {
        BlockPosition.MutableBlockPosition blockPos = this.b(x2, y2, z2);
        if (!box.b(blockPos)) {
            return;
        }
        if (!this.a(world, x2, y2, z2, box)) {
            return;
        }
        if (this.c != EnumBlockMirror.a) {
            block = block.a(this.c);
        }
        if (this.d != EnumBlockRotation.a) {
            block = block.a(this.d);
        }
        world.a((BlockPosition)blockPos, block, 2);
        Fluid fluidState = world.b_(blockPos);
        if (!fluidState.c()) {
            world.a((BlockPosition)blockPos, fluidState.a(), 0);
        }
        if (i.contains(block.b())) {
            world.A(blockPos).e(blockPos);
        }
    }

    protected boolean a(IWorldReader world, int x2, int y2, int z2, StructureBoundingBox box) {
        return true;
    }

    protected IBlockData a(IBlockAccess world, int x2, int y2, int z2, StructureBoundingBox box) {
        BlockPosition.MutableBlockPosition blockPos = this.b(x2, y2, z2);
        if (!box.b(blockPos)) {
            return Blocks.a.o();
        }
        return world.a_(blockPos);
    }

    protected boolean b(IWorldReader world, int x2, int z2, int y2, StructureBoundingBox box) {
        BlockPosition.MutableBlockPosition blockPos = this.b(x2, z2 + 1, y2);
        if (!box.b(blockPos)) {
            return false;
        }
        return blockPos.v() < world.a(HeightMap.Type.c, blockPos.u(), blockPos.w());
    }

    protected void a(GeneratorAccessSeed world, StructureBoundingBox bounds, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        for (int i2 = minY; i2 <= maxY; ++i2) {
            for (int j2 = minX; j2 <= maxX; ++j2) {
                for (int k2 = minZ; k2 <= maxZ; ++k2) {
                    this.a(world, Blocks.a.o(), j2, i2, k2, bounds);
                }
            }
        }
    }

    protected void a(GeneratorAccessSeed world, StructureBoundingBox box, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, IBlockData outline, IBlockData inside, boolean cantReplaceAir) {
        for (int i2 = minY; i2 <= maxY; ++i2) {
            for (int j2 = minX; j2 <= maxX; ++j2) {
                for (int k2 = minZ; k2 <= maxZ; ++k2) {
                    if (cantReplaceAir && this.a((IBlockAccess)world, j2, i2, k2, box).h()) continue;
                    if (i2 == minY || i2 == maxY || j2 == minX || j2 == maxX || k2 == minZ || k2 == maxZ) {
                        this.a(world, outline, j2, i2, k2, box);
                        continue;
                    }
                    this.a(world, inside, j2, i2, k2, box);
                }
            }
        }
    }

    protected void a(GeneratorAccessSeed world, StructureBoundingBox box, StructureBoundingBox fillBox, IBlockData outline, IBlockData inside, boolean cantReplaceAir) {
        this.a(world, box, fillBox.g(), fillBox.h(), fillBox.i(), fillBox.j(), fillBox.k(), fillBox.l(), outline, inside, cantReplaceAir);
    }

    protected void a(GeneratorAccessSeed world, StructureBoundingBox box, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean cantReplaceAir, RandomSource random, StructurePieceBlockSelector randomizer) {
        for (int i2 = minY; i2 <= maxY; ++i2) {
            for (int j2 = minX; j2 <= maxX; ++j2) {
                for (int k2 = minZ; k2 <= maxZ; ++k2) {
                    if (cantReplaceAir && this.a((IBlockAccess)world, j2, i2, k2, box).h()) continue;
                    randomizer.a(random, j2, i2, k2, i2 == minY || i2 == maxY || j2 == minX || j2 == maxX || k2 == minZ || k2 == maxZ);
                    this.a(world, randomizer.a(), j2, i2, k2, box);
                }
            }
        }
    }

    protected void a(GeneratorAccessSeed world, StructureBoundingBox box, StructureBoundingBox fillBox, boolean cantReplaceAir, RandomSource random, StructurePieceBlockSelector randomizer) {
        this.a(world, box, fillBox.g(), fillBox.h(), fillBox.i(), fillBox.j(), fillBox.k(), fillBox.l(), cantReplaceAir, random, randomizer);
    }

    protected void a(GeneratorAccessSeed world, StructureBoundingBox box, RandomSource random, float blockChance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, IBlockData outline, IBlockData inside, boolean cantReplaceAir, boolean stayBelowSeaLevel) {
        for (int i2 = minY; i2 <= maxY; ++i2) {
            for (int j2 = minX; j2 <= maxX; ++j2) {
                for (int k2 = minZ; k2 <= maxZ; ++k2) {
                    if (random.i() > blockChance || cantReplaceAir && this.a((IBlockAccess)world, j2, i2, k2, box).h() || stayBelowSeaLevel && !this.b(world, j2, i2, k2, box)) continue;
                    if (i2 == minY || i2 == maxY || j2 == minX || j2 == maxX || k2 == minZ || k2 == maxZ) {
                        this.a(world, outline, j2, i2, k2, box);
                        continue;
                    }
                    this.a(world, inside, j2, i2, k2, box);
                }
            }
        }
    }

    protected void a(GeneratorAccessSeed world, StructureBoundingBox bounds, RandomSource random, float threshold, int x2, int y2, int z2, IBlockData state) {
        if (random.i() < threshold) {
            this.a(world, state, x2, y2, z2, bounds);
        }
    }

    protected void a(GeneratorAccessSeed world, StructureBoundingBox bounds, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, IBlockData block, boolean cantReplaceAir) {
        float f2 = maxX - minX + 1;
        float g2 = maxY - minY + 1;
        float h2 = maxZ - minZ + 1;
        float i2 = (float)minX + f2 / 2.0f;
        float j2 = (float)minZ + h2 / 2.0f;
        for (int k2 = minY; k2 <= maxY; ++k2) {
            float l2 = (float)(k2 - minY) / g2;
            for (int m2 = minX; m2 <= maxX; ++m2) {
                float n2 = ((float)m2 - i2) / (f2 * 0.5f);
                for (int o2 = minZ; o2 <= maxZ; ++o2) {
                    float q2;
                    float p2 = ((float)o2 - j2) / (h2 * 0.5f);
                    if (cantReplaceAir && this.a((IBlockAccess)world, m2, k2, o2, bounds).h() || !((q2 = n2 * n2 + l2 * l2 + p2 * p2) <= 1.05f)) continue;
                    this.a(world, block, m2, k2, o2, bounds);
                }
            }
        }
    }

    protected void b(GeneratorAccessSeed world, IBlockData state, int x2, int y2, int z2, StructureBoundingBox box) {
        BlockPosition.MutableBlockPosition mutableBlockPos = this.b(x2, y2, z2);
        if (!box.b(mutableBlockPos)) {
            return;
        }
        while (this.a(world.a_(mutableBlockPos)) && mutableBlockPos.v() > world.v_() + 1) {
            world.a((BlockPosition)mutableBlockPos, state, 2);
            mutableBlockPos.c(EnumDirection.a);
        }
    }

    protected boolean a(IBlockData state) {
        return state.h() || state.d().a() || state.a(Blocks.ff) || state.a(Blocks.bv) || state.a(Blocks.bw);
    }

    protected boolean a(GeneratorAccessSeed world, StructureBoundingBox boundingBox, RandomSource random, int x2, int y2, int z2, MinecraftKey lootTableId) {
        return this.a((WorldAccess)world, boundingBox, random, this.b(x2, y2, z2), lootTableId, null);
    }

    public static IBlockData a(IBlockAccess world, BlockPosition pos, IBlockData state) {
        EnumDirection direction = null;
        for (EnumDirection direction2 : EnumDirection.EnumDirectionLimit.a) {
            BlockPosition blockPos = pos.a(direction2);
            IBlockData blockState = world.a_(blockPos);
            if (blockState.a(Blocks.cu)) {
                return state;
            }
            if (!blockState.i(world, blockPos)) continue;
            if (direction == null) {
                direction = direction2;
                continue;
            }
            direction = null;
            break;
        }
        if (direction != null) {
            return (IBlockData)state.a(BlockFacingHorizontal.aD, direction.g());
        }
        EnumDirection direction3 = state.c(BlockFacingHorizontal.aD);
        BlockPosition blockPos2 = pos.a(direction3);
        if (world.a_(blockPos2).i(world, blockPos2)) {
            direction3 = direction3.g();
            blockPos2 = pos.a(direction3);
        }
        if (world.a_(blockPos2).i(world, blockPos2)) {
            direction3 = direction3.h();
            blockPos2 = pos.a(direction3);
        }
        if (world.a_(blockPos2).i(world, blockPos2)) {
            direction3 = direction3.g();
            blockPos2 = pos.a(direction3);
        }
        return (IBlockData)state.a(BlockFacingHorizontal.aD, direction3);
    }

    protected boolean a(WorldAccess world, StructureBoundingBox boundingBox, RandomSource random, BlockPosition pos, MinecraftKey lootTableId, @Nullable IBlockData block) {
        if (!boundingBox.b(pos) || world.a_(pos).a(Blocks.cu)) {
            return false;
        }
        if (block == null) {
            block = StructurePiece.a(world, pos, Blocks.cu.o());
        }
        world.a(pos, block, 2);
        TileEntity blockEntity = world.c_(pos);
        if (blockEntity instanceof TileEntityChest) {
            ((TileEntityChest)blockEntity).a(lootTableId, random.g());
        }
        return true;
    }

    protected boolean a(GeneratorAccessSeed world, StructureBoundingBox boundingBox, RandomSource random, int x2, int y2, int z2, EnumDirection facing, MinecraftKey lootTableId) {
        BlockPosition.MutableBlockPosition blockPos = this.b(x2, y2, z2);
        if (boundingBox.b(blockPos) && !world.a_(blockPos).a(Blocks.aT)) {
            this.a(world, (IBlockData)Blocks.aT.o().a(BlockDispenser.a, facing), x2, y2, z2, boundingBox);
            TileEntity blockEntity = world.c_(blockPos);
            if (blockEntity instanceof TileEntityDispenser) {
                ((TileEntityDispenser)blockEntity).a(lootTableId, random.g());
            }
            return true;
        }
        return false;
    }

    public void a(int x2, int y2, int z2) {
        this.f.a(x2, y2, z2);
    }

    public static StructureBoundingBox a(Stream<StructurePiece> pieces) {
        return StructureBoundingBox.b(pieces.map(StructurePiece::f)::iterator).orElseThrow(() -> new IllegalStateException("Unable to calculate boundingbox without pieces"));
    }

    @Nullable
    public static StructurePiece a(List<StructurePiece> pieces, StructureBoundingBox box) {
        for (StructurePiece structurePiece : pieces) {
            if (!structurePiece.f().a(box)) continue;
            return structurePiece;
        }
        return null;
    }

    @Nullable
    public EnumDirection i() {
        return this.b;
    }

    public void a(@Nullable EnumDirection orientation) {
        this.b = orientation;
        if (orientation == null) {
            this.d = EnumBlockRotation.a;
            this.c = EnumBlockMirror.a;
        } else {
            switch (orientation) {
                case d: {
                    this.c = EnumBlockMirror.b;
                    this.d = EnumBlockRotation.a;
                    break;
                }
                case e: {
                    this.c = EnumBlockMirror.b;
                    this.d = EnumBlockRotation.b;
                    break;
                }
                case f: {
                    this.c = EnumBlockMirror.a;
                    this.d = EnumBlockRotation.b;
                    break;
                }
                default: {
                    this.c = EnumBlockMirror.a;
                    this.d = EnumBlockRotation.a;
                }
            }
        }
    }

    public EnumBlockRotation a() {
        return this.d;
    }

    public EnumBlockMirror j() {
        return this.c;
    }

    public WorldGenFeatureStructurePieceType k() {
        return this.h;
    }

    public static abstract class StructurePieceBlockSelector {
        protected IBlockData a = Blocks.a.o();

        public abstract void a(RandomSource var1, int var2, int var3, int var4, boolean var5);

        public IBlockData a() {
            return this.a;
        }
    }
}

