/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.WorldGenFeaturePieces;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.BlockJigsaw;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.WorldGenFeaturePillagerOutpostPoolPiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructureJigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolEmpty;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

public class WorldGenFeatureDefinedStructureJigsawPlacement {
    static final Logger a = LogUtils.getLogger();

    public static Optional<Structure.b> a(Structure.a context, Holder<WorldGenFeatureDefinedStructurePoolTemplate> structurePool, Optional<MinecraftKey> id, int size, BlockPosition pos, boolean useExpansionHack, Optional<HeightMap.Type> projectStartToHeightmap, int maxDistanceFromCenter) {
        int l2;
        BlockPosition blockPos2;
        IRegistryCustom registryAccess = context.a();
        ChunkGenerator chunkGenerator = context.b();
        StructureTemplateManager structureTemplateManager = context.e();
        LevelHeightAccessor levelHeightAccessor = context.i();
        SeededRandom worldgenRandom = context.f();
        IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> registry = registryAccess.d(Registries.aA);
        EnumBlockRotation rotation = EnumBlockRotation.a(worldgenRandom);
        WorldGenFeatureDefinedStructurePoolTemplate structureTemplatePool = structurePool.a();
        WorldGenFeatureDefinedStructurePoolStructure structurePoolElement = structureTemplatePool.a(worldgenRandom);
        if (structurePoolElement == WorldGenFeatureDefinedStructurePoolEmpty.b) {
            return Optional.empty();
        }
        if (id.isPresent()) {
            MinecraftKey resourceLocation = id.get();
            Optional<BlockPosition> optional = WorldGenFeatureDefinedStructureJigsawPlacement.a(structurePoolElement, resourceLocation, pos, rotation, structureTemplateManager, worldgenRandom);
            if (optional.isEmpty()) {
                a.error("No starting jigsaw {} found in start pool {}", (Object)resourceLocation, (Object)structurePool.e().map(key -> key.a().toString()).orElse("<unregistered>"));
                return Optional.empty();
            }
            BlockPosition blockPos = optional.get();
        } else {
            blockPos2 = pos;
        }
        BlockPosition vec3i = blockPos2.b(pos);
        BlockPosition blockPos3 = pos.b(vec3i);
        WorldGenFeaturePillagerOutpostPoolPiece poolElementStructurePiece = new WorldGenFeaturePillagerOutpostPoolPiece(structureTemplateManager, structurePoolElement, blockPos3, structurePoolElement.f(), rotation, structurePoolElement.a(structureTemplateManager, blockPos3, rotation));
        StructureBoundingBox boundingBox = poolElementStructurePiece.f();
        int i2 = (boundingBox.j() + boundingBox.g()) / 2;
        int j2 = (boundingBox.l() + boundingBox.i()) / 2;
        if (projectStartToHeightmap.isPresent()) {
            int k2 = pos.v() + chunkGenerator.b(i2, j2, projectStartToHeightmap.get(), levelHeightAccessor, context.d());
        } else {
            l2 = blockPos3.v();
        }
        int m2 = boundingBox.h() + poolElementStructurePiece.d();
        poolElementStructurePiece.a(0, l2 - m2, 0);
        int n2 = l2 + vec3i.v();
        return Optional.of(new Structure.b(new BlockPosition(i2, n2, j2), collector -> {
            ArrayList list = Lists.newArrayList();
            list.add(poolElementStructurePiece);
            if (size <= 0) {
                return;
            }
            AxisAlignedBB aABB = new AxisAlignedBB(i2 - maxDistanceFromCenter, n2 - maxDistanceFromCenter, j2 - maxDistanceFromCenter, i2 + maxDistanceFromCenter + 1, n2 + maxDistanceFromCenter + 1, j2 + maxDistanceFromCenter + 1);
            VoxelShape voxelShape = VoxelShapes.a(VoxelShapes.a(aABB), VoxelShapes.a(AxisAlignedBB.a(boundingBox)), OperatorBoolean.e);
            WorldGenFeatureDefinedStructureJigsawPlacement.a(context.d(), size, useExpansionHack, chunkGenerator, structureTemplateManager, levelHeightAccessor, worldgenRandom, registry, poolElementStructurePiece, list, voxelShape);
            list.forEach(collector::a);
        }));
    }

    private static Optional<BlockPosition> a(WorldGenFeatureDefinedStructurePoolStructure pool, MinecraftKey id, BlockPosition pos, EnumBlockRotation rotation, StructureTemplateManager structureManager, SeededRandom random) {
        List<DefinedStructure.BlockInfo> list = pool.a(structureManager, pos, rotation, random);
        Optional<BlockPosition> optional = Optional.empty();
        for (DefinedStructure.BlockInfo structureBlockInfo : list) {
            MinecraftKey resourceLocation = MinecraftKey.a(structureBlockInfo.c.l("name"));
            if (!id.equals(resourceLocation)) continue;
            optional = Optional.of(structureBlockInfo.a);
            break;
        }
        return optional;
    }

    private static void a(RandomState noiseConfig, int maxSize, boolean modifyBoundingBox, ChunkGenerator chunkGenerator, StructureTemplateManager structureTemplateManager, LevelHeightAccessor heightLimitView, RandomSource random, IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> structurePoolRegistry, WorldGenFeaturePillagerOutpostPoolPiece firstPiece, List<WorldGenFeaturePillagerOutpostPoolPiece> pieces, VoxelShape pieceShape) {
        b placer = new b(structurePoolRegistry, maxSize, chunkGenerator, structureTemplateManager, pieces, random);
        placer.g.addLast(new a(firstPiece, (MutableObject<VoxelShape>)new MutableObject((Object)pieceShape), 0));
        while (!placer.g.isEmpty()) {
            a pieceState = placer.g.removeFirst();
            placer.a(pieceState.a, pieceState.b, pieceState.c, modifyBoundingBox, heightLimitView, noiseConfig);
        }
    }

    public static boolean a(WorldServer world, Holder<WorldGenFeatureDefinedStructurePoolTemplate> structurePool, MinecraftKey id, int size, BlockPosition pos, boolean keepJigsaws) {
        ChunkGenerator chunkGenerator = world.k().g();
        StructureTemplateManager structureTemplateManager = world.p();
        StructureManager structureManager = world.a();
        RandomSource randomSource = world.r_();
        Structure.a generationContext = new Structure.a(world.u_(), chunkGenerator, chunkGenerator.c(), world.k().i(), structureTemplateManager, world.A(), new ChunkCoordIntPair(pos), world, biome -> true);
        Optional<Structure.b> optional = WorldGenFeatureDefinedStructureJigsawPlacement.a(generationContext, structurePool, Optional.of(id), size, pos, false, Optional.empty(), 128);
        if (optional.isPresent()) {
            StructurePiecesBuilder structurePiecesBuilder = optional.get().a();
            for (StructurePiece structurePiece : structurePiecesBuilder.a().c()) {
                if (!(structurePiece instanceof WorldGenFeaturePillagerOutpostPoolPiece)) continue;
                WorldGenFeaturePillagerOutpostPoolPiece poolElementStructurePiece = (WorldGenFeaturePillagerOutpostPoolPiece)structurePiece;
                poolElementStructurePiece.a((GeneratorAccessSeed)world, structureManager, chunkGenerator, randomSource, StructureBoundingBox.a(), pos, keepJigsaws);
            }
            return true;
        }
        return false;
    }

    static final class b {
        private final IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> a;
        private final int b;
        private final ChunkGenerator c;
        private final StructureTemplateManager d;
        private final List<? super WorldGenFeaturePillagerOutpostPoolPiece> e;
        private final RandomSource f;
        final Deque<a> g = Queues.newArrayDeque();

        b(IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> registry, int maxSize, ChunkGenerator chunkGenerator, StructureTemplateManager structureTemplateManager, List<? super WorldGenFeaturePillagerOutpostPoolPiece> children, RandomSource random) {
            this.a = registry;
            this.b = maxSize;
            this.c = chunkGenerator;
            this.d = structureTemplateManager;
            this.e = children;
            this.f = random;
        }

        void a(WorldGenFeaturePillagerOutpostPoolPiece piece, MutableObject<VoxelShape> pieceShape, int minY, boolean modifyBoundingBox, LevelHeightAccessor world, RandomState noiseConfig) {
            WorldGenFeatureDefinedStructurePoolStructure structurePoolElement = piece.b();
            BlockPosition blockPos = piece.c();
            EnumBlockRotation rotation = piece.a();
            WorldGenFeatureDefinedStructurePoolTemplate.Matching projection = structurePoolElement.e();
            boolean bl = projection == WorldGenFeatureDefinedStructurePoolTemplate.Matching.b;
            MutableObject mutableObject = new MutableObject();
            StructureBoundingBox boundingBox = piece.f();
            int i2 = boundingBox.h();
            block0: for (DefinedStructure.BlockInfo structureBlockInfo : structurePoolElement.a(this.d, blockPos, rotation, this.f)) {
                WorldGenFeatureDefinedStructurePoolStructure structurePoolElement2;
                MutableObject<VoxelShape> mutableObject3;
                EnumDirection direction = BlockJigsaw.h(structureBlockInfo.b);
                BlockPosition blockPos2 = structureBlockInfo.a;
                BlockPosition blockPos3 = blockPos2.a(direction);
                int j2 = blockPos2.v() - i2;
                int k2 = -1;
                ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> resourceKey = net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructureJigsawPlacement$b.a(structureBlockInfo);
                Optional<Holder.c<WorldGenFeatureDefinedStructurePoolTemplate>> optional = this.a.b(resourceKey);
                if (optional.isEmpty()) {
                    a.warn("Empty or non-existent pool: {}", (Object)resourceKey.a());
                    continue;
                }
                Holder holder = optional.get();
                if (((WorldGenFeatureDefinedStructurePoolTemplate)holder.a()).b() == 0 && !holder.a(WorldGenFeaturePieces.a)) {
                    a.warn("Empty or non-existent pool: {}", (Object)resourceKey.a());
                    continue;
                }
                Holder<WorldGenFeatureDefinedStructurePoolTemplate> holder2 = ((WorldGenFeatureDefinedStructurePoolTemplate)holder.a()).a();
                if (holder2.a().b() == 0 && !holder2.a(WorldGenFeaturePieces.a)) {
                    a.warn("Empty or non-existent fallback pool: {}", (Object)holder2.e().map(key -> key.a().toString()).orElse("<unregistered>"));
                    continue;
                }
                boolean bl2 = boundingBox.b(blockPos3);
                if (bl2) {
                    MutableObject mutableObject2 = mutableObject;
                    if (mutableObject.getValue() == null) {
                        mutableObject.setValue((Object)VoxelShapes.a(AxisAlignedBB.a(boundingBox)));
                    }
                } else {
                    mutableObject3 = pieceShape;
                }
                ArrayList list = Lists.newArrayList();
                if (minY != this.b) {
                    list.addAll(((WorldGenFeatureDefinedStructurePoolTemplate)holder.a()).b(this.f));
                }
                list.addAll(holder2.a().b(this.f));
                Iterator iterator = list.iterator();
                while (iterator.hasNext() && (structurePoolElement2 = (WorldGenFeatureDefinedStructurePoolStructure)iterator.next()) != WorldGenFeatureDefinedStructurePoolEmpty.b) {
                    for (EnumBlockRotation rotation2 : EnumBlockRotation.b(this.f)) {
                        int m2;
                        List<DefinedStructure.BlockInfo> list2 = structurePoolElement2.a(this.d, BlockPosition.b, rotation2, this.f);
                        StructureBoundingBox boundingBox2 = structurePoolElement2.a(this.d, BlockPosition.b, rotation2);
                        if (!modifyBoundingBox || boundingBox2.d() > 16) {
                            boolean l2 = false;
                        } else {
                            m2 = list2.stream().mapToInt(blockInfo -> {
                                if (!boundingBox2.b(blockInfo.a.a(BlockJigsaw.h(blockInfo.b)))) {
                                    return 0;
                                }
                                ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> resourceKey = net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructureJigsawPlacement$b.a(blockInfo);
                                Optional<Holder.c<WorldGenFeatureDefinedStructurePoolTemplate>> optional = this.a.b(resourceKey);
                                Optional<Holder> optional2 = optional.map(entry -> ((WorldGenFeatureDefinedStructurePoolTemplate)entry.a()).a());
                                int i2 = optional.map(entry -> ((WorldGenFeatureDefinedStructurePoolTemplate)entry.a()).a(this.d)).orElse(0);
                                int j2 = optional2.map(entry -> ((WorldGenFeatureDefinedStructurePoolTemplate)entry.a()).a(this.d)).orElse(0);
                                return Math.max(i2, j2);
                            }).max().orElse(0);
                        }
                        for (DefinedStructure.BlockInfo structureBlockInfo2 : list2) {
                            int z2;
                            int w2;
                            int r2;
                            if (!BlockJigsaw.a(structureBlockInfo, structureBlockInfo2)) continue;
                            BlockPosition blockPos4 = structureBlockInfo2.a;
                            BlockPosition blockPos5 = blockPos3.b(blockPos4);
                            StructureBoundingBox boundingBox3 = structurePoolElement2.a(this.d, blockPos5, rotation2);
                            int n2 = boundingBox3.h();
                            WorldGenFeatureDefinedStructurePoolTemplate.Matching projection2 = structurePoolElement2.e();
                            boolean bl3 = projection2 == WorldGenFeatureDefinedStructurePoolTemplate.Matching.b;
                            int o2 = blockPos4.v();
                            int p2 = j2 - o2 + BlockJigsaw.h(structureBlockInfo.b).k();
                            if (bl && bl3) {
                                int q2 = i2 + p2;
                            } else {
                                if (k2 == -1) {
                                    k2 = this.c.b(blockPos2.u(), blockPos2.w(), HeightMap.Type.a, world, noiseConfig);
                                }
                                r2 = k2 - o2;
                            }
                            int s2 = r2 - n2;
                            StructureBoundingBox boundingBox4 = boundingBox3.b(0, s2, 0);
                            BlockPosition blockPos6 = blockPos5.b(0, s2, 0);
                            if (m2 > 0) {
                                int t2 = Math.max(m2 + 1, boundingBox4.k() - boundingBox4.h());
                                boundingBox4.a(new BlockPosition(boundingBox4.g(), boundingBox4.h() + t2, boundingBox4.i()));
                            }
                            if (VoxelShapes.c((VoxelShape)mutableObject3.getValue(), VoxelShapes.a(AxisAlignedBB.a(boundingBox4).h(0.25)), OperatorBoolean.c)) continue;
                            mutableObject3.setValue((Object)VoxelShapes.b((VoxelShape)mutableObject3.getValue(), VoxelShapes.a(AxisAlignedBB.a(boundingBox4)), OperatorBoolean.e));
                            int u2 = piece.d();
                            if (bl3) {
                                int v2 = u2 - p2;
                            } else {
                                w2 = structurePoolElement2.f();
                            }
                            WorldGenFeaturePillagerOutpostPoolPiece poolElementStructurePiece = new WorldGenFeaturePillagerOutpostPoolPiece(this.d, structurePoolElement2, blockPos6, w2, rotation2, boundingBox4);
                            if (bl) {
                                int x2 = i2 + j2;
                            } else if (bl3) {
                                int y2 = r2 + o2;
                            } else {
                                if (k2 == -1) {
                                    k2 = this.c.b(blockPos2.u(), blockPos2.w(), HeightMap.Type.a, world, noiseConfig);
                                }
                                z2 = k2 + p2 / 2;
                            }
                            piece.a(new WorldGenFeatureDefinedStructureJigsawJunction(blockPos3.u(), (int)(z2 - j2 + u2), blockPos3.w(), p2, projection2));
                            poolElementStructurePiece.a(new WorldGenFeatureDefinedStructureJigsawJunction(blockPos2.u(), z2 - o2 + w2, blockPos2.w(), -p2, projection));
                            this.e.add(poolElementStructurePiece);
                            if (minY + 1 > this.b) continue block0;
                            this.g.addLast(new a(poolElementStructurePiece, mutableObject3, minY + 1));
                            continue block0;
                        }
                    }
                }
            }
        }

        private static ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> a(DefinedStructure.BlockInfo blockInfo) {
            return ResourceKey.a(Registries.aA, new MinecraftKey(blockInfo.c.l("pool")));
        }
    }

    static final class a {
        final WorldGenFeaturePillagerOutpostPoolPiece a;
        final MutableObject<VoxelShape> b;
        final int c;

        a(WorldGenFeaturePillagerOutpostPoolPiece piece, MutableObject<VoxelShape> pieceShape, int currentSize) {
            this.a = piece;
            this.b = pieceShape;
            this.c = currentSize;
        }
    }
}

