/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.monster.EntityDrowned;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.DefinedStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.structures.OceanRuinStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorBlockIgnore;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorRotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootTables;

public class OceanRuinPieces {
    private static final MinecraftKey[] a = new MinecraftKey[]{new MinecraftKey("underwater_ruin/warm_1"), new MinecraftKey("underwater_ruin/warm_2"), new MinecraftKey("underwater_ruin/warm_3"), new MinecraftKey("underwater_ruin/warm_4"), new MinecraftKey("underwater_ruin/warm_5"), new MinecraftKey("underwater_ruin/warm_6"), new MinecraftKey("underwater_ruin/warm_7"), new MinecraftKey("underwater_ruin/warm_8")};
    private static final MinecraftKey[] b = new MinecraftKey[]{new MinecraftKey("underwater_ruin/brick_1"), new MinecraftKey("underwater_ruin/brick_2"), new MinecraftKey("underwater_ruin/brick_3"), new MinecraftKey("underwater_ruin/brick_4"), new MinecraftKey("underwater_ruin/brick_5"), new MinecraftKey("underwater_ruin/brick_6"), new MinecraftKey("underwater_ruin/brick_7"), new MinecraftKey("underwater_ruin/brick_8")};
    private static final MinecraftKey[] c = new MinecraftKey[]{new MinecraftKey("underwater_ruin/cracked_1"), new MinecraftKey("underwater_ruin/cracked_2"), new MinecraftKey("underwater_ruin/cracked_3"), new MinecraftKey("underwater_ruin/cracked_4"), new MinecraftKey("underwater_ruin/cracked_5"), new MinecraftKey("underwater_ruin/cracked_6"), new MinecraftKey("underwater_ruin/cracked_7"), new MinecraftKey("underwater_ruin/cracked_8")};
    private static final MinecraftKey[] d = new MinecraftKey[]{new MinecraftKey("underwater_ruin/mossy_1"), new MinecraftKey("underwater_ruin/mossy_2"), new MinecraftKey("underwater_ruin/mossy_3"), new MinecraftKey("underwater_ruin/mossy_4"), new MinecraftKey("underwater_ruin/mossy_5"), new MinecraftKey("underwater_ruin/mossy_6"), new MinecraftKey("underwater_ruin/mossy_7"), new MinecraftKey("underwater_ruin/mossy_8")};
    private static final MinecraftKey[] e = new MinecraftKey[]{new MinecraftKey("underwater_ruin/big_brick_1"), new MinecraftKey("underwater_ruin/big_brick_2"), new MinecraftKey("underwater_ruin/big_brick_3"), new MinecraftKey("underwater_ruin/big_brick_8")};
    private static final MinecraftKey[] f = new MinecraftKey[]{new MinecraftKey("underwater_ruin/big_mossy_1"), new MinecraftKey("underwater_ruin/big_mossy_2"), new MinecraftKey("underwater_ruin/big_mossy_3"), new MinecraftKey("underwater_ruin/big_mossy_8")};
    private static final MinecraftKey[] g = new MinecraftKey[]{new MinecraftKey("underwater_ruin/big_cracked_1"), new MinecraftKey("underwater_ruin/big_cracked_2"), new MinecraftKey("underwater_ruin/big_cracked_3"), new MinecraftKey("underwater_ruin/big_cracked_8")};
    private static final MinecraftKey[] h = new MinecraftKey[]{new MinecraftKey("underwater_ruin/big_warm_4"), new MinecraftKey("underwater_ruin/big_warm_5"), new MinecraftKey("underwater_ruin/big_warm_6"), new MinecraftKey("underwater_ruin/big_warm_7")};

    private static MinecraftKey a(RandomSource random) {
        return SystemUtils.a(a, random);
    }

    private static MinecraftKey b(RandomSource random) {
        return SystemUtils.a(h, random);
    }

    public static void a(StructureTemplateManager manager, BlockPosition pos, EnumBlockRotation rotation, StructurePieceAccessor holder, RandomSource random, OceanRuinStructure structure) {
        boolean bl = random.i() <= structure.f;
        float f2 = bl ? 0.9f : 0.8f;
        OceanRuinPieces.a(manager, pos, rotation, holder, random, structure, bl, f2);
        if (bl && random.i() <= structure.g) {
            OceanRuinPieces.a(manager, random, rotation, pos, structure, holder);
        }
    }

    private static void a(StructureTemplateManager manager, RandomSource random, EnumBlockRotation rotation, BlockPosition pos, OceanRuinStructure structure, StructurePieceAccessor pieces) {
        BlockPosition blockPos = new BlockPosition(pos.u(), 90, pos.w());
        BlockPosition blockPos2 = DefinedStructure.a(new BlockPosition(15, 0, 15), EnumBlockMirror.a, rotation, BlockPosition.b).a(blockPos);
        StructureBoundingBox boundingBox = StructureBoundingBox.a(blockPos, blockPos2);
        BlockPosition blockPos3 = new BlockPosition(Math.min(blockPos.u(), blockPos2.u()), blockPos.v(), Math.min(blockPos.w(), blockPos2.w()));
        List<BlockPosition> list = OceanRuinPieces.a(random, blockPos3);
        int i2 = MathHelper.a(random, 4, 8);
        for (int j2 = 0; j2 < i2; ++j2) {
            EnumBlockRotation rotation2;
            BlockPosition blockPos5;
            int k2;
            BlockPosition blockPos4;
            StructureBoundingBox boundingBox2;
            if (list.isEmpty() || (boundingBox2 = StructureBoundingBox.a(blockPos4 = list.remove(k2 = random.a(list.size())), blockPos5 = DefinedStructure.a(new BlockPosition(5, 0, 6), EnumBlockMirror.a, rotation2 = EnumBlockRotation.a(random), BlockPosition.b).a(blockPos4))).a(boundingBox)) continue;
            OceanRuinPieces.a(manager, blockPos4, rotation2, pieces, random, structure, false, 0.8f);
        }
    }

    private static List<BlockPosition> a(RandomSource random, BlockPosition pos) {
        ArrayList list = Lists.newArrayList();
        list.add(pos.b(-16 + MathHelper.a(random, 1, 8), 0, 16 + MathHelper.a(random, 1, 7)));
        list.add(pos.b(-16 + MathHelper.a(random, 1, 8), 0, MathHelper.a(random, 1, 7)));
        list.add(pos.b(-16 + MathHelper.a(random, 1, 8), 0, -16 + MathHelper.a(random, 4, 8)));
        list.add(pos.b(MathHelper.a(random, 1, 7), 0, 16 + MathHelper.a(random, 1, 7)));
        list.add(pos.b(MathHelper.a(random, 1, 7), 0, -16 + MathHelper.a(random, 4, 6)));
        list.add(pos.b(16 + MathHelper.a(random, 1, 7), 0, 16 + MathHelper.a(random, 3, 8)));
        list.add(pos.b(16 + MathHelper.a(random, 1, 7), 0, MathHelper.a(random, 1, 7)));
        list.add(pos.b(16 + MathHelper.a(random, 1, 7), 0, -16 + MathHelper.a(random, 4, 8)));
        return list;
    }

    private static void a(StructureTemplateManager manager, BlockPosition pos, EnumBlockRotation rotation, StructurePieceAccessor holder, RandomSource random, OceanRuinStructure structure, boolean large, float integrity) {
        switch (structure.e) {
            default: {
                MinecraftKey resourceLocation = large ? OceanRuinPieces.b(random) : OceanRuinPieces.a(random);
                holder.a(new a(manager, resourceLocation, pos, rotation, integrity, structure.e, large));
                break;
            }
            case b: {
                MinecraftKey[] resourceLocations = large ? e : b;
                MinecraftKey[] resourceLocations2 = large ? g : c;
                MinecraftKey[] resourceLocations3 = large ? f : d;
                int i2 = random.a(resourceLocations.length);
                holder.a(new a(manager, resourceLocations[i2], pos, rotation, integrity, structure.e, large));
                holder.a(new a(manager, resourceLocations2[i2], pos, rotation, 0.7f, structure.e, large));
                holder.a(new a(manager, resourceLocations3[i2], pos, rotation, 0.5f, structure.e, large));
            }
        }
    }

    public static class a
    extends DefinedStructurePiece {
        private final OceanRuinStructure.a h;
        private final float i;
        private final boolean j;

        public a(StructureTemplateManager structureTemplateManager, MinecraftKey template, BlockPosition pos, EnumBlockRotation rotation, float integrity, OceanRuinStructure.a biomeType, boolean large) {
            super(WorldGenFeatureStructurePieceType.H, 0, structureTemplateManager, template, template.toString(), net.minecraft.world.level.levelgen.structure.structures.OceanRuinPieces$a.a(rotation), pos);
            this.i = integrity;
            this.h = biomeType;
            this.j = large;
        }

        public a(StructureTemplateManager holder, NBTTagCompound nbt) {
            super(WorldGenFeatureStructurePieceType.H, nbt, holder, id -> net.minecraft.world.level.levelgen.structure.structures.OceanRuinPieces$a.a(EnumBlockRotation.valueOf(nbt.l("Rot"))));
            this.i = nbt.j("Integrity");
            this.h = OceanRuinStructure.a.valueOf(nbt.l("BiomeType"));
            this.j = nbt.q("IsLarge");
        }

        private static DefinedStructureInfo a(EnumBlockRotation rotation) {
            return new DefinedStructureInfo().a(rotation).a(EnumBlockMirror.a).a(DefinedStructureProcessorBlockIgnore.d);
        }

        @Override
        @Override
        protected void a(StructurePieceSerializationContext context, NBTTagCompound nbt) {
            super.a(context, nbt);
            nbt.a("Rot", this.c.d().name());
            nbt.a("Integrity", this.i);
            nbt.a("BiomeType", this.h.toString());
            nbt.a("IsLarge", this.j);
        }

        @Override
        @Override
        protected void a(String metadata, BlockPosition pos, WorldAccess world, RandomSource random, StructureBoundingBox boundingBox) {
            EntityDrowned drowned;
            if ("chest".equals(metadata)) {
                world.a(pos, (IBlockData)Blocks.cu.o().a(BlockChest.d, world.b_(pos).a(TagsFluid.a)), 2);
                TileEntity blockEntity = world.c_(pos);
                if (blockEntity instanceof TileEntityChest) {
                    ((TileEntityChest)blockEntity).a(this.j ? LootTables.F : LootTables.E, random.g());
                }
            } else if ("drowned".equals(metadata) && (drowned = EntityTypes.y.a(world.C())) != null) {
                drowned.fz();
                drowned.a(pos, 0.0f, 0.0f);
                drowned.a(world, world.d_(pos), EnumMobSpawn.d, null, null);
                world.a_(drowned);
                if (pos.v() > world.m_()) {
                    world.a(pos, Blocks.a.o(), 2);
                } else {
                    world.a(pos, Blocks.G.o(), 2);
                }
            }
        }

        @Override
        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pivot) {
            this.c.b().a(new DefinedStructureProcessorRotation(this.i)).a(DefinedStructureProcessorBlockIgnore.d);
            int i2 = world.a(HeightMap.Type.c, this.d.u(), this.d.w());
            this.d = new BlockPosition(this.d.u(), i2, this.d.w());
            BlockPosition blockPos = DefinedStructure.a(new BlockPosition(this.b.a().u() - 1, 0, this.b.a().w() - 1), EnumBlockMirror.a, this.c.d(), BlockPosition.b).a(this.d);
            this.d = new BlockPosition(this.d.u(), this.a(this.d, world, blockPos), this.d.w());
            super.a(world, structureAccessor, chunkGenerator, random, chunkBox, chunkPos, pivot);
        }

        private int a(BlockPosition start, IBlockAccess world, BlockPosition end) {
            int i2 = start.v();
            int j2 = 512;
            int k2 = i2 - 1;
            int l2 = 0;
            for (BlockPosition blockPos : BlockPosition.a(start, end)) {
                int m2 = blockPos.u();
                int n2 = blockPos.w();
                int o2 = start.v() - 1;
                BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition(m2, o2, n2);
                IBlockData blockState = world.a_(mutableBlockPos);
                Fluid fluidState = world.b_(mutableBlockPos);
                while ((blockState.h() || fluidState.a(TagsFluid.a) || blockState.a(TagsBlock.aj)) && o2 > world.v_() + 1) {
                    mutableBlockPos.d(m2, --o2, n2);
                    blockState = world.a_(mutableBlockPos);
                    fluidState = world.b_(mutableBlockPos);
                }
                j2 = Math.min(j2, o2);
                if (o2 >= k2 - 2) continue;
                ++l2;
            }
            int p2 = Math.abs(start.u() - end.u());
            if (k2 - j2 > 2 && l2 > p2 - 2) {
                i2 = j2 + 1;
            }
            return i2;
        }
    }
}

