/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.BlockVine;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.DefinedStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorBlackstoneReplace;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorBlockAge;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorBlockIgnore;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorLavaSubmergedBlock;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorPredicates;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureTestBlock;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureTestRandomBlock;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureTestTrue;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProtectedBlockProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.slf4j.Logger;

public class RuinedPortalPiece
extends DefinedStructurePiece {
    private static final Logger h = LogUtils.getLogger();
    private static final float i = 0.3f;
    private static final float j = 0.07f;
    private static final float k = 0.2f;
    private final b l;
    private final a m;

    public RuinedPortalPiece(StructureTemplateManager manager, BlockPosition pos, b verticalPlacement, a properties, MinecraftKey id, DefinedStructure template, EnumBlockRotation rotation, EnumBlockMirror mirror, BlockPosition blockPos) {
        super(WorldGenFeatureStructurePieceType.J, 0, manager, id, id.toString(), RuinedPortalPiece.a(mirror, rotation, verticalPlacement, blockPos, properties), pos);
        this.l = verticalPlacement;
        this.m = properties;
    }

    public RuinedPortalPiece(StructureTemplateManager manager, NBTTagCompound nbt) {
        super(WorldGenFeatureStructurePieceType.J, nbt, manager, id -> RuinedPortalPiece.a(manager, nbt, id));
        this.l = net.minecraft.world.level.levelgen.structure.structures.RuinedPortalPiece$b.a(nbt.l("VerticalPlacement"));
        this.m = (a)net.minecraft.world.level.levelgen.structure.structures.RuinedPortalPiece$a.a.parse(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbt.c("Properties"))).getOrThrow(true, arg_0 -> ((Logger)h).error(arg_0));
    }

    @Override
    @Override
    protected void a(StructurePieceSerializationContext context, NBTTagCompound nbt) {
        super.a(context, nbt);
        nbt.a("Rotation", this.c.d().name());
        nbt.a("Mirror", this.c.c().name());
        nbt.a("VerticalPlacement", this.l.a());
        net.minecraft.world.level.levelgen.structure.structures.RuinedPortalPiece$a.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.m).resultOrPartial(arg_0 -> ((Logger)h).error(arg_0)).ifPresent(tag -> nbt.a("Properties", (NBTBase)tag));
    }

    private static DefinedStructureInfo a(StructureTemplateManager manager, NBTTagCompound nbt, MinecraftKey id) {
        DefinedStructure structureTemplate = manager.a(id);
        BlockPosition blockPos = new BlockPosition(structureTemplate.a().u() / 2, 0, structureTemplate.a().w() / 2);
        return RuinedPortalPiece.a(EnumBlockMirror.valueOf(nbt.l("Mirror")), EnumBlockRotation.valueOf(nbt.l("Rotation")), net.minecraft.world.level.levelgen.structure.structures.RuinedPortalPiece$b.a(nbt.l("VerticalPlacement")), blockPos, (a)net.minecraft.world.level.levelgen.structure.structures.RuinedPortalPiece$a.a.parse(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbt.c("Properties"))).getOrThrow(true, arg_0 -> ((Logger)h).error(arg_0)));
    }

    private static DefinedStructureInfo a(EnumBlockMirror mirror, EnumBlockRotation rotation, b verticalPlacement, BlockPosition pos, a properties) {
        DefinedStructureProcessorBlockIgnore blockIgnoreProcessor = properties.d ? DefinedStructureProcessorBlockIgnore.b : DefinedStructureProcessorBlockIgnore.d;
        ArrayList list = Lists.newArrayList();
        list.add(RuinedPortalPiece.a(Blocks.cg, 0.3f, Blocks.a));
        list.add(RuinedPortalPiece.a(verticalPlacement, properties));
        if (!properties.b) {
            list.add(RuinedPortalPiece.a(Blocks.dV, 0.07f, Blocks.kG));
        }
        DefinedStructureInfo structurePlaceSettings = new DefinedStructureInfo().a(rotation).a(mirror).a(pos).a(blockIgnoreProcessor).a(new DefinedStructureProcessorRule(list)).a(new DefinedStructureProcessorBlockAge(properties.c)).a(new ProtectedBlockProcessor(TagsBlock.bC)).a(new DefinedStructureProcessorLavaSubmergedBlock());
        if (properties.g) {
            structurePlaceSettings.a(DefinedStructureProcessorBlackstoneReplace.b);
        }
        return structurePlaceSettings;
    }

    private static DefinedStructureProcessorPredicates a(b verticalPlacement, a properties) {
        if (verticalPlacement == net.minecraft.world.level.levelgen.structure.structures.RuinedPortalPiece$b.c) {
            return RuinedPortalPiece.a(Blocks.H, Blocks.kG);
        }
        if (properties.b) {
            return RuinedPortalPiece.a(Blocks.H, Blocks.dV);
        }
        return RuinedPortalPiece.a(Blocks.H, 0.2f, Blocks.kG);
    }

    @Override
    @Override
    public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pivot) {
        StructureBoundingBox boundingBox = this.b.b(this.c, this.d);
        if (!chunkBox.b(boundingBox.f())) {
            return;
        }
        chunkBox.b(boundingBox);
        super.a(world, structureAccessor, chunkGenerator, random, chunkBox, chunkPos, pivot);
        this.b(random, world);
        this.a(random, world);
        if (this.m.f || this.m.e) {
            BlockPosition.a(this.f()).forEach(pos -> {
                if (this.m.f) {
                    this.a(random, (GeneratorAccess)world, (BlockPosition)pos);
                }
                if (this.m.e) {
                    this.b(random, world, (BlockPosition)pos);
                }
            });
        }
    }

    @Override
    @Override
    protected void a(String metadata, BlockPosition pos, WorldAccess world, RandomSource random, StructureBoundingBox boundingBox) {
    }

    private void a(RandomSource random, GeneratorAccess world, BlockPosition pos) {
        IBlockData blockState = world.a_(pos);
        if (blockState.h() || blockState.a(Blocks.fe)) {
            return;
        }
        EnumDirection direction = RuinedPortalPiece.a(random);
        BlockPosition blockPos = pos.a(direction);
        IBlockData blockState2 = world.a_(blockPos);
        if (!blockState2.h()) {
            return;
        }
        if (!Block.a(blockState.k(world, pos), direction)) {
            return;
        }
        BlockStateBoolean booleanProperty = BlockVine.a(direction.g());
        world.a(blockPos, (IBlockData)Blocks.fe.o().a(booleanProperty, true), 3);
    }

    private void b(RandomSource random, GeneratorAccess world, BlockPosition pos) {
        if (random.i() < 0.5f && world.a_(pos).a(Blocks.dV) && world.a_(pos.c()).h()) {
            world.a(pos.c(), (IBlockData)Blocks.aG.o().a(BlockLeaves.c, true), 3);
        }
    }

    private void a(RandomSource random, GeneratorAccess world) {
        for (int i2 = this.f.g() + 1; i2 < this.f.j(); ++i2) {
            for (int j2 = this.f.i() + 1; j2 < this.f.l(); ++j2) {
                BlockPosition blockPos = new BlockPosition(i2, this.f.h(), j2);
                if (!world.a_(blockPos).a(Blocks.dV)) continue;
                this.c(random, world, blockPos.d());
            }
        }
    }

    private void c(RandomSource random, GeneratorAccess world, BlockPosition pos) {
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.j();
        this.d(random, world, mutableBlockPos);
        for (int i2 = 8; i2 > 0 && random.i() < 0.5f; --i2) {
            mutableBlockPos.c(EnumDirection.a);
            this.d(random, world, mutableBlockPos);
        }
    }

    private void b(RandomSource random, GeneratorAccess world) {
        boolean bl = this.l == net.minecraft.world.level.levelgen.structure.structures.RuinedPortalPiece$b.a || this.l == net.minecraft.world.level.levelgen.structure.structures.RuinedPortalPiece$b.c;
        BlockPosition blockPos = this.f.f();
        int i2 = blockPos.u();
        int j2 = blockPos.w();
        float[] fs = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.9f, 0.9f, 0.8f, 0.7f, 0.6f, 0.4f, 0.2f};
        int k2 = fs.length;
        int l2 = (this.f.c() + this.f.e()) / 2;
        int m2 = random.a(Math.max(1, 8 - l2 / 2));
        int n2 = 3;
        BlockPosition.MutableBlockPosition mutableBlockPos = BlockPosition.b.j();
        for (int o2 = i2 - k2; o2 <= i2 + k2; ++o2) {
            for (int p2 = j2 - k2; p2 <= j2 + k2; ++p2) {
                int q2 = Math.abs(o2 - i2) + Math.abs(p2 - j2);
                int r2 = Math.max(0, q2 + m2);
                if (r2 >= k2) continue;
                float f2 = fs[r2];
                if (!(random.j() < (double)f2)) continue;
                int s2 = RuinedPortalPiece.a(world, o2, p2, this.l);
                int t2 = bl ? s2 : Math.min(this.f.h(), s2);
                mutableBlockPos.d(o2, t2, p2);
                if (Math.abs(t2 - this.f.h()) > 3 || !this.a(world, mutableBlockPos)) continue;
                this.d(random, world, mutableBlockPos);
                if (this.m.e) {
                    this.b(random, world, mutableBlockPos);
                }
                this.c(random, world, mutableBlockPos.d());
            }
        }
    }

    private boolean a(GeneratorAccess world, BlockPosition pos) {
        IBlockData blockState = world.a_(pos);
        return !blockState.a(Blocks.a) && !blockState.a(Blocks.cn) && !blockState.a(TagsBlock.bC) && (this.l == net.minecraft.world.level.levelgen.structure.structures.RuinedPortalPiece$b.f || !blockState.a(Blocks.H));
    }

    private void d(RandomSource random, GeneratorAccess world, BlockPosition pos) {
        if (!this.m.b && random.i() < 0.07f) {
            world.a(pos, Blocks.kG.o(), 3);
        } else {
            world.a(pos, Blocks.dV.o(), 3);
        }
    }

    private static int a(GeneratorAccess world, int x2, int y2, b verticalPlacement) {
        return world.a(RuinedPortalPiece.a(verticalPlacement), x2, y2) - 1;
    }

    public static HeightMap.Type a(b verticalPlacement) {
        return verticalPlacement == net.minecraft.world.level.levelgen.structure.structures.RuinedPortalPiece$b.c ? HeightMap.Type.c : HeightMap.Type.a;
    }

    private static DefinedStructureProcessorPredicates a(Block old, float chance, Block updated) {
        return new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(old, chance), DefinedStructureTestTrue.b, updated.o());
    }

    private static DefinedStructureProcessorPredicates a(Block old, Block updated) {
        return new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(old), DefinedStructureTestTrue.b, updated.o());
    }

    public static final class b
    extends Enum<b>
    implements INamable {
        public static final /* enum */ b a = new b("on_land_surface");
        public static final /* enum */ b b = new b("partly_buried");
        public static final /* enum */ b c = new b("on_ocean_floor");
        public static final /* enum */ b d = new b("in_mountain");
        public static final /* enum */ b e = new b("underground");
        public static final /* enum */ b f = new b("in_nether");
        public static final INamable.a<b> g;
        private final String h;
        private static final /* synthetic */ b[] i;

        public static b[] values() {
            return (b[])i.clone();
        }

        public static b valueOf(String string) {
            return Enum.valueOf(b.class, string);
        }

        private b(String id) {
            this.h = id;
        }

        public String a() {
            return this.h;
        }

        public static b a(String id) {
            return g.a(id);
        }

        @Override
        @Override
        public String c() {
            return this.h;
        }

        private static /* synthetic */ b[] b() {
            return new b[]{a, b, c, d, e, f};
        }

        static {
            i = net.minecraft.world.level.levelgen.structure.structures.RuinedPortalPiece$b.b();
            g = INamable.a(b::values);
        }
    }

    public static class a {
        public static final Codec<a> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("cold").forGetter(properties -> properties.b), (App)Codec.FLOAT.fieldOf("mossiness").forGetter(properties -> Float.valueOf(properties.c)), (App)Codec.BOOL.fieldOf("air_pocket").forGetter(properties -> properties.d), (App)Codec.BOOL.fieldOf("overgrown").forGetter(properties -> properties.e), (App)Codec.BOOL.fieldOf("vines").forGetter(properties -> properties.f), (App)Codec.BOOL.fieldOf("replace_with_blackstone").forGetter(properties -> properties.g)).apply((Applicative)instance, a::new));
        public boolean b;
        public float c;
        public boolean d;
        public boolean e;
        public boolean f;
        public boolean g;

        public a() {
        }

        public a(boolean cold, float mossiness, boolean airPocket, boolean overgrown, boolean vines, boolean replaceWithBlackstone) {
            this.b = cold;
            this.c = mossiness;
            this.d = airPocket;
            this.e = overgrown;
            this.f = vines;
            this.g = replaceWithBlackstone;
        }
    }
}

